/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.json.java.JSONObject;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class CMLogonMediator
extends LogonMediator {
    public CMConnection connection = null;
    private String privAddDoc = "false";
    private String privAddItem = "false";
    private String privAddSearch = "false";
    private String searchTemplateSupported = "false";
    private String repositoryId = null;
    private String recordType = null;
    private boolean isCM842 = false;
    public static final String RECORD_TYPE = "recordType";
    public static final String IS_CM842 = "isCM842";

    public CMLogonMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public CMConnection getConnection() {
        return this.connection;
    }

    public void setConnection(CMConnection connection) {
        this.connection = connection;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public boolean isCM842() {
        return this.isCM842;
    }

    public void setCM842(boolean isCM842) {
        this.isCM842 = isCM842;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        CMConnection connection = this.getConnection();
        JSONObject jsonObject = super.toJSONObject();
        Hashtable<String, String> privilagesTable = null;
        RepositoryConfig repoConfig = Config.getRepositoryConfigUsingIdOrServerName(this.request, this.repositoryId);
        if (connection != null) {
            try {
                privilagesTable = CMBaseAction.getPrivilagesTable(this.request, connection, repoConfig);
                if (privilagesTable != null) {
                    jsonObject.put("priv_addItem", (Object)privilagesTable.get("privAddContent").equalsIgnoreCase("true"));
                    jsonObject.put("priv_addDoc", (Object)privilagesTable.get("privAddItem").equalsIgnoreCase("true"));
                    jsonObject.put("priv_addSearch", (Object)privilagesTable.get("privAddSearch").equalsIgnoreCase("true"));
                    jsonObject.put("searchTemplateSupported", (Object)privilagesTable.get("setSearchTemplateSupported").equalsIgnoreCase("true"));
                    jsonObject.put("priv_foldering", (Object)privilagesTable.get("privFoldering").equalsIgnoreCase("true"));
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        String useSSO = "false";
        try {
            privilagesTable = CMBaseAction.getPrivilagesTable(this.request, connection, repoConfig);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        if (privilagesTable != null) {
            jsonObject.put("priv_addTeamspace", (Object)privilagesTable.get("privAddTeamspace").equalsIgnoreCase("true"));
            jsonObject.put("priv_addTeamspaceTemplate", (Object)privilagesTable.get("privAddTeamspaceTemplate").equalsIgnoreCase("true"));
        }
        if (repoConfig != null) {
            jsonObject.put("useSSO", repoConfig.getUseSSO());
        } else {
            jsonObject.put("useSSO", useSSO);
        }
        if (connection != null) {
            jsonObject.put("userid", this.getConnection().getUserid());
        }
        if (this.recordType != null) {
            jsonObject.put(RECORD_TYPE, this.recordType.toString());
        }
        if (this.isCM842) {
            jsonObject.put(IS_CM842, "true");
        } else {
            jsonObject.put(IS_CM842, "false");
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
    }
}

