/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMItemTypesMediator
extends BaseMediator {
    public Vector entities = null;
    int maxItemTypes;

    public CMItemTypesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void addEntity(CMEntity entity) {
        this.getEntities().add(entity);
    }

    public Vector getEntities() {
        if (this.entities == null) {
            this.entities = new Vector(0);
        }
        return this.entities;
    }

    public void setEntities(Vector entities) {
        this.entities = entities;
    }

    public int getMaxItemTypes() {
        return this.maxItemTypes;
    }

    public void setMaxItemTypes(int maxItemTypes) {
        this.maxItemTypes = maxItemTypes;
    }

    public static Map<String, String> itemTypeSettingsToJSONMap(CMEntity entity) {
        String versionControl;
        boolean storesContent;
        String classification;
        HashMap<String, String> properties = new HashMap<String, String>();
        switch (entity.getClassification()) {
            case 2: {
                classification = "DOCUMENT";
                try {
                    String[] partTypeNames = entity.getPartTypes();
                    storesContent = partTypeNames != null && partTypeNames.length > 0;
                }
                catch (Exception e) {
                    storesContent = false;
                }
                break;
            }
            case 1: {
                classification = "RESOURCE";
                storesContent = true;
                break;
            }
            default: {
                classification = "ITEM";
                storesContent = false;
            }
        }
        short versionControlVal = 0;
        try {
            versionControlVal = entity.getVersionControl();
        }
        catch (Exception e) {
            // empty catch block
        }
        switch (versionControlVal) {
            case 1: {
                versionControl = "ALWAYS";
                break;
            }
            case 2: {
                versionControl = "OPTIONAL";
                break;
            }
            default: {
                versionControl = "NEVER";
            }
        }
        properties.put("template_desc", entity.getDisplayName());
        properties.put("classification", classification);
        properties.put("storesContent", storesContent ? "true" : "false");
        properties.put("versionControl", versionControl);
        properties.put("text_searchable", entity.isTextSearchable() ? "true" : "false");
        properties.put("item_type_acl", entity.isItemTypeLevelACL() ? "true" : "false");
        properties.put("hierarchical", entity.isHierarchical() ? "true" : "false");
        properties.put("forFoldersOnly", entity.isForFoldersOnly() ? "true" : "false");
        properties.put("notForFolders", entity.isNotForFolders() ? "true" : "false");
        return properties;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        JSONUtils.put(jsonObject, "num_templates", this.getEntities().size());
        JSONStore DataStore = new JSONStore("template_name", "template_label", this.locale);
        for (int i = 0; i < this.entities.size() && i < this.getMaxItemTypes(); ++i) {
            CMEntity entity = (CMEntity)this.getEntities().elementAt(i);
            JSONItem DataItem = DataStore.createDataItem(entity.getName(), entity.getDisplayName());
            Map<String, String> properties = CMItemTypesMediator.itemTypeSettingsToJSONMap(entity);
            DataItem.setProperties(properties);
            DataStore.addItem(DataItem);
        }
        jsonObject.put("datastore", DataStore.toJson());
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonObject;
    }

    protected String toJSONFromVectorForEntities(String jsonString, String category) throws Exception {
        String methodName = "toJSONFromVectorForEntities";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String myString = new String();
        JSONObject jsonObject = null;
        jsonObject = jsonString != null ? JSONObject.parse(jsonString) : new JSONObject();
        JSONObject tempObject = null;
        Object tempString = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "this.getEntities().size(): " + this.getEntities().size());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "this.getMaxItemTypes(): " + this.getMaxItemTypes());
        for (int i = 0; i < this.getMaxItemTypes(); ++i) {
            CMEntity entity = (CMEntity)this.getEntities().elementAt(i);
            tempObject = new JSONObject();
            tempObject.put("template_name", entity.getName());
            tempObject.put("template_label", entity.getDisplayName());
            tempObject.put("template_desc", entity.getDisplayName());
            JSONUtils.accumulate(jsonObject, category, tempObject);
        }
        myString = jsonObject.toString();
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return myString;
    }

    protected static Map toMapFromJSONForEntities(String jsonStringArray) throws IOException {
        TreeMap<String, String> newVector = new TreeMap<String, String>();
        String myString = new String();
        JSONArray jsonArray = JSONArray.parse(jsonStringArray);
        JSONObject jsonObject = null;
        for (int iArrayItemCounter = 0; iArrayItemCounter < jsonArray.size(); ++iArrayItemCounter) {
            jsonObject = (JSONObject)jsonArray.get(iArrayItemCounter);
            for (String keyName : jsonObject.keySet()) {
                String value = jsonObject.get(keyName).toString();
                newVector.put(keyName, value);
            }
        }
        return newVector;
    }
}

