/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

public class CMItemMediator
extends BaseMediator {
    private static final long serialVersionUID = 3496039375197416613L;
    public transient Enumeration attrDefs = null;
    private DKSequentialCollection attrColl = null;
    private dkCollection referenceAttributes = null;
    private DKSequentialCollection childComponents = null;
    private DKSequentialCollection foreignKeys = null;
    private CMItem item = null;
    private Locale libraryServerLocale = null;
    public String itemTypeName = null;
    public DKComponentTypeDefICM itemType = null;
    public String itemTypeDescription = null;
    public String formType = null;
    public Hashtable attrNameValuePairs = null;
    public boolean versionDefByApp = false;
    public boolean hasSavedSearches = false;
    public boolean wasCheckedOutByAction = false;
    public MessageResources messageResources = null;
    private static WCDateFormat wcDateFormats = null;
    private boolean showFieldHoverHelp = false;
    private RepositoryConfig repositoryConfig = null;

    public CMItemMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMItemMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public Enumeration getAttrDefs() {
        return this.attrDefs;
    }

    public Hashtable getAttrNameValuePairs() {
        return this.attrNameValuePairs;
    }

    public void setItem(CMItem item) {
        this.item = item;
    }

    public void setAttrNameValuePairs(Hashtable attrNameValuePairs) {
        this.attrNameValuePairs = attrNameValuePairs;
    }

    public boolean getHasSavedSearches() {
        return this.hasSavedSearches;
    }

    public void setHasSavedSearches(boolean hasSavedSearches) {
        this.hasSavedSearches = hasSavedSearches;
    }

    public boolean getVersionDefByApp() {
        return this.versionDefByApp;
    }

    public void setVersionDefByApp(boolean versionDefByApp) {
        this.versionDefByApp = versionDefByApp;
    }

    public boolean getWasCheckedOutByAction() {
        return this.wasCheckedOutByAction;
    }

    public void setWasCheckedOutByAction(boolean wasCheckedOutByAction) {
        this.wasCheckedOutByAction = wasCheckedOutByAction;
    }

    public void setAttrDefs(Enumeration criterias) {
        this.attrDefs = criterias;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public void setItemTypeName(String folderName) {
        this.itemTypeName = folderName;
    }

    public String getItemTypeDescription() {
        return this.itemTypeDescription;
    }

    public void setItemTypeDescription(String itemTypeDescription) {
        this.itemTypeDescription = itemTypeDescription;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public DKSequentialCollection getAttrColl() {
        return this.attrColl;
    }

    public void setAttrColl(DKSequentialCollection attrColl) {
        this.attrColl = attrColl;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            dkIterator iter;
            jsonObject.put("template_name", this.getItemTypeName());
            jsonObject.put("template_label", this.getItemTypeDescription());
            jsonObject.put("template_desc", this.getItemTypeDescription());
            JSONUtils.put(jsonObject, "parm_version_def_by_app", this.getVersionDefByApp());
            JSONUtils.put(jsonObject, "parm_checked_out_by_action", this.getWasCheckedOutByAction());
            JSONUtils.put(jsonObject, "showFieldHoverHelp", this.getShowFieldHoverHelp());
            if (this.getErrors().size() > 0) {
                Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
                return jsonObject;
            }
            this.setPropertiesInfo(jsonObject, this.item);
            jsonObject = this.convertAttrCollectionToJSON(jsonObject, this.getAttrColl(), null);
            if (this.referenceAttributes != null) {
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Reference Attributes of '" + this.getItemTypeName() + "':");
                iter = this.referenceAttributes.createIterator();
                if (iter != null) {
                    while (iter.more()) {
                        DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)iter.next();
                        JSONObject jsonCriteria = new JSONObject();
                        jsonCriteria.put("name", attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "attrName: " + attrGroup.getName());
                        jsonCriteria.put("dataType", "xs:reference");
                        JSONUtils.put(jsonCriteria, "required", false);
                        JSONUtils.put(jsonCriteria, "fixedValue", false);
                        JSONUtils.put(jsonCriteria, "ascending", false);
                        String encodedName = StringEscapeUtils.escapeHtml((String)attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label: " + encodedName);
                        jsonCriteria.put("label", encodedName);
                        jsonCriteria.put("label2", attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label2: " + attrGroup.getName());
                        CMItemMediator.addStringArrayToJSON(jsonCriteria, "validValues", new String[0]);
                        if (this.attrNameValuePairs == null) {
                            jsonCriteria.put("values", "");
                        } else {
                            String val = (String)this.attrNameValuePairs.get(attrGroup.getName());
                            jsonCriteria.put("values", val);
                        }
                        JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
                    }
                }
            }
            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Sub Entities of '" + this.getItemTypeName() + "':");
            iter = this.getChildComponents().createIterator();
            while (iter.more()) {
                DKComponentTypeDefICM compType = (DKComponentTypeDefICM)iter.next();
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "     - " + compType.getName() + ":  " + compType.getDescription());
                JSONObject childComp = new JSONObject();
                childComp.put("template_name", compType.getName());
                childComp.put("template_label", compType.getDescription());
                childComp.put("template_desc", compType.getDescription());
                JSONUtils.put(childComp, "parm_minCardinality", compType.getCardinalityMin());
                JSONUtils.put(childComp, "parm_maxCardinality", compType.getCardinalityMax());
                DKSequentialCollection childCompAttrColl = (DKSequentialCollection)compType.listAllAttributes();
                this.convertAttrCollectionToJSON(childComp, childCompAttrColl, compType.getName());
                dkCollection referenceAttributes = compType.listAttrGroups(99);
                dkIterator refIter = referenceAttributes.createIterator();
                if (refIter != null) {
                    while (refIter.more()) {
                        DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)refIter.next();
                        JSONObject jsonCriteria = new JSONObject();
                        jsonCriteria.put("name", attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "referenceAttrName: " + attrGroup.getName());
                        jsonCriteria.put("dataType", "xs:reference");
                        JSONUtils.put(jsonCriteria, "required", false);
                        JSONUtils.put(jsonCriteria, "fixedValue", false);
                        JSONUtils.put(jsonCriteria, "ascending", false);
                        String encodedName = StringEscapeUtils.escapeHtml((String)attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label: " + encodedName);
                        jsonCriteria.put("label", encodedName);
                        jsonCriteria.put("label2", attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label2: " + attrGroup.getName());
                        String key = compType.getName() + "@$" + attrGroup.getName();
                        String[] childCompRefAttrValues = null;
                        if (this.attrNameValuePairs != null && this.attrNameValuePairs.containsKey(key)) {
                            childCompRefAttrValues = (String[])this.attrNameValuePairs.get(key);
                        }
                        if (childCompRefAttrValues == null) {
                            childCompRefAttrValues = new String[]{};
                        }
                        CMItemMediator.addStringArrayToJSON(jsonCriteria, "validValues", childCompRefAttrValues);
                        JSONUtils.accumulate(childComp, "criterias", jsonCriteria);
                    }
                }
                JSONUtils.accumulate(jsonObject, "parm_childcomponents", childComp);
            }
        }
        catch (DKException e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", CMUtil.getUserFriendlyDkErrorMessage(e, this.getMessageResources()));
        }
        catch (Throwable t) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, t);
            this.addError("error.exception.general", t.getLocalizedMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public JSONObject convertAttrCollectionToJSON(JSONObject jsonObject, DKSequentialCollection attributeCollection, String childCompName) throws DKException, Exception {
        String methodName = "convertAttrCollectionToJSON";
        Logger.logEntry((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        JSONObject jsonCriteria = null;
        dkIterator iter = attributeCollection.createIterator();
        while (iter.more()) {
            DKAttrDefICM attr = (DKAttrDefICM)iter.next();
            if (attr.getType() != 4 && attr.getType() != 3 && attr.getType() != 10 && attr.getType() != 5 && attr.getType() != 6 && attr.getType() != 7 && attr.getType() != 9 && attr.getType() != 8 && attr.getType() != 2 && attr.getType() != 1) continue;
            jsonCriteria = new JSONObject();
            if (!attr.isQueryable()) continue;
            String attrName = attr.getName();
            jsonCriteria.put("name", attrName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attrName: " + attrName);
            String type = CMUtil.getCriteriaType(attr);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "type: " + type);
            jsonCriteria.put("dataType", type);
            if (this.getFormType().equals("search") || this.getFormType().equals("searchFolder")) {
                JSONUtils.put(jsonCriteria, "required", false);
            } else {
                JSONUtils.put(jsonCriteria, "required", !attr.isNullable());
                JSONUtils.put(jsonCriteria, "readOnly", !attr.isWriteable());
            }
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "is required: " + !attr.isNullable());
            JSONUtils.put(jsonCriteria, "fixedValue", false);
            JSONUtils.put(jsonCriteria, "ascending", false);
            String attrDisplayName = attr.getDescription();
            String encodedName = StringEscapeUtils.escapeHtml((String)attrDisplayName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "encoded label: " + encodedName);
            jsonCriteria.put("label", encodedName);
            jsonCriteria.put("label2", attrDisplayName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "display label: " + attrDisplayName);
            String format = this.getFormat(attr);
            if (format != null) {
                jsonCriteria.put("format", format);
            }
            jsonCriteria.put("minValue", CMUtil.getMin(attr));
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMin(): " + CMUtil.getMin(attr));
            jsonCriteria.put("maxValue", CMUtil.getMax(attr));
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMax(): " + CMUtil.getMax(attr));
            int maxEntrySize = attr.getSize();
            if (attr.getType() == 6) {
                ++maxEntrySize;
                ++maxEntrySize;
            }
            if (maxEntrySize != 0) {
                JSONUtils.put(jsonCriteria, "maxEntry", maxEntrySize);
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getSize(): " + maxEntrySize);
            }
            int minEntrySize = 0;
            if (attr.getType() == 1) {
                minEntrySize = attr.getScale();
            }
            JSONUtils.put(jsonCriteria, "minEntry", minEntrySize);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "minEntry = attr.getScale(): " + minEntrySize);
            String[] validValues = CMUtil.getValidValues(this.request, attr, (dkCollection)this.getForeignKeys(), jsonObject);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "validValues: " + Arrays.asList(validValues).toString());
            CMItemMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "locale: " + this.getLocale());
            String[] operators = this.getOperatorSymbols(attr, this.getMessageResources(), this.getLocale());
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "operators: " + Arrays.asList(operators).toString());
            CMItemMediator.addStringArrayToJSON(jsonCriteria, "availableOperators", operators);
            jsonCriteria.put("defaultOperator", operators[0]);
            if (this.attrNameValuePairs == null) {
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding default values: " + attr.getDefaultValue());
                jsonCriteria.put("values", attr.getDefaultValue());
            } else if (childCompName != null) {
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding Attribute Values - attribName: " + childCompName + "@$" + attr.getName());
                String[] childCompAttrValues = (String[])this.attrNameValuePairs.get(childCompName + "@$" + attr.getName());
                CMItemMediator.addStringArrayToJSON(jsonCriteria, "validValues", childCompAttrValues);
            } else {
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding Attribute Values - attribName: " + attr.getName() + " Value: " + this.attrNameValuePairs.get(attr.getName()));
                String val = (String)this.attrNameValuePairs.get(attr.getName());
                if (val != null) {
                    val = val.trim();
                }
                jsonCriteria.put("values", val);
            }
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            attr = null;
        }
        Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Returning JSON: " + jsonCriteria.toString());
        Logger.logExit((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        return jsonObject;
    }

    public String[] getOperatorSymbols(DKAttrDefICM attr, MessageResources resources, Locale locale) {
        String methodName = "getOperatorSymbols";
        ArrayList<String> arrayListReturn = new ArrayList<String>(15);
        if (attr.isTextSearchable()) {
            arrayListReturn.add("CONTAINS");
        }
        switch (attr.getType()) {
            case 19: {
                arrayListReturn.add("LIKE");
                arrayListReturn.add("NOTLIKE");
                if (!attr.isNullable()) break;
                arrayListReturn.add("NULL");
                arrayListReturn.add("NOTNULL");
                break;
            }
            case 1: 
            case 2: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                arrayListReturn.add("LIKE");
                arrayListReturn.add("NOTLIKE");
                if (attr.isNullable()) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                if (attr.isNullable()) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
                break;
            }
            default: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                arrayListReturn.add("IN");
                arrayListReturn.add("NOTIN");
                if (attr.isNullable()) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
            }
        }
        return arrayListReturn.toArray(new String[0]);
    }

    private static String getOperatorFromDisplayValue(String operator, MessageResources resources, Locale locale) {
        String op = null;
        if (operator.equalsIgnoreCase("EQUAL")) {
            op = "=";
        } else if (operator.equalsIgnoreCase("NOTEQUAL")) {
            op = "!=";
        } else if (operator.equalsIgnoreCase("LIKE")) {
            op = "LIKE";
        } else if (operator.equalsIgnoreCase("NOTLIKE")) {
            op = "NOT LIKE";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            op = "NOT IN";
        } else if (operator.equalsIgnoreCase("NULL")) {
            op = "IS NULL";
        } else if (operator.equalsIgnoreCase("NOTNULL")) {
            op = "IS NOT NULL";
        } else if (operator.equalsIgnoreCase("CONTAINS")) {
            op = "contains-text-basic";
        } else if (operator.equalsIgnoreCase("IN")) {
            op = "IN";
        } else if (operator.equalsIgnoreCase("LESS")) {
            op = "<";
        } else if (operator.equalsIgnoreCase("LESSOREQUAL")) {
            op = "<=";
        } else if (operator.equalsIgnoreCase("GREATEROREQUAL")) {
            op = ">=";
        } else if (operator.equalsIgnoreCase("GREATER")) {
            op = ">";
        } else if (operator.equalsIgnoreCase("BETWEEN")) {
            op = "BETWEEN";
        } else if (operator.equalsIgnoreCase("NOTBETWEEN")) {
            op = "NOT BETWEEN";
        }
        return op;
    }

    public static CMQueryService.QueryCriterion[] getQueryCriteria(HttpServletRequest request, SearchTemplate searchTemplate, CMQueryService queryService, MessageResources resources, Locale locale) throws IOException {
        String methodName = "getFromJSONString";
        Logger.logEntry(CMItemMediator.class, methodName, (ServletRequest)request);
        List<SearchCriteria> criteria = searchTemplate.getSearchCriteria();
        Iterator<SearchCriteria> i = criteria.iterator();
        CMQueryService.QueryCriterion[] retCrit = new CMQueryService.QueryCriterion[criteria.size()];
        int count = 0;
        while (i.hasNext()) {
            SearchCriteria criteriaEntry = i.next();
            if (!(criteriaEntry instanceof SearchCriterion)) continue;
            SearchCriterion criterion = (SearchCriterion)criteriaEntry;
            String criteriaName = criterion.getName();
            Logger.logDebug(CMItemMediator.class, methodName, (ServletRequest)request, "criteriaName : " + criteriaName);
            String displayOperator = criterion.getOperator();
            String queryOperator = CMItemMediator.getOperatorFromDisplayValue(displayOperator, resources, locale);
            Logger.logDebug(CMItemMediator.class, methodName, (ServletRequest)request, "displayOperator : " + displayOperator);
            Logger.logDebug(CMItemMediator.class, methodName, (ServletRequest)request, "queryOperator : " + queryOperator);
            String[] values = criterion.getValues();
            for (int j = 0; j < values.length; ++j) {
                String value;
                values[j] = value = CMItemMediator.replaceWildCardChars(values[j], queryOperator);
                Logger.logDebug(CMItemMediator.class, methodName, (ServletRequest)request, "value " + j + " = " + value);
            }
            int n = count++;
            CMQueryService cMQueryService = queryService;
            cMQueryService.getClass();
            retCrit[n] = cMQueryService.new CMQueryService.QueryCriterion(criteriaName, queryOperator, values);
        }
        Logger.logExit(CMItemMediator.class, methodName, (ServletRequest)request);
        return retCrit;
    }

    private static String replaceWildCardChars(String value, String operator) {
        if (operator.equalsIgnoreCase("LIKE") || operator.equalsIgnoreCase("NOTLIKE")) {
            value = value.replace('*', '%');
            value = value.replace('?', '_');
        }
        return value;
    }

    public String getFormat(DKAttrDefICM criteria) {
        String methodName = "getFormat";
        short type = criteria.getType();
        String returnFormat = null;
        switch (type) {
            case 9: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                int scaleValue = criteria.getScale();
                StringBuffer format = new StringBuffer();
                for (int precisionValue = criteria.getPrecision() - scaleValue; precisionValue > 0; --precisionValue) {
                    format.append("#");
                }
                if (scaleValue > 0) {
                    format.append(".");
                }
                while (scaleValue > 0) {
                    format.append("#");
                    --scaleValue;
                }
                returnFormat = format.toString();
            }
        }
        Logger.logDebug(CMItemMediator.class, methodName, (ServletRequest)this.request, "return format [" + criteria.getName() + "]: " + returnFormat);
        return returnFormat;
    }

    private void setPropertiesInfo(JSONObject jsonObject, CMItem tempHit) {
        String methodName = "setPropertiesInfo";
        Logger.logEntry(CMItemMediator.class, methodName, (ServletRequest)this.request);
        String systemPropertyLabel = null;
        String customLabel = null;
        JSONObject jsonSystemProperties = null;
        String[] configuredSystemProperties = null;
        configuredSystemProperties = tempHit.getItemType() == 2 ? this.repositoryConfig.getFolderSystemProperties() : this.repositoryConfig.getDocumentSystemProperties();
        if (configuredSystemProperties != null) {
            for (int i = 0; i < configuredSystemProperties.length; ++i) {
                String configuredSysProperty = configuredSystemProperties[i];
                Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, i + ":" + configuredSysProperty);
                String messageKey = "systemcm." + configuredSysProperty + ".label";
                systemPropertyLabel = MessageUtil.getMessage(this.getLocale(), messageKey);
                String customLabelID = "sys_" + configuredSysProperty;
                customLabel = BaseUtil.getCustomLabelValue(this.request, customLabelID);
                if (customLabel != null) {
                    systemPropertyLabel = customLabel;
                }
                if (configuredSysProperty.equalsIgnoreCase("createdTimestamp")) {
                    String createdTimestamp = "" + DateUtil.getISODateString(tempHit.getCreateTimestamp(), true);
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "createdTimestamp");
                    jsonSystemProperties.put("values", createdTimestamp);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:timestamp");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (configuredSysProperty.equalsIgnoreCase("version")) {
                    String version = tempHit.getVersion();
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "version");
                    jsonSystemProperties.put("values", version);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:integer");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (configuredSysProperty.equalsIgnoreCase("modifiedTimestamp")) {
                    String modifiedTimestamp = "" + DateUtil.getISODateString(tempHit.getLastChangedTimestamp(), true);
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "modifiedTimestamp");
                    jsonSystemProperties.put("values", modifiedTimestamp);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:timestamp");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (configuredSysProperty.equalsIgnoreCase("modifiedBy")) {
                    String modifiedBy = tempHit.getLastChangedUserid();
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "modifiedBy");
                    jsonSystemProperties.put("values", modifiedBy);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:string");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (configuredSysProperty.equalsIgnoreCase("createdBy")) {
                    String createdBy = tempHit.getCreateUserid();
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "createdBy");
                    jsonSystemProperties.put("values", createdBy);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:string");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (configuredSysProperty.equalsIgnoreCase("itemID")) {
                    String itemID = tempHit.getPidString();
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "itemID");
                    jsonSystemProperties.put("values", itemID);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:string");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (configuredSysProperty.equalsIgnoreCase("semanticType")) {
                    String semanticType = tempHit.getSemanticType();
                    jsonSystemProperties = new JSONObject();
                    jsonSystemProperties.put("name", "semanticType");
                    jsonSystemProperties.put("values", semanticType);
                    jsonSystemProperties.put("label", systemPropertyLabel);
                    jsonSystemProperties.put("dataType", "xs:string");
                    jsonSystemProperties.put("system", new Boolean(true));
                    JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                    continue;
                }
                if (!configuredSysProperty.equalsIgnoreCase("aclCode")) continue;
                String aclCode = tempHit.getAclCode();
                jsonSystemProperties = new JSONObject();
                jsonSystemProperties.put("name", "aclCode");
                jsonSystemProperties.put("values", aclCode);
                jsonSystemProperties.put("label", systemPropertyLabel);
                jsonSystemProperties.put("dataType", "xs:string");
                jsonSystemProperties.put("system", new Boolean(true));
                JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        }
    }

    public Locale getLibraryServerLocale() {
        return this.libraryServerLocale;
    }

    public void setLibraryServerLocale(Locale libraryServerLocale) {
        this.libraryServerLocale = libraryServerLocale;
    }

    public WCDateFormat getDateFormats() {
        return wcDateFormats;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        CMItemMediator.wcDateFormats = wcDateFormats;
    }

    public DKComponentTypeDefICM getItemType() {
        return this.itemType;
    }

    public void setItemType(DKComponentTypeDefICM itemType) {
        this.itemType = itemType;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    public DKSequentialCollection getChildComponents() {
        return this.childComponents;
    }

    public void setReferenceAttributes(dkCollection referenceAttributes) {
        this.referenceAttributes = referenceAttributes;
    }

    public void setChildComponents(DKSequentialCollection childComponents) {
        this.childComponents = childComponents;
    }

    public DKSequentialCollection getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(DKSequentialCollection foreignKeys) {
        this.foreignKeys = foreignKeys;
    }
}

