/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.mediator.HitMediator;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKWorkPackageICM;
import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMHitMediator
extends HitMediator {
    CMItem hit;
    DKCommonPrivilege dkCommonPrivilege;
    boolean isWorkItem;
    boolean isSpecificVersion;
    boolean includeMimeTypes;
    Set<String> requiredAttributes;
    String itemTypeName;
    CMEntity itemTypeHelper;
    String mimeType;
    boolean hasContent;
    boolean isCheckedOut;
    String checkedOutBy;

    public CMHitMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setHit(CMItem item, boolean isWorkItem, boolean isSpecificVersion, boolean includeMimeTypes) throws Exception {
        this.hit = item;
        this.isWorkItem = isWorkItem;
        this.isSpecificVersion = isSpecificVersion;
        this.itemTypeName = this.hit.getEntityName();
        this.itemTypeHelper = this.hit.getConnection().getEntity(this.itemTypeName);
        this.mimeType = this.hit.getMimeType();
        if (this.mimeType.equalsIgnoreCase("item") && !this.itemTypeName.equals("ICMSearch")) {
            if (includeMimeTypes) {
                this.hasContent = false;
            } else if (this.itemTypeHelper.getItemTypeClassification() == 2) {
                this.hasContent = true;
                this.mimeType = "unknown/unknown";
            } else {
                this.hasContent = false;
            }
        } else {
            this.hasContent = true;
        }
        this.isCheckedOut = this.hit.isCheckedOut();
        this.checkedOutBy = this.hit.getCheckedOutUserid();
    }

    public void setRequiredAttributes(Set<String> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    public void setDKCommonPrivilege(DKCommonPrivilege dkCommonPrivilege) {
        this.dkCommonPrivilege = dkCommonPrivilege;
    }

    @Override
    public String getItemId() {
        if (this.isWorkItem) {
            return this.hit.getWorkPackage().getPidString();
        }
        return this.hit.getPidString();
    }

    @Override
    public String getItemName() throws Exception {
        String itemName = this.hit.getName();
        if (itemName.equals("ICMROOTFOLDER")) {
            itemName = this.messageResources.getMessage(this.getLocale(), "folder.root.name");
        } else if (itemName.equals("ICMSYSDEFAULTFOLDER")) {
            itemName = this.messageResources.getMessage(this.getLocale(), "folder.sysdefault.name");
        }
        return itemName;
    }

    @Override
    public JSONObject buildAttributes() throws Exception {
        JSONArray jsonAttributeInfo;
        JSONObject jsonAttributes = new JSONObject();
        for (int i = 0; i < this.hit.getAttrCount(); ++i) {
            DKChildCollection children;
            String fieldQualifier;
            String propValue;
            String attrName = this.hit.getAttrName(i);
            if (this.requiredAttributes != null && !this.requiredAttributes.contains(attrName)) continue;
            short attrType = this.hit.getAttrType(attrName);
            if (attrType == 4 || attrType == 3 || attrType == 10 || attrType == 5 || attrType == 6 || attrType == 7 || attrType == 8 || attrType == 9 || attrType == 2 || attrType == 1) {
                jsonAttributeInfo = new JSONArray();
                propValue = null;
                propValue = this.hit.getAttrValue(attrName);
                if (propValue == null) {
                    propValue = "";
                }
                propValue = propValue.trim();
                jsonAttributeInfo.add(propValue);
                String fieldQualifier2 = CMUtil.getCriteriaType(attrType);
                jsonAttributeInfo.add(fieldQualifier2);
                this.putColumnSize(attrName, propValue.length());
                jsonAttributes.put(attrName, jsonAttributeInfo);
                continue;
            }
            if (attrType == 48) {
                DKDDO ddoRef;
                jsonAttributeInfo = new JSONArray();
                propValue = "";
                short dataidx = this.hit.getDDO().dataId("ATTR", attrName);
                if (dataidx != 0 && (ddoRef = (DKDDO)this.hit.getDDO().getData(dataidx)) != null) {
                    DKPidICM referencePid;
                    DKPidICM dKPidICM = referencePid = ddoRef != null ? (DKPidICM)ddoRef.getPidObject() : null;
                    if (referencePid != null) {
                        propValue = referencePid.pidString();
                    }
                }
                jsonAttributeInfo.add(propValue);
                fieldQualifier = CMUtil.getCriteriaType(attrType);
                jsonAttributeInfo.add(fieldQualifier);
                this.putColumnSize(attrName, propValue.length());
                jsonAttributes.put(attrName, jsonAttributeInfo);
                continue;
            }
            if (attrType != 1072) continue;
            jsonAttributeInfo = new JSONArray();
            propValue = "";
            short dataid = this.hit.getDDO().dataId("CHILD", attrName);
            if (dataid != 0 && (children = (DKChildCollection)this.hit.getDDO().getData(dataid)) != null && children.cardinality() > 0) {
                propValue = "@Child{'" + attrName + "'}";
            }
            jsonAttributeInfo.add(propValue);
            fieldQualifier = CMUtil.getCriteriaType(attrType);
            jsonAttributeInfo.add(fieldQualifier);
            this.putColumnSize(attrName, propValue.length());
            jsonAttributes.put(attrName, jsonAttributeInfo);
        }
        jsonAttributeInfo = new JSONArray();
        jsonAttributeInfo.add(this.getItemName());
        jsonAttributeInfo.add("xs:string");
        jsonAttributes.put("{NAME}", jsonAttributeInfo);
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.itemID.toString())) {
            jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(this.hit.getPidString());
            jsonAttributeInfo.add("xs:string");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.itemID.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.version.toString())) {
            jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(this.hit.getVersion());
            jsonAttributeInfo.add("xs:integer");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.version.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.modifiedBy.toString())) {
            jsonAttributeInfo = new JSONArray();
            String modifiedBy = "";
            if (this.hit.getLastChangedUserid() != null) {
                modifiedBy = this.hit.getLastChangedUserid();
            }
            jsonAttributeInfo.add(modifiedBy);
            jsonAttributeInfo.add("xs:string");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.modifiedBy.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.modifiedTimestamp.toString())) {
            jsonAttributeInfo = new JSONArray();
            String modifiedTimestamp = "";
            if (this.hit.getLastChangedTimestamp() != null) {
                modifiedTimestamp = WCDateFormat.getDateString(this.request, this.hit.getLastChangedTimestamp().getTime(), WCDateFormat.UTC_DATE_FORMAT);
            }
            jsonAttributeInfo.add(modifiedTimestamp);
            jsonAttributeInfo.add("xs:timestamp");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.modifiedTimestamp.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.aclCode.toString())) {
            jsonAttributeInfo = new JSONArray();
            String aclCode = "";
            if (this.hit.getAclCode() != null) {
                aclCode = this.hit.getAclCode();
            }
            jsonAttributeInfo.add(aclCode);
            jsonAttributeInfo.add("xs:integer");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.aclCode.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.semanticType.toString())) {
            jsonAttributeInfo = new JSONArray();
            String semanticType = "";
            if (this.hit.getSemanticType() != null) {
                semanticType = this.hit.getSemanticType();
            }
            jsonAttributeInfo.add(semanticType);
            jsonAttributeInfo.add("xs:integer");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.semanticType.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.createdTimestamp.toString())) {
            jsonAttributeInfo = new JSONArray();
            String createdTimestamp = "";
            if (this.hit.getCreateTimestamp() != null) {
                createdTimestamp = WCDateFormat.getDateString(this.request, this.hit.getCreateTimestamp().getTime(), WCDateFormat.UTC_DATE_FORMAT);
            }
            jsonAttributeInfo.add(createdTimestamp);
            jsonAttributeInfo.add("xs:timestamp");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.createdTimestamp.toString(), jsonAttributeInfo);
        }
        if (this.requiredAttributes == null || this.requiredAttributes.contains(CMSearchConstants.SystemAttribute.createdBy.toString())) {
            jsonAttributeInfo = new JSONArray();
            String createdBy = "";
            if (this.hit.getCreateUserid() != null) {
                createdBy = this.hit.getCreateUserid();
            }
            jsonAttributeInfo.add(createdBy);
            jsonAttributeInfo.add("xs:string");
            jsonAttributes.put(CMSearchConstants.SystemAttribute.createdBy.toString(), jsonAttributeInfo);
        }
        if (this.isWorkItem) {
            DKWorkPackageICM workPackage = this.hit.getWorkPackage();
            if (this.requiredAttributes == null || this.requiredAttributes.contains("process_name")) {
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(workPackage.getProcessName());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("process_name", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("processStep")) {
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(workPackage.getWorkNodeName());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("processStep", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("process_priority")) {
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add((Object)workPackage.getPriority());
                jsonAttributeInfo.add("xs:integer");
                jsonAttributes.put("process_priority", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("processSuspendState")) {
                jsonAttributeInfo = new JSONArray();
                String suspendStateString = MessageUtil.getMessage(this.locale, "desktop.workList.view.active");
                if (workPackage.getSuspendState() == 1) {
                    suspendStateString = MessageUtil.getMessage(this.locale, "desktop.workList.view.suspended");
                }
                jsonAttributeInfo.add(suspendStateString);
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("processSuspendState", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("processNotifyDate")) {
                jsonAttributeInfo = new JSONArray();
                String notifyDate = "";
                if (workPackage.getNotifyTime() != null) {
                    notifyDate = WCDateFormat.getDateString(this.request, workPackage.getNotifyTime().getTime(), WCDateFormat.UTC_DATE_FORMAT);
                }
                jsonAttributeInfo.add(notifyDate);
                jsonAttributeInfo.add("xs:timestamp");
                jsonAttributes.put("processNotifyDate", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("process_owner")) {
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(workPackage.getOwner());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("process_owner", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("processLastMovedBy")) {
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(workPackage.getUserLastMoved());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("processLastMovedBy", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("processLastMovedDate")) {
                jsonAttributeInfo = new JSONArray();
                String lastMovedDate = "";
                if (workPackage.getTimeLastMoved() != null) {
                    lastMovedDate = WCDateFormat.getDateString(this.request, workPackage.getTimeLastMoved().getTime(), WCDateFormat.UTC_DATE_FORMAT);
                }
                jsonAttributeInfo.add(lastMovedDate);
                jsonAttributeInfo.add("xs:timestamp");
                jsonAttributes.put("processLastMovedDate", jsonAttributeInfo);
            }
            if (this.requiredAttributes == null || this.requiredAttributes.contains("processResumeDate")) {
                jsonAttributeInfo = new JSONArray();
                String processResumeDate = "";
                if (workPackage.getResumeTime() != null) {
                    processResumeDate = WCDateFormat.getDateString(this.request, workPackage.getResumeTime().getTime(), WCDateFormat.UTC_DATE_FORMAT);
                }
                jsonAttributeInfo.add(processResumeDate);
                jsonAttributeInfo.add("xs:timestamp");
                jsonAttributes.put("processResumeDate", jsonAttributeInfo);
            }
        }
        return jsonAttributes;
    }

    private String changeTimeZone(String oldTimeValue) {
        String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss.SSSSSS";
        String newTimeValue = null;
        TimeZone tz = TimeZone.getTimeZone("GMT");
        TimeZone tz1 = Calendar.getInstance().getTimeZone();
        if (oldTimeValue != null) {
            newTimeValue = CMUtil.changeTimeZone(oldTimeValue, TIMESTAMP_FORMAT, tz, tz1);
        }
        return newTimeValue;
    }

    public void putColumnSize(String index, int size) {
    }

    @Override
    public boolean canEditProperties() throws Exception {
        if (this.isCheckedOut && !this.hit.getConnection().getUserid().equalsIgnoreCase(this.checkedOutBy)) {
            return false;
        }
        return CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 31);
    }

    @Override
    public boolean canEditDoc() throws Exception {
        if (this.isSpecificVersion) {
            return false;
        }
        if (!this.hasContent || this.hit.getItemType() == 2) {
            return false;
        }
        if (this.isCheckedOut && !this.hit.getConnection().getUserid().equalsIgnoreCase(this.checkedOutBy)) {
            return false;
        }
        boolean privViewDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 1);
        boolean privUpdatePart = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 84);
        return privViewDoc && privUpdatePart;
    }

    @Override
    public boolean canViewNotes() throws Exception {
        boolean privViewNotes = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 66);
        return privViewNotes;
    }

    @Override
    public boolean canAddDoc() throws Exception {
        boolean privAddItem = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 28);
        boolean privAddContent = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 4);
        return privAddItem && privAddContent;
    }

    @Override
    public boolean canAddItem() throws Exception {
        boolean privAddItem = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 28);
        return privAddItem;
    }

    @Override
    public boolean canEmailDoc() throws Exception {
        if (!this.hasContent || this.hit.getItemType() == 2) {
            return false;
        }
        boolean privViewDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 1);
        boolean privExport = privViewDoc && CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 29);
        return privViewDoc && privExport;
    }

    @Override
    public boolean canExport() throws Exception {
        if (!this.hasContent || this.hit.getItemType() == 2) {
            return false;
        }
        boolean privViewDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 1);
        boolean privExport = privViewDoc && CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 29);
        return privExport;
    }

    @Override
    public boolean canAddToFolder() throws Exception {
        boolean privAddToFolder = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 38);
        return privAddToFolder;
    }

    @Override
    public boolean canRemoveFromFolder() throws Exception {
        boolean privRemoveFromFolder = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 39);
        return privRemoveFromFolder;
    }

    @Override
    public boolean canAddLink() throws Exception {
        boolean privAddLink = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 80);
        return privAddLink;
    }

    @Override
    public boolean canRemoveLink() throws Exception {
        boolean privRemoveLink = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 82);
        return privRemoveLink;
    }

    @Override
    public boolean canAddNotes() throws Exception {
        boolean privAddNotes = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 65);
        return privAddNotes;
    }

    @Override
    public boolean canPrintNotes() throws Exception {
        boolean privPrintNotes = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 2);
        return privPrintNotes;
    }

    @Override
    public boolean canPrintDoc() throws Exception {
        if (!this.hasContent || this.hit.getItemType() == 2) {
            return false;
        }
        boolean privViewDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 1);
        boolean privPrintDoc = privViewDoc && CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 2);
        return privPrintDoc;
    }

    @Override
    public boolean canCheckInOutDoc() throws Exception {
        if (this.isSpecificVersion) {
            return false;
        }
        boolean privCheckinDocAdmin = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 74);
        if (this.isCheckedOut && !privCheckinDocAdmin && !this.hit.getConnection().getUserid().equalsIgnoreCase(this.checkedOutBy)) {
            return false;
        }
        boolean privCheckInOutDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 33);
        if (privCheckinDocAdmin) {
            privCheckInOutDoc = true;
        }
        return privCheckInOutDoc;
    }

    @Override
    public boolean canCheckInDoc() throws Exception {
        if (this.isSpecificVersion) {
            return false;
        }
        boolean privCheckInOutDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 33);
        return privCheckInOutDoc && this.canEditDoc();
    }

    @Override
    public boolean canCheckOutDoc() throws Exception {
        boolean privCheckInOutDoc;
        if (this.isSpecificVersion) {
            return false;
        }
        boolean privCheckoutDoc = privCheckInOutDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 33);
        return privCheckoutDoc;
    }

    @Override
    public boolean canCancelCheckOutDoc() throws Exception {
        if (this.isSpecificVersion) {
            return false;
        }
        boolean privCheckinDocAdmin = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 74);
        if (this.isCheckedOut && !privCheckinDocAdmin && !this.hit.getConnection().getUserid().equalsIgnoreCase(this.checkedOutBy)) {
            return false;
        }
        boolean privCheckInOutDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 33);
        if (privCheckinDocAdmin) {
            privCheckInOutDoc = true;
        }
        return privCheckInOutDoc;
    }

    @Override
    public boolean canViewAnnotations() throws Exception {
        if (this.hit.getItemType() == 4 || !this.itemTypeHelper.getHasAnnotationpart() || this.itemTypeHelper.getItemTypeClassification() == 1) {
            return false;
        }
        boolean privViewAnnotations = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 7);
        return privViewAnnotations;
    }

    @Override
    public boolean canEditAnnotations() throws Exception {
        if (this.isSpecificVersion) {
            return false;
        }
        if (this.hit.getItemType() == 4 || !this.itemTypeHelper.getHasAnnotationpart() || this.itemTypeHelper.getItemTypeClassification() == 1) {
            return false;
        }
        boolean privEditAnnotations = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 8);
        return privEditAnnotations;
    }

    @Override
    public boolean canViewDoc() throws Exception {
        if (!this.hasContent || this.hit.getItemType() == 2) {
            return false;
        }
        boolean privViewDoc = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 1);
        return privViewDoc;
    }

    @Override
    public boolean canDelete() throws Exception {
        boolean _privDelete;
        boolean privDeletePart = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 78);
        boolean privDeleteItem = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 27);
        boolean bl = _privDelete = privDeleteItem && privDeletePart;
        if (!this.hasContent || this.hit.getItemType() == 2) {
            _privDelete = privDeleteItem;
        }
        return _privDelete;
    }

    @Override
    public boolean canStartWorkflow() throws Exception {
        if (this.isSpecificVersion) {
            return false;
        }
        boolean privStartWorkflow = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 34);
        return privStartWorkflow;
    }

    @Override
    public boolean canHold() {
        return false;
    }

    @Override
    public boolean canMoveToFolder() throws Exception {
        boolean privMoveToFolder = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 39);
        return privMoveToFolder;
    }

    @Override
    public boolean canChangeClass() throws Exception {
        if (this.itemTypeName.equals("ICMSearch")) {
            return false;
        }
        boolean privChangeClass = CMBaseUtil.checkAuthorization(this.dkCommonPrivilege, 32);
        return privChangeClass;
    }

    @Override
    public boolean canMajorVersion() {
        return false;
    }

    @Override
    public boolean canMinorVersion() {
        return false;
    }

    @Override
    public boolean canDeclare() {
        return false;
    }
}

