/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKForeignKeyDefICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

public class CMForeignKeyMediator
extends BaseMediator {
    private static final long serialVersionUID = 3496039375197416613L;
    public transient Enumeration attrDefs = null;
    private DKSequentialCollection attrColl = null;
    private DKSequentialCollection childComponents = null;
    private DKSequentialCollection foreignKeys = null;
    private Locale libraryServerLocale = null;
    public String itemTypeName = null;
    public DKComponentTypeDefICM itemType = null;
    public String itemTypeDescription = null;
    public String serverName = null;
    public String criteriaName = null;
    public String[] criteriaNames = null;
    public String[] criteriaValues = null;
    public Hashtable attrNameValuePairs = null;
    public boolean versionDefByApp = false;
    public boolean hasSavedSearches = false;
    public boolean wasCheckedOutByAction = false;
    public MessageResources messageResources = null;
    private static WCDateFormat wcDateFormats = null;
    private boolean showFieldHoverHelp = false;

    public CMForeignKeyMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMForeignKeyMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public Enumeration getAttrDefs() {
        return this.attrDefs;
    }

    public Hashtable getAttrNameValuePairs() {
        return this.attrNameValuePairs;
    }

    public void setAttrNameValuePairs(Hashtable attrNameValuePairs) {
        this.attrNameValuePairs = attrNameValuePairs;
    }

    public boolean getHasSavedSearches() {
        return this.hasSavedSearches;
    }

    public void setHasSavedSearches(boolean hasSavedSearches) {
        this.hasSavedSearches = hasSavedSearches;
    }

    public boolean getVersionDefByApp() {
        return this.versionDefByApp;
    }

    public void setVersionDefByApp(boolean versionDefByApp) {
        this.versionDefByApp = versionDefByApp;
    }

    public boolean getWasCheckedOutByAction() {
        return this.wasCheckedOutByAction;
    }

    public void setWasCheckedOutByAction(boolean wasCheckedOutByAction) {
        this.wasCheckedOutByAction = wasCheckedOutByAction;
    }

    public void setAttrDefs(Enumeration criterias) {
        this.attrDefs = criterias;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public void setItemTypeName(String folderName) {
        this.itemTypeName = folderName;
    }

    public String getItemTypeDescription() {
        return this.itemTypeDescription;
    }

    public void setItemTypeDescription(String itemTypeDescription) {
        this.itemTypeDescription = itemTypeDescription;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getCriteriaName() {
        return this.criteriaName;
    }

    public void setCriteriaName(String criteriaName) {
        this.criteriaName = criteriaName;
    }

    public String[] getCriteriaNames() {
        return this.criteriaNames;
    }

    public void setCriteriaNames(String[] criteriaNames) {
        this.criteriaNames = criteriaNames;
    }

    public String[] getCriteriaValues() {
        return this.criteriaValues;
    }

    public void setCriteriaValues(String[] criteriaValues) {
        this.criteriaValues = criteriaValues;
    }

    public DKSequentialCollection getAttrColl() {
        return this.attrColl;
    }

    public void setAttrColl(DKSequentialCollection attrColl) {
        this.attrColl = attrColl;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("template_name", this.getItemTypeName());
            jsonObject.put("template_label", this.getItemTypeDescription());
            jsonObject.put("template_desc", this.getItemTypeDescription());
            String[] attrNames = this.getCriteriaNames();
            String[] attrValues = this.getCriteriaValues();
            if (Logger.isDebugLogged() && this.foreignKeys != null) {
                dkIterator iter = this.foreignKeys.createIterator();
                while (iter.more()) {
                    DKForeignKeyDefICM def = (DKForeignKeyDefICM)iter.next();
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    String[] srcAttrNames = def.listSourceAttrNames();
                    for (int i = 0; i < srcAttrNames.length; ++i) {
                        sb.append(this.itemType.getAttr(srcAttrNames[i]).getDescription());
                        if (i >= srcAttrNames.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("]");
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "constraint name: " + def.getConstraintName() + ", contraints by name: " + sb.toString());
                }
            }
            if (attrNames != null && attrValues != null && this.foreignKeys != null) {
                ArrayList valuesArrayList;
                dkIterator iterator = this.foreignKeys.createIterator();
                DKForeignKeyDefICM foreignKey = null;
                String[] attrInfo = null;
                String criteriaColumnSequence = "";
                boolean found = false;
                while (iterator.more() && !found) {
                    foreignKey = (DKForeignKeyDefICM)iterator.next();
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "check constraint name: " + foreignKey.getConstraintName());
                    attrInfo = foreignKey.listSourceAttrNames();
                    for (int i = 0; i < attrInfo.length && !found; ++i) {
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "compare criteria: " + this.criteriaName + " vs " + attrInfo[i]);
                        if (!attrInfo[i].equals(this.criteriaName)) continue;
                        found = true;
                        criteriaColumnSequence = attrInfo[0];
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "found criteria: " + criteriaColumnSequence);
                    }
                }
                Vector<String> columnNamesVector = new Vector<String>();
                Vector<String> keysVector = new Vector<String>();
                Vector<String> valuesVector = new Vector<String>();
                if (found) {
                    block7: for (int i = 0; i < attrNames.length; ++i) {
                        String attrName = attrNames[i];
                        for (int j = 0; j < attrInfo.length; ++j) {
                            if (!attrInfo[2].equals(attrName)) continue;
                            if (attrInfo[0].compareTo(criteriaColumnSequence) > 0) {
                                columnNamesVector.addElement(attrName);
                                continue block7;
                            }
                            if (attrValues[i].toString().length() <= 0) continue block7;
                            keysVector.addElement(attrName);
                            valuesVector.addElement(attrValues[i].toString());
                            continue block7;
                        }
                    }
                }
                String[] columnNames = new String[columnNamesVector.size()];
                for (int i = 0; i < columnNamesVector.size(); ++i) {
                    columnNames[i] = (String)columnNamesVector.elementAt(i);
                }
                DKNVPair[] foreignKeyValues = null;
                if (!keysVector.isEmpty()) {
                    foreignKeyValues = new DKNVPair[keysVector.size()];
                    for (int i = 0; i < foreignKeyValues.length; ++i) {
                        String value = (String)valuesVector.elementAt(i);
                        if (value.length() <= 0) continue;
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "keys add: [" + (String)keysVector.elementAt(i) + "," + value + "]");
                        foreignKeyValues[i] = new DKNVPair((String)keysVector.elementAt(i), (Object)value);
                    }
                }
                if (columnNames.length > 0 && (valuesArrayList = foreignKey.getSpecificAttrsForForeignKey(foreignKeyValues, columnNames)) != null && valuesArrayList.size() > 0) {
                    Object[] valuesArray = valuesArrayList.toArray();
                    for (int i = 0; i < columnNames.length; ++i) {
                        JSONObject jsonCriteria = new JSONObject();
                        String attrName = columnNames[i];
                        jsonCriteria.put("name", attrName);
                        String[] validValues = (String[])valuesArray[i];
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "attrName: " + attrName + " add " + Arrays.asList(validValues).toString());
                        Arrays.sort(validValues, Collator.getInstance(this.request.getLocale()));
                        CMForeignKeyMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
                        JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
                    }
                }
            }
        }
        catch (DKException e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", CMUtil.getUserFriendlyDkErrorMessage(e, this.getMessageResources()));
        }
        catch (Throwable t) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, t);
            this.addError("error.exception.general", t.getLocalizedMessage());
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public JSONObject convertAttrCollectionToJSON(JSONObject jsonObject, DKSequentialCollection attributeCollection, String childCompName) throws DKException, Exception {
        String methodName = "convertAttrCollectionToJSON";
        Logger.logEntry((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        JSONObject jsonCriteria = null;
        dkIterator iter = attributeCollection.createIterator();
        while (iter.more()) {
            DKAttrDefICM attr = (DKAttrDefICM)iter.next();
            if (attr.getType() != 4 && attr.getType() != 3 && attr.getType() != 10 && attr.getType() != 5 && attr.getType() != 6 && attr.getType() != 7 && attr.getType() != 9 && attr.getType() != 8 && attr.getType() != 2 && attr.getType() != 1) continue;
            jsonCriteria = new JSONObject();
            if (!attr.isQueryable()) continue;
            String attrName = attr.getName();
            if (childCompName != null) {
                attrName = childCompName + "/" + attrName;
            }
            jsonCriteria.put("name", attrName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attrName: " + attrName);
            String type = CMUtil.getCriteriaType(attr);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "type: " + type);
            jsonCriteria.put("dataType", type);
            JSONUtils.put(jsonCriteria, "fixedValue", false);
            String[] validValues = CMUtil.getValidValues(this.request, attr, (dkCollection)this.getForeignKeys(), null);
            CMForeignKeyMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            JSONUtils.put(jsonCriteria, "ascending", false);
            String attrDisplayName = attr.getDescription();
            String encodedName = StringEscapeUtils.escapeHtml((String)attrDisplayName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "label: " + encodedName);
            jsonCriteria.put("label", encodedName);
            String format = this.getFormat(attr);
            if (format != null) {
                jsonCriteria.put("format", this.getFormat(attr));
            }
            jsonCriteria.put("minValue", CMUtil.getMin(attr));
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMin(): " + CMUtil.getMin(attr));
            jsonCriteria.put("maxValue", CMUtil.getMax(attr));
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMax(): " + CMUtil.getMax(attr));
            int maxEntrySize = attr.getSize();
            if (attr.getType() == 6) {
                ++maxEntrySize;
                ++maxEntrySize;
            }
            if (maxEntrySize != 0) {
                JSONUtils.put(jsonCriteria, "maxEntry", maxEntrySize);
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getSize(): " + maxEntrySize);
            }
            int minEntrySize = 0;
            if (attr.getType() == 1) {
                minEntrySize = attr.getScale();
            }
            JSONUtils.put(jsonCriteria, "minEntry", minEntrySize);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "minEntry = attr.getScale(): " + minEntrySize);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "this.getLocale(): " + this.getLocale());
            String[] operators = this.getOperatorSymbols(attr, this.getMessageResources(), this.getLocale());
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "operators.length: " + operators.length);
            CMForeignKeyMediator.addStringArrayToJSON(jsonCriteria, "availableOperators", operators);
            jsonCriteria.put("defaultOperator", operators[0]);
            if (this.attrNameValuePairs == null) {
                String[] value = new String[]{attr.getDefaultValue()};
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding default values : " + value.length);
                jsonCriteria.put("values", attr.getDefaultValue());
            } else {
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding Attribute Values - attribName: " + attr.getName() + " Value: " + this.attrNameValuePairs.get(attr.getName()));
                if (childCompName != null) {
                    String[] childCompAttrValues = (String[])this.attrNameValuePairs.get(childCompName + "@$" + attr.getName());
                    CMForeignKeyMediator.addStringArrayToJSON(jsonCriteria, "validValues", childCompAttrValues);
                } else {
                    jsonCriteria.put("values", (String)this.attrNameValuePairs.get(attr.getName()));
                }
            }
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            attr = null;
        }
        Logger.logExit((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        return jsonObject;
    }

    public String[] getOperatorSymbols(DKAttrDefICM attr, MessageResources resources, Locale locale) {
        String methodName = "getOperatorSymbols";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<String> arrayListReturn = new ArrayList<String>(15);
        if (attr.isTextSearchable()) {
            arrayListReturn.add("CONTAINS");
        }
        switch (attr.getType()) {
            case 19: {
                arrayListReturn.add("LIKE");
                arrayListReturn.add("NOTLIKE");
                if (!attr.isNullable()) break;
                arrayListReturn.add("NULL");
                arrayListReturn.add("NOTNULL");
                break;
            }
            case 1: 
            case 2: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                arrayListReturn.add("LIKE");
                arrayListReturn.add("NOTLIKE");
                if (attr.isNullable()) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                if (attr.isNullable()) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
                break;
            }
            default: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                arrayListReturn.add("IN");
                arrayListReturn.add("NOTIN");
                if (attr.isNullable()) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
            }
        }
        return arrayListReturn.toArray(new String[0]);
    }

    private static String getOperatorFromDisplayValue(String operator, MessageResources resources, Locale locale) {
        String op = null;
        if (operator.equalsIgnoreCase("EQUAL")) {
            op = "=";
        } else if (operator.equalsIgnoreCase("NOTEQUAL")) {
            op = "!=";
        } else if (operator.equalsIgnoreCase("LIKE")) {
            op = "LIKE";
        } else if (operator.equalsIgnoreCase("NOTLIKE")) {
            op = "NOT LIKE";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            op = "NOT IN";
        } else if (operator.equalsIgnoreCase("NULL")) {
            op = "IS NULL";
        } else if (operator.equalsIgnoreCase("NOTNULL")) {
            op = "IS NOT NULL";
        } else if (operator.equalsIgnoreCase("CONTAINS")) {
            op = "contains-text-basic";
        } else if (operator.equalsIgnoreCase("IN")) {
            op = "IN";
        } else if (operator.equalsIgnoreCase("LESS")) {
            op = "<";
        } else if (operator.equalsIgnoreCase("LESSOREQUAL")) {
            op = "<=";
        } else if (operator.equalsIgnoreCase("GREATEROREQUAL")) {
            op = ">=";
        } else if (operator.equalsIgnoreCase("GREATER")) {
            op = ">";
        } else if (operator.equalsIgnoreCase("BETWEEN")) {
            op = "BETWEEN";
        } else if (operator.equalsIgnoreCase("NOTBETWEEN")) {
            op = "NOT BETWEEN";
        }
        return op;
    }

    public static CMQueryService.QueryCriterion[] getFromJSONString(HttpServletRequest request, String stringJSON, CMQueryService queryService, MessageResources resources, Locale locale) throws IOException {
        String methodName = "getFromJSONString";
        Logger.logEntry(CMForeignKeyMediator.class, methodName, (ServletRequest)request);
        Logger.logDebug(CMForeignKeyMediator.class, methodName, (ServletRequest)request, "stringJSON = " + stringJSON);
        JSONObject jsonObject = JSONObject.parse(stringJSON);
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        CMQueryService.QueryCriterion[] retCrit = new CMQueryService.QueryCriterion[criteriasJsonArray.size()];
        CMQueryService.QueryCriterion queryCriteria = null;
        Logger.logDebug(CMForeignKeyMediator.class, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            String criteriaName = criteria.get("name").toString();
            Logger.logDebug(CMForeignKeyMediator.class, methodName, (ServletRequest)request, "criteriaName : " + criteriaName);
            String displayOperator = criteria.get("operator").toString();
            String queryOperator = CMForeignKeyMediator.getOperatorFromDisplayValue(displayOperator, resources, locale);
            Logger.logDebug(CMForeignKeyMediator.class, methodName, (ServletRequest)request, "displayOperator : " + displayOperator);
            Logger.logDebug(CMForeignKeyMediator.class, methodName, (ServletRequest)request, "queryOperator : " + queryOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                String value = (String)valuesJsonArray.get(iValuesCounter);
                tempValuesArray[iValuesCounter] = value = CMForeignKeyMediator.replaceWildCardChars(value, queryOperator);
                Logger.logDebug(CMForeignKeyMediator.class, methodName, (ServletRequest)request, "value" + iValuesCounter + " = " + value);
            }
            CMQueryService cMQueryService = queryService;
            cMQueryService.getClass();
            retCrit[iCriteriaCounter] = queryCriteria = cMQueryService.new CMQueryService.QueryCriterion(criteriaName, queryOperator, tempValuesArray);
        }
        Logger.logExit(CMForeignKeyMediator.class, methodName, (ServletRequest)request);
        return retCrit;
    }

    private static String replaceWildCardChars(String value, String operator) {
        if (operator.equalsIgnoreCase("LIKE") || operator.equalsIgnoreCase("NOTLIKE")) {
            value = value.replace('*', '%');
            value = value.replace('?', '_');
        }
        return value;
    }

    public String getFormat(DKAttrDefICM criteria) {
        String methodName = "getFormat";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        short type = criteria.getType();
        String returnFormat = null;
        WCDateFormat wcDateFormat = this.getDateFormats();
        switch (type) {
            case 9: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                int scaleValue = criteria.getScale();
                StringBuffer format = new StringBuffer();
                for (int precisionValue = criteria.getPrecision() - scaleValue; precisionValue > 0; --precisionValue) {
                    format.append("#");
                }
                if (scaleValue > 0) {
                    format.append(".");
                }
                while (scaleValue > 0) {
                    format.append("#");
                    --scaleValue;
                }
                returnFormat = format.toString();
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "returned Format [" + criteria.getName() + "]: " + returnFormat);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    public Locale getLibraryServerLocale() {
        return this.libraryServerLocale;
    }

    public void setLibraryServerLocale(Locale libraryServerLocale) {
        this.libraryServerLocale = libraryServerLocale;
    }

    public WCDateFormat getDateFormats() {
        return wcDateFormats;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        CMForeignKeyMediator.wcDateFormats = wcDateFormats;
    }

    public DKComponentTypeDefICM getItemType() {
        return this.itemType;
    }

    public void setItemType(DKComponentTypeDefICM itemType) {
        this.itemType = itemType;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    public DKSequentialCollection getChildComponents() {
        return this.childComponents;
    }

    public void setChildComponents(DKSequentialCollection childComponents) {
        this.childComponents = childComponents;
    }

    public DKSequentialCollection getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(DKSequentialCollection foreignKeys) {
        this.foreignKeys = foreignKeys;
    }
}

