/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.ChildSearchCriteria;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMCriteriasMediator
extends BaseMediator {
    private static final long serialVersionUID = 3496039375197416613L;
    public transient Enumeration attrDefs = null;
    private DKSequentialCollection attrColl = null;
    private DKSequentialCollection childComponents = null;
    private DKSequentialCollection foreignKeys = null;
    private CMItem item = null;
    private Locale libraryServerLocale = null;
    public String itemTypeName = null;
    public DKComponentTypeDefICM itemType = null;
    public String itemTypeDescription = null;
    public String formType = null;
    public Hashtable attrNameValuePairs = null;
    public boolean versionDefByApp = false;
    public boolean hasSavedSearches = false;
    public boolean wasCheckedOutByAction = false;
    public MessageResources messageResources = null;
    private boolean showFieldHoverHelp = false;

    public CMCriteriasMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMCriteriasMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public Enumeration getAttrDefs() {
        return this.attrDefs;
    }

    public Hashtable getAttrNameValuePairs() {
        return this.attrNameValuePairs;
    }

    public void setItem(CMItem item) {
        this.item = item;
    }

    public void setAttrNameValuePairs(Hashtable attrNameValuePairs) {
        this.attrNameValuePairs = attrNameValuePairs;
    }

    public boolean getHasSavedSearches() {
        return this.hasSavedSearches;
    }

    public void setHasSavedSearches(boolean hasSavedSearches) {
        this.hasSavedSearches = hasSavedSearches;
    }

    public boolean getVersionDefByApp() {
        return this.versionDefByApp;
    }

    public void setVersionDefByApp(boolean versionDefByApp) {
        this.versionDefByApp = versionDefByApp;
    }

    public boolean getWasCheckedOutByAction() {
        return this.wasCheckedOutByAction;
    }

    public void setWasCheckedOutByAction(boolean wasCheckedOutByAction) {
        this.wasCheckedOutByAction = wasCheckedOutByAction;
    }

    public void setAttrDefs(Enumeration criterias) {
        this.attrDefs = criterias;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public void setItemTypeName(String folderName) {
        this.itemTypeName = folderName;
    }

    public String getItemTypeDescription() {
        return this.itemTypeDescription;
    }

    public void setItemTypeDescription(String itemTypeDescription) {
        this.itemTypeDescription = itemTypeDescription;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public DKSequentialCollection getAttrColl() {
        return this.attrColl;
    }

    public void setAttrColl(DKSequentialCollection attrColl) {
        this.attrColl = attrColl;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("template_name", this.getItemTypeName());
            jsonObject.put("template_label", this.getItemTypeDescription());
            jsonObject.put("template_desc", this.getItemTypeDescription());
            JSONUtils.put(jsonObject, "parm_version_def_by_app", this.getVersionDefByApp());
            JSONUtils.put(jsonObject, "parm_checked_out_by_action", this.getWasCheckedOutByAction());
            JSONUtils.put(jsonObject, "showFieldHoverHelp", this.getShowFieldHoverHelp());
            if (this.getErrors().size() > 0) {
                Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
                return jsonObject;
            }
            if (this.getFormType().equals("import") && this.item != null) {
                this.setPropertiesInfo(jsonObject, this.item);
            }
            jsonObject = this.convertAttrCollectionToJSON(jsonObject, this.getAttrColl(), null);
            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "\nSub Entities of '" + this.getItemTypeName() + "':");
            dkIterator iter = this.getChildComponents().createIterator();
            while (iter.more()) {
                DKComponentTypeDefICM compType = (DKComponentTypeDefICM)iter.next();
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "     - " + compType.getName() + ":  " + compType.getDescription());
                JSONObject childComp = new JSONObject();
                childComp.put("template_name", compType.getName());
                childComp.put("template_label", compType.getDescription());
                childComp.put("template_desc", compType.getDescription());
                JSONUtils.put(childComp, "parm_minCardinality", compType.getCardinalityMin());
                JSONUtils.put(childComp, "parm_maxCardinality", compType.getCardinalityMax());
                DKSequentialCollection childCompAttrColl = (DKSequentialCollection)compType.listAllAttributes();
                this.convertAttrCollectionToJSON(childComp, childCompAttrColl, compType.getName());
                JSONUtils.accumulate(jsonObject, "parm_childcomponents", childComp);
            }
        }
        catch (DKException e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", CMUtil.getUserFriendlyDkErrorMessage(e, this.getMessageResources()));
        }
        catch (Throwable t) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, t);
            this.addError("error.exception.general", t.getLocalizedMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public JSONObject convertAttrCollectionToJSON(JSONObject jsonObject, DKSequentialCollection attributeCollection, String childCompName) throws DKException, Exception {
        String methodName = "convertAttrCollectionToJSON";
        Logger.logEntry((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        JSONObject jsonCriteria = null;
        dkIterator iter = attributeCollection.createIterator();
        while (iter.more()) {
            DKAttrDefICM attr = (DKAttrDefICM)iter.next();
            if (attr.getType() != 4 && attr.getType() != 3 && attr.getType() != 10 && attr.getType() != 5 && attr.getType() != 6 && attr.getType() != 7 && attr.getType() != 9 && attr.getType() != 8 && attr.getType() != 2 && attr.getType() != 1) continue;
            jsonCriteria = new JSONObject();
            if (!attr.isQueryable()) continue;
            String attrName = attr.getName();
            if (childCompName != null) {
                attrName = childCompName + "/" + attrName;
            }
            jsonCriteria.put("name", attrName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attrName: " + attrName);
            String type = CMUtil.getCriteriaType(attr);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "type: " + type);
            jsonCriteria.put("dataType", type);
            if (this.getFormType().equals("search") || this.getFormType().equals("searchFolder")) {
                JSONUtils.put(jsonCriteria, "required", false);
            } else {
                JSONUtils.put(jsonCriteria, "required", !attr.isNullable());
                JSONUtils.put(jsonCriteria, "readOnly", !attr.isWriteable());
            }
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "is required: " + !attr.isNullable());
            JSONUtils.put(jsonCriteria, "fixedValue", false);
            JSONUtils.put(jsonCriteria, "ascending", false);
            String attrDisplayName = attr.getDescription();
            String encodedName = StringEscapeUtils.escapeHtml((String)attrDisplayName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "label: " + encodedName);
            jsonCriteria.put("label", encodedName);
            jsonCriteria.put("label2", attrDisplayName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "label2: " + attrDisplayName);
            String format = this.getFormat(attr);
            if (format != null) {
                jsonCriteria.put("format", format);
            }
            jsonCriteria.put("minValue", CMUtil.getMin(attr));
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMin(): " + CMUtil.getMin(attr));
            jsonCriteria.put("maxValue", CMUtil.getMax(attr));
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMax(): " + CMUtil.getMax(attr));
            int maxEntrySize = attr.getSize();
            if (attr.getType() == 6) {
                ++maxEntrySize;
                ++maxEntrySize;
            }
            if (maxEntrySize != 0) {
                JSONUtils.put(jsonCriteria, "maxEntry", maxEntrySize);
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getSize(): " + maxEntrySize);
            }
            int minEntrySize = 0;
            if (attr.getType() == 1) {
                minEntrySize = attr.getScale();
            }
            JSONUtils.put(jsonCriteria, "minEntry", minEntrySize);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "minEntry = attr.getScale(): " + minEntrySize);
            String[] validValues = CMUtil.getValidValues(this.request, attr, (dkCollection)this.getForeignKeys(), jsonObject);
            CMCriteriasMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            JSONUtils.put(jsonCriteria, "foreignKey", validValues.length > 0);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "this.getLocale(): " + this.getLocale());
            if (this.attrNameValuePairs == null) {
                String[] value = new String[]{attr.getDefaultValue()};
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding default values : " + value.length);
                jsonCriteria.put("values", attr.getDefaultValue());
            } else if (childCompName != null) {
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding Attribute Values - attribName: " + childCompName + "@$" + attr.getName());
                String[] childCompAttrValues = (String[])this.attrNameValuePairs.get(childCompName + "@$" + attr.getName());
                CMCriteriasMediator.addStringArrayToJSON(jsonCriteria, "validValues", childCompAttrValues);
            } else {
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Adding Attribute Values - attribName: " + attr.getName() + " Value: " + this.attrNameValuePairs.get(attr.getName()));
                jsonCriteria.put("values", (String)this.attrNameValuePairs.get(attr.getName()));
            }
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            attr = null;
        }
        Logger.logExit((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        return jsonObject;
    }

    public static String getOperatorFromDisplayValue(HttpServletRequest request, String operator) {
        String methodName = "getOperatorFromDisplayValue";
        if (operator == null || operator.isEmpty()) {
            return null;
        }
        String op = null;
        if (operator.equalsIgnoreCase("EQUAL")) {
            op = "=";
        } else if (operator.equalsIgnoreCase("NOTEQUAL")) {
            op = "!=";
        } else if (operator.equalsIgnoreCase("LIKE") || operator.equalsIgnoreCase("STARTSWITH") || operator.equalsIgnoreCase("ENDSWITH")) {
            op = "LIKE";
        } else if (operator.equalsIgnoreCase("NOTLIKE")) {
            op = "NOT LIKE";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            op = "NOT IN";
        } else if (operator.equalsIgnoreCase("NULL")) {
            op = "IS NULL";
        } else if (operator.equalsIgnoreCase("NOTNULL")) {
            op = "IS NOT NULL";
        } else if (operator.equalsIgnoreCase("CONTAINS")) {
            op = "contains-text-basic";
        } else if (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("INANY")) {
            op = "IN";
        } else if (operator.equalsIgnoreCase("LESS")) {
            op = "<";
        } else if (operator.equalsIgnoreCase("LESSOREQUAL")) {
            op = "<=";
        } else if (operator.equalsIgnoreCase("GREATEROREQUAL")) {
            op = ">=";
        } else if (operator.equalsIgnoreCase("GREATER")) {
            op = ">";
        } else if (operator.equalsIgnoreCase("BETWEEN")) {
            op = "BETWEEN";
        } else if (operator.equalsIgnoreCase("NOTBETWEEN")) {
            op = "NOT BETWEEN";
        }
        Logger.logDebug(CMCriteriasMediator.class, methodName, (ServletRequest)request, "op: + op;");
        return op;
    }

    public static ArrayList<CMQueryService.QueryCriterion> getQueryCriteria(HttpServletRequest request, SearchTemplate searchTemplate, CMQueryService queryService, MessageResources resources, Locale locale) throws Exception {
        String methodName = "getQueryCriteria";
        Logger.logEntry(CMCriteriasMediator.class, methodName, (ServletRequest)request);
        List<SearchCriteria> criteria = searchTemplate.getSearchCriteria();
        ArrayList<CMQueryService.QueryCriterion> retCrit = new ArrayList<CMQueryService.QueryCriterion>();
        for (SearchCriteria criteriaEntry : criteria) {
            if (criteriaEntry instanceof SearchCriterion) {
                SearchCriterion criterion = (SearchCriterion)criteriaEntry;
                retCrit.add(CMCriteriasMediator.createQueryCriterion(request, queryService, criterion, resources, locale));
                continue;
            }
            if (!(criteriaEntry instanceof ChildSearchCriteria)) continue;
            ChildSearchCriteria childCritieraEntry = (ChildSearchCriteria)criteriaEntry;
            List<SearchCriterion> childSearchCriteria = childCritieraEntry.getSearchCriteria();
            for (SearchCriterion childCriterion : childSearchCriteria) {
                String criterionName = childCriterion.getName();
                childCriterion.setName(childCritieraEntry.getName() + "/" + criterionName);
                retCrit.add(CMCriteriasMediator.createQueryCriterion(request, queryService, childCriterion, resources, locale));
            }
        }
        Logger.logExit(CMCriteriasMediator.class, methodName, (ServletRequest)request);
        return retCrit;
    }

    private static CMQueryService.QueryCriterion createQueryCriterion(HttpServletRequest request, CMQueryService queryService, SearchCriterion criterion, MessageResources resources, Locale locale) throws Exception {
        String methodName = "createQueryCriterion";
        Logger.logEntry(CMCriteriasMediator.class, methodName, (ServletRequest)request);
        String criteriaName = criterion.getName();
        Logger.logDebug(CMCriteriasMediator.class, methodName, (ServletRequest)request, "criteriaName : " + criteriaName);
        String displayOperator = criterion.getOperator();
        String queryOperator = CMCriteriasMediator.getOperatorFromDisplayValue(request, displayOperator);
        Logger.logDebug(CMCriteriasMediator.class, methodName, (ServletRequest)request, "displayOperator : " + displayOperator);
        Logger.logDebug(CMCriteriasMediator.class, methodName, (ServletRequest)request, "queryOperator : " + queryOperator);
        String[] values = criterion.getValues();
        for (int j = 0; j < values.length; ++j) {
            String value = CMCriteriasMediator.replaceWildCardChars(values[j], displayOperator);
            if (value != null && value.length() > 0 && (criterion.getDataType().equals("xs:date") || criterion.getDataType().equals("xs:time"))) {
                value = DateUtil.getXQueryDateString(DateUtil.parseISODate(value, false));
            } else if (value != null && value.length() > 0 && criterion.getDataType().equals("xs:timestamp")) {
                value = DateUtil.getXQueryDateString(DateUtil.parseISODate(value, true));
            }
            values[j] = value;
            Logger.logDebug(CMCriteriasMediator.class, methodName, (ServletRequest)request, "value " + j + " = " + value);
        }
        Logger.logExit(CMCriteriasMediator.class, methodName, (ServletRequest)request);
        CMQueryService cMQueryService = queryService;
        cMQueryService.getClass();
        return cMQueryService.new CMQueryService.QueryCriterion(criteriaName, queryOperator, values);
    }

    private static String replaceWildCardChars(String value, String displayOperator) {
        boolean isStartsWith = displayOperator.equalsIgnoreCase("STARTSWITH");
        boolean isEndsWith = displayOperator.equalsIgnoreCase("ENDSWITH");
        if (value.length() > 0 && (displayOperator.equalsIgnoreCase("LIKE") || displayOperator.equalsIgnoreCase("NOTLIKE") || isStartsWith || isEndsWith)) {
            value = value.replace('*', '%');
            value = value.replace('?', '_');
            value = isStartsWith ? value + "%" : (isEndsWith ? "%" + value : "%" + value + "%");
        }
        return value;
    }

    public String getFormat(DKAttrDefICM criteria) {
        String methodName = "getFormat";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        short type = criteria.getType();
        String returnFormat = null;
        switch (type) {
            case 9: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                int scaleValue = criteria.getScale();
                StringBuffer format = new StringBuffer();
                for (int precisionValue = criteria.getPrecision() - scaleValue; precisionValue > 0; --precisionValue) {
                    format.append("#");
                }
                if (scaleValue > 0) {
                    format.append(".");
                }
                while (scaleValue > 0) {
                    format.append("#");
                    --scaleValue;
                }
                returnFormat = format.toString();
            }
        }
        Logger.logDebug(CMCriteriasMediator.class, methodName, (ServletRequest)this.request, "returned Format [" + criteria.getName() + "]: " + returnFormat);
        Logger.logExit(CMCriteriasMediator.class, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    private void setPropertiesInfo(JSONObject jsonObject, CMItem tempHit) {
        String methodName = "setPropertiesInfo";
        String lastModTimestampString = null;
        String createdTimestampString = null;
        JSONObject jsonSystemProperties = null;
        try {
            String idCustomLabel;
            String createdUserStringCustomLabel;
            String createdTimestampStringCustomLabel;
            String lastModUserStringCustomLabel;
            String lastModTimestampStringCustomLabel;
            String version = tempHit.getVersion();
            String modifiedTimestamp = "" + DateUtil.getISODateString(tempHit.getLastChangedTimestamp(), true);
            String modifiedBy = tempHit.getLastChangedUserid();
            String createdTimestamp = "" + DateUtil.getISODateString(tempHit.getCreateTimestamp(), true);
            String createdBy = tempHit.getCreateUserid();
            String versionString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.version.getMessageKey());
            lastModTimestampString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.modifiedTimestamp.getMessageKey());
            String lastModUserString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.modifiedBy.getMessageKey());
            createdTimestampString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.createdTimestamp.getMessageKey());
            String createdUserString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.createdBy.getMessageKey());
            String idString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.itemID.getMessageKey());
            String versionStringCustomLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.version.toString());
            if (versionStringCustomLabel != null) {
                versionString = versionStringCustomLabel;
            }
            if ((lastModTimestampStringCustomLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.modifiedTimestamp.toString())) != null) {
                lastModTimestampString = lastModTimestampStringCustomLabel;
            }
            if ((lastModUserStringCustomLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.modifiedBy.toString())) != null) {
                lastModUserString = lastModUserStringCustomLabel;
            }
            if ((createdTimestampStringCustomLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.createdTimestamp.toString())) != null) {
                createdTimestampString = createdTimestampStringCustomLabel;
            }
            if ((createdUserStringCustomLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.createdBy.toString())) != null) {
                createdUserString = createdUserStringCustomLabel;
            }
            if ((idCustomLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.itemID.toString())) != null) {
                idString = idCustomLabel;
            }
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "createdTimestamp");
            jsonSystemProperties.put("values", createdTimestamp);
            jsonSystemProperties.put("label", createdTimestampString);
            jsonSystemProperties.put("dataType", "xs:timestamp");
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "createdBy");
            jsonSystemProperties.put("values", createdBy);
            jsonSystemProperties.put("label", createdUserString);
            jsonSystemProperties.put("dataType", "xs:string");
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "modifiedTimestamp");
            jsonSystemProperties.put("values", modifiedTimestamp);
            jsonSystemProperties.put("label", lastModTimestampString);
            jsonSystemProperties.put("dataType", "xs:timestamp");
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "modifiedBy");
            jsonSystemProperties.put("values", modifiedBy);
            jsonSystemProperties.put("label", lastModUserString);
            jsonSystemProperties.put("dataType", "xs:string");
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "version");
            jsonSystemProperties.put("values", version);
            jsonSystemProperties.put("label", versionString);
            jsonSystemProperties.put("dataType", "xs:integer");
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "idValue");
            jsonSystemProperties.put("values", tempHit.getPidString());
            jsonSystemProperties.put("label", idString);
            jsonSystemProperties.put("dataType", "xs:string");
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
        }
        catch (Exception e) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "lastModTimestampString  =" + lastModTimestampString);
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "createdTimestampString  = " + createdTimestampString);
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
    }

    public Locale getLibraryServerLocale() {
        return this.libraryServerLocale;
    }

    public void setLibraryServerLocale(Locale libraryServerLocale) {
        this.libraryServerLocale = libraryServerLocale;
    }

    public DKComponentTypeDefICM getItemType() {
        return this.itemType;
    }

    public void setItemType(DKComponentTypeDefICM itemType) {
        this.itemType = itemType;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    public DKSequentialCollection getChildComponents() {
        return this.childComponents;
    }

    public void setChildComponents(DKSequentialCollection childComponents) {
        this.childComponents = childComponents;
    }

    public DKSequentialCollection getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(DKSequentialCollection foreignKeys) {
        this.foreignKeys = foreignKeys;
    }
}

