/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMCriteriasMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

public class CMChildComponentsMediator
extends CMCriteriasMediator {
    private static final long serialVersionUID = 3496039375197416613L;
    private String selectedChildName = null;

    public CMChildComponentsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMChildComponentsMediator(HttpServletRequest request, CMCriteriasMediator criteriasMediator) {
        super(request, criteriasMediator);
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        BaseMediator tempMediator = new BaseMediator(this.request, this.getMessageResources(), this.getLocale());
        JSONObject jsonObject = tempMediator.toJSONObject();
        try {
            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "\nSub Entities of '" + this.getItemTypeName() + "':");
            dkIterator iter = this.getChildComponents().createIterator();
            while (iter.more()) {
                DKComponentTypeDefICM compType = (DKComponentTypeDefICM)iter.next();
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "     - " + compType.getName() + ":  " + compType.getDescription());
                if (!compType.getName().equals(this.getSelectedChildName())) continue;
                JSONObject childComp = new JSONObject();
                childComp.put("template_name", compType.getName());
                childComp.put("template_label", compType.getDescription());
                childComp.put("template_desc", compType.getDescription());
                JSONUtils.put(childComp, "parm_minCardinality", compType.getCardinalityMin());
                JSONUtils.put(childComp, "parm_maxCardinality", compType.getCardinalityMax());
                DKSequentialCollection childCompAttrColl = (DKSequentialCollection)compType.listAllAttributes();
                this.convertAttrCollectionToJSON(childComp, childCompAttrColl, compType.getName());
                dkCollection referenceAttributes = compType.listAttrGroups(99);
                dkIterator refIter = referenceAttributes.createIterator();
                if (refIter != null) {
                    while (refIter.more()) {
                        DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)refIter.next();
                        JSONObject jsonCriteria = new JSONObject();
                        jsonCriteria.put("name", attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "referenceAttrName: " + attrGroup.getName());
                        jsonCriteria.put("dataType", "xs:reference");
                        JSONUtils.put(jsonCriteria, "required", false);
                        JSONUtils.put(jsonCriteria, "fixedValue", false);
                        JSONUtils.put(jsonCriteria, "ascending", false);
                        String encodedName = StringEscapeUtils.escapeHtml((String)attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label: " + encodedName);
                        jsonCriteria.put("label", encodedName);
                        jsonCriteria.put("label2", attrGroup.getName());
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label2: " + attrGroup.getName());
                        String[] childCompRefAttrValues = (String[])this.attrNameValuePairs.get(compType.getName() + "@$" + attrGroup.getName());
                        if (childCompRefAttrValues == null) {
                            childCompRefAttrValues = new String[]{};
                        }
                        CMChildComponentsMediator.addStringArrayToJSON(jsonCriteria, "validValues", childCompRefAttrValues);
                        JSONUtils.accumulate(childComp, "criterias", jsonCriteria);
                    }
                }
                JSONUtils.accumulate(jsonObject, "parm_childcomponents", childComp);
                break;
            }
        }
        catch (DKException e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", CMUtil.getUserFriendlyDkErrorMessage(e, this.getMessageResources()));
        }
        catch (Throwable t) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, t);
            this.addError("error.exception.general", t.getLocalizedMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public String getSelectedChildName() {
        return this.selectedChildName;
    }

    public void setSelectedChildName(String selectedChildName) {
        this.selectedChildName = selectedChildName;
    }
}

