/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class CMBookmarksMediator
extends BaseMediator {
    private static final long serialVersionUID = 1L;
    private String docId;
    private boolean editable;
    private short versioningPolicy = 0;
    private boolean newVersion;
    private CMObject bookmarkAnnotation;
    private static final String bookmarksKey = "bookmarks";

    public CMBookmarksMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setBookmarks(CMObject annotation) {
        this.bookmarkAnnotation = annotation;
    }

    public CMObject getBookmarks() {
        return this.bookmarkAnnotation;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        if (this.versioningPolicy == 0) {
            jsonObject.put("versioningPolicy", "never");
        } else if (this.versioningPolicy == 1) {
            jsonObject.put("versioningPolicy", "always");
        } else {
            jsonObject.put("versioningPolicy", "prompt");
        }
        boolean bookmarksAdded = false;
        if (this.bookmarkAnnotation != null) {
            try {
                byte[] b = this.bookmarkAnnotation.getByteArrayData();
                String bookmarkData = new String(b, "UTF-8");
                JSONArray array = JSONArray.parse(bookmarkData);
                jsonObject.put(bookmarksKey, array);
                bookmarksAdded = true;
            }
            catch (Exception e) {
                Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            }
        }
        if (!bookmarksAdded) {
            jsonObject.put(bookmarksKey, new JSONArray());
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        String methodName = "fromJSONString";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        super.fromJSONObject(jsonObject);
        this.newVersion = new Boolean(jsonObject.get("newVersion").toString());
        try {
            CMObject bookmarkAnnotation = null;
            if (jsonObject.containsKey(bookmarksKey)) {
                JSONArray jsonAnnotations = (JSONArray)jsonObject.get(bookmarksKey);
                byte[] b = jsonAnnotations.toString().getBytes("UTF-8");
                bookmarkAnnotation = new CMObject(b, "text/xml");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "created CMObject for bookmarks contains " + jsonAnnotations.size() + " bookmarks");
            }
            this.setBookmarks(bookmarkAnnotation);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public boolean isNewVersion() {
        return this.newVersion;
    }

    public void setVersioningPolicy(short versioningPolicy) {
        this.versioningPolicy = versioningPolicy;
    }
}

