/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMItemTypesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDate;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKTime;
import com.ibm.mm.sdk.common.DKTimestamp;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMAttributesMediator
extends BaseMediator {
    private static final long serialVersionUID = 3496039375197416613L;
    private dkCollection attrColl = null;
    private dkCollection referenceAttributes = null;
    private dkCollection childComponents = null;
    private dkCollection foreignKeys = null;
    private List<CMEntity> cmEntities = null;
    private Map<String, Object> currentValues = new HashMap<String, Object>();
    public MessageResources messageResources = null;
    private boolean showFieldHoverHelp = false;
    private boolean forSearch;

    public CMAttributesMediator(HttpServletRequest request, MessageResources resources, Locale locale, boolean forSearch) {
        this(request, resources, locale);
        this.forSearch = forSearch;
    }

    public CMAttributesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMAttributesMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public dkCollection getAttrColl() {
        return this.attrColl;
    }

    public void setAttrColl(dkCollection attrColl) {
        this.attrColl = attrColl;
    }

    public void addCurrentValue(String attributeName, Object value) {
        this.currentValues.put(attributeName, value);
    }

    private Map<String, String> itemTypeSettingsToJSONMap(CMEntity entity) throws Exception {
        Map<String, String> properties = CMItemTypesMediator.itemTypeSettingsToJSONMap(entity);
        DKComponentTypeDefICM itemType = entity.getItemType();
        properties.put("template_name", itemType.getItemTypeName());
        properties.put("template_label", entity.getDKDescription());
        String nameAttribute = CMBaseUtil.getNameAttrForEntity(this.request, itemType);
        if (nameAttribute != null) {
            properties.put("parm_name_attribute", nameAttribute);
        }
        return properties;
    }

    private boolean isMultipleClassesMode() {
        return this.cmEntities != null && this.cmEntities.size() > 1;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            dkIterator iter;
            JSONUtils.put(jsonObject, "showFieldHoverHelp", this.getShowFieldHoverHelp());
            if (this.getErrors().size() > 0) {
                Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
                return jsonObject;
            }
            if (this.cmEntities != null && this.cmEntities.size() > 0) {
                jsonObject.putAll(this.itemTypeSettingsToJSONMap(this.cmEntities.get(0)));
                if (this.isMultipleClassesMode()) {
                    for (CMEntity entity : this.cmEntities) {
                        JSONObject jsonEntity = new JSONObject();
                        jsonEntity.putAll(this.itemTypeSettingsToJSONMap(entity));
                        JSONUtils.accumulate(jsonObject, "classes", jsonEntity);
                    }
                }
            }
            if (this.attrColl != null) {
                jsonObject = this.convertAttrCollectionToJSON(jsonObject, this.getAttrColl(), null);
            }
            if (this.referenceAttributes != null && (iter = this.referenceAttributes.createIterator()) != null) {
                while (iter.more()) {
                    DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)iter.next();
                    JSONObject jsonCriteria = new JSONObject();
                    jsonCriteria.put("name", attrGroup.getName());
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "attrName: " + attrGroup.getName());
                    jsonCriteria.put("dataType", "xs:reference");
                    JSONUtils.put(jsonCriteria, "required", false);
                    JSONUtils.put(jsonCriteria, "fixedValue", false);
                    JSONUtils.put(jsonCriteria, "ascending", false);
                    JSONUtils.put(jsonCriteria, "textSearchable", false);
                    JSONUtils.put(jsonCriteria, "nullable", true);
                    String encodedName = StringEscapeUtils.escapeHtml((String)attrGroup.getName());
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label: " + encodedName);
                    jsonCriteria.put("label", encodedName);
                    jsonCriteria.put("label2", attrGroup.getName());
                    String key = attrGroup.getName();
                    String[] refAttrValues = null;
                    if (this.currentValues != null && this.currentValues.containsKey(key)) {
                        refAttrValues = (String[])this.currentValues.get(key);
                    }
                    if (refAttrValues == null) {
                        refAttrValues = new String[]{};
                    }
                    CMAttributesMediator.addStringArrayToJSON(jsonCriteria, "value", refAttrValues);
                    JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
                }
            }
            if (this.childComponents != null) {
                iter = this.childComponents.createIterator();
                while (iter.more()) {
                    DKComponentTypeDefICM compType = (DKComponentTypeDefICM)iter.next();
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "     - " + compType.getName() + ":  " + compType.getDescription());
                    JSONObject childComp = new JSONObject();
                    childComp.put("template_name", compType.getName());
                    childComp.put("template_label", compType.getDescription());
                    childComp.put("template_desc", compType.getDescription());
                    JSONUtils.put(childComp, "parm_minCardinality", compType.getCardinalityMin());
                    JSONUtils.put(childComp, "parm_maxCardinality", compType.getCardinalityMax());
                    dkCollection childCompAttrColl = compType.listAllAttributes();
                    this.convertAttrCollectionToJSON(childComp, childCompAttrColl, compType.getName());
                    dkCollection referenceAttributes = compType.listAttrGroups(99);
                    dkIterator refIter = referenceAttributes.createIterator();
                    if (refIter != null) {
                        while (refIter.more()) {
                            DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)refIter.next();
                            JSONObject jsonCriteria = new JSONObject();
                            jsonCriteria.put("name", attrGroup.getName());
                            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "referenceAttrName: " + attrGroup.getName());
                            jsonCriteria.put("dataType", "xs:reference");
                            JSONUtils.put(jsonCriteria, "required", false);
                            JSONUtils.put(jsonCriteria, "fixedValue", false);
                            JSONUtils.put(jsonCriteria, "ascending", false);
                            String encodedName = StringEscapeUtils.escapeHtml((String)attrGroup.getName());
                            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label: " + encodedName);
                            jsonCriteria.put("label", encodedName);
                            jsonCriteria.put("label2", attrGroup.getName());
                            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "label2: " + attrGroup.getName());
                            String[] childCompRefAttrValues = null;
                            if (childCompRefAttrValues == null) {
                                childCompRefAttrValues = new String[]{};
                            }
                            CMAttributesMediator.addStringArrayToJSON(jsonCriteria, "validValues", childCompRefAttrValues);
                            JSONUtils.accumulate(childComp, "criterias", jsonCriteria);
                        }
                    }
                    JSONUtils.accumulate(jsonObject, "parm_childcomponents", childComp);
                }
            }
            this.addSystemProperties(this.request, jsonObject);
        }
        catch (DKException e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", CMUtil.getUserFriendlyDkErrorMessage(e, this.getMessageResources()));
        }
        catch (Throwable t) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, t);
            this.addError("error.exception.general", t.getLocalizedMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public JSONObject convertAttrCollectionToJSON(JSONObject jsonObject, dkCollection attributeCollection, String childCompName) throws DKException, Exception {
        String methodName = "convertAttrCollectionToJSON";
        Logger.logEntry((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        JSONObject jsonCriteria = null;
        dkIterator iter = attributeCollection.createIterator();
        while (iter.more()) {
            DKAttrDefICM attr = (DKAttrDefICM)iter.next();
            if (attr.getType() != 4 && attr.getType() != 3 && attr.getType() != 10 && attr.getType() != 5 && attr.getType() != 6 && attr.getType() != 7 && attr.getType() != 9 && attr.getType() != 8 && attr.getType() != 2 && attr.getType() != 1) continue;
            jsonCriteria = new JSONObject();
            if (!attr.isQueryable()) continue;
            String attrName = attr.getName();
            jsonCriteria.put("name", attrName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attrName: " + attrName);
            String type = CMUtil.getCriteriaType(attr);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "type: " + type);
            jsonCriteria.put("dataType", type);
            if (!this.forSearch) {
                JSONUtils.put(jsonCriteria, "required", !attr.isNullable());
            }
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "is required: " + !attr.isNullable());
            JSONUtils.put(jsonCriteria, "fixedValue", false);
            JSONUtils.put(jsonCriteria, "ascending", false);
            JSONUtils.put(jsonCriteria, "textSearchable", attr.isTextSearchable());
            JSONUtils.put(jsonCriteria, "nullable", this.isMultipleClassesMode() || attr.isNullable());
            String attrDisplayName = attr.getDescription();
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "label: " + attrDisplayName);
            jsonCriteria.put("label", attrDisplayName);
            jsonCriteria.put("label2", attrDisplayName);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "label2: " + attrDisplayName);
            String format = this.getFormat(attr);
            if (format != null) {
                jsonCriteria.put("format", format);
            }
            String min = CMUtil.getMin(attr, this.isMultipleClassesMode());
            jsonCriteria.put("minValue", min);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMin(): " + min);
            String max = CMUtil.getMax(attr, this.isMultipleClassesMode());
            jsonCriteria.put("maxValue", max);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getMax(): " + max);
            int maxEntrySize = attr.getSize();
            if (attr.getType() == 6) {
                ++maxEntrySize;
                ++maxEntrySize;
            }
            if (maxEntrySize != 0) {
                JSONUtils.put(jsonCriteria, "maxEntry", maxEntrySize);
                Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "attr.getSize(): " + maxEntrySize);
            }
            int minEntrySize = 0;
            if (attr.getType() == 1) {
                minEntrySize = attr.getScale();
            }
            JSONUtils.put(jsonCriteria, "minEntry", minEntrySize);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "minEntry = attr.getScale(): " + minEntrySize);
            String[] validValues = this.foreignKeys != null ? CMUtil.getValidValues(this.request, attr, this.foreignKeys, jsonObject) : new String[]{};
            Arrays.sort(validValues, Collator.getInstance(this.request.getLocale()));
            CMAttributesMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            JSONUtils.put(jsonCriteria, "foreignKey", validValues.length > 0);
            Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "this.getLocale(): " + this.getLocale());
            String defaultValue = attr.getDefaultValue();
            if (defaultValue != null && defaultValue.trim().length() > 0) {
                if (attr.getType() == 7) {
                    defaultValue = DateUtil.getISODateString(DKDate.valueOf((String)defaultValue.trim()), false);
                } else if (attr.getType() == 8) {
                    defaultValue = defaultValue.replaceAll(":", ".");
                    defaultValue = DateUtil.getISODateString(DKTime.valueOf((String)defaultValue.trim()), false);
                } else if (attr.getType() == 9) {
                    defaultValue = defaultValue.replaceAll(":", ".");
                    defaultValue = DateUtil.getISODateString(DKTimestamp.valueOf((String)defaultValue.trim()), true);
                }
            }
            jsonCriteria.put("value", defaultValue);
            if (childCompName == null && this.currentValues != null && this.currentValues.containsKey(attr.getName())) {
                Object value = this.currentValues.get(attr.getName());
                if (value instanceof String[]) {
                    CMAttributesMediator.addStringArrayToJSON(jsonCriteria, "value", (String[])value);
                } else {
                    jsonCriteria.put("value", value);
                }
            }
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            attr = null;
        }
        Logger.logDebug((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "convertAttrCollectionToJSON", (ServletRequest)this.request);
        return jsonObject;
    }

    public String[] getOperatorSymbols(Short type, boolean searchable, boolean nullable, MessageResources resources, Locale locale) {
        String methodName = "getOperatorSymbols";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<String> arrayListReturn = new ArrayList<String>(15);
        if (searchable) {
            arrayListReturn.add("CONTAINS");
        }
        switch (type) {
            case 19: {
                arrayListReturn.add("LIKE");
                arrayListReturn.add("NOTLIKE");
                if (!nullable) break;
                arrayListReturn.add("NULL");
                arrayListReturn.add("NOTNULL");
                break;
            }
            case 1: 
            case 2: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                arrayListReturn.add("LIKE");
                arrayListReturn.add("NOTLIKE");
                if (nullable) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                if (nullable) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
                break;
            }
            default: {
                arrayListReturn.add("EQUAL");
                arrayListReturn.add("NOTEQUAL");
                arrayListReturn.add("IN");
                arrayListReturn.add("NOTIN");
                if (nullable) {
                    arrayListReturn.add("NULL");
                    arrayListReturn.add("NOTNULL");
                }
                arrayListReturn.add("LESS");
                arrayListReturn.add("LESSOREQUAL");
                arrayListReturn.add("GREATER");
                arrayListReturn.add("GREATEROREQUAL");
                arrayListReturn.add("BETWEEN");
                arrayListReturn.add("NOTBETWEEN");
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return arrayListReturn.toArray(new String[0]);
    }

    private static String getOperatorFromDisplayValue(HttpServletRequest request, String operator, MessageResources resources, Locale locale) {
        String methodName = "getOperatorFromDisplayValue";
        String op = null;
        if (operator.equalsIgnoreCase("EQUAL")) {
            op = "=";
        } else if (operator.equalsIgnoreCase("NOTEQUAL")) {
            op = "!=";
        } else if (operator.equalsIgnoreCase("LIKE")) {
            op = "LIKE";
        } else if (operator.equalsIgnoreCase("NOTLIKE")) {
            op = "NOT LIKE";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            op = "NOT IN";
        } else if (operator.equalsIgnoreCase("NULL")) {
            op = "IS NULL";
        } else if (operator.equalsIgnoreCase("NOTNULL")) {
            op = "IS NOT NULL";
        } else if (operator.equalsIgnoreCase("CONTAINS")) {
            op = "contains-text-basic";
        } else if (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("INANY")) {
            op = "IN";
        } else if (operator.equalsIgnoreCase("LESS")) {
            op = "<";
        } else if (operator.equalsIgnoreCase("LESSOREQUAL")) {
            op = "<=";
        } else if (operator.equalsIgnoreCase("GREATEROREQUAL")) {
            op = ">=";
        } else if (operator.equalsIgnoreCase("GREATER")) {
            op = ">";
        } else if (operator.equalsIgnoreCase("BETWEEN")) {
            op = "BETWEEN";
        } else if (operator.equalsIgnoreCase("NOTBETWEEN")) {
            op = "NOT BETWEEN";
        }
        Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "op: " + op);
        return op;
    }

    public static CMQueryService.QueryCriterion[] getFromJSONString(HttpServletRequest request, String stringJSON, CMQueryService queryService, MessageResources resources, Locale locale) throws IOException {
        String methodName = "getFromJSONString";
        Logger.logEntry(CMAttributesMediator.class, methodName, (ServletRequest)request);
        Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "stringJSON = " + stringJSON);
        JSONObject jsonObject = JSONObject.parse(stringJSON);
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        CMQueryService.QueryCriterion[] retCrit = new CMQueryService.QueryCriterion[criteriasJsonArray.size()];
        CMQueryService.QueryCriterion queryCriteria = null;
        Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            String criteriaName = criteria.get("name").toString();
            Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "criteriaName : " + criteriaName);
            String displayOperator = criteria.get("operator").toString();
            String queryOperator = CMAttributesMediator.getOperatorFromDisplayValue(request, displayOperator, resources, locale);
            Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "displayOperator : " + displayOperator);
            Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "queryOperator : " + queryOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                String value = valuesJsonArray.get(iValuesCounter).toString();
                tempValuesArray[iValuesCounter] = value = CMAttributesMediator.replaceWildCardChars(value, queryOperator);
                Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)request, "value" + iValuesCounter + " = " + value);
            }
            CMQueryService cMQueryService = queryService;
            cMQueryService.getClass();
            retCrit[iCriteriaCounter] = queryCriteria = cMQueryService.new CMQueryService.QueryCriterion(criteriaName, queryOperator, tempValuesArray);
        }
        Logger.logExit(CMAttributesMediator.class, methodName, (ServletRequest)request);
        return retCrit;
    }

    private static String replaceWildCardChars(String value, String operator) {
        if (operator.equalsIgnoreCase("LIKE") || operator.equalsIgnoreCase("NOTLIKE")) {
            value = value.replace('*', '%');
            value = value.replace('?', '_');
        }
        return value;
    }

    public String getFormat(DKAttrDefICM criteria) {
        String methodName = "getFormat";
        Logger.logEntry(CMAttributesMediator.class, methodName, (ServletRequest)this.request);
        short type = criteria.getType();
        String returnFormat = null;
        switch (type) {
            case 9: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                int scaleValue = criteria.getScale();
                StringBuffer format = new StringBuffer();
                for (int precisionValue = criteria.getPrecision() - scaleValue; precisionValue > 0; --precisionValue) {
                    format.append("#");
                }
                if (scaleValue > 0) {
                    format.append(".");
                }
                while (scaleValue > 0) {
                    format.append("#");
                    --scaleValue;
                }
                returnFormat = format.toString();
                break;
            }
            default: {
                returnFormat = null;
            }
        }
        Logger.logDebug(CMAttributesMediator.class, methodName, (ServletRequest)this.request, "returned Format [" + criteria.getName() + "]: " + returnFormat);
        Logger.logExit(CMAttributesMediator.class, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    private void addSystemProperties(HttpServletRequest request, JSONObject jsonObject) {
        String methodName = "addSystemProperties";
        String lastModTimestampString = null;
        String createdTimestampString = null;
        JSONObject jsonSystemProperties = null;
        try {
            String idCustomLabel;
            String semanticTypeStringCustomLabel;
            String aclCodeStringCustomLabel;
            String createdUserStringCustomLabel;
            String createdTimestampStringCustomLabel;
            String lastModUserStringCustomLabel;
            String lastModTimestampStringCustomLabel;
            String versionString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.version.getMessageKey());
            lastModTimestampString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.modifiedTimestamp.getMessageKey());
            String lastModUserString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.modifiedBy.getMessageKey());
            createdTimestampString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.createdTimestamp.getMessageKey());
            String createdUserString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.createdBy.getMessageKey());
            String aclCodeString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.aclCode.getMessageKey());
            String semanticTypeString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.semanticType.getMessageKey());
            String idString = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.itemID.getMessageKey());
            String versionStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.version.toString());
            if (versionStringCustomLabel != null) {
                versionString = versionStringCustomLabel;
            }
            if ((lastModTimestampStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.modifiedTimestamp.toString())) != null) {
                lastModTimestampString = lastModTimestampStringCustomLabel;
            }
            if ((lastModUserStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.modifiedBy.toString())) != null) {
                lastModUserString = lastModUserStringCustomLabel;
            }
            if ((createdTimestampStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.createdTimestamp.toString())) != null) {
                createdTimestampString = createdTimestampStringCustomLabel;
            }
            if ((createdUserStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.createdBy.toString())) != null) {
                createdUserString = createdUserStringCustomLabel;
            }
            if ((aclCodeStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.aclCode.toString())) != null) {
                aclCodeString = aclCodeStringCustomLabel;
            }
            if ((semanticTypeStringCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.semanticType.toString())) != null) {
                semanticTypeString = semanticTypeStringCustomLabel;
            }
            if ((idCustomLabel = BaseUtil.getCustomLabelValue(request, "sys_" + CMSearchConstants.SystemAttribute.itemID.toString())) != null) {
                idString = idCustomLabel;
            }
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.aclCode.toString());
            jsonSystemProperties.put("label", aclCodeString);
            jsonSystemProperties.put("dataType", "xs:integer");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.semanticType.toString());
            jsonSystemProperties.put("label", semanticTypeString);
            jsonSystemProperties.put("dataType", "xs:integer");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.createdTimestamp.toString());
            jsonSystemProperties.put("label", createdTimestampString);
            jsonSystemProperties.put("dataType", "xs:timestamp");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.createdBy.toString());
            jsonSystemProperties.put("label", createdUserString);
            jsonSystemProperties.put("dataType", "xs:string");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.modifiedTimestamp.toString());
            jsonSystemProperties.put("label", lastModTimestampString);
            jsonSystemProperties.put("dataType", "xs:timestamp");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.modifiedBy.toString());
            jsonSystemProperties.put("label", lastModUserString);
            jsonSystemProperties.put("dataType", "xs:string");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.version.toString());
            jsonSystemProperties.put("label", versionString);
            jsonSystemProperties.put("dataType", "xs:integer");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", CMSearchConstants.SystemAttribute.itemID.toString());
            jsonSystemProperties.put("label", idString);
            jsonSystemProperties.put("dataType", "xs:string");
            jsonSystemProperties.put("system", new Boolean(true));
            JSONUtils.accumulate(jsonObject, "criterias", jsonSystemProperties);
        }
        catch (Exception e) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "lastModTimestampString  =" + lastModTimestampString);
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "createdTimestampString  = " + createdTimestampString);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    public dkCollection getChildComponents() {
        return this.childComponents;
    }

    public void setChildComponents(dkCollection childComponents) {
        this.childComponents = childComponents;
    }

    public dkCollection getReferenceAttributes() {
        return this.referenceAttributes;
    }

    public void setReferenceAttributes(dkCollection referenceAttributes) {
        this.referenceAttributes = referenceAttributes;
    }

    public dkCollection getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(dkCollection foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public List<CMEntity> getCmEntities() {
        return this.cmEntities;
    }

    public void setCmEntities(List<CMEntity> cmEntities) {
        this.cmEntities = cmEntities;
    }

    public void addCMEntity(CMEntity cmEntity) {
        if (this.cmEntities == null) {
            this.cmEntities = new ArrayList<CMEntity>();
        }
        this.cmEntities.add(cmEntity);
    }
}

