/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBArrowAnnotation;
import com.ibm.mm.viewer.annotation.CMBCircleAnnotation;
import com.ibm.mm.viewer.annotation.CMBHighlightAnnotation;
import com.ibm.mm.viewer.annotation.CMBLineAnnotation;
import com.ibm.mm.viewer.annotation.CMBNoteAnnotation;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenStroke;
import com.ibm.mm.viewer.annotation.CMBRectAnnotation;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.CMBTextAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.struts.util.MessageResources;

public class CMAnnotationsMediator
extends BaseMediator {
    private String docId;
    private boolean editable;
    private short versioningPolicy = 0;
    private boolean newVersion;
    private CMObject annotation;
    private int annotationPosition = 1400;

    public CMAnnotationsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setAnnotation(CMObject annotation) {
        this.annotation = annotation;
    }

    public CMObject getAnnotation() {
        return this.annotation;
    }

    public void setAnnotationPosition(int annotationPosition) {
        this.annotationPosition = annotationPosition;
    }

    public int getAnnotationPosition() {
        return this.annotationPosition;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        if (this.versioningPolicy == 0) {
            jsonObject.put("versioningPolicy", "never");
        } else if (this.versioningPolicy == 1) {
            jsonObject.put("versioningPolicy", "always");
        } else {
            jsonObject.put("versioningPolicy", "prompt");
        }
        if (this.annotation != null) {
            try {
                CMBAnnotationServices annotationServices = new CMBAnnotationServices(new DummyAnnotationCallbacks());
                CMObject firstAnnotationPart = this.annotation;
                CMBAnnotationSet annotationSet = annotationServices.loadAnnotationSet(firstAnnotationPart.getDataStream(), "application/vnd.ibm.modcap", this.annotationPosition, 1, 0);
                jsonObject.put("annotations", new JSONArray());
                for (int i = 0; i < annotationSet.getAnnotationCount(); ++i) {
                    JSONObject annotationJson = this.toJSON(annotationSet.getAnnotationAt(i));
                    JSONUtils.accumulate(jsonObject, "annotations", annotationJson);
                }
                annotationServices.dropAnnotationSet(annotationSet);
                annotationServices.terminate();
            }
            catch (Exception e) {
                Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            }
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    private JSONObject toJSON(CMBPageAnnotation annotation) throws IOException {
        Font font;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", this.annotationTypeAsString(annotation.getType()));
        JSONUtils.put(jsonObject, "pageNumber", annotation.getPageNumber());
        JSONUtils.put(jsonObject, "x", annotation.getAnnoDrawRect().x);
        JSONUtils.put(jsonObject, "y", annotation.getAnnoDrawRect().y);
        JSONUtils.put(jsonObject, "width", annotation.getAnnoDrawRect().width);
        JSONUtils.put(jsonObject, "height", annotation.getAnnoDrawRect().height);
        JSONUtils.put(jsonObject, "canDelete", annotation.canDelete());
        JSONUtils.put(jsonObject, "canUpdate", annotation.canUpdate());
        JSONUtils.put(jsonObject, "canShow", annotation.canShow());
        JSONUtils.put(jsonObject, "canHide", annotation.canHide());
        JSONUtils.put(jsonObject, "transparent", annotation.getTransparent());
        Color borderColor = annotation.getBorderColor();
        if (borderColor != null) {
            JSONUtils.put(jsonObject, "borderColor", borderColor.getRGB());
        }
        JSONUtils.put(jsonObject, "borderWidth", annotation.getBorderWidth());
        Color fillColor = annotation.getFillColor();
        if (fillColor != null) {
            JSONUtils.put(jsonObject, "fillColor", fillColor.getRGB());
        }
        if ((font = annotation.getFont()) != null) {
            jsonObject.put("fontName", font.getName());
            JSONUtils.put(jsonObject, "fontStyle", font.getStyle());
            JSONUtils.put(jsonObject, "fontSize", font.getSize());
        }
        JSONUtils.put(jsonObject, "rotateWithImage", annotation.getRotateWithImage());
        JSONUtils.put(jsonObject, "rotation", annotation.getRotation());
        JSONUtils.put(jsonObject, "invertHorizontal", annotation.getInvertHorizontal());
        JSONUtils.put(jsonObject, "invertVertical", annotation.getInvertVertical());
        if (annotation.getType() == 5) {
            CMBNoteAnnotation noteAnnotation = (CMBNoteAnnotation)annotation;
            JSONUtils.put(jsonObject, "wordWrap", noteAnnotation.getWordWrap());
            jsonObject.put("text", noteAnnotation.getText());
        } else if (annotation.getType() == 9) {
            CMBTextAnnotation textAnnotation = (CMBTextAnnotation)annotation;
            String text = textAnnotation.getTextLine();
            text = this.convertLineSeparators(text, System.getProperty("line.separator"), "\n");
            jsonObject.put("text", text);
        } else if (annotation.getType() == 8) {
            CMBStampAnnotation stampAnnotation = (CMBStampAnnotation)annotation;
            JSONUtils.put(jsonObject, "angle", stampAnnotation.getStampAngle());
            jsonObject.put("text", stampAnnotation.getStampText());
            JSONUtils.put(jsonObject, "isImage", stampAnnotation.isImageStamp());
            if (stampAnnotation.isImageStamp()) {
                JSONUtils.put(jsonObject, "imageWidth", stampAnnotation.getImageSize().width);
                JSONUtils.put(jsonObject, "imageHeight", stampAnnotation.getImageSize().height);
                jsonObject.put("imageData", Base64.encodeBase64String((byte[])stampAnnotation.getImageData()));
            }
        } else if (annotation.getType() == 6) {
            CMBPenAnnotation penAnnotation = (CMBPenAnnotation)annotation;
            Vector penStrokes = penAnnotation.getPenStrokes();
            jsonObject.put("strokes", new JSONArray());
            for (int i = 0; i < penStrokes.size(); ++i) {
                JSONObject penStrokeJsonObject = new JSONObject();
                CMBPenStroke penStroke = (CMBPenStroke)penStrokes.get(i);
                JSONUtils.put(penStrokeJsonObject, "fromX", penStroke.from.x);
                JSONUtils.put(penStrokeJsonObject, "fromY", penStroke.from.y);
                JSONUtils.put(penStrokeJsonObject, "toX", penStroke.to.x);
                JSONUtils.put(penStrokeJsonObject, "toY", penStroke.to.y);
                JSONUtils.accumulate(jsonObject, "strokes", penStrokeJsonObject);
            }
        } else if (annotation.getType() == 1) {
            CMBArrowAnnotation arrowAnnotation = (CMBArrowAnnotation)annotation;
            JSONUtils.put(jsonObject, "wingAngle", arrowAnnotation.getWingAngle());
            JSONUtils.put(jsonObject, "wingLength", arrowAnnotation.getWingLength());
        }
        return jsonObject;
    }

    private String convertLineSeparators(String text, String oldSeparator, String newSeparator) {
        StringBuffer oldString = new StringBuffer(text);
        StringBuffer newString = new StringBuffer();
        while (oldString.length() > 0) {
            if (oldString.indexOf(oldSeparator) == 0) {
                newString.append(newSeparator);
                oldString.delete(0, oldSeparator.length());
                continue;
            }
            newString.append(oldString.charAt(0));
            oldString.deleteCharAt(0);
        }
        return newString.toString();
    }

    private String annotationTypeAsString(int type) {
        if (type == 0) {
            return "unknown";
        }
        if (type == 1) {
            return "arrow";
        }
        if (type == 2) {
            return "circle";
        }
        if (type == 3) {
            return "highlight";
        }
        if (type == 4) {
            return "line";
        }
        if (type == 5) {
            return "note";
        }
        if (type == 6) {
            return "pen";
        }
        if (type == 7) {
            return "rect";
        }
        if (type == 8) {
            return "stamp";
        }
        if (type == 9) {
            return "text";
        }
        if (type == 10) {
            return "mask";
        }
        return "custom" + Integer.toString(type);
    }

    public void fromJSONObject(JSONObject jsonObject, int annotationPosition) throws IOException {
        String methodName = "getFromJSONString";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        super.fromJSONObject(jsonObject);
        this.newVersion = new Boolean(jsonObject.get("newVersion").toString());
        this.setAnnotationPosition(annotationPosition);
        try {
            Object annotation;
            CMBAnnotationServices annotationServices = new CMBAnnotationServices(new DummyAnnotationCallbacks());
            CMBAnnotationSet annotationSet = annotationServices.loadAnnotationSet(new ByteArrayInputStream(new byte[0]), "application/vnd.ibm.modcap", this.annotationPosition, 1, 0);
            if (jsonObject.containsKey("annotations")) {
                JSONArray jsonAnnotations = (JSONArray)jsonObject.get("annotations");
                for (int i = 0; i < jsonAnnotations.size(); ++i) {
                    annotation = this.getAnnotation((JSONObject)jsonAnnotations.get(i));
                    annotationSet.addAnnotation((CMBPageAnnotation)annotation);
                }
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "annotation set contains " + annotationSet.getAnnotationCount() + " annotations");
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            annotationSet.write(byteOutputStream);
            byteOutputStream.close();
            annotationServices.dropAnnotationSet(annotationSet);
            annotationServices.terminate();
            byte[] annotationBytes = byteOutputStream.toByteArray();
            if (annotationBytes.length == 0) {
                annotationBytes = new byte[]{0, 33, -45, -88, -88, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 6, 1, 3, -44, 3, 82, 5, 24, 1, 12, 0, 4, 101, 105, 1, 0, 8, -45, -87, -88, 0, 0, 0};
            }
            annotation = new CMObject(annotationBytes, "application/vnd.ibm.modcap");
            this.setAnnotation((CMObject)annotation);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private CMBPageAnnotation getAnnotation(JSONObject jsonAnnotation) throws IOException, CMBAnnotationEngineException {
        String text;
        String methodName = "getAnnotation";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        CMBPageAnnotation annotation = null;
        String type = jsonAnnotation.get("type").toString();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Annotation type: " + type);
        int pageNumber = new Integer(jsonAnnotation.get("pageNumber").toString());
        int x = new Integer(jsonAnnotation.get("x").toString());
        int y = new Integer(jsonAnnotation.get("y").toString());
        int width = new Integer(jsonAnnotation.get("width").toString());
        int height = new Integer(jsonAnnotation.get("height").toString());
        Rectangle position = new Rectangle(x, y, width, height);
        if (type.equals("arrow")) {
            CMBArrowAnnotation arrowAnnotation = new CMBArrowAnnotation(position, pageNumber);
            arrowAnnotation.setWingAngle(new Integer(jsonAnnotation.get("wingAngle").toString()));
            arrowAnnotation.setWingLength(new Integer(jsonAnnotation.get("wingLength").toString()));
            annotation = arrowAnnotation;
        } else if (type.equals("circle")) {
            annotation = new CMBCircleAnnotation(position, pageNumber);
        } else if (type.equals("highlight")) {
            annotation = new CMBHighlightAnnotation(position, pageNumber);
        } else if (type.equals("line")) {
            annotation = new CMBLineAnnotation(position, pageNumber);
        } else if (type.equals("note")) {
            text = jsonAnnotation.get("text").toString();
            CMBNoteAnnotation noteAnnotation = new CMBNoteAnnotation(position, text, pageNumber);
            noteAnnotation.setWordWrap(new Boolean(jsonAnnotation.get("wordWrap").toString()));
            annotation = noteAnnotation;
        } else if (type.equals("pen")) {
            Vector<CMBPenStroke> strokes = new Vector<CMBPenStroke>();
            if (jsonAnnotation.containsKey("strokes")) {
                JSONArray jsonStrokes = (JSONArray)jsonAnnotation.get("strokes");
                for (int i = 0; i < jsonStrokes.size(); ++i) {
                    JSONObject jsonStroke = (JSONObject)jsonStrokes.get(i);
                    int fromX = new Integer(jsonStroke.get("fromX").toString());
                    int fromY = new Integer(jsonStroke.get("fromY").toString());
                    int toX = new Integer(jsonStroke.get("toX").toString());
                    int toY = new Integer(jsonStroke.get("toY").toString());
                    CMBPenStroke stroke = new CMBPenStroke(new Point(fromX, fromY), new Point(toX, toY));
                    strokes.addElement(stroke);
                }
            }
            annotation = new CMBPenAnnotation(strokes, pageNumber);
        } else if (type.equals("rect")) {
            annotation = new CMBRectAnnotation(position, pageNumber);
        } else if (type.equals("stamp")) {
            CMBStampAnnotation stampAnnotation = new CMBStampAnnotation(position, pageNumber);
            stampAnnotation.setStampAngle(new Integer(jsonAnnotation.get("angle").toString()));
            stampAnnotation.setStampText(jsonAnnotation.get("text").toString());
            stampAnnotation.setImageStamp(new Boolean(jsonAnnotation.get("isImage").toString()));
            if (stampAnnotation.isImageStamp()) {
                stampAnnotation.setImageSize(new Dimension(new Integer(jsonAnnotation.get("imageWidth").toString()), new Integer(jsonAnnotation.get("imageHeight").toString())));
                stampAnnotation.setImageData(Base64.decodeBase64((String)jsonAnnotation.get("imageData").toString()));
            }
            annotation = stampAnnotation;
        } else if (type.equals("text")) {
            text = jsonAnnotation.get("text").toString();
            text = this.convertLineSeparators(text, "\n", System.getProperty("line.separator"));
            annotation = new CMBTextAnnotation(position, text, pageNumber);
        } else {
            throw new CMBAnnotationEngineException("Invalid annotation type found in JSON format annotations");
        }
        annotation.setTransparent(new Boolean(jsonAnnotation.get("transparent").toString()));
        if (jsonAnnotation.containsKey("borderColor")) {
            annotation.setBorderColor(new Color(new Integer(jsonAnnotation.get("borderColor").toString())));
        }
        annotation.setBorderWidth(new Integer(jsonAnnotation.get("borderWidth").toString()));
        if (jsonAnnotation.containsKey("fillColor")) {
            annotation.setFillColor(new Color(new Integer(jsonAnnotation.get("fillColor").toString())));
        }
        if (jsonAnnotation.containsKey("fontName")) {
            String fontName = jsonAnnotation.get("fontName").toString();
            int fontStyle = new Integer(jsonAnnotation.get("fontStyle").toString());
            int fontSize = new Integer(jsonAnnotation.get("fontSize").toString());
            annotation.setFont(new Font(fontName, fontStyle, fontSize));
        }
        annotation.setRotateWithImage(new Boolean(jsonAnnotation.get("rotateWithImage").toString()));
        annotation.setRotation(new Integer(jsonAnnotation.get("rotation").toString()));
        annotation.setInvertHorizontal(new Boolean(jsonAnnotation.get("invertHorizontal").toString()));
        annotation.setInvertVertical(new Boolean(jsonAnnotation.get("invertVertical").toString()));
        annotation.setCanDelete(new Boolean(jsonAnnotation.get("canDelete").toString()));
        annotation.setCanUpdate(new Boolean(jsonAnnotation.get("canUpdate").toString()));
        annotation.setCanShow(new Boolean(jsonAnnotation.get("canShow").toString()));
        annotation.setCanHide(new Boolean(jsonAnnotation.get("canHide").toString()));
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotation;
    }

    public boolean isNewVersion() {
        return this.newVersion;
    }

    public void setVersioningPolicy(short versioningPolicy) {
        this.versioningPolicy = versioningPolicy;
    }

    private class DummyAnnotationCallbacks
    extends CMBAnnotationServicesCallbacks {
        private DummyAnnotationCallbacks() {
        }

        public InputStream getAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            CMObject annotationPart = CMAnnotationsMediator.this.annotation;
            try {
                return annotationPart.getDataStream();
            }
            catch (Exception e) {
                throw new CMBAnnotationEngineException(e.getMessage(), (Object)e);
            }
        }

        public boolean getPrivilege(CMBAnnotationSet annotationSet, int privilegeID) throws CMBAnnotationEngineException {
            return true;
        }

        public int addAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData) throws CMBAnnotationEngineException {
            return 0;
        }

        public void updateAnnotationPart(CMBAnnotationSet annotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public void removeAnnotationPart(CMBAnnotationSet annotationSet, int annotationNumber) throws CMBAnnotationEngineException {
        }

        public boolean traceEnabled() {
            return false;
        }

        public void trace(String message) {
        }
    }
}

