/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.configuration.ViewerContentTypeConfig;
import com.ibm.ecm.configuration.ViewerDefConfig;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginViewerDef;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewersMediator
extends BaseMediator {
    static final long serialVersionUID = 1L;
    private ViewerConfig viewerConfig = null;
    private List<ViewerDefConfig> definitions = null;
    private List<ViewerContentTypeConfig> contentTypes = null;
    private Collection<ViewerMappingConfig> defaultViewerMapping = null;

    public ViewersMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected ViewersMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public void setViewerConfig(ViewerConfig viewerConfig) {
        this.viewerConfig = viewerConfig;
    }

    public void setViewerDefConfigs(List<ViewerDefConfig> definitions) {
        this.definitions = definitions;
    }

    public void setViewerContentTypeConfigs(List<ViewerContentTypeConfig> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public void setDefaultViewerMappingConfigs(List<ViewerMappingConfig> defaultViewerMapping) {
        this.defaultViewerMapping = defaultViewerMapping;
    }

    private JSONArray toJSONArray(String[] stringArray) {
        JSONArray jsonArray = new JSONArray();
        if (stringArray != null) {
            for (int n = 0; n < stringArray.length; ++n) {
                jsonArray.add(stringArray[n]);
            }
        }
        return jsonArray;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            ViewerConfig viewerConfig = this.viewerConfig;
            if (viewerConfig != null) {
                JSONArray viewerDefsJSON = this.getViewerDefsJSON();
                Plugin[] plugins = PluginUtil.getPlugins(this.request);
                for (int i = 0; i < plugins.length; ++i) {
                    Plugin plugin = plugins[i];
                    PluginViewerDef[] pluginViewers = plugin.getViewers();
                    for (int j = 0; j < pluginViewers.length; ++j) {
                        PluginViewerDef pluginViewer = pluginViewers[j];
                        JSONObject viewerDefJSON = new JSONObject();
                        viewerDefJSON.put("id", pluginViewer.getId());
                        viewerDefJSON.put("viewerName", pluginViewer.getId());
                        viewerDefJSON.put("label", pluginViewer.getName(this.request.getLocale()));
                        viewerDefJSON.put("launchUrl", pluginViewer.getLaunchUrlPattern());
                        viewerDefJSON.put("launchInSeparateWindow", (Object)pluginViewer.isLaunchInSeparateWindow());
                        viewerDefJSON.put("serverTypes", this.toJSONArray(pluginViewer.getSupportedServerTypes()));
                        viewerDefJSON.put("viewerClass", pluginViewer.getViewerClass());
                        viewerDefsJSON.add(viewerDefJSON);
                    }
                }
                jsonObject.put("viewerDefs", viewerDefsJSON);
                jsonObject.put("viewerMappings", viewerConfig.getViewerMappingsJSON());
                jsonObject.put("viewerContentTypes", this.getViewerContentTypesJSON());
                jsonObject.put("defaultViewerMappings", this.getDefaultViewerMappingsJSON());
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        return jsonObject;
    }

    public JSONArray getViewerDefsJSON() {
        JSONArray jsonViewerDefs = new JSONArray();
        if (this.definitions != null) {
            for (ViewerDefConfig defConfig : this.definitions) {
                jsonViewerDefs.add(defConfig.toJSON());
            }
        }
        return jsonViewerDefs;
    }

    public JSONArray getViewerContentTypesJSON() {
        JSONArray jsonViewerContentTypes = new JSONArray();
        if (this.contentTypes != null) {
            for (ViewerContentTypeConfig contentTypeConfig : this.contentTypes) {
                jsonViewerContentTypes.add(contentTypeConfig.toJSON());
            }
        }
        return jsonViewerContentTypes;
    }

    public JSONArray getDefaultViewerMappingsJSON() {
        JSONArray jsonViewerMappings = new JSONArray();
        if (this.defaultViewerMapping != null) {
            for (ViewerMappingConfig mappingConfig : this.defaultViewerMapping) {
                jsonViewerMappings.add(mappingConfig.toJSON());
            }
        }
        return jsonViewerMappings;
    }
}

