/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.configuration.LocaleConfig;
import com.ibm.ecm.configuration.ServerConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMediator
extends BaseMediator {
    static final long serialVersionUID = 1L;
    private List<LocaleConfig> localeConfigs = null;
    private List<ServerConfig> serverConfigs = null;

    public ServerMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected ServerMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public void setLocaleConfigs(List<LocaleConfig> configs) {
        this.localeConfigs = configs;
    }

    public void setServerConfigs(List<ServerConfig> configs) {
        this.serverConfigs = configs;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            JSONArray jsonArray;
            if (this.localeConfigs != null) {
                jsonArray = new JSONArray();
                for (LocaleConfig iconConfig : this.localeConfigs) {
                    jsonArray.add(iconConfig.toJSON());
                }
                jsonObject.put("locales", jsonArray);
            }
            if (this.serverConfigs != null) {
                jsonArray = new JSONArray();
                for (ServerConfig config : this.serverConfigs) {
                    jsonArray.add(config.toJSON());
                }
                jsonObject.put("servers", jsonArray);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        return jsonObject;
    }
}

