/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SelectedItem;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class SelectedItemsMediator
extends BaseMediator {
    Map items = new HashMap();

    public SelectedItemsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public Map getItems() {
        return this.items;
    }

    public void setItems(Map items) {
        this.items = items;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        Iterator itemsList = this.getItems().values().iterator();
        int count = 0;
        while (itemsList.hasNext()) {
            ++count;
            SelectedItem selectedItem = (SelectedItem)itemsList.next();
            JSONObject listObject = new JSONObject();
            listObject.put("iconFileName", selectedItem.getIconFileName());
            listObject.put("mimetype", selectedItem.getMimetype());
            listObject.put("mimetypeDescription", selectedItem.getMimeTypeDescription());
            listObject.put("fileName", selectedItem.getFilename());
            listObject.put("fileExtension", selectedItem.getFileExtension());
            listObject.put("allPartsSize", selectedItem.getAllPartsSizeStr());
            listObject.put("basePartSize", selectedItem.getBasePartSizeStr());
            JSONUtils.put(listObject, "part_count", selectedItem.getPartCount());
            JSONUtils.put(listObject, "anno_part_count", selectedItem.getAnnoPartCount());
            JSONUtils.put(listObject, "notelog_part_count", selectedItem.getNotelogCount());
            JSONUtils.put(listObject, "pdfConvertable", selectedItem.isPDFConvertable());
            listObject.put("docid", selectedItem.getDocId());
            JSONUtils.accumulate(jsonObject, "selectedItems", listObject);
        }
        JSONUtils.put(jsonObject, "selectedItems_count", count);
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON:").append(jsonObject.toString()).toString());
        return jsonObject;
    }
}

