/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public abstract class ResultSetMediator
extends BaseMediator {
    private boolean isContinuation;
    private String continuationData;

    public ResultSetMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setContinuation(boolean value) {
        this.isContinuation = value;
    }

    public boolean isContinuation() {
        return this.isContinuation;
    }

    public String getContinuationData() {
        return this.continuationData;
    }

    public void setContinuationData(String continuationData) {
        this.continuationData = continuationData;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("rows", this.buildTableRows());
            if (!this.isContinuation) {
                jsonObject.put("columns", this.buildTableColumns());
                jsonObject.put("magazineColumns", this.buildMagazineViewColumns());
            }
            if (this.continuationData != null) {
                jsonObject.put("continuationData", this.continuationData);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    protected abstract JSONObject buildTableColumns() throws Exception;

    protected abstract JSONArray buildMagazineViewColumns();

    protected abstract JSONArray buildTableRows() throws Exception;
}

