/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginAction;
import com.ibm.ecm.extension.PluginFeature;
import com.ibm.ecm.extension.PluginLayout;
import com.ibm.ecm.extension.PluginViewerDef;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class PluginsMediator
extends BaseMediator {
    static final long serialVersionUID = 1L;
    Plugin plugin = null;

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public PluginsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected PluginsMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        if (this.plugin != null) {
            jsonObject.put("name", this.plugin.getName(this.request.getLocale()));
            jsonObject.put("id", this.plugin.getId());
            jsonObject.put("version", this.plugin.getVersion());
            jsonObject.put("configClass", this.plugin.getConfigurationDijitClass());
            jsonObject.put("dojoModule", this.plugin.getDojoModule());
            jsonObject.put("script", this.plugin.getScript());
            jsonObject.put("cssFileName", this.plugin.getCSSFileName());
            PluginAction[] pluginActions = this.plugin.getActions();
            JSONArray actionNames = new JSONArray();
            if (pluginActions != null) {
                for (int i = 0; i < pluginActions.length; ++i) {
                    PluginAction pluginAction = pluginActions[i];
                    if (pluginAction == null) continue;
                    actionNames.add(this.getJson(pluginAction));
                }
            }
            jsonObject.put("actions", actionNames);
            PluginViewerDef[] pluginViewers = this.plugin.getViewers();
            JSONArray viewerNames = new JSONArray();
            if (pluginViewers != null) {
                for (int i = 0; i < pluginViewers.length; ++i) {
                    PluginViewerDef pluginViewer = pluginViewers[i];
                    if (pluginViewer == null) continue;
                    viewerNames.add(this.getJson(pluginViewer));
                }
            }
            jsonObject.put("viewerDefs", viewerNames);
            PluginFeature[] pluginFeatures = this.plugin.getFeatures();
            JSONArray featureNames = new JSONArray();
            if (pluginFeatures != null) {
                for (int i = 0; i < pluginFeatures.length; ++i) {
                    PluginFeature pluginFeature = pluginFeatures[i];
                    if (pluginFeature == null) continue;
                    featureNames.add(this.getJson(pluginFeature));
                }
            }
            jsonObject.put("features", featureNames);
            PluginLayout[] pluginLayouts = this.plugin.getLayouts();
            JSONArray layoutNames = new JSONArray();
            if (pluginLayouts != null) {
                for (int i = 0; i < pluginLayouts.length; ++i) {
                    PluginLayout pluginLayout = pluginLayouts[i];
                    if (pluginLayout == null) continue;
                    layoutNames.add(this.getJson(pluginLayout));
                }
            }
            jsonObject.put("layouts", layoutNames);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        return jsonObject;
    }

    public JSONObject getJson(PluginViewerDef pluginViewer) {
        JSONObject viewerDefJSON = new JSONObject();
        viewerDefJSON.put("id", pluginViewer.getId());
        viewerDefJSON.put("viewerName", pluginViewer.getId());
        viewerDefJSON.put("label", pluginViewer.getName(this.request.getLocale()));
        viewerDefJSON.put("launchUrl", pluginViewer.getLaunchUrlPattern());
        viewerDefJSON.put("launchInSeparateWindow", (Object)pluginViewer.isLaunchInSeparateWindow());
        viewerDefJSON.put("serverTypes", this.toJSONArray(pluginViewer.getSupportedServerTypes()));
        return viewerDefJSON;
    }

    public JSONObject getJson(PluginFeature pluginFeature) {
        JSONObject featureJSON = new JSONObject();
        featureJSON.put("id", pluginFeature.getId());
        featureJSON.put("label", pluginFeature.getName(this.request.getLocale()));
        return featureJSON;
    }

    public JSONObject getJson(PluginLayout pluginLayout) {
        JSONObject layoutJSON = new JSONObject();
        layoutJSON.put("id", pluginLayout.getId());
        layoutJSON.put("label", pluginLayout.getName(this.request.getLocale()));
        return layoutJSON;
    }

    private JSONArray toJSONArray(String[] stringArray) {
        JSONArray jsonArray = new JSONArray();
        if (stringArray != null) {
            for (int n = 0; n < stringArray.length; ++n) {
                jsonArray.add(stringArray[n]);
            }
        }
        return jsonArray;
    }

    private JSONObject getJson(PluginAction pluginAction) {
        JSONObject jsonAction = new JSONObject();
        jsonAction.put("id", pluginAction.getId());
        jsonAction.put("label", pluginAction.getName(this.request.getLocale()));
        jsonAction.put("icon", pluginAction.getIcon());
        if (pluginAction.getPluginId() != null) {
            jsonAction.put("pluginId", pluginAction.getPluginId());
        } else {
            jsonAction.put("pluginId", (Object)null);
        }
        jsonAction.put("action", pluginAction.getActionFunction());
        JSONUtils.put(jsonAction, "multiDoc", pluginAction.isMultiDoc());
        JSONUtils.put(jsonAction, "global", pluginAction.isGlobal());
        jsonAction.put("privilegeName", pluginAction.getPrivilege());
        jsonAction.put("widgetType", (Object)null);
        jsonAction.put("widgetFunction", (Object)null);
        jsonAction.put("serverTypes", pluginAction.getServerTypes());
        jsonAction.put("actionModelClass", pluginAction.getActionModelClass());
        return jsonAction;
    }
}

