/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.NexusPingAction;
import com.ibm.ecm.struts.controller.ControllerServlet;
import com.ibm.ecm.util.JarManifest;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.struts.util.MessageResources;

public class NexusPingMediator
extends BaseMediator {
    private static final long serialVersionUID = 1L;
    public static final String WCVERSION_PROPS = "wcversion.properties";
    private static int RESPONSE_AS_JSON = 1;
    private static int RESPONSE_AS_XML = 2;
    private static int RESPONSE_AS_HTML = 3;
    private static int RESPONSE_AS_TEXT = 4;
    String tableHeaderKey = "Key";
    String tableHeaderValue = "Value";
    private static String VERSION = "Version";
    private static String BUILD = "Build Level";
    private static String PRODUCT_NAME = "Product Name";
    private static String OPERATING_SYSTEM = "Operating System";
    private static String JVM = "JVM";
    private static String START_TIME = "Startup Time";
    private static String LOCAL_HOST = "Host Name";
    private static String PROCESSORS = "Available Processors";
    private static String JDBC_DRIVER = "JDBC Driver";
    private static String DATABASE_NAME = "Database Schema Name";
    private static String DEFAULT_DESKTOP = "Default Desktop";
    private static String CONFIG_TYPE = "Configuration Type";
    private static String PLUGINS = "Plugins";
    private static String PE_BUILD = "PE Client Build";
    private static String CE_BUILD = "CE Client Build";
    private static String CM_BUILD = "CM Client Build";
    private static String OD_BUILD = "OD Client Build";
    private Hashtable<String, Object> pingData = new Hashtable();
    private Hashtable<String, String> jvmData = new Hashtable();
    private static TreeMap<String, String> pingDataOrder = new TreeMap();
    private static String[] jvmArgs = new String[]{"java.vm.vendor", "java.vm.name", "java.runtime.version", "java.runtime.name", "java.vm.version", "java.vm.info", "java.fullversion"};

    protected NexusPingMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public NexusPingMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    private int getResponseType() {
        if (this.request.getContentType() == null) {
            return RESPONSE_AS_HTML;
        }
        if (this.request.getContentType().equalsIgnoreCase("text/plain")) {
            return RESPONSE_AS_TEXT;
        }
        if (this.request.getContentType().equalsIgnoreCase("text/xml")) {
            return RESPONSE_AS_XML;
        }
        if (this.request.getContentType().equalsIgnoreCase("application/json")) {
            return RESPONSE_AS_JSON;
        }
        return RESPONSE_AS_HTML;
    }

    private static Properties loadFile(String fileName) throws Exception {
        ClassLoader cl = NexusPingAction.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(fileName);
        Properties rawMap = new Properties();
        rawMap.load(is);
        is.close();
        return rawMap;
    }

    private void buildPingDataOrder() {
        pingDataOrder.put("01", PRODUCT_NAME);
        pingDataOrder.put("02", BUILD);
        pingDataOrder.put("03", VERSION);
        pingDataOrder.put("04", OPERATING_SYSTEM);
        pingDataOrder.put("05", JVM);
        pingDataOrder.put("06", START_TIME);
        pingDataOrder.put("07", LOCAL_HOST);
        pingDataOrder.put("08", PROCESSORS);
        pingDataOrder.put("09", CONFIG_TYPE);
        pingDataOrder.put("10", DATABASE_NAME);
        pingDataOrder.put("11", JDBC_DRIVER);
        pingDataOrder.put("12", DEFAULT_DESKTOP);
        pingDataOrder.put("13", PLUGINS);
        pingDataOrder.put("14", PE_BUILD);
        pingDataOrder.put("15", CE_BUILD);
        pingDataOrder.put("16", CM_BUILD);
        pingDataOrder.put("17", OD_BUILD);
    }

    private void collectPingData() {
        try {
            this.buildPingDataOrder();
            String productName = this.getMessageResources().getMessage(this.getLocale(), "about.product.name");
            this.pingData.put(PRODUCT_NAME, productName);
            Properties installProperties = NexusPingMediator.loadFile(WCVERSION_PROPS);
            String release = (String)installProperties.get("version");
            String buildLevel = (String)installProperties.get("build.level");
            String buildNumber = (String)installProperties.get("build.number");
            this.pingData.put(VERSION, release);
            this.pingData.put(BUILD, buildLevel + " (" + buildNumber + ")");
            this.pingData.put(OPERATING_SYSTEM, System.getProperty("os.name") + " " + System.getProperty("os.version"));
            this.pingData.put(JVM, this.getJVMTable());
            String hostName = null;
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            this.pingData.put(START_TIME, ControllerServlet.startupTime);
            this.pingData.put(LOCAL_HOST, hostName);
            this.pingData.put(PROCESSORS, Runtime.getRuntime().availableProcessors() + "");
            this.pingData.put(VERSION, release);
            Config.CONFIGURATION_TYPE confType = Config.getConfigurationType();
            this.pingData.put(CONFIG_TYPE, (Object)((Object)confType) + "");
            this.pingData.put(DATABASE_NAME, Config.getDatabseName());
            this.pingData.put(JDBC_DRIVER, Config.getJDBCVersion());
            this.pingData.put(DEFAULT_DESKTOP, Config.getDefaultDesktopName(this.request));
            String[] plugins = Config.getApplicationConfig(this.request).getPluginsId();
            String pluginStr = "";
            for (int i = 0; i < plugins.length; ++i) {
                pluginStr = pluginStr + plugins[i];
                if (i >= plugins.length - 1) continue;
                pluginStr = pluginStr + ", ";
            }
            this.pingData.put(PLUGINS, pluginStr);
            this.pingData.put(PE_BUILD, NexusPingMediator.getPEBuildNumber());
            this.pingData.put(CE_BUILD, NexusPingMediator.getCEBuildNumber());
            this.pingData.put(CM_BUILD, NexusPingMediator.getCMBuildNumber());
            this.pingData.put(OD_BUILD, NexusPingMediator.getODBuildNumber());
        }
        catch (Exception e) {
            Logger.logDebug((Object)this, "collectPingData", (ServletRequest)this.request, e.getLocalizedMessage());
        }
    }

    private String getJVMTable() {
        StringBuffer sb = new StringBuffer();
        sb.append("<TABLE>");
        for (int lp = 0; lp < jvmArgs.length; ++lp) {
            String val = System.getProperty(jvmArgs[lp]);
            if (val == null || val.trim().length() <= 0) continue;
            sb.append("<TR><TD style=\"font-size:12px;\">");
            sb.append(jvmArgs[lp]);
            sb.append("</TD><TD style=\"font-size:12px;\">");
            sb.append(val);
            sb.append("</TD></TR>");
            this.jvmData.put(jvmArgs[lp], val);
        }
        sb.append("</TABLE>");
        return sb.toString();
    }

    public final void writeJSON(Writer writer, HttpServletResponse response) throws IOException {
        String methodName = "writeJSON";
        String jsonString = this.toJSONString();
        if (this.getResponseType() == RESPONSE_AS_HTML) {
            try {
                jsonString = this.convertToHtml();
            }
            catch (Exception e) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, e.getLocalizedMessage());
            }
            response.setContentType("text/html");
        } else if (this.getResponseType() == RESPONSE_AS_XML) {
            try {
                jsonString = this.convertToXml();
            }
            catch (Exception e) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, e.getLocalizedMessage());
            }
            response.setContentType("text/xml");
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonString).toString());
        writer.write(jsonString);
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        this.collectPingData();
        for (Map.Entry<String, String> ent : pingDataOrder.entrySet()) {
            String keyName = ent.getValue();
            if (keyName.equals(JVM)) {
                JSONObject jsontable = new JSONObject();
                Enumeration<String> keys = this.jvmData.keys();
                while (keys.hasMoreElements()) {
                    String nameKey = keys.nextElement();
                    String value = this.jvmData.get(nameKey);
                    jsontable.put(nameKey, value);
                }
                jsonObject.put(keyName, jsontable);
                continue;
            }
            Object keyValue = this.pingData.get(ent.getValue());
            jsonObject.put(keyName, keyValue);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, jsonObject.toString());
        return jsonObject;
    }

    public String convertToXml() throws JAXBException {
        String xmlPingData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\t<pingData>\n";
        for (Map.Entry<String, String> ent : pingDataOrder.entrySet()) {
            String keyName = ent.getValue();
            String xmlEntry = "\t\t<entry>\n";
            if (keyName.equals(JVM)) {
                String jvmEntries = "\t\t\t<jvmEntry>\n";
                Enumeration<String> keys = this.jvmData.keys();
                while (keys.hasMoreElements()) {
                    String nameKey = keys.nextElement();
                    String value = this.jvmData.get(nameKey);
                    jvmEntries = jvmEntries + "\t\t\t\t<jvmEntryName>" + nameKey + "</jvmEntryName>\n" + "\t\t\t\t<jvmEntryValue>" + value + "</jvmEntryValue>\n";
                }
                jvmEntries = jvmEntries + "\t\t\t</jvmEntry>\n";
                xmlEntry = xmlEntry + jvmEntries;
            } else {
                String keyValue = (String)this.pingData.get(ent.getValue());
                xmlEntry = xmlEntry + "\t\t\t<entryName>" + keyName + "</entryName>\n" + "\t\t\t<entryValue>" + keyValue + "</entryValue>\n";
            }
            xmlEntry = xmlEntry + "\t\t</entry>\n";
            xmlPingData = xmlPingData + xmlEntry;
        }
        xmlPingData = xmlPingData + "\t</pingData>\n";
        Logger.logDebug((Object)this, "convertToXml", (ServletRequest)this.request, xmlPingData);
        return xmlPingData;
    }

    public String convertToHtml() throws TransformerException, JAXBException {
        String title = this.pingData.get(PRODUCT_NAME) + " Ping Page";
        String header = this.pingData.get(PRODUCT_NAME) + " Ping Page";
        String ecmCss = this.request.getContextPath() + "/ecm/widget/resources/PingPage.css";
        String nexusLogo = this.request.getContextPath() + "/ecm/widget/resources/images/ibmLogo.png";
        String htmlPingData = "<html>\n<head>\n<title>" + title + "</title>\n" + "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + ecmCss + "\"></link>\n" + "</head>\n" + "<body  class=\"ecm lotusui30 pingPage\">\n" + "          <div class=\"ecmBanner\">\n" + "            <div class=\"productName\">" + header + "</div>\n" + "            <div class=\"logo\"><img src=\"" + nexusLogo + "\"/> </div>\n" + "          </div>\n" + "\t\t  <div class=\"blueBar\"> </div>\n" + "          <div class=\"section\">\n" + "\t\t\t\t<TABLE CELLSPACING=\"0\">\n" + "\t\t\t\t\t<TR><TH class=\"keyCell\">" + this.tableHeaderKey + "<TH>" + this.tableHeaderValue + "</TH></TR>\n";
        for (Map.Entry<String, String> ent : pingDataOrder.entrySet()) {
            String keyName = ent.getValue();
            String keyValue = (String)this.pingData.get(ent.getValue());
            String htmlEntry = "\t\t\t\t\t<TR><TD class=\"keyCell\">" + keyName + "</TD><TD>" + keyValue + "</TD></TR>\n";
            htmlPingData = htmlPingData + htmlEntry;
        }
        htmlPingData = htmlPingData + "\t\t\t\t</TABLE>\n       </div>\n</body>\n</html>";
        return htmlPingData;
    }

    private static String setMessageBackgroundColor(int row) {
        if (row % 2 == 0) {
            return "bgcolor=\"#f0f0f0\"";
        }
        return "bgcolor=\"white\"";
    }

    private static String getPEBuildNumber() {
        String peBuildNumber = "Unknown";
        try {
            Class<?> peBuildStampClass = Class.forName("filenet.vw.toolkit.utils.VWBuildStamp");
            Field buildVersion = peBuildStampClass.getField("buildVersion");
            Field buildLine = peBuildStampClass.getField("buildLine");
            if (buildLine != null && buildVersion != null) {
                peBuildNumber = (String)buildVersion.get(buildVersion) + " " + (String)buildLine.get(buildLine);
            }
        }
        catch (Throwable e) {
            Logger.logDebug(NexusPingMediator.class, "getPEBuildNumber", (HttpSession)null, e.getLocalizedMessage());
        }
        return peBuildNumber;
    }

    private static String getCEBuildNumber() {
        String CEClientJar = "Jace.jar";
        String ceBuildNumber = "";
        String[] MANIFEST_ATTRIBUTE_NAMES = new String[]{"Specification-Version", "Implementation-Version"};
        try {
            List attributeValues = JarManifest.getManifestAttributes(null, CEClientJar, MANIFEST_ATTRIBUTE_NAMES);
            if (attributeValues != null) {
                String productRelease = (String)attributeValues.get(0);
                String buildNumber = (String)attributeValues.get(1);
                if (productRelease != null) {
                    ceBuildNumber = ceBuildNumber + productRelease;
                }
                if (buildNumber != null) {
                    ceBuildNumber = ceBuildNumber + " (" + buildNumber + ")";
                }
            }
        }
        catch (Throwable e) {
            Logger.logDebug(NexusPingMediator.class, "getCEBuildNumber", (HttpSession)null, e.getLocalizedMessage());
        }
        return ceBuildNumber;
    }

    private static String getCMBuildNumber() {
        String cmBuildNumber = "";
        try {
            Class<?> cmDataStoreClass = Class.forName("com.ibm.mm.sdk.server.DKDatastoreICM");
            Class[] params = new Class[]{};
            Object[] paramsObj = new Object[]{};
            Method apiVersionMethod = cmDataStoreClass.getDeclaredMethod("getAPIVersion", params);
            Object datastoreClass = cmDataStoreClass.newInstance();
            cmBuildNumber = apiVersionMethod.invoke(datastoreClass, paramsObj).toString();
        }
        catch (Throwable e) {
            Logger.logDebug(NexusPingMediator.class, "getCMBuildNumber", (HttpSession)null, e.getLocalizedMessage());
        }
        return cmBuildNumber;
    }

    private static String getODBuildNumber() {
        String odBuildNumber = "";
        try {
            odBuildNumber = "9.0.0.0";
            Class<?> peBuildStampClass = Class.forName("com.ibm.edms.od.ODVersion");
            Field buildVersion = peBuildStampClass.getField("version");
            if (buildVersion != null) {
                odBuildNumber = (String)buildVersion.get(buildVersion);
            }
        }
        catch (Throwable e) {
            Logger.logDebug(NexusPingMediator.class, "getODBuildNumber", (HttpSession)null, e.getLocalizedMessage());
        }
        return odBuildNumber;
    }
}

