/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.AdminLayoutConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.od.ODServerConnection;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import com.ibm.edms.od.ODServer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

public abstract class LogonMediator
extends BaseMediator {
    private static final long serialVersionUID = 1L;
    protected Hashtable p8ConnectionList = null;
    protected Hashtable cm8ConnectionList = null;
    protected Hashtable odConnectionList = null;
    public String privAddDoc = "true";
    public String privAddItem = "true";
    public String privAddSearch = "true";
    private String privAddItemTeamspaceTemplate = "false";
    private String privAddItemTeamspace = "false";
    private String searchTemplateSupported = "false";
    private boolean tamTokenPresent = false;
    public static final String USER_ID = "userID";
    public static final String REPOSITORY_ID = "repositoryId";
    public static final String CONNECTED = "connected";
    public static final String USE_SSO = "useSSO";
    protected String isAdminUser = null;
    protected String currentRepositoryId = null;
    private Hashtable containerConnectionList = null;
    protected String userDisplayName = null;

    protected LogonMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public LogonMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public Hashtable getP8ConnectionList() {
        if (this.p8ConnectionList == null) {
            this.p8ConnectionList = (Hashtable)this.request.getSession(true).getAttribute("p8_servers");
        }
        return this.p8ConnectionList;
    }

    public void setP8ConnectionList(Hashtable p8ConnectionList) {
        this.p8ConnectionList = p8ConnectionList;
    }

    public void setCM8ConnectionList(Hashtable cm8ConnectionList) {
        this.cm8ConnectionList = cm8ConnectionList;
    }

    public Hashtable getCM8ConnectionList() {
        if (this.cm8ConnectionList == null) {
            this.cm8ConnectionList = (Hashtable)this.request.getSession(true).getAttribute("cm_servers");
        }
        return this.cm8ConnectionList;
    }

    public void setODConnectionList(Hashtable odConnectionList) {
        this.odConnectionList = odConnectionList;
    }

    public Hashtable getODConnectionList() {
        if (this.odConnectionList == null) {
            this.odConnectionList = (Hashtable)this.request.getSession(true).getAttribute("od_servers");
        }
        return this.odConnectionList;
    }

    public String getSSOForRepository(String repositoryId) {
        return null;
    }

    public String getCurrentRepositoryId() {
        return this.currentRepositoryId;
    }

    public void setCurrentRepositoryId(String currentRepositoryId) {
        this.currentRepositoryId = currentRepositoryId;
    }

    public static boolean isAdminUser(HttpServletRequest request, String userId) {
        String methodName = "isAdminUser";
        HttpSession session = request.getSession(false);
        String desktopName = request.getParameter("desktop");
        if (desktopName == null || desktopName.length() == 0) {
            try {
                desktopName = Config.getDefaultDesktopName(request);
            }
            catch (Exception e) {
                Logger.logDebug(LogonMediator.class, methodName, session, e.getLocalizedMessage());
            }
        }
        if (session != null) {
            Hashtable connectionList = (Hashtable)session.getAttribute(ContainerLogonAction.CONTAINERS);
            Logger.logDebug(LogonMediator.class, methodName, session, "connectionList=" + connectionList + "  desktopName=" + desktopName);
            if (connectionList != null && desktopName != null) {
                Hashtable connections = (Hashtable)connectionList.get(desktopName);
                Logger.logDebug(LogonMediator.class, methodName, session, "Connections for desktop(" + desktopName + ")=" + connections);
                if (connections != null) {
                    Enumeration userIds = connections.keys();
                    Logger.logDebug(LogonMediator.class, methodName, session, "userIds" + userIds);
                    while (userIds.hasMoreElements()) {
                        String user = (String)userIds.nextElement();
                        Logger.logDebug(LogonMediator.class, methodName, session, "isAdmin  userId " + userId + "   user=" + user);
                        if (!LogonMediator.containsIgnoreCase(userId, user) || !Config.getApplicationConfig(request).checkAdminAccessForUser(userId)) continue;
                        Logger.logDebug(LogonMediator.class, methodName, session, "isAdminUser=true");
                        return true;
                    }
                }
            }
        }
        Logger.logDebug(LogonMediator.class, "isAdminUser", session, "isAdminUser=false");
        return false;
    }

    public static boolean containsIgnoreCase(String userid, String user) {
        String methodName = "containsIgnoreCase";
        if (userid.equalsIgnoreCase(user)) {
            return true;
        }
        if (user.contains("@")) {
            StringTokenizer st = new StringTokenizer(user, "@");
            user = (String)st.nextElement();
        }
        if (userid.equalsIgnoreCase(user)) {
            AdminLogger.logDebug(LogonMediator.class, methodName, "adminUser found in the config=" + user);
            return true;
        }
        return false;
    }

    public boolean isAdminUser(String userId) {
        return LogonMediator.isAdminUser(this.request, userId);
    }

    public JSONObject getAdminLayoutJSONObject() {
        JSONObject jsonAdminLayout = new JSONObject();
        AdminLayoutConfig adminLayoutConfig = AdminLayoutConfig.getAdminLayoutConfig();
        jsonAdminLayout.put(AdminLayoutConfig.NAME, adminLayoutConfig.getName());
        jsonAdminLayout.put(AdminLayoutConfig.ICON_CLASS, adminLayoutConfig.getIconClass());
        jsonAdminLayout.put(AdminLayoutConfig.LABEL, this.messageResources.getMessage(this.locale, "feature.administration"));
        jsonAdminLayout.put(AdminLayoutConfig.TOOL_TIP_TEXT, adminLayoutConfig.getTooltipText());
        jsonAdminLayout.put(AdminLayoutConfig.IS_SEPARATOR, (Object)adminLayoutConfig.isSeparator());
        jsonAdminLayout.put(AdminLayoutConfig.POPUP_WINDOW_CLASS, adminLayoutConfig.getPopupWindowClass());
        jsonAdminLayout.put(AdminLayoutConfig.CONTENT_CLASS, adminLayoutConfig.getContentClass());
        return jsonAdminLayout;
    }

    public boolean isTamTokenPresent() {
        return this.tamTokenPresent;
    }

    public void setTamKerberosTokenPresent(boolean tamTokenPresent) {
        this.tamTokenPresent = tamTokenPresent;
    }

    public JSONObject toJSONObject() {
        String token;
        RepositoryConfig repoConfig;
        JSONObject jsonServer;
        Object connection;
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        String useSSO = "false";
        DesktopConfig desktopConfig = Config.getDesktopConfig(this.request);
        String defaultRepositoryId = desktopConfig == null ? null : desktopConfig.getDefaultRepositoryId();
        JSONArray jsonServers = null;
        if (this.getP8ConnectionList() != null) {
            Enumeration p8Repositories = this.p8ConnectionList.keys();
            if (jsonServers == null) {
                jsonServers = new JSONArray();
            }
            while (p8Repositories.hasMoreElements()) {
                String p8RepositoryId = (String)p8Repositories.nextElement();
                connection = (P8Connection)this.p8ConnectionList.get(p8RepositoryId);
                if (connection == null) continue;
                jsonServer = new JSONObject();
                jsonServer.put(USER_ID, ((P8Connection)connection).getUserId());
                jsonServer.put(REPOSITORY_ID, p8RepositoryId);
                jsonServer.put("priv_addItem", ((P8Connection)connection).getPrivAddDoc() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddDoc().equalsIgnoreCase("true")));
                jsonServer.put("priv_addDoc", ((P8Connection)connection).getPrivAddItem() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddItem().equalsIgnoreCase("true")));
                jsonServer.put("priv_addSearch", ((P8Connection)connection).getPrivAddSearch() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddSearch().equalsIgnoreCase("true")));
                jsonServer.put("searchTemplateSupported", ((P8Connection)connection).getSearchTemplateSupported() == null ? null : Boolean.valueOf(((P8Connection)connection).getSearchTemplateSupported().equalsIgnoreCase("true")));
                jsonServer.put("priv_workflow", ((P8Connection)connection).getPrivWorkflow() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivWorkflow().equalsIgnoreCase("true")));
                jsonServer.put("priv_addTeamspace", ((P8Connection)connection).getPrivAddItemTeamspace() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddItemTeamspace().equalsIgnoreCase("true")));
                jsonServer.put("priv_addTeamspaceTemplate", ((P8Connection)connection).getPrivAddItemTeamspaceTemplate() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddItemTeamspaceTemplate().equalsIgnoreCase("true")));
                jsonServer.put("textSearchType", ((P8Connection)connection).getTextSearchType(this.request));
                jsonServer.put(CONNECTED, (Object)true);
                if (defaultRepositoryId != null && defaultRepositoryId.equals(p8RepositoryId) && this.isAdminUser(((P8Connection)connection).getUserId())) {
                    jsonServer.put("adminLayout", this.getAdminLayoutJSONObject());
                }
                jsonServer.put("admin_user", (Object)this.isAdminUser(((P8Connection)connection).getUserId()));
                repoConfig = null;
                if (Config.hasRepositoryConfigUsingIdOrServerName(this.request, p8RepositoryId)) {
                    repoConfig = Config.getRepositoryConfigUsingIdOrServerName(this.request, p8RepositoryId);
                }
                if (repoConfig != null) {
                    jsonServer.put(USE_SSO, repoConfig.getUseSSO());
                } else {
                    jsonServer.put(USE_SSO, useSSO);
                }
                jsonServer.put("textSearchType", P8TextSearchUtil.getTextSearchType((P8Connection)connection, this.request));
                jsonServers.add(jsonServer);
            }
        }
        if (this.getCM8ConnectionList() != null) {
            Enumeration cm8Repositories = this.cm8ConnectionList.keys();
            if (jsonServers == null) {
                jsonServers = new JSONArray();
            }
            while (cm8Repositories.hasMoreElements()) {
                String cm8RepositoryId = (String)cm8Repositories.nextElement();
                connection = (CMConnection)this.cm8ConnectionList.get(cm8RepositoryId);
                String cm8TextSearchType = CMBaseUtil.getTextSearchType(((CMConnection)connection).getDatastore(), this.request);
                if (connection == null) continue;
                Hashtable<String, String> privilagesTable = null;
                RepositoryConfig repoConfig2 = Config.getRepositoryConfigUsingIdOrServerName(this.request, cm8RepositoryId);
                JSONObject jsonServer2 = new JSONObject();
                jsonServer2.put(USER_ID, ((CMConnection)connection).getUserid());
                jsonServer2.put(REPOSITORY_ID, cm8RepositoryId);
                try {
                    privilagesTable = CMBaseAction.getPrivilagesTable(this.request, (CMConnection)connection, repoConfig2);
                    if (privilagesTable != null) {
                        jsonServer2.put("priv_addTeamspace", (Object)privilagesTable.get("privAddTeamspace").equalsIgnoreCase("true"));
                        jsonServer2.put("priv_addTeamspaceTemplate", (Object)privilagesTable.get("privAddTeamspaceTemplate").equalsIgnoreCase("true"));
                        jsonServer2.put("priv_addItem", (Object)privilagesTable.get("privAddContent").equalsIgnoreCase("true"));
                        jsonServer2.put("priv_addDoc", (Object)privilagesTable.get("privAddItem").equalsIgnoreCase("true"));
                        jsonServer2.put("priv_addSearch", (Object)privilagesTable.get("privAddSearch").equalsIgnoreCase("true"));
                        jsonServer2.put("searchTemplateSupported", (Object)privilagesTable.get("setSearchTemplateSupported").equalsIgnoreCase("true"));
                        jsonServer2.put("priv_foldering", (Object)privilagesTable.get("privFoldering").equalsIgnoreCase("true"));
                    }
                }
                catch (Exception e) {
                    Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
                }
                jsonServer2.put("textSearchType", cm8TextSearchType);
                jsonServer2.put(CONNECTED, (Object)true);
                if (defaultRepositoryId != null && defaultRepositoryId.equals(cm8RepositoryId) && this.isAdminUser(((CMConnection)connection).getUserid())) {
                    jsonServer2.put("adminLayout", this.getAdminLayoutJSONObject());
                }
                jsonServer2.put("admin_user", (Object)this.isAdminUser(((CMConnection)connection).getUserid()));
                if (repoConfig2 != null) {
                    jsonServer2.put(USE_SSO, repoConfig2.getUseSSO());
                } else {
                    jsonServer2.put(USE_SSO, useSSO);
                }
                jsonServers.add(jsonServer2);
            }
        }
        if (this.getODConnectionList() != null) {
            Enumeration odRepositories = this.odConnectionList.keys();
            if (jsonServers == null) {
                jsonServers = new JSONArray();
            }
            while (odRepositories.hasMoreElements()) {
                String odRepositoryId = (String)odRepositories.nextElement();
                connection = (ODServer)this.odConnectionList.get(odRepositoryId);
                if (connection == null) continue;
                jsonServer = new JSONObject();
                if (connection instanceof ODServerConnection) {
                    jsonServer.put(USER_ID, ((ODServerConnection)((Object)connection)).getUserId());
                } else {
                    jsonServer.put(USER_ID, connection.getUserId());
                }
                jsonServer.put(REPOSITORY_ID, odRepositoryId);
                jsonServer.put("priv_addDoc", (Object)true);
                jsonServer.put("priv_addItem", (Object)true);
                jsonServer.put("searchTemplateSupported", (Object)true);
                jsonServer.put(CONNECTED, (Object)true);
                if (defaultRepositoryId != null && defaultRepositoryId.equals(odRepositoryId) && this.isAdminUser(connection.getUserId())) {
                    jsonServer.put("adminLayout", this.getAdminLayoutJSONObject());
                }
                jsonServer.put("admin_user", (Object)this.isAdminUser(connection.getUserId()));
                repoConfig = Config.getRepositoryConfigUsingIdOrServerName(this.request, odRepositoryId);
                if (repoConfig != null) {
                    jsonServer.put(USE_SSO, repoConfig.getUseSSO());
                } else {
                    jsonServer.put(USE_SSO, useSSO);
                }
                boolean privCreateHold = false;
                if (connection.isInitialized()) {
                    privCreateHold = ODUtil.hasHoldPriv(this.request, (ODServer)connection);
                }
                jsonObject.put("privCreateHold", (Object)privCreateHold);
                jsonServer.put("privCreateHold", (Object)privCreateHold);
                jsonServers.add(jsonServer);
            }
        }
        if (jsonServers != null) {
            jsonObject.put("servers", jsonServers);
        }
        if (LogonMediator.isSecureServiceEnabled(this.request) && (token = new SecurityTokenManager().generateToken(this.request)) != null && jsonObject != null) {
            jsonObject.put("security_token", token);
        }
        if (this.isTamTokenPresent()) {
            jsonObject.put("tam_token", (Object)this.isTamTokenPresent());
        }
        return jsonObject;
    }

    public String getPrivAddItemTeamspaceTemplate() {
        return this.privAddItemTeamspaceTemplate;
    }

    public void setPrivAddItemTeamspaceTemplate(String privAddItemTeamspaceTemplate) {
        this.privAddItemTeamspaceTemplate = privAddItemTeamspaceTemplate;
    }

    public String getPrivAddItemTeamspace() {
        return this.privAddItemTeamspace;
    }

    public void setPrivAddItemTeamspace(String privAddItemTeamspace) {
        this.privAddItemTeamspace = privAddItemTeamspace;
    }

    public String getIsAdminUser() {
        return this.isAdminUser;
    }

    public void setIsAdminUser(String isAdminUser) {
        this.isAdminUser = isAdminUser;
    }

    public void setContainerConnectionList(Hashtable connectionList) {
        this.containerConnectionList = connectionList;
    }

    public Hashtable getContainerConnectionList() {
        if (this.containerConnectionList == null) {
            this.containerConnectionList = (Hashtable)this.request.getSession(true).getAttribute(ContainerLogonAction.CONTAINERS);
        }
        return this.containerConnectionList;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }
}

