/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.HitMediator;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFavoritesMediator
extends ResultSetMediator {
    static final long serialVersionUID = 1L;
    private Collection<FavoriteConfig> favoriteList = null;

    public ListFavoritesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setConfigurationObject(Collection<FavoriteConfig> favoriteList) {
        this.favoriteList = favoriteList;
    }

    @Override
    protected JSONArray buildTableRows() {
        JSONArray favoritesJSON = new JSONArray();
        if (this.favoriteList != null) {
            for (FavoriteConfig favorite : this.favoriteList) {
                JSONObject rowJSON = new JSONObject();
                rowJSON.put("id", favorite.getItemId());
                rowJSON.put("name", favorite.getAlias());
                rowJSON.put("mimetype", favorite.getMimeType());
                rowJSON.put("template", favorite.getTemplate());
                rowJSON.put("vsId", favorite.getVersionSerieId());
                rowJSON.put("favoriteId", favorite.getObjectId());
                rowJSON.put("repositoryId", favorite.getRepositoryId());
                String repositoryLabel = BaseUtil.getCustomLabelValue(this.request, "app_repository");
                if (repositoryLabel == null || repositoryLabel.length() == 0) {
                    repositoryLabel = this.messageResources.getMessage(this.getLocale(), "repository");
                }
                rowJSON.put("repositoryLabel", repositoryLabel);
                JSONObject attributesJSON = new JSONObject();
                JSONArray attributeJSON = new JSONArray();
                attributeJSON.add(favorite.getRepositoryId());
                attributesJSON.put("repositoryId", attributeJSON);
                HitMediator.addAttribute(attributesJSON, "repositoryId", favorite.getRepositoryId());
                HitMediator.addAttribute(attributesJSON, "title", favorite.getAlias());
                HitMediator.addAttribute(attributesJSON, "type", favorite.getType());
                HitMediator.addAttribute(attributesJSON, "label", favorite.getAlias());
                HitMediator.addAttribute(attributesJSON, "mimetype", favorite.getMimeType());
                HitMediator.addAttribute(attributesJSON, "template", favorite.getTemplate());
                rowJSON.put("attributes", attributesJSON);
                favoritesJSON.add(rowJSON);
            }
        }
        Collections.sort(favoritesJSON, new FavoritesComparator());
        return favoritesJSON;
    }

    @Override
    protected JSONArray buildMagazineViewColumns() {
        JSONArray columns = new JSONArray();
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("field", "thumbnail");
        thumbnail.put("name", "");
        thumbnail.put("width", "60px");
        thumbnail.put("decorator", "MagazineViewDecorator.thumbnailDecorator");
        columns.add(thumbnail);
        JSONObject content = new JSONObject();
        content.put("field", "content");
        content.put("name", "");
        content.put("decorator", "MagazineViewDecorator.contentCellDecoratorFavorite");
        columns.add(content);
        return columns;
    }

    @Override
    protected JSONObject buildTableColumns() throws Exception {
        String methodName = "buildTableColums";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        TableView tableView = new TableView();
        TableView.ColumnSet columnSet = tableView.createColumnSet();
        columnSet.addColumnProperty(this.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
        columnSet.addColumnProperty(this.buildColumnProperty(this.messageResources.getMessage(this.getLocale(), "name"), "26em", "label", null, false), true);
        String repositoryLabel = BaseUtil.getCustomLabelValue(this.request, "app_repository");
        if (repositoryLabel == null || repositoryLabel.length() == 0) {
            repositoryLabel = this.messageResources.getMessage(this.getLocale(), "repository");
        }
        columnSet.addColumnProperty(this.buildColumnProperty(repositoryLabel, "26em", "repositoryName", null, false), true);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return tableView.toJson();
    }

    private Map buildColumnProperty(String name, String width, String symbolicName, String styles, Boolean removeSorting) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("name", name);
        propertyMap.put("width", width);
        propertyMap.put("field", symbolicName);
        if (styles != null) {
            propertyMap.put("styles", styles);
        }
        if (removeSorting.booleanValue()) {
            propertyMap.put("nosort", removeSorting);
        }
        propertyMap.put("sortable", removeSorting == false);
        if (symbolicName != null && symbolicName.equals("mimeTypeIcon")) {
            propertyMap.put("decorator", "DetailsViewDecorator.mimeTypeDecorator");
        }
        return propertyMap;
    }

    private String getTitleUrl(FavoriteConfig favorite) {
        return "<a href=\"" + favorite.getItemId() + "\">" + favorite.getAlias() + "</a>";
    }

    private String getName(FavoriteConfig favorite) {
        return "<a href=\"" + favorite.getItemId() + "\">" + favorite.getName() + "</a>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FavoritesComparator
    implements Comparator<JSONObject> {
        private FavoritesComparator() {
        }

        @Override
        public int compare(JSONObject i1, JSONObject i2) {
            String t1 = (String)((JSONArray)((JSONObject)i1.get("attributes")).get("type")).get(0);
            String t2 = (String)((JSONArray)((JSONObject)i2.get("attributes")).get("type")).get(0);
            if (t1 == null) {
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            if (t1.equals(t2)) {
                return ((String)i1.get("name")).compareTo((String)i2.get("name"));
            }
            if ("teamspace".equals(t1)) {
                return -1;
            }
            if ("teamspace".equals(t2)) {
                return 1;
            }
            if ("folder".equals(t1)) {
                return -1;
            }
            if ("folder".equals(t2)) {
                return 1;
            }
            if ("search".equals(t1)) {
                return -1;
            }
            if ("search".equals(t2)) {
                return 1;
            }
            return ((String)i1.get("name")).compareTo((String)i2.get("name"));
        }
    }
}

