/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.extension.PluginFeature;
import com.ibm.ecm.extension.PluginLayout;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutConfigMediator
extends BaseMediator {
    static final long serialVersionUID = 1L;
    private static final String ADMIN_ID = "admin";
    private static final String ADMIN_PANE = "ecmClientAdmin";
    private Map<String, Object> layoutMap;
    private Map<String, Object> featureMap;
    private Map<String, Object> commonActionHandlerMap;
    private String id;

    public LayoutConfigMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected LayoutConfigMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public void setLayoutMap(Map<String, Object> map) {
        this.layoutMap = map;
    }

    public void setFeatureMap(Map<String, Object> map) {
        this.featureMap = map;
    }

    public void setCommonActionHandler(Map<String, Object> map) {
        this.commonActionHandlerMap = map;
    }

    public void setDesktopId(String id) {
        this.id = id;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject layoutDefObj;
        Object type;
        JSONObject json;
        JSONArray jsonArray;
        String methodName = "toJSONObject";
        JSONObject jsonObj = super.toJSONObject();
        if (this.layoutMap != null) {
            JSONObject layoutObj = new JSONObject();
            layoutObj.put("identifier", "value");
            jsonArray = new JSONArray();
            for (String layout : this.layoutMap.keySet()) {
                json = new JSONObject();
                type = this.layoutMap.get(layout);
                if (type instanceof String) {
                    json.put("label", layout);
                    json.put("value", layout);
                    json.put("type", type);
                } else {
                    PluginLayout pluginLayout = (PluginLayout)type;
                    json.put("label", pluginLayout.getName(this.request.getLocale()));
                    json.put("value", pluginLayout.getId());
                    json.put("type", "custom");
                    json.put("layoutClass", pluginLayout.getLayoutClass());
                    json.put("pluginId", pluginLayout.getPluginId());
                }
                jsonArray.add(json);
            }
            layoutObj.put("items", jsonArray);
            jsonObj.put("layouts", layoutObj);
        }
        if (this.featureMap != null) {
            layoutDefObj = new JSONObject();
            layoutDefObj.put("identifier", "value");
            jsonArray = new JSONArray();
            for (String layoutDef : this.featureMap.keySet()) {
                json = new JSONObject();
                type = this.featureMap.get(layoutDef);
                PluginFeature pluginFeature = (PluginFeature)type;
                json.put("name", pluginFeature.getId());
                json.put("iconClass", pluginFeature.getIconUrl());
                json.put("label", pluginFeature.getName(this.request.getLocale()));
                json.put("buttonTooltip", pluginFeature.getFeatureIconTooltipText(this.request.getLocale()));
                json.put("popupTooltip", pluginFeature.getPopupWindowTooltipText(this.request.getLocale()));
                json.put("isSeparator", (Object)pluginFeature.isSeparator());
                json.put("popupWindowClass", pluginFeature.getPopupWindowClass());
                json.put("contentClass", pluginFeature.getContentClass());
                json.put("pluginId", pluginFeature.getId());
                json.put("preLoad", (Object)pluginFeature.isPreLoad());
                jsonArray.add(json);
            }
            jsonObj.put("features", jsonArray);
        }
        if (this.commonActionHandlerMap != null) {
            layoutDefObj = new JSONObject();
            layoutDefObj.put("identifier", "value");
            jsonArray = new JSONArray();
            for (String commonActionHandler : this.commonActionHandlerMap.keySet()) {
                json = new JSONObject();
                type = this.commonActionHandlerMap.get(commonActionHandler);
                if (type instanceof String) {
                    json.put("label", commonActionHandler);
                    json.put("value", commonActionHandler);
                    json.put("type", type);
                }
                jsonArray.add(json);
            }
            layoutDefObj.put("items", jsonArray);
            jsonObj.put("commonActionHandler", layoutDefObj);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObj.toString());
        return jsonObj;
    }
}

