/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.configuration.IconConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.IdLabelConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconMediator
extends BaseMediator {
    static final long serialVersionUID = 1L;
    private List<IconConfig> iconConfigs = null;
    private List<IconStatusConfig> iconStatusConfigs = null;
    private String[] defaultContentTypes = null;
    private List<IdLabelConfig> defaultContentTypeClasses = null;
    private List<IdLabelConfig> defaultStatusClasses = null;

    public IconMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected IconMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public void setIconConfigs(List<IconConfig> iconConfigs) {
        this.iconConfigs = iconConfigs;
    }

    public void setIconStatusConfigs(List<IconStatusConfig> iconStatusConfigs) {
        this.iconStatusConfigs = iconStatusConfigs;
    }

    public void setDefaultContentTypes(String[] contentTypes) {
        this.defaultContentTypes = contentTypes;
    }

    public void setDefaultContentTypeClasses(List<IdLabelConfig> classes) {
        this.defaultContentTypeClasses = classes;
    }

    public void setDefaultStatusClasses(List<IdLabelConfig> classes) {
        this.defaultStatusClasses = classes;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            JSONArray jsonArray;
            if (this.defaultContentTypes != null) {
                jsonArray = new JSONArray();
                for (int i = 0; i < this.defaultContentTypes.length; ++i) {
                    jsonArray.add(this.defaultContentTypes[i]);
                }
                jsonObject.put("defaultContentTypes", jsonArray);
            }
            if (this.defaultContentTypeClasses != null) {
                jsonArray = new JSONArray();
                for (IdLabelConfig idLabelConfig : this.defaultContentTypeClasses) {
                    jsonArray.add(idLabelConfig.toJSON());
                }
                jsonObject.put("defaultContentTypeClasses", jsonArray);
            }
            if (this.iconConfigs != null) {
                jsonArray = new JSONArray();
                for (IconConfig iconConfig : this.iconConfigs) {
                    jsonArray.add(iconConfig.toJSON());
                }
                jsonObject.put("iconMappings", jsonArray);
            }
            if (this.defaultStatusClasses != null) {
                jsonArray = new JSONArray();
                for (IdLabelConfig idLabelConfig : this.defaultStatusClasses) {
                    jsonArray.add(idLabelConfig.toJSON());
                }
                jsonObject.put("iconStatusClasses", jsonArray);
            }
            if (this.iconStatusConfigs != null) {
                jsonArray = new JSONArray();
                for (IconStatusConfig iconStatusConfig : this.iconStatusConfigs) {
                    jsonArray.add(iconStatusConfig.toJSON());
                }
                jsonObject.put("iconStatus", jsonArray);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        return jsonObject;
    }
}

