/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public abstract class HitMediator
extends BaseMediator {
    public static final long PRIV_EDITPROPERTIES = 1L;
    public static final long PRIV_EDITDOC = 2L;
    public static final long PRIV_VIEWNOTES = 4L;
    public static final long PRIV_ADDDOC = 8L;
    public static final long PRIV_ADDITEM = 16L;
    public static final long PRIV_EMAILDOC = 32L;
    public static final long PRIV_EXPORT = 64L;
    public static final long PRIV_ADD_TO_FOLDER = 128L;
    public static final long PRIV_REMOVE_FROM_FOLDER = 256L;
    public static final long PRIV_ADD_LINK = 512L;
    public static final long PRIV_REMOVE_LINK = 1024L;
    public static final long PRIV_ADDNOTES = 4096L;
    public static final long PRIV_PRINTNOTES = 8192L;
    public static final long PRIV_PRINTDOC = 16384L;
    public static final long PRIV_CHECKINOUTDOC = 32768L;
    public static final long PRIV_CHECKINDOC = 65536L;
    public static final long PRIV_CHECKOUTDOC = 131072L;
    public static final long PRIV_CANCELCHECKOUTDOC = 262144L;
    public static final long PRIV_VIEWANNOTATIONS = 524288L;
    public static final long PRIV_EDITANNOTATIONS = 0x100000L;
    public static final long PRIV_VIEWDOC = 0x200000L;
    public static final long PRIV_DELETE = 0x400000L;
    public static final long PRIV_STARTWORKFLOW = 0x800000L;
    public static final long PRIV_HOLD = 0x1000000L;
    public static final long PRIV_MOVE_TO_FOLDER = 0x2000000L;
    public static final long PRIV_CHANGE_CLASS = 0x4000000L;
    public static final long PRIV_MAJOR_VERSION = 0x8000000L;
    public static final long PRIV_MINOR_VERSION = 0x10000000L;
    public static final long PRIV_DECLARE = 0x20000000L;

    public HitMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            this.fillJSONObject(jsonObject);
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public final void fillJSONObject(JSONObject jsonObject) throws Exception {
        jsonObject.put("attributes", this.buildAttributes());
        jsonObject.put("privileges", (Object)this.getPrivileges());
        jsonObject.put("id", this.getItemId());
        jsonObject.put("name", this.getItemName());
    }

    public abstract String getItemId() throws Exception;

    public abstract String getItemName() throws Exception;

    public abstract JSONObject buildAttributes() throws Exception;

    public static final void addAttribute(JSONObject attributesJSON, String name, String value, String format, String displayName) {
        JSONArray attributeJSON = new JSONArray();
        attributeJSON.add(value);
        if (format != null || displayName != null) {
            attributeJSON.add(format);
        }
        if (displayName != null) {
            attributeJSON.add(displayName);
        }
        attributesJSON.put(name, attributeJSON);
    }

    public static final void addAttribute(JSONObject attributesJSON, String name, String value, String format) {
        HitMediator.addAttribute(attributesJSON, name, value, format, null);
    }

    public static final void addAttribute(JSONObject attributesJSON, String name, String value) {
        HitMediator.addAttribute(attributesJSON, name, value, null, null);
    }

    public final long getPrivileges() throws Exception {
        long privileges = 0L;
        if (this.canEditProperties()) {
            privileges |= 1L;
        }
        if (this.canEditDoc()) {
            privileges |= 2L;
        }
        if (this.canViewNotes()) {
            privileges |= 4L;
        }
        if (this.canAddDoc()) {
            privileges |= 8L;
        }
        if (this.canAddItem()) {
            privileges |= 0x10L;
        }
        if (this.canEmailDoc()) {
            privileges |= 0x20L;
        }
        if (this.canExport()) {
            privileges |= 0x40L;
        }
        if (this.canAddToFolder()) {
            privileges |= 0x80L;
        }
        if (this.canRemoveFromFolder()) {
            privileges |= 0x100L;
        }
        if (this.canAddLink()) {
            privileges |= 0x200L;
        }
        if (this.canRemoveLink()) {
            privileges |= 0x400L;
        }
        if (this.canAddNotes()) {
            privileges |= 0x1000L;
        }
        if (this.canPrintNotes()) {
            privileges |= 0x2000L;
        }
        if (this.canPrintDoc()) {
            privileges |= 0x4000L;
        }
        if (this.canCheckInOutDoc()) {
            privileges |= 0x8000L;
        }
        if (this.canCheckInDoc()) {
            privileges |= 0x10000L;
        }
        if (this.canCheckOutDoc()) {
            privileges |= 0x20000L;
        }
        if (this.canCancelCheckOutDoc()) {
            privileges |= 0x40000L;
        }
        if (this.canViewAnnotations()) {
            privileges |= 0x80000L;
        }
        if (this.canEditAnnotations()) {
            privileges |= 0x100000L;
        }
        if (this.canViewDoc()) {
            privileges |= 0x200000L;
        }
        if (this.canDelete()) {
            privileges |= 0x400000L;
        }
        if (this.canStartWorkflow()) {
            privileges |= 0x800000L;
        }
        if (this.canHold()) {
            privileges |= 0x1000000L;
        }
        if (this.canMoveToFolder()) {
            privileges |= 0x2000000L;
        }
        if (this.canChangeClass()) {
            privileges |= 0x4000000L;
        }
        if (this.canMajorVersion()) {
            privileges |= 0x8000000L;
        }
        if (this.canMinorVersion()) {
            privileges |= 0x10000000L;
        }
        if (this.canDeclare()) {
            privileges |= 0x20000000L;
        }
        return privileges;
    }

    public abstract boolean canEditProperties() throws Exception;

    public abstract boolean canEditDoc() throws Exception;

    public abstract boolean canViewNotes() throws Exception;

    public abstract boolean canAddDoc() throws Exception;

    public abstract boolean canAddItem() throws Exception;

    public abstract boolean canEmailDoc() throws Exception;

    public abstract boolean canExport() throws Exception;

    public abstract boolean canAddToFolder() throws Exception;

    public abstract boolean canRemoveFromFolder() throws Exception;

    public abstract boolean canAddLink() throws Exception;

    public abstract boolean canRemoveLink() throws Exception;

    public abstract boolean canAddNotes() throws Exception;

    public abstract boolean canPrintNotes() throws Exception;

    public abstract boolean canPrintDoc() throws Exception;

    public abstract boolean canCheckInOutDoc() throws Exception;

    public abstract boolean canCheckInDoc() throws Exception;

    public abstract boolean canCheckOutDoc() throws Exception;

    public abstract boolean canCancelCheckOutDoc() throws Exception;

    public abstract boolean canViewAnnotations() throws Exception;

    public abstract boolean canEditAnnotations() throws Exception;

    public abstract boolean canViewDoc() throws Exception;

    public abstract boolean canDelete() throws Exception;

    public abstract boolean canStartWorkflow() throws Exception;

    public abstract boolean canHold() throws Exception;

    public abstract boolean canMoveToFolder() throws Exception;

    public abstract boolean canChangeClass() throws Exception;

    public abstract boolean canMajorVersion() throws Exception;

    public abstract boolean canMinorVersion() throws Exception;

    public abstract boolean canDeclare() throws Exception;
}

