/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

public class ExportSearchResultsMediator
extends BaseMediator {
    public ExportSearchResultsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected ExportSearchResultsMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public String toCSVString(String exportColumns, String[] exportRows) {
        String methodName = "toCSVString";
        Logger.logEntry((Object)this, "toCSVString", (ServletRequest)this.request);
        StringBuffer csvString = new StringBuffer();
        String newLine = System.getProperty("line.seperator");
        if (newLine == null) {
            newLine = "\n";
        }
        JSONArray columnJsonArray = null;
        try {
            columnJsonArray = JSONArray.parse(exportColumns);
            for (JSONObject columnJsonObject : columnJsonArray) {
                String columnDisplayName = columnJsonObject.get("name").toString();
                columnDisplayName = StringEscapeUtils.unescapeHtml((String)columnDisplayName);
                columnDisplayName = columnDisplayName.replaceAll("\"", "\"\"");
                csvString.append("\"").append(columnDisplayName).append("\",");
            }
            csvString.setLength(csvString.length() - 1);
            csvString.append(newLine);
        }
        catch (IOException e) {
            Logger.logError((Object)this, "toCSVString", (ServletRequest)this.request, (Throwable)e);
        }
        if (columnJsonArray != null) {
            for (int i = 0; i < exportRows.length; ++i) {
                try {
                    JSONObject rowJsonObject = JSONObject.parse(exportRows[i]);
                    Iterator itr2 = columnJsonArray.iterator();
                    while (itr2.hasNext()) {
                        String columnName = (String)((JSONObject)itr2.next()).get("field");
                        String value = "";
                        Object valueObject = rowJsonObject.get(columnName);
                        if (valueObject != null) {
                            value = valueObject instanceof String[] ? ((String[])valueObject)[0] : (String)valueObject;
                            value = StringEscapeUtils.unescapeHtml((String)value);
                            value = value.replaceAll("\"", "\"\"");
                        }
                        csvString.append("\"").append(value).append("\",");
                    }
                    csvString.setLength(csvString.length() - 1);
                    csvString.append(newLine);
                    continue;
                }
                catch (IOException e) {
                    Logger.logError((Object)this, "toCSVString", (ServletRequest)this.request, (Throwable)e);
                }
            }
        }
        return csvString.toString();
    }
}

