/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class DocumentInfoMediator
extends BaseMediator {
    public boolean hasErrors = false;
    public String documentId = null;
    public int partCount = 1;
    public int annotationPartCount = 0;
    public int notelogCount = 0;
    public int partNumber = 0;
    public long partSize = 0L;
    public String mimeType;
    public String storedFileName;
    public boolean pdfConvertable;

    public DocumentInfoMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected DocumentInfoMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public int getPartCount() {
        return this.partCount;
    }

    public void setPartCount(int partCount) {
        this.partCount = partCount;
    }

    public int getAnnotationPartCount() {
        return this.annotationPartCount;
    }

    public void setAnnotationPartCount(int annotationPartCount) {
        this.annotationPartCount = annotationPartCount;
    }

    public int getNotelogCount() {
        return this.notelogCount;
    }

    public void setNotelogCount(int notelogCount) {
        this.notelogCount = notelogCount;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("docid", this.getDocumentId());
        JSONUtils.put(jsonObject, "part_number", this.getPartNumber());
        JSONUtils.put(jsonObject, "partSize", this.getPartSize());
        JSONUtils.put(jsonObject, "part_count", this.getPartCount());
        JSONUtils.put(jsonObject, "anno_part_count", this.getAnnotationPartCount());
        JSONUtils.put(jsonObject, "notelog_part_count", this.getNotelogCount());
        jsonObject.put("mimetype", this.getMimeType());
        if (this.getStoredFileName() != null && !this.getStoredFileName().equals("")) {
            jsonObject.put("fileName", this.getStoredFileName());
        }
        JSONUtils.put(jsonObject, "pdfConvertable", this.isPDFConvertable());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public static BaseMediator getFromJSONString(HttpServletRequest request, String stringJSON, MessageResources resources, Locale locale) throws IOException {
        String methodName = "getFromJSONString";
        DocumentInfoMediator thisObject = new DocumentInfoMediator(request, resources, locale);
        JSONObject jsonObject = JSONObject.parse(stringJSON);
        Object errorsString = null;
        JSONArray jsonErrors = (JSONArray)jsonObject.get("errors");
        if (jsonErrors != null) {
            JSONObject jsonError = (JSONObject)jsonErrors.get(0);
            String errorText = (String)jsonError.get("text");
            thisObject.addError("error.exception.general", errorText);
            Logger.logDebug(DocumentInfoMediator.class, methodName, (ServletRequest)request, "Session Expired Error");
            thisObject.setHasErrors(true);
        } else {
            Logger.logDebug(DocumentInfoMediator.class, methodName, (ServletRequest)request, "No errors found in mediator.");
            thisObject.setDocumentId(jsonObject.get("docid").toString());
            thisObject.setPartCount(new Integer(jsonObject.get("part_count").toString()));
            thisObject.setAnnotationPartCount(new Integer(jsonObject.get("anno_part_count").toString()));
            thisObject.setNotelogCount(new Integer(jsonObject.get("notelog_part_count").toString()));
            thisObject.setPartNumber(new Integer(jsonObject.get("part_number").toString()));
            thisObject.setPartSize(new Integer(jsonObject.get("partSize").toString()).intValue());
            thisObject.setMimeType(jsonObject.get("mimetype").toString());
            String fileName = null;
            if (jsonObject.get("fileName") != null) {
                fileName = jsonObject.get("fileName").toString();
            }
            if (fileName != null && fileName.length() > 0) {
                thisObject.setStoredFileName(fileName);
            }
            thisObject.setPDFConvertable(new Boolean(jsonObject.get("pdfConvertable").toString()));
            thisObject.setHasErrors(false);
        }
        return thisObject;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getStoredFileName() {
        return this.storedFileName;
    }

    public void setStoredFileName(String storedFileName) {
        this.storedFileName = storedFileName;
    }

    public boolean isPDFConvertable() {
        return this.pdfConvertable;
    }

    public void setPDFConvertable(boolean pdfConvertable) {
        this.pdfConvertable = pdfConvertable;
    }

    public boolean isErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }
}

