/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.IconConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.PropertyMappingConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.configuration.ViewerContentTypeConfig;
import com.ibm.ecm.configuration.ViewerDefConfig;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginFeature;
import com.ibm.ecm.extension.PluginViewerDef;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.ecm.util.SystemInfo;
import com.ibm.ecm.util.container.ContainerConnection;
import com.ibm.ecm.util.od.ODServerConnection;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import com.ibm.edms.od.ODServer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopMediator
extends LogonMediator {
    static final long serialVersionUID = 1L;
    private HttpSession session;
    private String desktopName = null;
    public static final String PRIV_ADD_ITEM = "priv_addDoc";
    public static final String PRIV_ADD_CONTENT = "priv_addItem";
    private DesktopConfig desktopConfig;
    private Collection<RepositoryConfig> repositoryConfigs;
    private Plugin[] plugins;
    private ViewerConfig viewerConfig;
    private List<ViewerDefConfig> definitions = null;
    private List<ViewerContentTypeConfig> contentTypes = null;
    private Collection<ViewerMappingConfig> defaultViewerMapping = null;
    private SettingsConfig settingsConfig;
    private Hashtable<String, List<MenuConfig>> menus;
    private List<IconConfig> iconConfigs = null;
    private List<IconStatusConfig> iconStatusConfigs = null;
    private List<InterfaceTextConfig> applicationLabels = null;

    public DesktopMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected DesktopMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public void setDesktop(DesktopConfig desktopConfig) {
        this.desktopConfig = desktopConfig;
    }

    public void setRepositories(Collection<RepositoryConfig> serverConfigs) {
        this.repositoryConfigs = serverConfigs;
    }

    public void setPlugins(Plugin[] plugins) {
        this.plugins = plugins;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setDesktopName(String desktopName) {
        this.desktopName = desktopName;
    }

    public String getDesktopName() {
        return this.desktopName;
    }

    public void setViewerConfig(ViewerConfig viewerConfig) {
        this.viewerConfig = viewerConfig;
    }

    public void setSettingsConfig(SettingsConfig settingsConfig) {
        this.settingsConfig = settingsConfig;
    }

    public void setViewerDefConfigs(List<ViewerDefConfig> definitions) {
        this.definitions = definitions;
    }

    public void setViewerContentTypeConfigs(List<ViewerContentTypeConfig> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public void setDefaultViewerMappingConfigs(List<ViewerMappingConfig> defaultViewerMapping) {
        this.defaultViewerMapping = defaultViewerMapping;
    }

    private JSONArray toJSONArray(String[] stringArray) {
        JSONArray jsonArray = new JSONArray();
        if (stringArray != null) {
            for (int n = 0; n < stringArray.length; ++n) {
                jsonArray.add(stringArray[n]);
            }
        }
        return jsonArray;
    }

    public JSONArray getViewerDefsJSON() {
        JSONArray jsonViewerDefs = new JSONArray();
        if (this.definitions != null) {
            for (ViewerDefConfig defConfig : this.definitions) {
                jsonViewerDefs.add(defConfig.toJSON());
            }
        }
        return jsonViewerDefs;
    }

    public JSONArray getViewerContentTypesJSON() {
        JSONArray jsonViewerContentTypes = new JSONArray();
        if (this.contentTypes != null) {
            for (ViewerContentTypeConfig contentTypeConfig : this.contentTypes) {
                jsonViewerContentTypes.add(contentTypeConfig.toJSON());
            }
        }
        return jsonViewerContentTypes;
    }

    public JSONArray getDefaultViewerMappingsJSON() {
        JSONArray jsonViewerMappings = new JSONArray();
        if (this.defaultViewerMapping != null) {
            for (ViewerMappingConfig mappingConfig : this.defaultViewerMapping) {
                jsonViewerMappings.add(mappingConfig.toJSON());
            }
        }
        return jsonViewerMappings;
    }

    public void addMenu(String menuId, List<MenuConfig> menu) {
        if (this.menus == null) {
            this.menus = new Hashtable();
        }
        this.menus.put(menuId, menu);
    }

    public void setIconConfigs(List<IconConfig> iconConfigs) {
        this.iconConfigs = iconConfigs;
    }

    public void setIconStatusConfigs(List<IconStatusConfig> iconStatusConfigs) {
        this.iconStatusConfigs = iconStatusConfigs;
    }

    public void setApplicationUILabels(List<InterfaceTextConfig> applicationLabels) {
        this.applicationLabels = applicationLabels;
    }

    public static String computeAuthenticateRepository(DesktopConfig desktopConfig) {
        String authenticatingRepo = "CONTAINER";
        String defaultRepository = desktopConfig.getDefaultRepositoryId();
        if (defaultRepository == null) {
            return authenticatingRepo;
        }
        if (defaultRepository.equalsIgnoreCase("CONTAINER")) {
            return authenticatingRepo;
        }
        RepositoryConfig defaultRepoConfig = desktopConfig.getRepository(defaultRepository);
        authenticatingRepo = defaultRepoConfig == null || defaultRepoConfig.getType().equalsIgnoreCase("p8") && defaultRepoConfig.getProtocol().equals("FileNetP8") || defaultRepoConfig.getType().equalsIgnoreCase("cm") && defaultRepoConfig.getUseSSO().equalsIgnoreCase("TRUE") ? "CONTAINER" : defaultRepository;
        return authenticatingRepo;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONArray jsonArray;
        String token;
        Hashtable connections;
        Hashtable connectionList;
        String defaultRepositoryId;
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        if (this.desktopConfig != null) {
            jsonObject.put("id", this.desktopConfig.getObjectId());
            jsonObject.put("name", this.desktopConfig.getName());
            jsonObject.put("theme", "default");
            jsonObject.put("role", this.desktopConfig.getMenuPrefix());
            jsonObject.put("helpURL", this.desktopConfig.getHelpUrl());
            jsonObject.put("messageSearchURL", this.desktopConfig.getMessageSearchUrl());
            jsonObject.put("applicationName", this.desktopConfig.getApplicationName());
            jsonObject.put("loginLogoURL", this.desktopConfig.getLoginLogoUrl());
            jsonObject.put("bannerLogoURL", this.desktopConfig.getBannerLogoUrl());
            jsonObject.put("loginInformationURL", this.desktopConfig.getLoginInformationUrl());
            jsonObject.put("passwordRulesURL", this.desktopConfig.getPasswordRulesUrl());
            jsonObject.put("bannerBackgroundColor", this.desktopConfig.getBannerBackgroundColor());
            jsonObject.put("bannerApplicationNameColor", this.desktopConfig.getBannerApplicationNameColor());
            jsonObject.put("bannerMenuColor", this.desktopConfig.getBannerMenuColor());
            jsonObject.put("authenticatingRepositoryId", DesktopMediator.computeAuthenticateRepository(this.desktopConfig));
            jsonObject.put("defaultRepositoryId", this.desktopConfig.getDefaultRepositoryId());
            jsonObject.put("additionalScript", this.desktopConfig.getAdditionalScript());
            jsonObject.put("additionalCss", this.desktopConfig.getAdditionalCss());
            jsonObject.put("layout", this.desktopConfig.getLayout());
            jsonObject.put("maxNumberDocToAdd", (Object)this.desktopConfig.getMaxNumberDocToAdd());
            String[] features = this.desktopConfig.getFeatures();
            if (features != null) {
                Map<String, PluginFeature> pluginFeatures = PluginUtil.getPluginFeatures(this.request);
                JSONArray jsonArray2 = new JSONArray();
                for (String feature : features) {
                    JSONObject json = new JSONObject();
                    PluginFeature pluginFeature = pluginFeatures.get(feature);
                    if (pluginFeature != null) {
                        json.put("isCustom", (Object)true);
                        json.put("name", pluginFeature.getId());
                        json.put("iconClass", pluginFeature.getIconUrl());
                        json.put("label", pluginFeature.getName(this.request.getLocale()));
                        json.put("buttonTooltip", pluginFeature.getFeatureIconTooltipText(this.request.getLocale()));
                        json.put("popupTooltip", pluginFeature.getPopupWindowTooltipText(this.request.getLocale()));
                        json.put("isSeparator", (Object)pluginFeature.isSeparator());
                        json.put("popupWindowClass", pluginFeature.getPopupWindowClass());
                        json.put("contentClass", pluginFeature.getContentClass());
                        json.put("pluginId", pluginFeature.getId());
                        json.put("preLoad", (Object)pluginFeature.isPreLoad());
                    } else {
                        json.put("label", feature);
                        json.put("value", feature);
                    }
                    jsonArray2.add(json);
                }
                jsonObject.put("features", jsonArray2);
            }
            jsonObject.put("defaultFeature", this.desktopConfig.getDefaultFeature());
            jsonObject.put("actionHandler", this.desktopConfig.getActionHandler());
            jsonObject.put("disableAutocomplete", (Object)this.desktopConfig.getDisableAutocomplete());
            jsonObject.put("culturalCollation", (Object)this.desktopConfig.getCulturalCollation());
            jsonObject.put("enableThumbnails", (Object)this.desktopConfig.getShowThumbnails());
            jsonObject.put("showGlobalToolbar", (Object)this.desktopConfig.getShowGlobalToolbar());
            jsonObject.put("showSecurity", this.desktopConfig.getShowSecurity());
            jsonObject.put("fileIntoFolder", this.desktopConfig.getFileIntoFolder());
            JSONObject defaultLayoutRepositories = new JSONObject();
            defaultLayoutRepositories.put("work", this.desktopConfig.getWorkDefaultRepository());
            defaultLayoutRepositories.put("teamspaces", this.desktopConfig.getTeamspacesDefaultRepository());
            defaultLayoutRepositories.put("others", this.desktopConfig.getOtherFeaturesDefaultRepository());
            jsonObject.put("defaultLayoutRepositories", defaultLayoutRepositories);
            JSONObject officePrefs = new JSONObject();
            officePrefs.put("addWithEntryTemplateOnly", (Object)this.desktopConfig.getAddWithEntryTemplateOnly());
            officePrefs.put("checkoutOnOpenDoc", (Object)this.desktopConfig.getCheckoutOnOpenDoc());
            officePrefs.put("promptCloseAppOnCheckout", (Object)this.desktopConfig.getPromptCloseOfficeIfDocCheckout());
            officePrefs.put("deleteFileOnAdd", (Object)this.desktopConfig.getDeleteLocalOnAdd());
            officePrefs.put("deleteFileOnSave", (Object)this.desktopConfig.getDeleteLocalOnSave());
            officePrefs.put("outlookPromptForProperties", (Object)this.desktopConfig.getPromptForPropsOnAdd());
            officePrefs.put("outlookDeleteEmailOnAdd", (Object)this.desktopConfig.getDeleteEmailOnAdd());
            officePrefs.put("outlookSendEmailAsLinkOnly", (Object)this.desktopConfig.getSendEmailAsLinkOnly());
            officePrefs.put("enablePropMappingForAdd", (Object)this.desktopConfig.getEnablePropMappingForAdd());
            jsonObject.put("generalOfficePreferences", officePrefs);
        }
        if (this.settingsConfig != null) {
            Collection userActionMacros;
            Collection fileTypes = this.settingsConfig.getList("fileTypes", this.settingsConfig.getIdPrefix(), this.request);
            if (fileTypes != null) {
                JSONArray jsonFileTypesArray = new JSONArray();
                for (FileTypeConfig ftConf : fileTypes) {
                    jsonFileTypesArray.add(ftConf.toJSON());
                }
                jsonObject.put("fileTypes", jsonFileTypesArray);
            }
            if ((userActionMacros = this.settingsConfig.getList("userActionMacros", this.settingsConfig.getIdPrefix(), this.request)) != null) {
                JSONArray jsonUserActionMacrosArray = new JSONArray();
                for (UserActionMacroConfig uaConf : userActionMacros) {
                    jsonUserActionMacrosArray.add(uaConf.toJSON());
                }
                jsonObject.put("userActionMacros", jsonUserActionMacrosArray);
            }
        }
        String string = defaultRepositoryId = this.desktopConfig == null ? null : this.desktopConfig.getDefaultRepositoryId();
        if (this.repositoryConfigs != null) {
            JSONArray jsonServers = new JSONArray();
            for (RepositoryConfig server : this.repositoryConfigs) {
                Collection propertiesMappingList;
                JSONObject jsonServer = new JSONObject();
                jsonServer.put("type", server.getType());
                if (server.getType().equals("od")) {
                    jsonServer.put("hostName", server.getObjectId());
                } else {
                    jsonServer.put("hostName", server.getServerName());
                }
                jsonServer.put("displayName", server.getName());
                jsonServer.put("repositoryId", server.getObjectId());
                jsonServer.put("serviceURL", this.request.getContextPath() + "/" + server.getType());
                jsonServer.put("pageSize", (Object)server.getPageSize());
                jsonServer.put("useSSO", server.getUseSSO());
                jsonServer.put("teamspacesEnabled", (Object)server.isTeamspacesEnabled());
                jsonServer.put("addAsMajorVersion", server.getAddAsMajorVersion());
                jsonServer.put("checkinAsMajorVersion", server.getCheckinAsMajorVersion());
                jsonServer.put("connectionPoint", server.getConnectionPoint());
                if (server.getType().equals("p8")) {
                    jsonServer.put("objectStore", server.getObjectStore());
                    jsonServer.put("objectStoreDisplayName", server.getObjectStoreDisplayName());
                }
                if (server.getType().equals("cm")) {
                    jsonServer.put("folderingEnabled", (Object)(server.getFolderingEnabled() == null ? false : server.getFolderingEnabled().equalsIgnoreCase("true")));
                } else if (!server.getType().equals("od") && !server.getType().equals("ci")) {
                    jsonServer.put("folderingEnabled", (Object)true);
                }
                if ((server.getType().equals("cm") || server.getType().equals("p8")) && (propertiesMappingList = server.getPropertiesMappingList()) != null && propertiesMappingList.size() > 0) {
                    JSONArray jsonMappingsArray = new JSONArray();
                    for (PropertyMappingConfig mapping : propertiesMappingList) {
                        JSONObject property = new JSONObject();
                        property.put("symbolicName", mapping.getRepositoryProperty());
                        property.put("propertyType", mapping.getDataType());
                        property.put("officeProperties", this.toJSONArray(mapping.getOfficeProperties()));
                        jsonMappingsArray.add(property);
                    }
                    jsonServer.put("propertiesMapping", jsonMappingsArray);
                }
                boolean connected = false;
                if (this.session != null) {
                    Object connection;
                    Hashtable connectionList2;
                    if (server.getType().equals("cm")) {
                        connectionList2 = (Hashtable)this.session.getAttribute("cm_servers");
                        if (connectionList2 != null) {
                            connected = connectionList2.containsKey(server.getObjectId());
                            connection = (CMConnection)connectionList2.get(server.getObjectId());
                            if (connection != null) {
                                jsonServer.put("userID", ((CMConnection)connection).getUserid());
                                jsonServer.put("admin_user", (Object)this.isAdminUser(((CMConnection)connection).getUserid()));
                                if (defaultRepositoryId != null && defaultRepositoryId.equals(server.getObjectId()) && this.isAdminUser(((CMConnection)connection).getUserid())) {
                                    jsonServer.put("adminLayout", this.getAdminLayoutJSONObject());
                                }
                            }
                        }
                        Hashtable aclConnectionList = (Hashtable)this.session.getAttribute("cm_servers_permissions");
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "aclConnectionList = " + aclConnectionList);
                        if (aclConnectionList != null) {
                            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "server.getRepositoryId() = " + server.getObjectId());
                            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "aclConnectionList.containsKey(server.getRepositoryId()) = " + aclConnectionList.containsKey(server.getObjectId()));
                            if (aclConnectionList.containsKey(server.getObjectId())) {
                                Hashtable privTable = (Hashtable)aclConnectionList.get(server.getObjectId());
                                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "privTable = " + privTable);
                                if (privTable != null) {
                                    String privAddDoc = (String)privTable.get(PRIV_ADD_CONTENT);
                                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "privAddDoc = " + privAddDoc);
                                    String privAddItem = (String)privTable.get(PRIV_ADD_ITEM);
                                    String userId = (String)privTable.get("userId");
                                    if (privAddDoc != null) {
                                        jsonServer.put(PRIV_ADD_CONTENT, (Object)privAddDoc.equalsIgnoreCase("true"));
                                    }
                                    if (privAddItem != null) {
                                        jsonServer.put(PRIV_ADD_ITEM, (Object)privAddItem.equalsIgnoreCase("true"));
                                    }
                                    if (userId != null) {
                                        jsonServer.put("userID", userId);
                                    }
                                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "PRIV_ADD_TEAMSPACE = " + privTable.get("privAddTeamspace"));
                                    jsonServer.put("priv_addTeamspace", (Object)((String)privTable.get("privAddTeamspace")).equalsIgnoreCase("true"));
                                    jsonServer.put("priv_addTeamspaceTemplate", (Object)((String)privTable.get("privAddTeamspaceTemplate")).equalsIgnoreCase("true"));
                                    jsonServer.put("folderingEnabled", (Object)((String)privTable.get("privFoldering")).equalsIgnoreCase("true"));
                                }
                            }
                        }
                    } else if (server.getType().equals("od")) {
                        connectionList2 = (Hashtable)this.session.getAttribute("od_servers");
                        if (connectionList2 != null && (connection = (ODServer)connectionList2.get(server.getObjectId())) != null) {
                            connected = true;
                            jsonServer.put("userID", connection.getUserId());
                            if (connection instanceof ODServerConnection && !((ODServerConnection)((Object)connection)).isConnected()) {
                                jsonServer.put("privCreateHold", new Boolean(true));
                            } else {
                                jsonServer.put("privCreateHold", new Boolean(ODUtil.hasHoldPriv(this.request, (ODServer)connection)).toString());
                            }
                            jsonServer.put(PRIV_ADD_ITEM, (Object)true);
                            jsonServer.put(PRIV_ADD_CONTENT, (Object)true);
                            jsonServer.put("searchTemplateSupported", (Object)true);
                            jsonServer.put("admin_user", (Object)this.isAdminUser(connection.getUserId()));
                            if (defaultRepositoryId != null && defaultRepositoryId.equals(server.getObjectId()) && this.isAdminUser(connection.getUserId())) {
                                jsonServer.put("adminLayout", this.getAdminLayoutJSONObject());
                            }
                        }
                    } else if (server.getType().equals("p8") && (connectionList2 = (Hashtable)this.session.getAttribute("p8_servers")) != null && (connection = (P8Connection)connectionList2.get(server.getObjectId())) != null) {
                        connected = true;
                        jsonServer.put("userID", ((P8Connection)connection).getUserId());
                        jsonServer.put(PRIV_ADD_CONTENT, ((P8Connection)connection).getPrivAddDoc() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddDoc().equalsIgnoreCase("true")));
                        jsonServer.put(PRIV_ADD_ITEM, ((P8Connection)connection).getPrivAddItem() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddItem().equalsIgnoreCase("true")));
                        jsonServer.put("textSearchType", P8TextSearchUtil.getTextSearchType((P8Connection)connection, this.request));
                        jsonServer.put("priv_addTeamspace", ((P8Connection)connection).getPrivAddItemTeamspace() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddItemTeamspace().equalsIgnoreCase("true")));
                        jsonServer.put("priv_addTeamspaceTemplate", ((P8Connection)connection).getPrivAddItemTeamspaceTemplate() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddItemTeamspaceTemplate().equalsIgnoreCase("true")));
                        jsonServer.put("priv_addSearch", ((P8Connection)connection).getPrivAddSearch() == null ? null : Boolean.valueOf(((P8Connection)connection).getPrivAddSearch().equalsIgnoreCase("true")));
                        jsonServer.put("admin_user", (Object)this.isAdminUser(((P8Connection)connection).getUserId()));
                        if (defaultRepositoryId != null && defaultRepositoryId.equals(server.getObjectId()) && this.isAdminUser(((P8Connection)connection).getUserId())) {
                            jsonServer.put("adminLayout", this.getAdminLayoutJSONObject());
                        }
                    }
                }
                jsonServer.put("connected", (Object)connected);
                jsonServers.add(jsonServer);
            }
            jsonObject.put("servers", jsonServers);
        }
        if (this.session != null && (connectionList = (Hashtable)this.session.getAttribute(ContainerLogonAction.CONTAINERS)) != null && (connections = (Hashtable)connectionList.get(this.desktopName)) != null) {
            Enumeration userIds = connections.keys();
            while (userIds.hasMoreElements()) {
                String userId = (String)userIds.nextElement();
                ContainerConnection connection = (ContainerConnection)connections.get(userId);
                if (connection == null) continue;
                JSONObject jsonContaner = new JSONObject();
                jsonContaner.put("connected", (Object)true);
                jsonContaner.put("userID", connection.getUserId());
                jsonContaner.put("desktop", this.desktopName);
                if (this.desktopName != null && this.desktopName.equals("admin") && this.isAdminUser(connection.getUserId())) {
                    jsonContaner.put("adminLayout", this.getAdminLayoutJSONObject());
                }
                jsonObject.put("containers", jsonContaner);
            }
        }
        if (this.plugins != null) {
            JSONArray jsonPluginArray = new JSONArray();
            for (int i = 0; i < this.plugins.length; ++i) {
                Plugin plugin = this.plugins[i];
                JSONObject jsonPlugin = new JSONObject();
                jsonPlugin.put("id", plugin.getId());
                if (plugin.getScript() != null) {
                    jsonPlugin.put("script", plugin.getScript());
                }
                if (plugin.getDojoModule() != null) {
                    jsonPlugin.put("dojoModule", plugin.getDojoModule());
                }
                if (plugin.getCSSFileName() != null) {
                    jsonPlugin.put("cssFileName", plugin.getCSSFileName());
                }
                jsonPluginArray.add(jsonPlugin);
            }
            jsonObject.put("plugins", jsonPluginArray);
        }
        if (DesktopMediator.isSecureServiceEnabled(this.request) && (token = new SecurityTokenManager().generateToken(this.request, false)) != null) {
            jsonObject.put("security_token", token);
        }
        if (this.isTamTokenPresent()) {
            jsonObject.put("tam_token", (Object)this.isTamTokenPresent());
        }
        try {
            ViewerConfig viewerConfig = this.viewerConfig;
            if (viewerConfig != null) {
                JSONArray viewerDefsJSON = this.getViewerDefsJSON();
                Plugin[] plugins = PluginUtil.getPlugins(this.request);
                for (int i = 0; i < plugins.length; ++i) {
                    Plugin plugin = plugins[i];
                    PluginViewerDef[] pluginViewers = plugin.getViewers();
                    for (int j = 0; j < pluginViewers.length; ++j) {
                        PluginViewerDef pluginViewer = pluginViewers[j];
                        JSONObject viewerDefJSON = new JSONObject();
                        viewerDefJSON.put("id", pluginViewer.getId());
                        viewerDefJSON.put("viewerName", pluginViewer.getId());
                        viewerDefJSON.put("label", "en");
                        viewerDefJSON.put("launchUrl", pluginViewer.getLaunchUrlPattern());
                        viewerDefJSON.put("launchInSeparateWindow", (Object)pluginViewer.isLaunchInSeparateWindow());
                        viewerDefJSON.put("serverTypes", this.toJSONArray(pluginViewer.getSupportedServerTypes()));
                        viewerDefsJSON.add(viewerDefJSON);
                    }
                }
                jsonObject.put("viewerDefs", viewerDefsJSON);
                jsonObject.put("viewerMappings", viewerConfig.getViewerMappingsJSON());
                jsonObject.put("viewerContentTypes", this.getViewerContentTypesJSON());
                jsonObject.put("defaultViewerMappings", this.getDefaultViewerMappingsJSON());
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        if (this.menus != null) {
            JSONObject menusJSON = new JSONObject();
            for (String menuId : this.menus.keySet()) {
                List<MenuConfig> menu = this.menus.get(menuId);
                JSONArray menuJSON = new JSONArray();
                for (MenuConfig menuItem : menu) {
                    menuJSON.add(menuItem.getJson());
                }
                menusJSON.put(menuId, menuJSON);
            }
            jsonObject.put("menus", menusJSON);
        }
        if (this.iconConfigs != null) {
            jsonArray = new JSONArray();
            for (IconConfig iconConfig : this.iconConfigs) {
                jsonArray.add(iconConfig.toJSON());
            }
            jsonObject.put("iconMappings", jsonArray);
        }
        if (this.iconStatusConfigs != null) {
            jsonArray = new JSONArray();
            for (IconStatusConfig iconStatusConfig : this.iconStatusConfigs) {
                jsonArray.add(iconStatusConfig.toJSON());
            }
            jsonObject.put("iconStatus", jsonArray);
        }
        jsonArray = new JSONArray();
        if (this.applicationLabels != null) {
            for (InterfaceTextConfig uiLabelConfig : this.applicationLabels) {
                jsonArray.add(uiLabelConfig.toJSON());
            }
        }
        jsonObject.put("uiLabels", jsonArray);
        SystemInfo si = SystemInfo.getSystemInfo();
        jsonObject.put("appServerOSName", si.getOsName());
        jsonObject.put("appServerOSArch", si.getOsArch());
        jsonObject.put("appServerOSVersion", si.getOsVersion());
        String distroName = si.getDistroName();
        if (distroName != null) {
            jsonObject.put("appServerOSDistroName", distroName);
            jsonObject.put("appServerOSDistroRelease", si.getDistroRelease());
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }
}

