/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.util.MessageResources;

public class BaseMediator
implements Serializable {
    private static final String CATEGORY_MESSAGES = "messages";
    private static final String CATEGORY_WARNINGS = "warnings";
    private static final String CATEGORY_ERRORS = "errors";
    protected HttpServletRequest request;
    public MessageResources messageResources;
    protected Locale locale;
    private ArrayList<String> messages;
    private ArrayList<Message> warnings;
    private ArrayList<Message> errors;
    private boolean responseAsHtml = false;
    public static final String ENABLE_SECURE_SERVICE = "enableSecureService";
    protected static final String SECURE_JSON_PREFIX = "{}&&";
    private static final long serialVersionUID = -1644321520389006199L;

    public BaseMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        this.request = request;
        this.messageResources = resources;
        this.locale = locale;
    }

    protected BaseMediator(HttpServletRequest request, BaseMediator baseMediator) {
        this.request = request;
        this.messageResources = baseMediator.getMessageResources();
        this.locale = baseMediator.getLocale();
        this.setErrors(baseMediator.getErrors());
        this.setMessages(baseMediator.getMessages());
        this.setWarnings(baseMediator.getWarnings());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponseAsHtml(boolean responseAsHtml) {
        this.responseAsHtml = responseAsHtml;
    }

    public MessageResources getMessageResources() {
        return this.messageResources;
    }

    protected void setErrors(ArrayList errors) {
        this.errors = errors;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setMessages(ArrayList messages) {
        this.messages = messages;
    }

    protected void setWarnings(ArrayList warnings) {
        this.warnings = warnings;
    }

    public ArrayList getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        return this.errors;
    }

    public ArrayList getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        return this.messages;
    }

    public ArrayList getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        return this.warnings;
    }

    public void addMessage(String messageKey, Object ... inserts) {
        this.getMessages().add(this.createMessageObject(messageKey, inserts));
    }

    public void addWarning(String messageKey, Object ... inserts) {
        this.getWarnings().add(this.createMessageObject(messageKey, inserts));
    }

    private Message createMessageObject(String messageKey, Object ... inserts) {
        Message message = new Message();
        message.text = this.messageResources.getMessage(this.locale, messageKey, inserts);
        String id = this.messageResources.getMessage(this.locale, messageKey + ".id");
        if (id != null) {
            message.number = Integer.parseInt(id);
        }
        message.explanation = this.messageResources.getMessage(this.locale, messageKey + ".explanation", inserts);
        message.userResponse = this.messageResources.getMessage(this.locale, messageKey + ".userResponse", inserts);
        message.adminResponse = this.messageResources.getMessage(this.locale, messageKey + ".adminResponse", inserts);
        message.moreInformation = this.messageResources.getMessage(this.locale, messageKey + ".moreInformation", inserts);
        return message;
    }

    public void addError(String messageKey) {
        this.addError(messageKey, new Object[0]);
    }

    public void addError(String messageKey, Object ... inserts) {
        Message message = new Message();
        message.text = this.messageResources.getMessage(this.locale, messageKey, inserts);
        String id = this.messageResources.getMessage(this.locale, messageKey + ".id");
        if (id != null) {
            message.number = Integer.parseInt(id.trim());
        }
        message.explanation = this.messageResources.getMessage(this.locale, messageKey + ".explanation", inserts);
        message.userResponse = this.messageResources.getMessage(this.locale, messageKey + ".userResponse", inserts);
        message.adminResponse = this.messageResources.getMessage(this.locale, messageKey + ".adminResponse", inserts);
        this.getErrors().add(message);
    }

    public void sendErrorResponse(HttpServletResponse response) throws IOException {
        if (this.errors != null) {
            StringBuffer errorMessage = new StringBuffer();
            for (Message message : this.errors) {
                if (message instanceof Message) {
                    errorMessage.append("CIWEB").append(message.number).append(": ").append(message.text).append("\n");
                    continue;
                }
                errorMessage.append(message).append("\n");
            }
            response.sendError(400, errorMessage.toString());
        } else {
            response.sendError(400);
        }
    }

    public final String toJSONString() {
        JSONObject jsonObject = this.toJSONObject();
        String jsonString = jsonObject.toString();
        return jsonString;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        if (this.messages != null && this.messages.size() > 0) {
            JSONArray jsonMessages = new JSONArray();
            for (Object object : this.messages) {
                if (object instanceof Message) {
                    jsonMessages.add(((Message)object).toJSONObject());
                    continue;
                }
                jsonMessages.add(object);
            }
            jsonObject.put(CATEGORY_MESSAGES, jsonMessages);
        }
        if (this.warnings != null && this.warnings.size() > 0) {
            JSONArray jsonWarnings = new JSONArray();
            for (Object object : this.warnings) {
                if (object instanceof Message) {
                    jsonWarnings.add(((Message)object).toJSONObject());
                    continue;
                }
                jsonWarnings.add(object);
            }
            jsonObject.put(CATEGORY_WARNINGS, jsonWarnings);
        }
        if (this.errors != null && this.errors.size() > 0) {
            JSONArray jsonErrors = new JSONArray();
            for (Object object : this.errors) {
                if (object instanceof Message) {
                    jsonErrors.add(((Message)object).toJSONObject());
                    continue;
                }
                jsonErrors.add(object);
            }
            jsonObject.put(CATEGORY_ERRORS, jsonErrors);
        }
        return jsonObject;
    }

    public void writeJSON(Writer writer, HttpServletResponse response) throws IOException {
        this.writeJSON(null, writer, response);
    }

    private void writeJSON(String jsonString, Writer writer, HttpServletResponse response) throws IOException {
        if (jsonString == null) {
            jsonString = this.toJSONString();
        }
        if (this.responseAsHtml) {
            jsonString = "<html><body><textarea>" + jsonString + "</textarea></body></html>";
            response.setContentType("text/html");
        }
        writer.write(jsonString);
    }

    public final void writeJSONResponse(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "writeJSONMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        try {
            response.addHeader("Cache-Control", "no-cache");
            if (this.errors == null && PluginUtil.responseFilterExists(request)) {
                JSONObject jsonResponse = this.toJSONObject();
                PluginUtil.invokeResponseFilters(request, jsonResponse);
                response.setContentType("text/plain");
                response.setCharacterEncoding("UTF-8");
                PrintWriter writer = response.getWriter();
                if (BaseMediator.isSecureServiceEnabled(request)) {
                    ((Writer)writer).write(SECURE_JSON_PREFIX);
                }
                this.writeJSON(jsonResponse.toString(), writer, response);
            } else {
                String acceptedEncodings = request.getHeader("Accept-Encoding");
                if (acceptedEncodings != null && acceptedEncodings.indexOf("gzip") >= 0) {
                    response.setBufferSize(65536);
                    response.setHeader("Content-Encoding", "gzip");
                    response.setContentType("text/plain");
                    GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gzos, "UTF-8");
                    if (BaseMediator.isSecureServiceEnabled(request)) {
                        writer.write(SECURE_JSON_PREFIX);
                    }
                    this.writeJSON(writer, response);
                    ((Writer)writer).close();
                } else {
                    response.setContentType("text/plain");
                    response.setCharacterEncoding("UTF-8");
                    PrintWriter writer = response.getWriter();
                    if (BaseMediator.isSecureServiceEnabled(request)) {
                        ((Writer)writer).write(SECURE_JSON_PREFIX);
                    }
                    this.writeJSON(writer, response);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (Throwable e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, e);
            BaseMediator mediator = new BaseMediator(request, this.getMessageResources(), request.getLocale());
            mediator.addError("error.exception.general", e.getLocalizedMessage());
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            try {
                PrintWriter writer = response.getWriter();
                if (BaseMediator.isSecureServiceEnabled(request)) {
                    ((Writer)writer).write(SECURE_JSON_PREFIX);
                }
                mediator.writeJSON(writer, response);
            }
            catch (Exception e2) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e2);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected static ArrayList toMessageListFromJSON(JSONArray jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : jsonArray) {
            Object value = null;
            value = item instanceof JSONObject ? Message.fromJSONObject((JSONObject)item) : (String)item;
            list.add(value);
        }
        return list;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        if (jsonObject.containsKey(CATEGORY_MESSAGES)) {
            JSONArray messagesJsonObject = (JSONArray)jsonObject.get(CATEGORY_MESSAGES);
            this.setMessages(BaseMediator.toMessageListFromJSON(messagesJsonObject));
        }
        if (jsonObject.containsKey(CATEGORY_WARNINGS)) {
            JSONArray warningsJsonObject = (JSONArray)jsonObject.get(CATEGORY_WARNINGS);
            this.setWarnings(BaseMediator.toMessageListFromJSON(warningsJsonObject));
        }
        if (jsonObject.containsKey(CATEGORY_ERRORS)) {
            JSONArray errorsJsonObject = (JSONArray)jsonObject.get(CATEGORY_ERRORS);
            this.setErrors(BaseMediator.toMessageListFromJSON(errorsJsonObject));
        }
    }

    protected static void addStringArrayToJSON(JSONObject jsonObject, String label, String[] stringArray) {
        if (jsonObject != null && stringArray != null) {
            JSONArray jsonStringArray = new JSONArray();
            for (int iArrayItemCounter = 0; iArrayItemCounter < stringArray.length; ++iArrayItemCounter) {
                jsonStringArray.add(iArrayItemCounter, stringArray[iArrayItemCounter]);
            }
            jsonObject.put(label, jsonStringArray);
        }
    }

    public static boolean isSecureServiceEnabled(HttpServletRequest request) {
        String path = request.getRequestURI();
        return request != null && request.getAttribute(ENABLE_SECURE_SERVICE) == Boolean.TRUE && !path.endsWith("/Ping");
    }

    protected static final class Message {
        public int number;
        public String text;
        public String explanation;
        public String userResponse;
        public String adminResponse;
        public String moreInformation;

        protected Message() {
        }

        public JSONObject toJSONObject() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("number", String.valueOf(this.number));
            jsonObject.put("text", this.text);
            jsonObject.put("explanation", this.explanation);
            jsonObject.put("userResponse", this.userResponse);
            jsonObject.put("adminResponse", this.adminResponse);
            jsonObject.put("moreInformation", this.moreInformation);
            return jsonObject;
        }

        public static Message fromJSONObject(JSONObject jsonObject) {
            Message message = new Message();
            message.number = Integer.parseInt((String)jsonObject.get("number"));
            message.text = (String)jsonObject.get("text");
            message.explanation = (String)jsonObject.get("explanation");
            message.userResponse = (String)jsonObject.get("userResponse");
            message.adminResponse = (String)jsonObject.get("adminResponse");
            message.moreInformation = (String)jsonObject.get("moreInformation");
            return message;
        }
    }
}

