/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json.changesummary;

import com.ibm.ecm.json.changesummary.Value;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;

public class ChangedItem {
    private String id;
    private String name;
    private String operation;
    private String parentId;
    private String server;
    private ChangedItem[] subItems;
    private String type;
    private Value[] values;

    public void fromJSONString(String jsonString) throws IOException {
        JSONObject jsonObject = JSONObject.parse(jsonString);
        this.id = jsonObject.get("id").toString();
        this.name = jsonObject.get("name").toString();
        this.operation = jsonObject.get("operation").toString();
        this.parentId = jsonObject.get("parentId").toString();
        this.server = jsonObject.get("server").toString();
        this.type = jsonObject.get("type").toString();
        JSONArray subItemArray = (JSONArray)jsonObject.get("subItems");
        this.subItems = new ChangedItem[subItemArray.size()];
        for (int i = 0; i < subItemArray.size(); ++i) {
            JSONObject object = (JSONObject)subItemArray.get(i);
            ChangedItem item = new ChangedItem();
            item.fromJSONString(object.toString());
            this.subItems[i] = item;
        }
        JSONArray valuesArray = (JSONArray)jsonObject.get("values");
        this.values = new Value[valuesArray.size()];
        for (int i = 0; i < valuesArray.size(); ++i) {
            JSONObject object = (JSONObject)valuesArray.get(i);
            Value value = new Value();
            value.fromJSONString(object.toString());
            this.values[i] = value;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getItemType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAdded() {
        return this.getOperation().equals("ADD");
    }

    public boolean isRemoved() {
        return this.getOperation().equals("REMOVE");
    }

    public boolean isUpdated() {
        return this.getOperation().equals("UPDATE");
    }

    public String getOperation() {
        return this.operation;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getServer() {
        return this.server;
    }

    public ChangedItem[] getSubItems() {
        return this.subItems;
    }

    public String getType() {
        return this.type;
    }

    public Value[] getValues() {
        return this.values;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer("ChangedItem: {");
        buffer.append("id=\"");
        buffer.append(this.getId());
        buffer.append("\", ");
        buffer.append("name=\"");
        buffer.append(this.getName());
        buffer.append("\", ");
        buffer.append("operation=\"");
        buffer.append(this.getOperation());
        buffer.append("\", ");
        buffer.append("parentId=\"");
        buffer.append(this.getParentId());
        buffer.append("\", ");
        buffer.append("server=\"");
        buffer.append(this.getServer());
        buffer.append("\", ");
        buffer.append("type=\"");
        buffer.append(this.getType());
        buffer.append("\", ");
        for (i = 0; i < this.subItems.length; ++i) {
            buffer.append(this.subItems[i].toString());
        }
        for (i = 0; i < this.values.length; ++i) {
            buffer.append("\n  ");
            buffer.append(this.values[i].toString());
        }
        buffer.append("\n}\n");
        return buffer.toString();
    }
}

