/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json.changesummary;

import com.ibm.ecm.json.changesummary.ChangedItem;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;

public class ChangeSummary {
    private ChangedItem[] changedItems;

    public ChangeSummary() {
    }

    public ChangeSummary(String jsonString) throws IOException {
        this.fromJSONString(jsonString);
    }

    public void fromJSONString(String jsonString) throws IOException {
        JSONObject jsonObject = JSONObject.parse(jsonString);
        JSONArray array = (JSONArray)jsonObject.get("changedItems");
        this.changedItems = new ChangedItem[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = (JSONObject)array.get(i);
            ChangedItem item = new ChangedItem();
            item.fromJSONString(object.toString());
            this.changedItems[i] = item;
        }
    }

    public ChangedItem[] getAddedItems() {
        return this.getItemsByOperation("ADD");
    }

    public ChangedItem[] getChangedItems() {
        return this.changedItems;
    }

    private ChangedItem[] getItemsByOperation(String operation) {
        ArrayList<ChangedItem> itemList = new ArrayList<ChangedItem>();
        for (int i = 0; i < this.changedItems.length; ++i) {
            ChangedItem item = this.changedItems[i];
            if (!item.getOperation().equals(operation)) continue;
            itemList.add(item);
        }
        return itemList.toArray(new ChangedItem[itemList.size()]);
    }

    public ChangedItem[] getRemovedItems() {
        return this.getItemsByOperation("REMOVE");
    }

    public ChangedItem[] getUpdatedItems() {
        return this.getItemsByOperation("UPDATE");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < this.changedItems.length; ++i) {
            buffer.append(this.changedItems[i].toString());
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        String jsonString = "{\"className\":\"ChangeHistory\",\"changedItems\":[{\"className\":\"ChangedItem\",\"name\":\"\",\"id\":\"\",\"server\":\"ICMNLSDB\",\"type\":\"\",\"parentId\":\"jwt_base_model;HasChildComp;92 3 ICM8 ICMNLSDB12 HasChildComp59 26 A1001001A06E24B40036H2300418 A06E24B40036H230041 14 1013;Books\",\"operation\":\"ADD\",\"subItems\":[],\"values\":[{\"className\":\"Value\",\"id\":\"editForm_Author_1150923352464\",\"name\":\"Author\",\"value\":\"Author\"},{\"className\":\"Value\",\"id\":\"editForm_TItle_1150923352464\",\"name\":\"TItle\",\"value\":\"TItle\"},{\"className\":\"Value\",\"id\":\"editForm_Subject_1150923352464\",\"name\":\"Subject\",\"value\":\"Subject\"}]}]}";
        ChangeSummary summary = new ChangeSummary();
        try {
            summary.fromJSONString(jsonString);
            System.out.println(summary.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

