/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class TableView {
    private List columnSets = new ArrayList();

    public ColumnSet createColumnSet() {
        ColumnSet set = new ColumnSet();
        this.columnSets.add(set);
        return set;
    }

    public JSONObject toJson() throws IOException {
        JSONObject jsonObject = new JSONObject();
        JSONArray columnsArray = new JSONArray();
        for (ColumnSet columnSet : this.columnSets) {
            List columnPropList = columnSet.getColumnPropList();
            JSONArray columnPropArray = new JSONArray();
            for (ColumnProperties props : columnPropList) {
                columnPropArray.add(props.toJson());
            }
            columnsArray.add(columnPropArray);
        }
        jsonObject.put("cells", columnsArray);
        return jsonObject;
    }

    public String toString(HttpServletRequest request) {
        String methodName = "toString";
        String returnString = null;
        try {
            JSONObject jsonRepresentation = this.toJson();
            returnString = JSONUtils.prettyPrintJson(jsonRepresentation);
        }
        catch (IOException e) {
            returnString = "JSONException encountered during toString() operation. " + e.getMessage();
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        return returnString;
    }

    public class ColumnSet {
        private List columnPropList = new ArrayList();

        ColumnSet() {
        }

        public ColumnProperties addColumnProperty(Map propertyMap) {
            return this.addColumnProperty(propertyMap, false);
        }

        public ColumnProperties addColumnProperty(Map propertyMap, boolean allowDuplicates) {
            ColumnProperties props = new ColumnProperties(propertyMap);
            boolean columnFound = false;
            if (!allowDuplicates) {
                String newPropName = props.getProperty("name");
                for (ColumnProperties oldProp : this.columnPropList) {
                    String oldPropName = oldProp.getProperty("name");
                    if (oldPropName == null || !oldPropName.equals(newPropName)) continue;
                    columnFound = true;
                }
            }
            if (!columnFound) {
                this.columnPropList.add(props);
            }
            return props;
        }

        public ColumnProperties addColumnProperty(String[][] properties) {
            return this.addColumnProperty(JSONUtils.arrayToMap(properties));
        }

        List getColumnPropList() {
            return this.columnPropList;
        }
    }

    public class ColumnProperties {
        private Map properties = new HashMap();

        ColumnProperties(Map properties) {
            this.properties = properties;
        }

        public String getProperty(String key) {
            return (String)this.properties.get(key);
        }

        public JSONObject toJson() throws IOException {
            JSONObject jsonObject = new JSONObject();
            for (String key : this.properties.keySet()) {
                Object value = this.properties.get(key);
                if (value instanceof ArrayList) {
                    ArrayList values = (ArrayList)value;
                    JSONArray array = new JSONArray();
                    for (int i = 0; i < values.size(); ++i) {
                        array.add((String)values.get(i));
                    }
                    jsonObject.put(key, array);
                    continue;
                }
                jsonObject.put(key, value);
            }
            return jsonObject;
        }

        public String toString(HttpServletRequest request) {
            String methodName = "toString";
            String returnString = null;
            try {
                JSONObject jsonRepresentation = this.toJson();
                returnString = JSONUtils.prettyPrintJson(jsonRepresentation);
            }
            catch (IOException e) {
                returnString = "JSONException encountered during toString() operation. " + e.getMessage();
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
            return returnString;
        }
    }
}

