/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JSONUtils {
    private static final String FIXED_INDENT = "  ";

    public static Map arrayToMap(String[][] properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].length < 2) continue;
                if (propertyMap == null) {
                    propertyMap = new HashMap();
                }
                String key = properties[i][0];
                String value = properties[i][1];
                propertyMap.put(key, value);
            }
        }
        return propertyMap;
    }

    private static String getIndent(int depth) {
        String indent = "";
        if (depth > 0) {
            StringBuffer calculatedIndent = new StringBuffer();
            for (int i = 0; i < depth; ++i) {
                calculatedIndent.append(FIXED_INDENT);
            }
            indent = calculatedIndent.toString();
        }
        return indent;
    }

    public static String prettyPrintJson(JSONObject jsonObject) throws IOException {
        return JSONUtils.prettyPrintJsonObject(jsonObject, 0);
    }

    private static String prettyPrintJsonArray(JSONArray jsonArray, int depth) throws IOException {
        StringBuffer buffer = new StringBuffer();
        String indent = JSONUtils.getIndent(depth);
        if (jsonArray.size() == 0) {
            buffer.append("[]");
        } else {
            buffer.append("[").append("\n");
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object object = jsonArray.get(i);
                if (object instanceof JSONObject) {
                    buffer.append(indent).append(JSONUtils.prettyPrintJsonObject((JSONObject)object, depth + 1));
                } else if (object instanceof JSONArray) {
                    buffer.append(indent).append(JSONUtils.prettyPrintJsonArray((JSONArray)object, depth + 1));
                }
                buffer.append(",\n");
            }
            JSONUtils.removeTrailingCommaAndNewline(buffer);
            buffer.append("\n").append(indent).append("]");
        }
        return buffer.toString();
    }

    private static String prettyPrintJsonObject(JSONObject jsonObject, int depth) throws IOException {
        StringBuffer buffer = new StringBuffer();
        String indent = JSONUtils.getIndent(depth);
        if (depth == 0) {
            buffer.append("{").append("\n");
        } else {
            buffer.append(FIXED_INDENT).append("{").append("\n");
        }
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value == null) continue;
            buffer.append(indent).append(FIXED_INDENT).append("'").append(key).append("':");
            if (value instanceof String) {
                buffer.append("'").append(value).append("'");
            } else if (value instanceof JSONObject) {
                buffer.append(JSONUtils.prettyPrintJsonObject((JSONObject)value, depth + 1));
            } else if (value instanceof JSONArray) {
                buffer.append(JSONUtils.prettyPrintJsonArray((JSONArray)value, depth + 1));
            }
            buffer.append(",\n");
        }
        JSONUtils.removeTrailingCommaAndNewline(buffer);
        buffer.append("\n").append(indent).append("}");
        return buffer.toString();
    }

    private static void removeTrailingCommaAndNewline(StringBuffer buffer) {
        int bufferLength = buffer.length();
        if (bufferLength > 2 && buffer.charAt(bufferLength - 1) == '\n' && buffer.charAt(bufferLength - 2) == ',') {
            buffer.delete(bufferLength - 2, bufferLength);
        }
    }

    public static void put(JSONObject jsonObject, String key, boolean value) {
        jsonObject.put(key, new Boolean(value));
    }

    public static void put(JSONObject jsonObject, String key, double value) {
        jsonObject.put(key, new Double(value));
    }

    public static void put(JSONObject jsonObject, String key, int value) {
        jsonObject.put(key, new Integer(value));
    }

    public static void put(JSONObject jsonObject, String key, long value) {
        jsonObject.put(key, new Long(value));
    }

    public static void accumulate(JSONObject jsonObject, Object key, Object value) {
        JSONArray jsonArray;
        if (!jsonObject.containsKey(key)) {
            jsonArray = new JSONArray();
            jsonObject.put(key, jsonArray);
        } else {
            jsonArray = (JSONArray)jsonObject.get(key);
        }
        jsonArray.add(value);
    }
}

