/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json;

import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONStore {
    protected int nProperties;
    protected String identifier;
    protected List<JSONItem> items = new ArrayList<JSONItem>();
    protected String label;
    Collator nlsCollator;

    public JSONStore(int nProperties, Locale locale) {
        this.nProperties = nProperties;
        this.nlsCollator = Collator.getInstance(locale);
    }

    public JSONStore(String identifier, String label, Locale locale) {
        this.identifier = identifier;
        this.label = label;
        this.nlsCollator = Collator.getInstance(locale);
    }

    public void addItem(JSONItem item) {
        this.items.add(item);
    }

    public void addItem(JSONItem item, JSONItem parentItem) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean containsItem(JSONItem item) {
        return this.items.contains(item);
    }

    public JSONItem[] getDataItems() {
        return this.items.toArray(new JSONItem[this.items.size()]);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public void insertItem(JSONItem item, int position) {
        this.items.add(position, item);
    }

    public void removeItem(JSONItem item) {
        JSONItem parentItem = item.getParent();
        if (parentItem != null) {
            parentItem.removeChild(item);
        } else {
            this.items.remove(item);
        }
    }

    public void setDataItems(JSONItem[] items) {
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
        for (int i = 0; i < items.length; ++i) {
            JSONItem item = items[i];
            item.setDataStore(this);
        }
    }

    public JSONItem createDataItem(String id) {
        return this.createDataItem(id, null, null);
    }

    public JSONItem createDataItem(String id, String label) {
        return this.createDataItem(id, label, null);
    }

    public JSONItem createDataItem(String id, String label, Map properties) {
        return new JSONItem(this, id, label, properties);
    }

    public void addRow(String id, String label, String[][] columns) {
        Map propertyMap = JSONUtils.arrayToMap(columns);
        this.addRow(id, label, propertyMap);
    }

    public void addRow(String id, String label, Map columns) {
        HashMap propertyMap = new HashMap(columns);
        JSONItem item = this.createDataItem(id, label);
        this.addItem(item);
    }

    public void sortSearchResultsByProperty(final String property, final boolean ascending, final boolean foldersFirst) {
        Collections.sort(this.items, new Comparator<JSONItem>(){

            @Override
            public int compare(JSONItem item1, JSONItem item2) {
                String value2;
                String value1;
                Map item1Properties = item1.getProperties();
                Map item2Properties = item2.getProperties();
                if (foldersFirst) {
                    String type1 = (String)item1Properties.get("mimetype");
                    String type2 = (String)item2Properties.get("mimetype");
                    if (type1.equals("folder") && !type2.equals("folder")) {
                        return ascending ? -1 : 1;
                    }
                    if (!type1.equals("folder") && type2.equals("folder")) {
                        return ascending ? 1 : -1;
                    }
                }
                if (item1Properties.get(property) != null) {
                    value1 = (String)item1Properties.get(property);
                    value2 = (String)item2Properties.get(property);
                } else {
                    JSONObject item1Attributes = (JSONObject)item1Properties.get("attributes");
                    JSONObject item2Attributes = (JSONObject)item2Properties.get("attributes");
                    value1 = (String)item1Attributes.get(property);
                    value2 = (String)item2Attributes.get(property);
                }
                if (value1 != null && value2 != null) {
                    if (ascending) {
                        return JSONStore.this.nlsCollator.compare(value1, value2);
                    }
                    return JSONStore.this.nlsCollator.compare(value2, value1);
                }
                return 0;
            }
        });
    }

    public void sort(Comparator<JSONItem> comparator) {
        Collections.sort(this.items, comparator);
    }

    public JSONObject toJson() {
        JSONObject root = new JSONObject();
        if (this.nProperties > 0) {
            JSONArray DataItems = new JSONArray();
            JSONItem[] items = this.getDataItems();
            for (int i = 0; i < items.length; ++i) {
                JSONItem item = items[i];
                if (!(item instanceof JSONItem)) continue;
                JSONItem DataItem = item;
                DataItems.add(DataItem.toJsonArray());
            }
            root.put("items", DataItems);
            root.put("identifier", "0");
            if (this.nProperties > 1) {
                root.put("label", "1");
            } else {
                root.put("label", "0");
            }
        } else {
            JSONArray DataItems = new JSONArray();
            JSONItem[] items = this.getDataItems();
            for (int i = 0; i < items.length; ++i) {
                JSONItem item = items[i];
                if (!(item instanceof JSONItem)) continue;
                JSONItem DataItem = item;
                DataItems.add(DataItem.toJson());
            }
            root.put("items", DataItems);
            root.put("identifier", this.getIdentifier());
            root.put("label", this.getLabel());
        }
        return root;
    }

    public String toString(HttpServletRequest request) {
        String methodName = "toString";
        String returnString = null;
        try {
            JSONObject jsonRepresentation = this.toJson();
            returnString = JSONUtils.prettyPrintJson(jsonRepresentation);
        }
        catch (IOException e) {
            returnString = "JSONException encountered during toString() operation. " + e.getMessage();
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        return returnString;
    }
}

