/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json;

import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class JSONItem {
    private List children;
    private JSONStore dataStore;
    private String id;
    private String label;
    private JSONItem parent;
    private Map properties;

    protected JSONItem(JSONStore dataStore, String id) {
        this(dataStore, id, null, null);
    }

    protected JSONItem(JSONStore dataStore, String id, String label) {
        this(dataStore, id, label, null);
    }

    protected JSONItem(JSONStore dataStore, String id, String label, Map properties) {
        this.dataStore = dataStore;
        this.id = id;
        this.label = label;
        this.properties = properties;
    }

    public void addChild(JSONItem child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        if (child instanceof JSONItem) {
            child.parent = this;
        }
    }

    public void addChildren(JSONItem[] children) {
        for (int i = 0; i < children.length; ++i) {
            this.addChild(children[i]);
        }
    }

    public int compareTo(Object obj) {
        JSONItem otherItem = (JSONItem)obj;
        return this.getLabel().compareTo(otherItem.getLabel());
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (!(obj instanceof JSONItem)) {
            result = false;
        } else {
            JSONItem otherItem = (JSONItem)obj;
            JSONItem[] thisChildArray = this.getChildren();
            JSONItem[] otherChildArray = otherItem.getChildren();
            boolean childrenEqual = true;
            if (thisChildArray.length != otherChildArray.length) {
                childrenEqual = false;
            } else {
                for (int i = 0; i < thisChildArray.length && childrenEqual; childrenEqual |= thisChildArray[i].equals(otherChildArray[i]), ++i) {
                }
            }
            result = this.getId() == otherItem.getId() && this.getLabel().equals(otherItem.getLabel()) && childrenEqual;
        }
        return result;
    }

    public JSONItem[] getChildren() {
        JSONItem[] returnArray = null;
        returnArray = this.children == null ? new JSONItem[]{} : this.children.toArray(new JSONItem[this.children.size()]);
        return returnArray;
    }

    public JSONStore getDataStore() {
        return this.dataStore;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public JSONItem getParent() {
        return this.parent;
    }

    public Map getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int result = 19;
        result = 37 * result + this.id.hashCode();
        result = 37 * result + this.label.hashCode();
        JSONItem[] childArray = this.getChildren();
        int childHashCode = 0;
        for (int i = 0; i < childArray.length; ++i) {
            childHashCode += childArray[i].hashCode();
        }
        result = 37 * result + childHashCode;
        return result;
    }

    public void removeChild(JSONItem child) {
        this.children.remove(child);
        child.parent = null;
    }

    protected void setDataStore(JSONStore dataStore) {
        this.dataStore = dataStore;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public JSONObject toJson() {
        Map properties;
        JSONObject jsonObj = new JSONObject();
        JSONItem[] children = this.getChildren();
        if (children.length > 0) {
            JSONArray jsonChildren = new JSONArray();
            for (int i = 0; i < children.length; ++i) {
                JSONItem child = children[i];
                if (!(child instanceof JSONItem)) continue;
                jsonChildren.add(child.toJson());
            }
            jsonObj.put("children", jsonChildren);
        }
        if ((properties = this.getProperties()) != null) {
            Set keys = properties.keySet();
            for (String key : keys) {
                Object value = properties.get(key);
                if (value instanceof JSONItem) {
                    jsonObj.put(key, ((JSONItem)value).toJson());
                    continue;
                }
                if (value instanceof String) {
                    jsonObj.put(key, value);
                    continue;
                }
                if (value instanceof String[]) {
                    JSONArray jsonArray = new JSONArray();
                    String[] array = (String[])value;
                    for (int i = 0; i < array.length; ++i) {
                        String v = array[i];
                        jsonArray.add(v);
                    }
                    jsonObj.put(key, jsonArray);
                    continue;
                }
                if (value instanceof JSONObject) {
                    jsonObj.put(key, value);
                    continue;
                }
                String str = value == null ? "null" : value.toString();
                jsonObj.put(key, str);
            }
        }
        if (this.getId() != null) {
            jsonObj.put(this.getDataStore().getIdentifier(), this.getId());
        }
        if (this.getLabel() != null) {
            jsonObj.put(this.getDataStore().getLabel(), this.getLabel());
        }
        return jsonObj;
    }

    public JSONArray toJsonArray() {
        JSONArray jsonArray = new JSONArray();
        Map properties = this.getProperties();
        JSONItem[] children = this.getChildren();
        jsonArray.add(this.getId());
        if (this.getLabel() != null || properties != null) {
            jsonArray.add(this.getLabel());
        }
        if (properties != null) {
            Set keys = properties.keySet();
            for (String key : keys) {
                Object value = properties.get(key);
                if (value instanceof JSONItem) {
                    jsonArray.add(((JSONItem)value).toJson());
                    continue;
                }
                jsonArray.add(value);
            }
        }
        if (children.length > 0) {
            JSONArray jsonChildren = new JSONArray();
            for (int i = 0; i < children.length; ++i) {
                JSONItem child = children[i];
                jsonChildren.add(child.toJson());
            }
            jsonArray.add(jsonChildren);
        }
        return jsonArray;
    }

    public String toString(HttpServletRequest request) {
        String methodName = "toString";
        String returnString = null;
        try {
            JSONObject jsonRepresentation = this.toJson();
            returnString = JSONUtils.prettyPrintJson(jsonRepresentation);
        }
        catch (IOException e) {
            returnString = "JSONException encountered during toString() operation. " + e.getMessage();
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        return returnString;
    }
}

