/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.filters;

import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.ViewerUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewerReloginFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean connected = false;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String serverType = request.getParameter("serverType");
            String docUrl = request.getParameter("docUrl");
            if (serverType != null) {
                Map<String, String> docUrlMap = Util.getParameterMap(docUrl);
                String repositoryId = docUrlMap.get("repositoryId");
                if (repositoryId != null) {
                    repositoryId = URLDecoder.decode(repositoryId, "UTF-8");
                }
                connected = Util.isConnected(request, repositoryId);
            }
            if (!connected) {
                response.sendRedirect(ViewerUtil.getReloginUrl(request));
            }
        } else {
            connected = true;
        }
        if (connected) {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

