/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.extension.PluginDataSource;
import com.ibm.ecm.extension.PluginServiceCallbacks;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.edms.od.ODServer;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PluginServiceUtil {
    public static P8Connection getP8Connection(HttpServletRequest request, String repositoryId) {
        return (P8Connection)PluginServiceUtil.getConnection(request, "p8_servers", repositoryId);
    }

    public static CMConnection getCMConnection(HttpServletRequest request, String repositoryId) {
        return (CMConnection)PluginServiceUtil.getConnection(request, "cm_servers", repositoryId);
    }

    public static ODServer getODServer(HttpServletRequest request, String repositoryId) {
        return (ODServer)PluginServiceUtil.getConnection(request, "od_servers", repositoryId);
    }

    public static PluginDataSource getPluginDataSource(HttpServletRequest request, String dataSourceId) {
        Map pluginDatasources = PluginUtil.getPluginDataSources((HttpServletRequest)request);
        if (pluginDatasources != null && pluginDatasources.containsKey(dataSourceId)) {
            return (PluginDataSource)pluginDatasources.get(dataSourceId);
        }
        return null;
    }

    public static CMISConnection getCMISConnection(HttpServletRequest request, String repositoryId) {
        return (CMISConnection)PluginServiceUtil.getConnection(request, "CMIS_servers", repositoryId);
    }

    static DKRetrieveOptionsICM createDKRetrieveOptions(CMConnection connection, boolean baseAttributes, boolean partsList, boolean partsAttributes) throws Exception {
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
        dkRetrieveOptions.baseAttributes(baseAttributes);
        dkRetrieveOptions.partsList(partsList);
        dkRetrieveOptions.partsAttributes(partsAttributes);
        return dkRetrieveOptions;
    }

    private static Object getConnection(HttpServletRequest request, String connectionListKey, String repositoryId) {
        String methodName = "getConnection";
        PluginServiceCallbacks callbacks = (PluginServiceCallbacks)request.getAttribute("PluginServiceCallbacks");
        callbacks.getLogger().logEntry(PluginServiceUtil.class, methodName, (ServletRequest)request);
        Object connection = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            callbacks.getLogger().logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "HttpSession ID is: " + session.getId());
            callbacks.getLogger().logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "serverName: " + repositoryId);
            Hashtable connectionList = (Hashtable)session.getAttribute(connectionListKey);
            if (connectionList != null && repositoryId != null) {
                connection = connectionList.get(repositoryId);
            }
        }
        callbacks.getLogger().logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "Returning connection: " + connection);
        callbacks.getLogger().logExit(PluginServiceUtil.class, methodName, (ServletRequest)request);
        return connection;
    }
}

