/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.ObjectStore;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginDataSource;
import com.ibm.ecm.extension.PluginDocumentContent;
import com.ibm.ecm.extension.PluginLogger;
import com.ibm.ecm.extension.PluginServiceUtil;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODAnnotationMediator;
import com.ibm.ecm.util.Connection;
import com.ibm.ecm.util.DocumentContent;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.ecm.util.cm.CMContentUtil;
import com.ibm.ecm.util.cmis.CMISContentUtil;
import com.ibm.ecm.util.od.ODContentUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8ContentUtil;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.edms.od.ODHit;
import com.ibm.edms.od.ODServer;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkXDO;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import filenet.vw.api.VWSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

public class PluginServiceCallbacks {
    private static MessageResources resources = MessageResources.getMessageResources((String)"com.ibm.ecm.nls.ServicesMessages");
    private HttpServletRequest request;
    private Plugin plugin;
    private PluginLogger pluginLogger = null;

    public PluginServiceCallbacks(HttpServletRequest request, Plugin plugin) {
        this.request = request;
        this.plugin = plugin;
        this.pluginLogger = new PluginLogger(plugin);
        this.getLogger().logInfo(this, "constructor", (ServletRequest)request, "logLevel: " + this.pluginLogger.getLogLevel());
        request.setAttribute("PluginServiceCallbacks", (Object)this);
    }

    public PluginLogger getLogger() {
        if (this.pluginLogger == null) {
            this.pluginLogger = new PluginLogger(null);
        }
        return this.pluginLogger;
    }

    public String loadConfiguration() throws Exception {
        return PluginUtil.loadPluginConfig(this.plugin);
    }

    public void saveConfiguration(String config) throws Exception {
        PluginUtil.savePluginConfig(this.plugin, config);
    }

    public String loadUserConfiguration(String key) throws Exception {
        return PluginUtil.loadPluginUserConfig((HttpServletRequest)this.request, (Plugin)this.plugin, (String)key);
    }

    public void saveUserConfiguration(String key, String config) throws Exception {
        PluginUtil.savePluginUserConfig((HttpServletRequest)this.request, (Plugin)this.plugin, (String)key, (String)config);
    }

    public String getRepositoryId() {
        return this.request.getParameter("repositoryId");
    }

    public String getUserId() {
        Connection p8Connection;
        Connection cmConnection;
        ODServer server;
        String repositoryId = this.getRepositoryId();
        HttpSession session = this.request.getSession(false);
        Hashtable connectionList = (Hashtable)session.getAttribute("od_servers");
        if (connectionList != null && (server = (ODServer)connectionList.get(repositoryId)) != null) {
            return server.getUserId();
        }
        connectionList = (Hashtable)session.getAttribute("cm_servers");
        if (connectionList != null && (cmConnection = (Connection)connectionList.get(repositoryId)) != null) {
            return cmConnection.getUserId();
        }
        connectionList = (Hashtable)session.getAttribute("p8_servers");
        if (connectionList != null && (p8Connection = (Connection)connectionList.get(repositoryId)) != null) {
            return p8Connection.getUserId();
        }
        return null;
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public URL getServerBaseUrl() {
        try {
            String serverURL = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort();
            return new URL(serverURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public DKDatastoreICM getCMDatastore(String repositoryId) {
        DKDatastoreICM cmDatastore = null;
        CMConnection cmConnection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        if (cmConnection != null) {
            cmDatastore = cmConnection.getDatastore();
        }
        return cmDatastore;
    }

    public ODServer getODServer(String repositoryId) {
        return PluginServiceUtil.getODServer(this.request, repositoryId);
    }

    public com.filenet.api.core.Connection getP8Connection(String repositoryId) {
        com.filenet.api.core.Connection ceConnection = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            ceConnection = p8Connection.getCEConnection();
        }
        return ceConnection;
    }

    public P8Connection getP8ConnectionObject(String repositoryId) {
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        return p8Connection;
    }

    public VWSession getVWSession(String repositoryId, String connectionPoint) throws Exception {
        String methodName = "getVWSession";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        VWSession vwSession = null;
        try {
            P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
            if (p8Connection != null) {
                vwSession = P8Workflow.getVWSessionUsingConnection((P8Connection)p8Connection, (String)repositoryId, (String)connectionPoint, (boolean)true, (HttpServletRequest)this.request);
            } else {
                this.getLogger().logDebug(this, methodName, (ServletRequest)this.request, "No P8Connection has been established with the repository.");
            }
        }
        catch (Exception e) {
            this.getLogger().logError((Object)this, methodName, (ServletRequest)this.request, e);
            throw e;
        }
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return vwSession;
    }

    public ObjectStore getP8ObjectStore(String repositoryId) {
        ObjectStore objectStore = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            objectStore = p8Connection.getObjectStore();
        }
        return objectStore;
    }

    public Domain getP8Domain(String repositoryId) {
        Domain domain = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            domain = p8Connection.getDomain();
        }
        return domain;
    }

    public Subject getP8Subject(String repositoryId) {
        Subject subject = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            subject = p8Connection.getSubject();
        }
        return subject;
    }

    public MessageResources getResources() {
        return resources;
    }

    public Object getSynchObject(String repositoryId, String repositoryType) {
        Object synchObject = null;
        if (repositoryType.equalsIgnoreCase("cm")) {
            synchObject = CMContentUtil.getSynchObject(this.request, repositoryId);
        } else if (repositoryType.equalsIgnoreCase("od")) {
            synchObject = ODContentUtil.getSynchObject(this.request, repositoryId);
        }
        return synchObject;
    }

    public PluginDocumentContent retrieveDocumentContent(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, boolean odAsciiTransform) throws Exception {
        return this.retrieveContentInternal(repositoryId, repositoryType, documentId, partNum, p8VsId, p8Version, odFolderName, odSegmentNum, odAsciiTransform);
    }

    public DocumentContent retrieveContent(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, boolean odAsciiTransform) throws Exception {
        return this.retrieveContentInternal(repositoryId, repositoryType, documentId, partNum, p8VsId, p8Version, odFolderName, odSegmentNum, odAsciiTransform);
    }

    private DocumentContent retrieveContentInternal(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, boolean odAsciiTransform) throws Exception {
        String methodName = "retrieveContent";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        DocumentContent documentContent = null;
        if (repositoryType.equalsIgnoreCase("p8")) {
            documentContent = P8ContentUtil.retrieveContent(this.request, repositoryId, documentId, p8VsId, p8Version, partNum);
        } else if (repositoryType.equalsIgnoreCase("cm")) {
            documentContent = CMContentUtil.retrieveContent(this.request, repositoryId, documentId, partNum);
        } else if (repositoryType.equalsIgnoreCase("od")) {
            documentContent = ODContentUtil.retrieveContent(this.request, repositoryId, documentId, odFolderName, odSegmentNum, odAsciiTransform);
        } else if (repositoryType.equalsIgnoreCase("cmis")) {
            documentContent = CMISContentUtil.retrieveContent(this.request, repositoryId, documentId);
        }
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return documentContent;
    }

    public BaseMediator retrieveAnnotations(String repositoryId, String repositoryType, String documentId, String p8VsId, String p8Version, String odFolderName, boolean cmBookmarks, Integer cmAnnotationPosition) {
        String methodName = "retrieveAnnotations";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        BaseMediator mediator = null;
        if (repositoryType.equalsIgnoreCase("p8")) {
            mediator = P8ContentUtil.retrieveAnnotations(this.request, this.getResources(), repositoryId, documentId, p8VsId, p8Version);
        } else if (repositoryType.equalsIgnoreCase("cm")) {
            mediator = cmBookmarks ? CMContentUtil.retrieveBookmarks(this.request, this.getResources(), repositoryId, documentId) : CMContentUtil.retrieveAnnotations(this.request, this.getResources(), repositoryId, documentId, cmAnnotationPosition);
        } else if (repositoryType.equalsIgnoreCase("od")) {
            mediator = ODContentUtil.retrieveAnnotations(this.request, this.getResources(), repositoryId, documentId, odFolderName);
        }
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return mediator;
    }

    public JSONObject retrieveJSONAnnotations(String repositoryId, String repositoryType, String documentId, String p8VsId, String p8Version, String odFolderName, boolean cmBookmarks, Integer cmAnnotationPosition) {
        BaseMediator mediator = this.retrieveAnnotations(repositoryId, repositoryType, documentId, p8VsId, p8Version, odFolderName, cmBookmarks, cmAnnotationPosition);
        return mediator.toJSONObject();
    }

    public Document getP8Document(String repositoryId, String documentId, String vsId, String version) {
        return P8ContentUtil.retrieveDocument(this.request, repositoryId, documentId, vsId, version);
    }

    public CMItem getCMDocument(String repositoryId, String documentId, DKRetrieveOptionsICM dkRetrieveOptions) throws Exception {
        return CMContentUtil.retrieveDocument(this.request, repositoryId, documentId, dkRetrieveOptions);
    }

    public DKDDO getCMDocument(String repositoryId, String documentId, boolean baseAttributes, boolean partsList, boolean partsAttributes) throws Exception {
        CMConnection connection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        DKRetrieveOptionsICM dkRetrieveOptions = PluginServiceUtil.createDKRetrieveOptions(connection, baseAttributes, partsList, partsAttributes);
        CMItem item = CMContentUtil.retrieveDocument(this.request, repositoryId, documentId, dkRetrieveOptions);
        return item.getDDO();
    }

    public ODHit getODDocument(String repositoryId, String documentId, String templateName) throws Exception {
        return ODContentUtil.retrieveDocument(this.request, repositoryId, documentId, templateName);
    }

    public org.apache.chemistry.opencmis.client.api.Document getCMISDocument(String repositoryId, String documentId) {
        return CMISContentUtil.retrieveDocument(this.request, repositoryId, documentId);
    }

    public ODAnnotationMediator addODNote(String repositoryId, String documentId, String templateName, String noteGroupName, String noteText, boolean noteIsOKToCopy, boolean noteIsPublic) {
        String methodName = "addODNote";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        ODAnnotationMediator mediator = ODContentUtil.addNote(this.request, this.getResources(), repositoryId, documentId, templateName, noteGroupName, noteText, noteIsOKToCopy, noteIsPublic);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return mediator;
    }

    public AnnotationSet getP8Annotations(Document document, String repositoryId, String[] properties) {
        String methodName = "getP8Annotations";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        AnnotationSet annotations = P8ContentUtil.retrieveNativeAnnotations(this.request, repositoryId, document, properties);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return annotations;
    }

    public String getP8AnnotationsXML(Document document, String repositoryId) throws Exception {
        String methodName = "getP8AnnotationsXML";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        String annotationsXml = P8ContentUtil.retrieveAnnotationsXml(this.request, document, repositoryId);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return annotationsXml;
    }

    public CMObject getCMAnnotations(CMItem item, String repositoryId, int partNum) throws Exception {
        String methodName = "getCMAnnotations";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        CMObject annotations = CMContentUtil.retrieveNativeAnnotations(this.request, item, repositoryId, partNum);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return annotations;
    }

    public CMObject getCMAnnotations(CMItem item, String repositoryId) throws Exception {
        String methodName = "getCMAnnotations";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        CMObject annotations = CMContentUtil.retrieveNativeAnnotations(this.request, item, repositoryId);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return annotations;
    }

    public CMObject getCMBookmarks(CMItem item, String repositoryId) throws Exception {
        String methodName = "getCMBookmarks";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        CMObject bookmarks = CMContentUtil.retrieveNativeBookmarks(this.request, item, repositoryId);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return bookmarks;
    }

    public dkXDO getCMAnnotations(String repositoryId, String documentId, int partNum) throws Exception {
        String methodName = "getCMAnnotations";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        CMConnection connection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        DKRetrieveOptionsICM dkRetrieveOptions = PluginServiceUtil.createDKRetrieveOptions(connection, false, true, true);
        CMItem item = CMContentUtil.retrieveDocument(this.request, repositoryId, documentId, dkRetrieveOptions);
        CMObject annotations = CMContentUtil.retrieveNativeAnnotations(this.request, item, repositoryId, partNum);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return annotations.getXDO();
    }

    public dkXDO getCMAnnotations(String repositoryId, String documentId) throws Exception {
        return this.getCMAnnotations(repositoryId, documentId, 0);
    }

    public dkXDO getCMBookmarks(String repositoryId, String documentId) throws Exception {
        return this.getCMAnnotations(repositoryId, documentId, 1);
    }

    public Vector[] getODNotes(String repositoryId, String documentId, String templateName) throws Exception {
        String methodName = "getODNotes";
        this.getLogger().logEntry(this, methodName, (ServletRequest)this.request);
        Vector[] hitAndNotes = ODContentUtil.retrieveNativeAnnotations(this.request, repositoryId, documentId, templateName);
        this.getLogger().logExit(this, methodName, (ServletRequest)this.request);
        return hitAndNotes;
    }

    public PluginDataSource getPluginDataSource(String dataSourceId) {
        return PluginServiceUtil.getPluginDataSource(this.request, dataSourceId);
    }
}

