/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.serviceability.Logger;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;

public class PluginLogger {
    private String applId = Logger.getAppId();
    private int level = Logger.getLogLevel();

    public PluginLogger(Plugin plugin) {
        this.applId = plugin != null ? this.applId + "." + plugin.getId() : this.applId + ".unknown";
    }

    public String getPluginAppId() {
        return this.applId;
    }

    public int getLogLevel() {
        return this.level;
    }

    public void setLogLevel(int level) {
        this.level = level;
    }

    public void logEntry(Object object, String methodName, ServletRequest request) {
        this._log(this.getPluginAppId(), 5, object, methodName, "", request, null, null, null);
    }

    public void logEntry(Object object, String methodName, ServletRequest request, String message) {
        this._log(this.getPluginAppId(), 5, object, methodName, message, request, null, null, null);
    }

    public void logExit(Object object, String methodName, ServletRequest request) {
        this._log(this.getPluginAppId(), 6, object, methodName, "", request, null, null, null);
    }

    public void logExit(Object object, String methodName, ServletRequest request, String message) {
        this._log(this.getPluginAppId(), 6, object, methodName, message, request, null, null, null);
    }

    public void logError(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 1, loggingObject, methodName, text, request, null, null, null);
    }

    public void logError(Object object, String methodName, ServletRequest request, Throwable exception) {
        this._log(this.getPluginAppId(), 1, object, methodName, null, request, null, null, exception);
    }

    public void logError(Object object, String methodName, ServletRequest request, String text, Throwable exception) {
        this._log(this.getPluginAppId(), 1, object, methodName, text, request, null, null, exception);
    }

    public void logWarning(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 2, loggingObject, methodName, text, request, null, null, null);
    }

    public void logInfo(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 3, loggingObject, methodName, text, request, null, null, null);
    }

    public void logDebug(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 3, loggingObject, methodName, text, request, null, null, null);
    }

    public Date logPerf(Object object, String methodName, ServletRequest request) {
        return this._log(this.getPluginAppId(), 3, object, methodName, "", request, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request, String message) {
        return this._log(this.getPluginAppId(), 3, object, methodName, message, request, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request, Date date) {
        long elapsedTime = System.currentTimeMillis() - date.getTime();
        String elapsedInfo = Logger.formatElapsed(elapsedTime);
        return this._log(this.getPluginAppId(), 3, object, methodName, elapsedInfo, request, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request, Date date, String message) {
        long elapsedTime = System.currentTimeMillis() - date.getTime();
        String elapsedInfo = Logger.formatElapsed(elapsedTime);
        return this._log(this.getPluginAppId(), 3, object, methodName, elapsedInfo + message, request, null, null, new Exception());
    }

    private Date _log(String appId, int type, Object loggingObject, String methodName, String message, ServletRequest request, HttpSession session, ServletContext context, Throwable exception) {
        return Logger._log(appId, type, this.getLogLevel(), loggingObject, methodName, message, request, null, null, exception);
    }
}

