/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.dm;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.LocalizedString;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.admin.PropertyTemplateBoolean;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.LocalizedStringList;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.PropertyPersistence;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class P8DataModel {
    public static final String STORED_SEARCH = "StoredSearch";
    private static final String AUTO_RUN = "AutoRun";
    private static final String SHOW_IN_TREE = "ShowInTree";
    private static final Id AUTO_RUN_ID = new Id("{d5b08c48-a3e2-4172-904a-718e91c5b90c}");
    private static final Id SHOW_IN_TREE_ID = new Id("{1ac7f880-f112-448d-80ff-d59547ecfde2}");

    public static void augmentSearchClass(HttpServletRequest request, ObjectStore objectStore) throws Exception {
        PropertyFilter filter = new PropertyFilter();
        filter.addIncludeProperty(0, null, null, "PropertyDefinitions", null);
        ClassDefinition classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)objectStore, (String)STORED_SEARCH, (PropertyFilter)filter);
        PropertyDefinitionList properties = classDefinition.get_PropertyDefinitions();
        boolean addOnInstalled = false;
        for (PropertyDefinition prop : properties) {
            if (!prop.get_SymbolicName().equals(AUTO_RUN)) continue;
            addOnInstalled = true;
            break;
        }
        if (!addOnInstalled) {
            PropertyTemplateBoolean autoRunProp = P8DataModel.createPropertyTemplateBoolean(objectStore, AUTO_RUN_ID, AUTO_RUN, "Auto-run", "Run the search when opened", Boolean.FALSE);
            PropertyTemplateBoolean showInTreeProp = P8DataModel.createPropertyTemplateBoolean(objectStore, SHOW_IN_TREE_ID, SHOW_IN_TREE, "Show in the browse tree", "Show the search in the browse tree.", Boolean.FALSE);
            UpdatingBatch batch = UpdatingBatch.createUpdatingBatchInstance((Domain)objectStore.get_Domain(), (RefreshMode)RefreshMode.REFRESH);
            batch.add((IndependentlyPersistableObject)autoRunProp, null);
            batch.add((IndependentlyPersistableObject)showInTreeProp, null);
            batch.updateBatch();
            properties.add((Object)autoRunProp);
            properties.add((Object)showInTreeProp);
            classDefinition.save(RefreshMode.REFRESH);
        }
    }

    private static PropertyTemplateBoolean createPropertyTemplateBoolean(ObjectStore objectStore, Id id, String symbolicName, String name, String description, Boolean defaultValue) {
        PropertyTemplateBoolean propTemplate = Factory.PropertyTemplateBoolean.createInstance((ObjectStore)objectStore, (Id)id);
        propTemplate.set_Cardinality(Cardinality.SINGLE);
        propTemplate.set_PersistenceType(PropertyPersistence.OWN_COLUMN);
        propTemplate.set_IsHidden(Boolean.TRUE);
        propTemplate.set_PropertyDefaultBoolean(defaultValue);
        propTemplate.getProperties().putValue("SymbolicName", symbolicName);
        propTemplate.getProperties().putValue("DisplayNames", (DependentObjectList)P8DataModel.createLocalizedStringList(name));
        propTemplate.getProperties().putValue("DescriptiveTexts", (DependentObjectList)P8DataModel.createLocalizedStringList(description));
        return propTemplate;
    }

    private static LocalizedStringList createLocalizedStringList(String text) {
        LocalizedStringList list = Factory.LocalizedString.createList();
        LocalizedString str = Factory.LocalizedString.createInstance();
        str.set_LocaleName(Locale.ENGLISH.toString());
        str.set_LocalizedText(text);
        list.add((Object)str);
        return list;
    }
}

