/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.dm;

import com.ibm.ecm.dm.CMAttrs;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.mm.sdk.common.DKAccessControlListICM;
import com.ibm.mm.sdk.common.DKAdminDomainsMgmtICM;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKAuthorizationMgmtICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKNotExistException;
import com.ibm.mm.sdk.common.DKResults;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkAccessControlList;
import com.ibm.mm.sdk.common.dkAttrDef;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkResultSetCursor;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class CMDataModel {
    public static final String DOCUMENT_ITEM_TYPE_NAME = "Document";
    public static final String FOLDER_ITEM_TYPE_NAME = "Folder";
    public static final String ROLE_ITEM_TYPE_NAME = "ICMRole";
    public static final String TEAMSPACE_ITEM_TYPE_NAME = "ICMTeamspace";
    public static final String TEAMSPACE_TEMPLATE_ITEM_TYPE_NAME = "ICMTeamspaceTemplate";
    public static final String TEAMSPACE_ITEM_TYPE_CHILD = "ICMTeamspaceData";
    public static final String TEAMSPACE_TEMPLATE_ITEM_TYPE_CHILD = "ICMTeamspaceTemplateData";
    public static final String SEARCH_ITEM_TYPE_NAME = "ICMSearch";
    public static final String SEARCH_ITEM_TYPE_CHILD = "ICMSearchData";
    public static final String TEAMSPACE_PARENT_FOLDER = "Teamspaces";
    public static final String TEAMSPACE_TEMPLATE_PARENT_FOLDER = "Teamspace Templates";
    public static final String TEAMSPACE_ROLE_PARENT_FOLDER = "Roles";
    public static final String CM_ITEM_NAME = "ICM$NAME";
    public static final String NAME_ATTRIBUTE = "clbName";
    public static final String DESCRIPTION_ATTRIBUTE = "clbDescription";
    public static final String DEFAULT_DOC_TYPE_ATTRIBUTE = "clbDefaultDocType";
    public static final String GROUP_NAME_ATTRIBUTE = "clbGroupName";
    public static final String STATE_ATTRIBUTE = "clbState";
    public static final String TITLE_ATTRIBUTE = "clbTitle";
    public static final String TYPE_ATTRIBUTE = "clbType";
    public static final String DATABASE_ATTRIBUTE = "clbJSONData";
    public static final String ROLE_TYPE_ATTRIBUTE = "clbRoleType";
    public static final String ROLE_PRIVSET_ATTRIBUTE = "clbPrivSetName";
    public static final String SEARCH_TYPE_ATTRIBUTE = "clbSearchType";
    public static final String AUTO_RUN_ATTRIBUTE = "clbAutoRun";
    public static final String SHOW_IN_TREE_ATTRIBUTE = "clbShowInTree";
    public static final String SEARCH_JSON_ATTRIBUTE = "clbSearchJSON";
    private static final int CLOB_LENGTH = 0x100000;
    private static final String[] READONLY_PRIVSET = new String[]{"ItemSQLSelect", "ItemTypeQuery", "ItemQuery", "ItemGetWorkList", "SystemQueryUserPrivs", "ClientPrint", "ClientExport", "ClientReadBasePart", "ClientReadNoteLog", "ClientReadHistory", "ClientAdvancedSearch", "ClientReadAnnotation"};
    public static final String[] EDIT_PRIVSET = new String[]{"ItemSQLSelect", "ItemTypeQuery", "ItemQuery", "ItemAdd", "ItemSetUserAttr", "ItemMove", "ItemLinkTo", "ItemLinked", "ItemAddPart", "ItemAddLink", "ItemRemoveLink", "ItemCheckInOut", "ItemUpdatePart", "ItemGetWorkList", "ItemGetWork", "ItemRoute", "ItemRouteStart", "ItemRouteEnd", "ItemUpdateWork", "SystemQueryUserPrivs", "ClientPrint", "ClientExport", "ClientReadBasePart", "ClientReadNoteLog", "ClientReadHistory", "ClientAdvancedSearch", "ClientImport", "ClientModifyBasePart", "ClientAddNewBasePart", "ClientDeleteBasePart", "ClientReadAnnotation", "ClientModifyAnnotation", "ClientModifyNoteLog", "ClientAddToNoteLog", "ClientScan"};
    public static final String[] OWNER_PRIVSET = new String[]{"ItemSQLSelect", "ItemTypeQuery", "ItemQuery", "ItemAdd", "ItemSetUserAttr", "ItemDelete", "ItemMove", "ItemLinkTo", "ItemLinked", "ItemDeletePart", "ItemAddPart", "ItemAddLink", "ItemRemoveLink", "ItemCheckInOut", "ItemUpdatePart", "ItemGetWorkList", "ItemGetWork", "ItemRoute", "ItemRouteStart", "ItemRouteEnd", "ItemUpdateWork", "ItemGetAssignedWork", "SystemQueryUserPrivs", "SystemQueryGroup", "ItemSetACL", "UserACLOwner", "ClientPrint", "ClientExport", "ClientReadBasePart", "ClientReadNoteLog", "ClientReadHistory", "ClientAdvancedSearch", "ClientImport", "ClientModifyBasePart", "ClientAddNewBasePart", "ClientDeleteBasePart", "ClientReadAnnotation", "ClientModifyAnnotation", "ClientModifyNoteLog", "ClientAddToNoteLog", "ClientScan"};
    public static final String[] TEAMSPACE_OWNER_PRIVSET = new String[]{"addNewSearches", "shareSearches", "addRemoveClasses", "addRemoveRoleParticipants", "SystemQueryGroup", "UserACLOwner", "SystemQueryUserPrivs", "ItemSQLSelect", "ItemTypeQuery", "ItemQuery", "ItemAdd", "ItemSetUserAttr", "ItemDelete", "ItemMove", "ItemLinkTo", "ItemLinked", "ItemDeletePart", "ItemAddPart", "ItemAddLink", "ItemRemoveLink", "ItemCheckInOut", "ItemUpdatePart", "ItemGetWorkList", "ItemGetWork", "ItemRoute", "ItemRouteStart", "ItemRouteEnd", "ItemUpdateWork", "ItemGetAssignedWork", "ItemSetACL", "ClientPrint", "ClientExport", "ClientReadBasePart", "ClientReadNoteLog", "ClientReadHistory", "ClientAdvancedSearch", "ClientImport", "ClientModifyBasePart", "ClientAddNewBasePart", "ClientDeleteBasePart", "ClientReadAnnotation", "ClientModifyAnnotation", "ClientModifyNoteLog", "ClientAddToNoteLog", "ClientScan"};
    private static final String[] CLIENT_PRIVILEGES = new String[]{"addNewSearches", "shareSearches", "addRemoveClasses", "addRemoveRoleParticipants"};
    public static final String DOCUMENT_DEFAULT_ACL_NAME = "ClbDocumentACL";
    public static final String FOLDER_DEFAULT_ACL_NAME = "ClbFolderACL";
    public static final String SEARCH_DEFAULT_ACL_NAME = "ClbSearchACL";
    public static final String TEAMSPACE_DEFAULT_ACL_NAME = "ClbTeamspaceACL";
    public static final String TEAMSPACE_TEMPLATE_DEFAULT_ACL_NAME = "ClbTeamspaceTemplateACL";
    public static final String DOCUMENT_DEFAULT_ACL_DESCRIPTION = "Default ACL used Documents";
    public static final String FOLDER_DEFAULT_ACL_DESCRIPTION = "Default ACL used Folders";
    public static final String SEARCH_DEFAULT_ACL_DESCRIPTION = "Default ACL used ICMSearches";
    public static final String TEAMSPACE_DEFAULT_ACL_DESCRIPITION = "Default ACL used for ICMTeamspaces";
    public static final String TEAMSPACE_TEMPLATE_DEFAULT_ACL_DESCRIPITION = "Default ACL used for ICMTeamspacesTemplates";
    private static final PropertyDefinition[] teamspaceSimpleFolderItemTypeAttributeDefs = new PropertyDefinition[0];
    private static final PropertyDefinition[] teamspaceSimpleDocItemTypeAttributeDefs = new PropertyDefinition[0];
    private static final PropertyDefinition[] teamspaceAttributeDefs = new PropertyDefinition[]{new PropertyDefinition("clbName", "", 1, 255, false, false), new PropertyDefinition("clbDescription", "", 1, 1024, false, true), new PropertyDefinition("clbDefaultDocType", "Default teamspace item type name", 1, 255, false, true), new PropertyDefinition("clbGroupName", "Teamspace group name", 1, 255, false, true), new PropertyDefinition("clbState", "Teamspace state", 4, 0, false, false), new PropertyDefinition("clbTitle", "Teamspace title", 1, 255, false, true), new PropertyDefinition("clbType", "Teamspace type", 1, 255, false, false)};
    private static final PropertyDefinition[] roleAttributeDefs = new PropertyDefinition[]{new PropertyDefinition("clbDescription", "", 1, 1024, false, true), new PropertyDefinition("clbRoleType", "Role type defintion", 4, 0, false, false), new PropertyDefinition("clbPrivSetName", "", 1, 255, false, false)};
    private static final PropertyDefinition[] searchAttributeDefs = new PropertyDefinition[]{new PropertyDefinition("clbDescription", "Search Description", 1, 1024, false, true), new PropertyDefinition("clbSearchType", "Search Type", 4, 0, false, true), new PropertyDefinition("clbAutoRun", "Run search when opened", 4, 0, false, false), new PropertyDefinition("clbShowInTree", "Show search in the browse tree", 4, 0, false, false)};
    private static final String usageString = "Usage:  Java DataModelCM <operation> <database> <userid> <password> [<schema>] [<types>]        where:        operation = CREATE | DELETE         database  = name of the CM database to operate on        userid    = CM admin userid        password  = password for CM admin userid        schema    = database schema (optional, '.' may be used for no specified schema)        types     = optional comma-delimited list of data model objects to create. Data model objects include \"Teamspace\", \"Role\", \"Search\". Example= \"Teamspace,Role\"";

    public static void main(String[] args) {
        String methodName = "main";
        Operation op = null;
        String command = null;
        String database = null;
        String userName = null;
        String password = null;
        String schema = null;
        String typeStr = null;
        HttpServletRequest request = null;
        Logger.setLogLevel(4);
        Logger.validateHttp = false;
        if (args.length < 4) {
            Logger.logDebug(CMDataModel.class, methodName, request, usageString);
            System.exit(0);
        } else {
            if (args.length > 0) {
                command = args[0].toUpperCase();
            }
            if (args.length > 1) {
                database = args[1];
            }
            if (args.length > 2) {
                userName = args[2];
            }
            if (args.length > 3) {
                password = args[3];
            }
            if (args.length > 4) {
                typeStr = args[4];
            }
            if (args.length > 5) {
                schema = args[5];
            }
        }
        try {
            op = Enum.valueOf(Operation.class, command);
        }
        catch (Exception e) {
            op = Operation.CREATE;
        }
        String connectString = "";
        if (schema != null && schema.length() > 0) {
            connectString = "SCHEMA=" + schema;
        }
        String[] types = null;
        if (typeStr != null) {
            types = typeStr.split(",");
        }
        try {
            Logger.logDebug(CMDataModel.class, methodName, request, "Connecting to datastore (Database '" + database + "', UserName '" + userName + "')...");
            DKDatastoreICM dsICM = new DKDatastoreICM();
            dsICM.connect(database, userName, password, connectString);
            Logger.logDebug(CMDataModel.class, methodName, request, "Connected to datastore (Database '" + dsICM.datastoreName() + "', UserName '" + dsICM.userName() + "').");
            if (op == Operation.CREATE) {
                CMDataModel.createDefaultACLData(request, dsICM);
                if (types != null) {
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i].equalsIgnoreCase("teamspace")) {
                            CMDataModel.createTeamspaceDataModel(request, dsICM);
                            continue;
                        }
                        if (types[i].equalsIgnoreCase("role")) {
                            CMDataModel.createRoleDataModel(request, dsICM);
                            continue;
                        }
                        if (types[i].equalsIgnoreCase("search")) {
                            CMDataModel.createSearchDataModel(request, dsICM);
                            continue;
                        }
                        if (!types[i].equalsIgnoreCase("privSet")) continue;
                        CMDataModel.createPrivilegeSets(request, dsICM);
                    }
                } else {
                    CMDataModel.createTeamspaceDataModel(request, dsICM);
                    CMDataModel.createRoleDataModel(request, dsICM);
                    CMDataModel.createSearchDataModel(request, dsICM);
                    CMDataModel.createPrivilegeSets(request, dsICM);
                }
            } else if (op == Operation.DELETE) {
                CMDataModel.deleteItems(request, "/ICMSearch", dsICM);
                CMDataModel.deleteItems(request, "/ICMRole", dsICM);
                CMDataModel.deleteItems(request, "/ICMTeamspace", dsICM);
                CMDataModel.deleteItems(request, "/ICMTeamspaceTemplate", dsICM);
                CMDataModel.deleteItems(request, "/Document", dsICM);
                CMDataModel.deleteItems(request, "/Folder", dsICM);
                CMDataModel.deleteItemType(request, dsICM, SEARCH_ITEM_TYPE_NAME, SEARCH_ITEM_TYPE_CHILD);
                CMDataModel.deleteItemType(request, dsICM, TEAMSPACE_ITEM_TYPE_NAME, TEAMSPACE_ITEM_TYPE_CHILD);
                CMDataModel.deleteItemType(request, dsICM, TEAMSPACE_TEMPLATE_ITEM_TYPE_NAME, TEAMSPACE_TEMPLATE_ITEM_TYPE_CHILD);
                CMDataModel.deleteItemType(request, dsICM, ROLE_ITEM_TYPE_NAME, null);
                CMDataModel.deleteItemType(request, dsICM, DOCUMENT_ITEM_TYPE_NAME, null);
                CMDataModel.deleteItemType(request, dsICM, FOLDER_ITEM_TYPE_NAME, null);
                CMDataModel.deleteAttributes(request, dsICM, searchAttributeDefs);
                CMDataModel.deleteAttributes(request, dsICM, teamspaceAttributeDefs);
                CMDataModel.deleteAttributes(request, dsICM, roleAttributeDefs);
                CMDataModel.deleteJsonAttributes(request, dsICM);
                CMDataModel.deleteACLs(request, dsICM);
                CMDataModel.deleteUserACLs(request, dsICM);
                CMDataModel.deleteClientPrivileges(request, dsICM);
            }
        }
        catch (DKException exc) {
            CMDataModel.printException(request, exc);
        }
        catch (Exception exc) {
            CMDataModel.printException(request, exc);
        }
    }

    public static void deleteACLs(HttpServletRequest request, DKDatastoreICM dsICM) {
        String methodName = "deleteACLs";
        Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
        try {
            CM8SecurityService service = new CM8SecurityService(null, dsICM);
            service.deleteACL(DOCUMENT_DEFAULT_ACL_NAME);
            service.deleteACL(FOLDER_DEFAULT_ACL_NAME);
            service.deleteACL(TEAMSPACE_DEFAULT_ACL_NAME);
            service.deleteACL(SEARCH_DEFAULT_ACL_NAME);
            service.deleteACL(TEAMSPACE_TEMPLATE_DEFAULT_ACL_NAME);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
    }

    public static void deleteUserACLs(HttpServletRequest request, DKDatastoreICM dsICM) {
        try {
            CM8SecurityService service = new CM8SecurityService(null, dsICM);
            service.deleteAllUserACLs();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void deleteJsonAttributes(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "deleteJsonAttributes";
        Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
        try {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
            DKAttrDefICM attr = (DKAttrDefICM)dsDefICM.retrieveAttr(SEARCH_JSON_ATTRIBUTE);
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "clbSearchJSON  : " + attr);
            if (attr != null) {
                attr.del();
            }
            attr = (DKAttrDefICM)dsDefICM.retrieveAttr(DATABASE_ATTRIBUTE);
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "clbJSONData : " + attr);
            if (attr != null) {
                attr.del();
            }
        }
        catch (Exception e) {
            Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
    }

    public static void createDefaultACLData(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createDefaultACLData";
        DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)dsICM);
        DKAdminDomainsMgmtICM adminDomainMgmt = new DKAdminDomainsMgmtICM((dkDatastore)dsICM);
        dkAccessControlList acl = null;
        dkCollection domains = null;
        try {
            domains = adminDomainMgmt.listAdminDomains();
        }
        catch (Exception e1) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL for: ClbTeamspaceACL");
        try {
            acl = authorMgmt.retrieveAccessControlList(TEAMSPACE_DEFAULT_ACL_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL = " + acl);
        if (acl == null) {
            acl = new DKAccessControlListICM((dkDatastore)dsICM);
            if (domains != null && domains.cardinality() > 0) {
                ((DKAccessControlListICM)acl).setAdminDomains(domains);
            }
            acl.setACLType((short)0);
            acl.setName(TEAMSPACE_DEFAULT_ACL_NAME);
            acl.setDescription(TEAMSPACE_DEFAULT_ACL_DESCRIPITION);
            authorMgmt.add(acl);
        } else {
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "did not create or update: ClbTeamspaceACL");
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL for: ClbTeamspaceTemplateACL");
        try {
            acl = authorMgmt.retrieveAccessControlList(TEAMSPACE_TEMPLATE_DEFAULT_ACL_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL = " + acl);
        if (acl == null) {
            acl = new DKAccessControlListICM((dkDatastore)dsICM);
            if (domains != null && domains.cardinality() > 0) {
                ((DKAccessControlListICM)acl).setAdminDomains(domains);
            }
            acl.setACLType((short)0);
            acl.setName(TEAMSPACE_TEMPLATE_DEFAULT_ACL_NAME);
            acl.setDescription(TEAMSPACE_TEMPLATE_DEFAULT_ACL_DESCRIPITION);
            authorMgmt.add(acl);
        } else {
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "did not create or update: ClbTeamspaceTemplateACL");
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL for: ClbSearchACL");
        try {
            acl = authorMgmt.retrieveAccessControlList(SEARCH_DEFAULT_ACL_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL = " + acl);
        if (acl == null) {
            acl = new DKAccessControlListICM((dkDatastore)dsICM);
            if (domains != null && domains.cardinality() > 0) {
                ((DKAccessControlListICM)acl).setAdminDomains(domains);
            }
            acl.setACLType((short)0);
            acl.setName(SEARCH_DEFAULT_ACL_NAME);
            acl.setDescription(SEARCH_DEFAULT_ACL_DESCRIPTION);
            authorMgmt.add(acl);
        } else {
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "did not create or update: ClbSearchACL");
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL for: ClbFolderACL");
        try {
            acl = authorMgmt.retrieveAccessControlList(FOLDER_DEFAULT_ACL_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL = " + acl);
        if (acl == null) {
            acl = new DKAccessControlListICM((dkDatastore)dsICM);
            if (domains != null && domains.cardinality() > 0) {
                ((DKAccessControlListICM)acl).setAdminDomains(domains);
            }
            acl.setACLType((short)0);
            acl.setName(FOLDER_DEFAULT_ACL_NAME);
            acl.setDescription(FOLDER_DEFAULT_ACL_DESCRIPTION);
            authorMgmt.add(acl);
        } else {
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "did not create or update: ClbFolderACL");
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL for: ClbDocumentACL");
        try {
            acl = authorMgmt.retrieveAccessControlList(DOCUMENT_DEFAULT_ACL_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "retrieve ACL = " + acl);
        if (acl == null) {
            acl = new DKAccessControlListICM((dkDatastore)dsICM);
            if (domains != null && domains.cardinality() > 0) {
                ((DKAccessControlListICM)acl).setAdminDomains(domains);
            }
            acl.setACLType((short)0);
            acl.setName(DOCUMENT_DEFAULT_ACL_NAME);
            acl.setDescription(DOCUMENT_DEFAULT_ACL_DESCRIPTION);
            authorMgmt.add(acl);
        } else {
            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "did not create or update: ClbDocumentACL");
        }
    }

    private static void deleteClientPrivileges(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        CM8SecurityService securityService = new CM8SecurityService(request, dsICM);
        try {
            for (int i = 0; i < CLIENT_PRIVILEGES.length; ++i) {
                securityService.deletePrivilege(CLIENT_PRIVILEGES[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createClientPrivileges(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        CM8SecurityService securityService = new CM8SecurityService(request, dsICM);
        for (int i = 0; i < CLIENT_PRIVILEGES.length; ++i) {
            securityService.createPrivilege(CLIENT_PRIVILEGES[i], CLIENT_PRIVILEGES[i]);
        }
    }

    public static void createPrivilegeSets(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createPrivilegeSets";
        Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
        try {
            CM8SecurityService securityService = new CM8SecurityService(request, dsICM);
            List<String> privs = Arrays.asList(READONLY_PRIVSET);
            String description = "Privilege Set for read only access";
            securityService.createPrivilegeSet(SecurityConstants.AppPrivilegeSets.READ.getValue(), description, privs);
            privs = Arrays.asList(EDIT_PRIVSET);
            description = "Privilege Set for edit access";
            securityService.createPrivilegeSet(SecurityConstants.AppPrivilegeSets.EDIT.getValue(), description, privs);
            privs = Arrays.asList(OWNER_PRIVSET);
            description = "Privilege Set for full access";
            securityService.createPrivilegeSet(SecurityConstants.AppPrivilegeSets.OWNER.getValue(), description, privs);
        }
        catch (Exception e) {
            Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)e);
            throw e;
        }
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
    }

    public static void createTeamspaceDataModel(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createTeamspaceDataModel";
        CMDataModel.createClientPrivileges(request, dsICM);
        CM8SecurityService securityService = new CM8SecurityService(request, dsICM);
        List<String> privs = Arrays.asList(TEAMSPACE_OWNER_PRIVSET);
        String description = "Privilege Set to create teamspaces";
        securityService.createPrivilegeSet(SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue(), description, privs);
        DKItemTypeDefICM itemType = CMDataModel.createItemType(request, dsICM, TEAMSPACE_ITEM_TYPE_NAME, true, teamspaceAttributeDefs, true, true, TEAMSPACE_DEFAULT_ACL_NAME, true);
        if (itemType == null) {
            throw new Exception("Error creating item type: ICMTeamspace");
        }
        CMDataModel._buildTeamspaceItemType(request, dsICM, itemType, TEAMSPACE_ITEM_TYPE_CHILD);
        itemType = CMDataModel.createItemType(request, dsICM, TEAMSPACE_TEMPLATE_ITEM_TYPE_NAME, true, teamspaceAttributeDefs, true, true, TEAMSPACE_TEMPLATE_DEFAULT_ACL_NAME, true);
        if (itemType == null) {
            throw new Exception("Error creating item type: ICMTeamspaceTemplate");
        }
        CMDataModel._buildTeamspaceItemType(request, dsICM, itemType, TEAMSPACE_TEMPLATE_ITEM_TYPE_CHILD);
        CMDataModel.createTeamspaceTemplateFolder(request, dsICM);
        CMDataModel.createTeamspaceFolder(request, dsICM);
        CMDataModel.createFolderAndDocItemType(request, dsICM);
    }

    private static void _buildTeamspaceItemType(HttpServletRequest request, DKDatastoreICM dsICM, DKItemTypeDefICM itemType, String childName) throws Exception {
        String methodName = "_buildTeamspaceItemType";
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
        DKAttrDefICM childAttr = (DKAttrDefICM)dsDefICM.retrieveAttr(DATABASE_ATTRIBUTE);
        if (childAttr == null) {
            childAttr = CMDataModel.defineAttribute(request, dsICM, DATABASE_ATTRIBUTE, "Teamspace Data", (short)19, 0x100000, true);
        }
        dkEntityDef childCompType = null;
        try {
            childCompType = itemType.retrieveSubEntity(childName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "childCompType = " + childCompType);
        if (childCompType == null) {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "Creating child component for json data");
            DKComponentTypeDefICM compType = new DKComponentTypeDefICM((dkDatastore)dsICM);
            compType.setName(childName);
            compType.setDescription("Teamspace Clob data");
            compType.setDeleteRule((short)1);
            compType.addAttr((dkAttrDef)childAttr);
            itemType.addSubEntity((dkEntityDef)compType);
        }
        itemType.update();
    }

    public static void createFolderAndDocItemType(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createFolderAndDocItemType";
        Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
        try {
            CMDataModel.createItemType(request, dsICM, DOCUMENT_ITEM_TYPE_NAME, false, teamspaceSimpleDocItemTypeAttributeDefs, false, true, DOCUMENT_DEFAULT_ACL_NAME, false);
            CMDataModel.createItemType(request, dsICM, FOLDER_ITEM_TYPE_NAME, true, teamspaceSimpleFolderItemTypeAttributeDefs, true, true, FOLDER_DEFAULT_ACL_NAME, true);
            CMAttrs.addAttrToItemTypeIfNeeded((ServletRequest)request, dsICM, DOCUMENT_ITEM_TYPE_NAME, false);
        }
        catch (Exception e) {
            Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
    }

    public static void createRoleDataModel(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        CMDataModel.createItemType(request, dsICM, ROLE_ITEM_TYPE_NAME, false, roleAttributeDefs, false, false, null, true);
        CMAttrs.addAttrToItemTypeIfNeeded((ServletRequest)request, dsICM, ROLE_ITEM_TYPE_NAME, false);
    }

    public static void createSearchDataModel(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createSearchDataModel";
        DKItemTypeDefICM itemType = CMDataModel.createItemType(request, dsICM, SEARCH_ITEM_TYPE_NAME, false, searchAttributeDefs, false, true, SEARCH_DEFAULT_ACL_NAME, true);
        if (itemType != null) {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
            DKAttrDefICM childAttr = (DKAttrDefICM)dsDefICM.retrieveAttr(SEARCH_JSON_ATTRIBUTE);
            if (childAttr == null) {
                childAttr = CMDataModel.defineAttribute(request, dsICM, SEARCH_JSON_ATTRIBUTE, "Saved search data", (short)19, 0x100000, true);
            }
            dkEntityDef childCompType = null;
            try {
                childCompType = itemType.retrieveSubEntity(SEARCH_ITEM_TYPE_CHILD);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "childCompType = " + childCompType);
            if (childCompType == null) {
                Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "Creating child component for json data");
                DKComponentTypeDefICM compType = new DKComponentTypeDefICM((dkDatastore)dsICM);
                compType.setName(SEARCH_ITEM_TYPE_CHILD);
                compType.setDescription("Search clob data");
                compType.setDeleteRule((short)1);
                compType.addAttr((dkAttrDef)childAttr);
                itemType.addSubEntity((dkEntityDef)compType);
            }
        } else {
            throw new Exception("Error creating item type: ICMTeamspace");
        }
        itemType.update();
        CMAttrs.addAttrToItemTypeIfNeeded((ServletRequest)request, dsICM, SEARCH_ITEM_TYPE_NAME, false);
    }

    public static void createTeamspaceTemplateFolder(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createTeamspaceTemplateFolder";
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> createTeamspaceTemplateFolder .....");
        DKDDO systemRootFolder = dsICM.getRootFolder();
        DKDDO rootChildFolder = CMDataModel.getChild(dsICM, systemRootFolder, TEAMSPACE_TEMPLATE_ITEM_TYPE_NAME, TEAMSPACE_TEMPLATE_PARENT_FOLDER);
        if (rootChildFolder != null) {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Teamspace template root already exists, this will cause errors when adding items. ");
        } else {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Create a folder under the system root that will be used as its root...");
            rootChildFolder = CMDataModel.createFolder(dsICM, systemRootFolder, TEAMSPACE_TEMPLATE_PARENT_FOLDER, TEAMSPACE_TEMPLATE_ITEM_TYPE_NAME);
        }
    }

    public static void createTeamspaceFolder(HttpServletRequest request, DKDatastoreICM dsICM) throws Exception {
        String methodName = "createTeamspaceFolder";
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> createTeamspaceFolder .....");
        DKDDO systemRootFolder = dsICM.getRootFolder();
        DKDDO rootChildFolder = CMDataModel.getChild(dsICM, systemRootFolder, TEAMSPACE_ITEM_TYPE_NAME, TEAMSPACE_PARENT_FOLDER);
        if (rootChildFolder != null) {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Teamspace root already exists, this will cause errors when adding items.  \n");
        } else {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Create a folder under the system root ");
            rootChildFolder = CMDataModel.createFolder(dsICM, systemRootFolder, TEAMSPACE_PARENT_FOLDER, TEAMSPACE_ITEM_TYPE_NAME);
        }
    }

    public static dkCollection getChildren(DKDatastoreICM dsICM, DKDDO folder, DKRetrieveOptionsICM retrieveOptions) throws Exception {
        short id = folder.dataId("ATTR", "DKFolder");
        if (id == 0) {
            throw new Exception("No DKFolder Attribute Found!  DDO is either not a Folder or Folder Contents have not been explicitly retrieved.");
        }
        DKFolder dkFolder = (DKFolder)folder.getData(id);
        dsICM.retrieveObjects((dkCollection)dkFolder, retrieveOptions.dkNVPair());
        return dkFolder;
    }

    public static DKDDO getChild(DKDatastoreICM dsICM, DKDDO parentFolder, String childTypeName, String childName) throws DKUsageError, Exception {
        String queryString = "/*[@ITEMID = \"" + parentFolder.getPidObject().getPrimaryId() + "\"]";
        queryString = queryString + "/OUTBOUNDLINK[@LINKTYPE = \"DKFolder\"]/@TARGETITEMREF =>";
        queryString = queryString + childTypeName + "[@ICM$NAME = \"" + childName + "\"]";
        DKNVPair[] options = new DKNVPair[]{new DKNVPair("MAX_RESULTS", (Object)"1"), new DKNVPair("RETRIEVE_OPTION", (Object)CMDataModel.getBasePlusChildrenRetrieveOptions(dsICM)), new DKNVPair("End", null)};
        DKResults results = (DKResults)dsICM.evaluate(queryString, (short)7, options);
        DKDDO ddo = null;
        if (results.cardinality() > 0) {
            ddo = (DKDDO)results.createIterator().next();
        }
        return ddo;
    }

    public static DKDDO createFolder(DKDatastoreICM dsICM, DKDDO parent, String name, String itemType) throws DKException, Exception {
        DKDDO ddo = dsICM.createDDO(itemType, 2);
        CMDataModel.setHierarchicalAttrs(ddo, parent, name);
        ddo.add();
        return ddo;
    }

    public static void setHierarchicalAttrs(DKDDO ddo, DKDDO parent, String name) throws DKUsageError {
        short dataId = ddo.dataId(CM_ITEM_NAME);
        if (dataId > 0) {
            ddo.setData(dataId, (Object)name);
        }
        ddo.addProperty("PARENT_FOLDER", (Object)parent);
    }

    public static void deleteTree(DKDatastoreICM dsICM, DKDDO folder) throws DKException, Exception {
        dsICM.retrieveObject((dkDataObject)folder, CMDataModel.getBasePlusChildrenRetrieveOptions(dsICM).dkNVPair());
        dkCollection children = CMDataModel.getChildren(dsICM, folder, CMDataModel.getBasePlusChildrenRetrieveOptions(dsICM));
        dkIterator it = children.createIterator();
        while (it.more()) {
            DKDDO child = (DKDDO)it.next();
            short id = child.dataId("ATTR", "DKFolder");
            if (id != 0) {
                CMDataModel.deleteTree(dsICM, child);
                continue;
            }
            child.del();
        }
        folder.del();
    }

    public static void printTree(HttpServletRequest request, DKDatastoreICM dsICM, DKDDO folder, String indent) throws DKUsageError, Exception {
        String methodName = "printTree";
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, indent + "--> " + dsICM.getName(folder) + " [Folder]");
        String newIndent = indent + "  ";
        dkCollection children = CMDataModel.getChildren(dsICM, folder, CMDataModel.getBasePlusChildrenRetrieveOptions(dsICM));
        dkIterator it = children.createIterator();
        while (it.more()) {
            DKDDO child = (DKDDO)it.next();
            short id = child.dataId("ATTR", "DKFolder");
            if (id != 0) {
                CMDataModel.printTree(request, dsICM, child, newIndent);
                continue;
            }
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, newIndent + "--> " + dsICM.getName(child) + " [Doc]");
        }
    }

    public static DKItemTypeDefICM createItemType(HttpServletRequest request, DKDatastoreICM dsICM, String name, boolean hierarchical, PropertyDefinition[] attributeDefs, boolean foldersOnly, boolean itemLevelACL, String defaultACLName, boolean typeItem) throws DKException, Exception {
        String methodName = "createItemType";
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Create item type with name: " + name + "...");
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Create item type with defaultACLName: " + defaultACLName + "...");
        DKDatastoreDefICM dsDef = (DKDatastoreDefICM)dsICM.datastoreDef();
        DKItemTypeDefICM itemType = (DKItemTypeDefICM)dsDef.retrieveEntity(name);
        if (itemType != null) {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "  Item type already exists.");
            return itemType;
        }
        itemType = new DKItemTypeDefICM((dkDatastore)dsICM);
        itemType.setName(name);
        itemType.setDescription(name);
        if (typeItem) {
            itemType.setClassification((short)0);
        } else {
            itemType.setClassification((short)1);
            itemType.setXDOClassName("DKLobICM");
            itemType.setXDOClassID(1);
            itemType.setDefaultRMCode((short)1);
            itemType.setDefaultCollCode((short)1);
        }
        itemType.setHierarchical(hierarchical);
        itemType.setFoldersOnly(foldersOnly);
        if (itemLevelACL) {
            itemType.setItemLevelACLFlag(new Short("1").shortValue());
        } else {
            itemType.setItemLevelACLFlag(new Short("0").shortValue());
        }
        if (defaultACLName != null) {
            itemType.setItemTypeACLName(defaultACLName);
        }
        itemType.setVersionControl((short)0);
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
        for (PropertyDefinition attrDef : attributeDefs) {
            DKAttrDefICM attr = (DKAttrDefICM)dsDefICM.retrieveAttr(attrDef.getName());
            if (attr == null) {
                attr = CMDataModel.defineAttribute(request, dsICM, attrDef.getName(), attrDef.getDescription(), attrDef.getType(), attrDef.getSize(), attrDef.getNullable());
            }
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "adding " + attrDef.getName() + " attribute");
            itemType.addAttr((dkAttrDef)attr);
        }
        itemType.add();
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Created item type: " + name);
        return itemType;
    }

    public static DKAttrDefICM getAttr(HttpServletRequest request, DKDatastoreDefICM dsDef, String name, short type, int size) throws DKException, Exception {
        String methodName = "getAttr";
        DKAttrDefICM attr = null;
        attr = (DKAttrDefICM)dsDef.retrieveAttr(name);
        if (attr == null) {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "  --> Attribute " + name + " does not exist, so create it...");
            attr = (DKAttrDefICM)dsDef.createAttr();
            attr.setName(name);
            attr.setDescription(" " + name);
            attr.setType(type);
            if (size != 0) {
                attr.setSize(size);
            }
            attr.add();
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "  --> Attribute " + name + " created.");
        } else {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "  --> Attribute " + name + " already exists...");
        }
        return attr;
    }

    public static DKRetrieveOptionsICM getBasePlusChildrenRetrieveOptions(DKDatastoreICM dsICM) throws DKUsageError, Exception {
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.linksOutbound(true);
        dkRetrieveOptions.linksTypeFilter("DKFolder");
        dkRetrieveOptions.behaviorIgnoreNoneFoundError(true);
        return dkRetrieveOptions;
    }

    public static DKRetrieveOptionsICM getBasePlusParentRetrieveOptions(DKDatastoreICM dsICM) throws DKUsageError, Exception {
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.linksInbound(true);
        dkRetrieveOptions.linksInboundFolderSources(true);
        dkRetrieveOptions.linksTypeFilter("DKFolder");
        dkRetrieveOptions.behaviorIgnoreNoneFoundError(true);
        return dkRetrieveOptions;
    }

    public static void printException(HttpServletRequest request, DKException exc) {
        String methodName = "printException";
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "X     !!! Exception !!!    X");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "       Name: " + exc.name());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "    Message: " + exc.getMessage());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, " Message ID: " + exc.getErrorId());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "Error State: " + exc.errorState());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, " Error Code: " + exc.errorCode());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)exc);
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "----------------------------------");
    }

    public static void printException(HttpServletRequest request, Exception exc) {
        String methodName = "printStack";
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "X     !!! Exception !!!    X");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "    Name: " + exc.getClass().getName());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, " Message: " + exc.getMessage());
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)exc);
        Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, "----------------------------------");
    }

    public static DKAttrDefICM defineAttribute(HttpServletRequest request, DKDatastoreICM dsICM, String name, String description, short type, int size, boolean nullable) throws DKException, Exception {
        String methodName = "defineAttribute";
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "Defining Attribute '" + name + "'...");
        DKAttrDefICM attr = new DKAttrDefICM((dkDatastore)dsICM);
        attr.setName(name);
        attr.setDescription(description);
        attr.setType(type);
        if (type == 1 || type == 2 || type == 18 || type == 19) {
            attr.setSize(size);
            attr.setNullable(true);
            attr.setMin(0);
        }
        attr.add();
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "Defined Attribute '" + name + "'.");
        return attr;
    }

    public static void deleteAttributes(HttpServletRequest request, DKDatastoreICM dsICM, PropertyDefinition[] attributeDefs) throws DKException, Exception {
        String methodName = "deleteAttributes";
        Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
        try {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
            for (PropertyDefinition attrDef : attributeDefs) {
                DKAttrDefICM attr = (DKAttrDefICM)dsDefICM.retrieveAttr(attrDef.getName());
                Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, attrDef.getName() + " : " + attrDef.getName() + attr);
                if (attr == null) continue;
                Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "removing " + attrDef.getName() + " attribute");
                attr.del();
            }
        }
        catch (Exception e) {
            Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
    }

    public static void deleteItemType(HttpServletRequest request, DKDatastoreICM dsICM, String name, String childName) throws DKException, Exception {
        String methodName = "createItemType";
        try {
            Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "-->Delete item type with name: " + name + "...");
            DKDatastoreDefICM dsDef = (DKDatastoreDefICM)dsICM.datastoreDef();
            DKItemTypeDefICM itemType = (DKItemTypeDefICM)dsDef.retrieveEntity(name);
            if (itemType != null) {
                Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "Found the Item type");
                if (childName != null) {
                    dkEntityDef childCompType = itemType.retrieveSubEntity(childName);
                    Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Delete child component: " + childName + "...");
                    childCompType.del();
                } else {
                    Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "No child data to delete");
                }
                itemType.del();
            } else {
                Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, name + " item type was not found");
            }
        }
        catch (Exception e) {
            Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logDebug(CMDataModel.class, methodName, (ServletRequest)request, "--> Deleted item type: " + name);
    }

    public static void deleteItems(HttpServletRequest request, String queryString, DKDatastoreICM dsICM) throws DKNotExistException, DKException, Exception {
        int count;
        String methodName;
        block8: {
            methodName = "deleteItems";
            Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
            count = 0;
            try {
                if (dsICM == null || !dsICM.isConnected()) {
                    throw new Exception("Not connected to CM database \"");
                }
                Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "Query=" + queryString);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.basePropertyAclName(true);
                dkRetrieveOptions.childListOneLevel(true);
                dkRetrieveOptions.linksTypeFilter("DKFolder");
                DKNVPair[] parms = new DKNVPair[2];
                parms[0] = new DKNVPair("RETRIEVE_OPTION", (Object)new Integer(4));
                parms[0] = new DKNVPair("RETRIEVE_OPTION", (Object)dkRetrieveOptions);
                parms[1] = new DKNVPair("End", null);
                dkResultSetCursor results = dsICM.execute(queryString, (short)7, parms);
                if (!results.isValid()) break block8;
                while (!results.isEnd()) {
                    DKDDO item = results.fetchNext();
                    if (item == null) continue;
                    try {
                        dsICM.checkIn((dkDataObject)item);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    short propID = item.propertyId("semantic-type");
                    Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "semantic type propID=" + propID);
                    if (propID != 0) {
                        Object obj = item.getProperty(propID);
                        Integer semanticType = (Integer)obj;
                        Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "semantic type=" + semanticType);
                        if (semanticType == 2) {
                            Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "trying to cleanup item=" + item.getPidObject().getPrimaryId());
                            CMDataModel.deleteItems(request, CMDataModel.buildFolderContentQueryString(request, item.getPidObject().getPrimaryId(), false), dsICM);
                        }
                    }
                    item.del();
                    ++count;
                }
            }
            catch (Exception e) {
                Logger.logError(CMDataModel.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        Logger.logInfo(CMDataModel.class, methodName, (ServletRequest)request, "Result count=" + count);
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
    }

    private static String buildFolderContentQueryString(HttpServletRequest request, String parentFolderPrimaryId, boolean onlySubfolders) {
        String methodName = "buildFolderContentQueryString";
        Logger.logEntry(CMDataModel.class, methodName, (ServletRequest)request);
        String queryString = "/* [";
        if (onlySubfolders) {
            queryString = queryString + "(@SEMANTICTYPE = 2) AND ";
        }
        queryString = queryString + "(INBOUNDLINK[@LINKTYPE = \"DKFolder\"]/@SOURCEITEMREF = \"" + parentFolderPrimaryId + "\")]";
        Logger.logExit(CMDataModel.class, methodName, (ServletRequest)request);
        return queryString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        CREATE,
        DELETE;

    }

    private static class PropertyDefinition {
        private String name = null;
        private String description = null;
        private short type = 0;
        private int size = 0;
        private boolean unique = false;
        private boolean nullable = true;

        PropertyDefinition(String name, String description, short type, int size, boolean unique, boolean nullable) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.size = size;
            this.unique = unique;
            this.nullable = nullable;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public short getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }

        public boolean getUnique() {
            return this.unique;
        }

        public boolean getNullable() {
            return this.nullable;
        }
    }
}

