/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.dm;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.dkAttrDef;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.servlet.ServletRequest;

public class CMAttrs {
    public static final String NAME_ATTR_NAME = "ICM$NAME";
    public static final String TITLE_ATTR_NAME = "ICM$TITLE";
    public static final String DEFAULT_NAME = "ICM$DEFAULTNAME";

    public static void main(String[] args) throws DKException, Exception {
        String methodName = "main";
        ServletRequest request = null;
        String database = null;
        String userid = null;
        String pw = null;
        String itemTypeName = null;
        String nullableSt = "true";
        String options = "";
        if (args.length < 3) {
            Logger.logDebug(CMAttrs.class, methodName, request, "Usage: ");
            Logger.logDebug(CMAttrs.class, methodName, request, "  java tNexusAttrs <database> <userName> <password> <itemTypeName> <nullable true|false> <connectString>");
            Logger.logDebug(CMAttrs.class, methodName, request, "  *** First three parameters are required, exiting...");
            Logger.logDebug(CMAttrs.class, methodName, request, "");
            return;
        }
        if (args.length > 0) {
            database = args[0];
        }
        if (args.length > 1) {
            userid = args[1];
        }
        if (args.length > 2) {
            pw = args[2];
        }
        if (args.length > 3) {
            itemTypeName = args[3];
        }
        if (args.length > 4) {
            nullableSt = args[4];
        }
        if (args.length > 5) {
            options = args[5];
        }
        DKDatastoreICM ds = new DKDatastoreICM();
        Logger.logDebug(CMAttrs.class, methodName, request, "Connecting to datastore " + database + " with userid: " + userid);
        ds.connect(database, userid, pw, options);
        Logger.logDebug(CMAttrs.class, methodName, request, "Connected to datastore.");
        CMAttrs.createNameAttrIfNeeded(request, ds);
        CMAttrs.createTitleAttrIfNeeded(request, ds);
        if (itemTypeName != null) {
            CMAttrs.addAttrToItemTypeIfNeeded(request, ds, itemTypeName, nullableSt.equals("true"));
        }
        Logger.logDebug(CMAttrs.class, methodName, request, "\nDisconnect from datastore " + database);
        ds.disconnect();
        ds.destroy();
    }

    public static void addAttrToItemTypeIfNeeded(ServletRequest request, DKDatastoreICM ds, String itemTypeName, boolean nullable) throws DKException, Exception {
        String methodName = "addAttrToItemTypeIfNeeded";
        Logger.logDebug(CMAttrs.class, methodName, request, "Item type to create names for: " + itemTypeName);
        DKItemTypeDefICM itemType = CMAttrs.retrieveItemTypeByName(request, ds, itemTypeName);
        if (itemType == null) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Item type specified does not exist!  Exit...\n");
            return;
        }
        if (itemType.getClassification() == 3) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Name attribute may not be added to a Part item type!  Exit...\n");
            return;
        }
        if (itemType.isHierarchical()) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Name attribute may not be added to a Hierarchical item type!  Exit...\n");
            return;
        }
        DKAttrDefICM itAttr = (DKAttrDefICM)itemType.getAttr(NAME_ATTR_NAME);
        if (itAttr == null) {
            boolean ready = CMAttrs.addAttrToItemType(request, ds, itemType, nullable);
            if (!ready) {
                Logger.logDebug(CMAttrs.class, methodName, request, "*** Access module for item type: " + itemTypeName + " is not ready.");
                Logger.logDebug(CMAttrs.class, methodName, request, "    Likely this is because deferred DDL is enabled and the DDL has not be run.");
                Logger.logDebug(CMAttrs.class, methodName, request, "    Please run the DDL and retry running this program.");
                return;
            }
            itemType = CMAttrs.retrieveItemTypeByName(request, ds, itemTypeName);
        } else {
            Logger.logDebug(CMAttrs.class, methodName, request, "The name attribute already exists in the item type.");
        }
    }

    public static void createNameAttrIfNeeded(ServletRequest request, DKDatastoreICM _ds) throws DKException, Exception {
        String methodName = "createNameAttrIfNeeded";
        Logger.logDebug(CMAttrs.class, "", request, "\nLibrary Server version:  " + _ds.getLSVersion());
        Logger.logDebug(CMAttrs.class, "", request, "Library Server database: " + CMAttrs.getLSDbPlatformString(_ds));
        Logger.logDebug(CMAttrs.class, "", request, "\nAPI Version:             " + _ds.getAPIVersion());
        if (!CMAttrs.APIIs843OrHigher(_ds)) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Tool only supports 8.4.3 CM API or higher!  Exit...\n");
            return;
        }
        if (!CMAttrs.serverIs842OrAbove(_ds)) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Tool only supports 8.4.2 CM server or higher!  Exit...\n");
            return;
        }
        DKAttrDefICM nameAttr = CMAttrs.retrieveAttrByName(_ds, NAME_ATTR_NAME);
        if (nameAttr == null) {
            nameAttr = CMAttrs.createNameAttr(request, _ds, NAME_ATTR_NAME, "Name");
        } else {
            Logger.logDebug(CMAttrs.class, methodName, request, "Attribute: ICM$NAME already exists.");
        }
    }

    public static void createTitleAttrIfNeeded(ServletRequest request, DKDatastoreICM _ds) throws DKException, Exception {
        String methodName = "createTitleAttrIfNeeded";
        Logger.logDebug(CMAttrs.class, methodName, request, "\nLibrary Server version:  " + _ds.getLSVersion());
        Logger.logDebug(CMAttrs.class, methodName, request, "Library Server database: " + CMAttrs.getLSDbPlatformString(_ds));
        Logger.logDebug(CMAttrs.class, methodName, request, "\nAPI Version:             " + _ds.getAPIVersion());
        if (!CMAttrs.APIIs843OrHigher(_ds)) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Supports 8.4.3 CM API or higher!  Exit...\n");
            return;
        }
        if (!CMAttrs.serverIs842OrAbove(_ds)) {
            Logger.logDebug(CMAttrs.class, methodName, request, "\n*** Tool only supports 8.4.2 CM server or higher!  Exit...\n");
            return;
        }
        DKAttrDefICM nameAttr = CMAttrs.retrieveAttrByName(_ds, TITLE_ATTR_NAME);
        if (nameAttr == null) {
            nameAttr = CMAttrs.createNameAttr(request, _ds, TITLE_ATTR_NAME, "Title");
        } else {
            Logger.logDebug(CMAttrs.class, methodName, request, "Attribute: ICM$TITLE already exists.");
        }
    }

    private static boolean addAttrToItemType(ServletRequest request, DKDatastoreICM ds, DKItemTypeDefICM itemType, boolean nullable) throws DKException, Exception {
        DKAttrDefICM nameAttr = CMAttrs.retrieveAttrByName(ds, NAME_ATTR_NAME);
        Logger.logDebug(CMAttrs.class, "", request, "Add attribute: ICM$NAME to item type: " + itemType.getName() + " nullable: " + nullable);
        if (nameAttr == null) {
            nameAttr = CMAttrs.createNameAttr(request, ds, NAME_ATTR_NAME, "Name");
        }
        if (nullable) {
            Logger.logDebug(CMAttrs.class, "", request, "  Name attribute will not be nullable.  Default name set to: ICM$DEFAULTNAME");
            nameAttr.setNullable(false);
            nameAttr.setDefaultType((short)6);
            nameAttr.setDefaultValue(DEFAULT_NAME);
        } else {
            nameAttr.setNullable(true);
        }
        if (CMAttrs.serverIs843Ga(ds) || CMAttrs.APIIsBelow843FixPack1(ds)) {
            CMAttrs.addAttrToItemTypeWithSql(request, ds, itemType, nameAttr);
        } else {
            itemType.addAttr((dkAttrDef)nameAttr);
            itemType.update();
        }
        Logger.logDebug(CMAttrs.class, "", request, "  Add attribute committed.");
        return CMAttrs.itemTypeIsReady(request, itemType, 30);
    }

    /*
     * Loose catch block
     */
    private static void addAttrToItemTypeWithSql(ServletRequest request, DKDatastoreICM ds, DKItemTypeDefICM itemType, DKAttrDefICM nameAttr) throws DKException, Exception {
        block19: {
            Statement stmt;
            Connection conn;
            block18: {
                conn = null;
                stmt = null;
                Logger.logDebug(CMAttrs.class, "", request, "Adding attribute directly with SQL...");
                conn = CMAttrs.getConnectionFromDs(ds);
                int compTypeId = itemType.getComponentTypeId();
                short sequenceNum = 1;
                String sql = "SELECT MAX(SEQUENCENUM) FROM " + CMAttrs.getSchema(ds) + "ICMSTCOMPATTRS WHERE COMPONENTTYPEID = ?";
                Logger.logDebug(CMAttrs.class, "", request, "Get sequence number sql: " + sql);
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, compTypeId);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    sequenceNum = rs.getShort(1);
                }
                rs.close();
                stmt.close();
                sequenceNum = (short)(sequenceNum + 1);
                if (sequenceNum <= 0) {
                    sequenceNum = 1;
                }
                sql = "INSERT INTO " + CMAttrs.getSchema(ds) + "ICMSTCOMPATTRS (COMPONENTTYPEID, ATTRIBUTEID, ATTRIBUTEGROUP, SEQUENCENUM, " + "ATTRFLAGS, DEFAULTTYPE, MINIMUMVALUE, MAXIMUMVALUE, DEFAULTVALUE)" + "VALUES (?,?,0,?,?,?,0,0,?)";
                Logger.logDebug(CMAttrs.class, "", request, "Insert into comp attrs...");
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, compTypeId);
                stmt.setInt(2, nameAttr.getIntId());
                stmt.setShort(3, sequenceNum);
                stmt.setShort(4, nameAttr.getAttrFlag());
                stmt.setShort(5, nameAttr.getDefaultType());
                if (!nameAttr.isNullable()) {
                    stmt.setString(6, DEFAULT_NAME);
                } else {
                    stmt.setString(6, null);
                }
                stmt.executeUpdate();
                stmt.close();
                sql = "INSERT INTO " + CMAttrs.getSchema(ds) + "ICMSTCOMPVIEWATTRS (COMPONENTVIEWID,ATTRIBUTEID,ATTRIBUTEGROUP,SEQUENCENUM," + "ATTRIBUTEFLAGS,VIEWOPERATOR,VIEWCOMPAREVALUE)" + "VALUES (?,?,0,?,3,0,' ')";
                Logger.logDebug(CMAttrs.class, "", request, "Insert into comp veiw attrs...");
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, compTypeId);
                stmt.setInt(2, nameAttr.getIntId());
                stmt.setShort(3, sequenceNum);
                stmt.executeUpdate();
                stmt.close();
                sql = "ALTER TABLE " + CMAttrs.getUTTableName(itemType) + " ADD " + CMAttrs.getAttrColumn(ds, itemType, nameAttr);
                if (ds.getDBType() == 1) {
                    sql = sql + " VARCHAR2(256) ";
                    if (!nameAttr.isNullable()) {
                        sql = sql + "DEFAULT 'ICM$DEFAULTNAME' NOT NULL";
                    }
                } else {
                    sql = sql + " VARCHAR(256) ";
                    if (!nameAttr.isNullable()) {
                        sql = sql + "NOT NULL DEFAULT 'ICM$DEFAULTNAME'";
                    }
                }
                Logger.logDebug(CMAttrs.class, "", request, "Alter table to add column for the attr...");
                stmt = conn.prepareStatement(sql);
                stmt.executeUpdate();
                stmt.close();
                sql = "UPDATE " + CMAttrs.getSchema(ds) + "ICMSTITEMTYPEDEFS SET CHANGED=? WHERE ITEMTYPEID =?";
                Logger.logDebug(CMAttrs.class, "", request, "Update item type defs changed timestamp: " + sql);
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                stmt = conn.prepareStatement(sql);
                stmt.setTimestamp(1, ts);
                stmt.setInt(2, itemType.getIntId());
                stmt.executeUpdate();
                stmt.close();
                sql = "UPDATE " + CMAttrs.getSchema(ds) + "ICMSTCOMPVIEWDEFS SET ACCESSMODULESTATUS = -1 WHERE COMPONENTVIEWID =?";
                Logger.logDebug(CMAttrs.class, "", request, "Mark component invalid sql to regen access module: " + sql);
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, compTypeId);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                CMAttrs.releaseConnectionFromDs(ds);
                conn = null;
                Logger.logDebug(CMAttrs.class, "", request, "Rebuild comp type...");
                DKDatastoreDefICM dsDef = (DKDatastoreDefICM)ds.datastoreDef();
                dsDef.rebuildComponentType(itemType.getName());
                dsDef.clearCache();
                Object var13_13 = null;
                if (stmt == null) break block18;
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (conn != null) {
                CMAttrs.releaseConnectionFromDs(ds);
            }
            break block19;
            {
                catch (Exception e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    CMAttrs.releaseConnectionFromDs(ds);
                }
                throw throwable;
            }
        }
    }

    private static DKItemTypeDefICM retrieveItemTypeByName(ServletRequest request, DKDatastoreICM ds, String itemTypeName) throws DKException, Exception {
        DKItemTypeDefICM itemType = null;
        DKDatastoreDefICM dsDef = (DKDatastoreDefICM)ds.datastoreDef();
        dkEntityDef ent = dsDef.retrieveEntity(itemTypeName);
        if (ent instanceof DKItemTypeDefICM) {
            itemType = (DKItemTypeDefICM)ent;
        } else if (ent != null) {
            Logger.logDebug(CMAttrs.class, "", request, "The item type name specified: " + itemTypeName + "is not valid because it is a view and not an item type.");
        }
        return itemType;
    }

    public static boolean itemTypeIsReady(ServletRequest request, DKItemTypeDefICM itemType, int timeoutSecs) throws DKException, Exception {
        Logger.logDebug(CMAttrs.class, "", request, "Check access module status with timeout of " + timeoutSecs + ".");
        long timeElapsed = 0L;
        DKDatastoreDefICM dsDef = (DKDatastoreDefICM)itemType.getDatastore().datastoreDef();
        short status = dsDef.getAccessModuleStatus(itemType.getIntId(), -1);
        while (status == -1) {
            if (timeElapsed > (long)timeoutSecs) {
                return false;
            }
            Logger.logDebug(CMAttrs.class, "", request, "  Item type is not ready, wait 5 seconds and try again...");
            Thread.sleep(5000L);
            timeElapsed += 5L;
            status = dsDef.getAccessModuleStatus(itemType.getIntId(), -1);
        }
        return true;
    }

    private static String getUTTableName(DKItemTypeDefICM itemType) throws DKException, Exception {
        DKDatastoreICM ds = (DKDatastoreICM)itemType.getDatastore();
        int compID = itemType.getComponentTypeId();
        String cs = Integer.toString(compID);
        if (cs.length() < 5) {
            cs = "0000" + cs;
            cs = cs.substring(cs.length() - 5);
        }
        return CMAttrs.getSchema(ds) + "ICMUT" + cs + "001";
    }

    private static String getAttrColumn(DKDatastoreICM ds, DKItemTypeDefICM itemType, DKAttrDefICM attr) throws DKException, Exception {
        String columnName = null;
        if (attr == null) {
            if (ds.getDBType() == 0 && ds.platform() == 3) {
                return "NULLIF(0 , 0)";
            }
            return "cast(NULL as CHAR)";
        }
        int attrId = attr.getIntId();
        if (attrId < 1000) {
            columnName = attr.getName();
        } else {
            int aID = attrId & 0xFFFF;
            int gID = attrId >> 16;
            if (gID > 0 && gID < 1000) {
                columnName = attr.getName();
            } else {
                String as;
                String gs = Integer.toString(gID);
                if (gs.length() < 5) {
                    gs = "0000" + gs;
                    gs = gs.substring(gs.length() - 5);
                }
                if ((as = Integer.toString(aID)).length() < 5) {
                    as = "0000" + as;
                    as = as.substring(as.length() - 5);
                }
                columnName = "ATTR" + gs + as;
            }
        }
        return columnName;
    }

    /*
     * Loose catch block
     */
    private static DKAttrDefICM createNameAttr(ServletRequest request, DKDatastoreICM ds, String name, String desc) throws Exception {
        boolean commitWork;
        DKAttrDefICM nameAttr;
        String methodName;
        block48: {
            SQLException e222;
            ResultSet rs;
            Statement stmtInsertAttrdefs;
            Statement stmtInsertKeyword;
            Statement stmtUpdateMaxKeword;
            Statement stmtQueryKeyword;
            boolean autoCommit;
            Connection conn;
            block42: {
                block41: {
                    methodName = "createNameAttr";
                    conn = CMAttrs.getConnectionFromDs(ds);
                    nameAttr = null;
                    boolean alreadyExists = false;
                    autoCommit = true;
                    commitWork = false;
                    stmtQueryKeyword = null;
                    stmtUpdateMaxKeword = null;
                    stmtInsertKeyword = null;
                    stmtInsertAttrdefs = null;
                    rs = null;
                    autoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    String sqlQueryKeyword = "SELECT COUNT(1) FROM " + CMAttrs.getSchema(ds) + "ICMSTNLSKEYWORDS WHERE LANGUAGECODE='ENU' AND " + " KEYWORDCLASS=1 AND KEYWORDNAME='" + name + "'";
                    stmtQueryKeyword = conn.prepareStatement(sqlQueryKeyword);
                    stmtQueryKeyword.setFetchSize(1);
                    stmtQueryKeyword.setMaxRows(1);
                    rs = stmtQueryKeyword.executeQuery();
                    if (rs.next()) {
                        boolean bl = alreadyExists = 1 == rs.getInt(1);
                    }
                    if (alreadyExists) break block41;
                    String sqlUpdateMaxKeword = "UPDATE " + CMAttrs.getSchema(ds) + "ICMSTMAXKEYWORD SET MAXKEYWORD =" + " (SELECT (CASE WHEN 1000>MAX(MAXKEYWORD)+1 THEN 1000 ELSE max(MAXKEYWORD)+1 END)" + " FROM " + CMAttrs.getSchema(ds) + "ICMSTMAXKEYWORD WHERE KEYWORDCLASS=1) " + " WHERE KEYWORDCLASS=1 AND NOT EXISTS " + " (SELECT 1 FROM " + CMAttrs.getSchema(ds) + "ICMSTNLSKEYWORDS B WHERE B.LANGUAGECODE = 'ENU' AND " + " B.KEYWORDCLASS = 1 AND B.KEYWORDNAME = '" + name + "')";
                    Logger.logDebug(CMAttrs.class, methodName, request, "SQL: " + sqlUpdateMaxKeword);
                    stmtUpdateMaxKeword = conn.prepareStatement(sqlUpdateMaxKeword);
                    if (stmtUpdateMaxKeword.executeUpdate() <= 0) break block41;
                    String sqlInsertKeyword = " INSERT INTO " + CMAttrs.getSchema(ds) + "ICMSTNLSKEYWORDS (KEYWORDCLASS, LANGUAGECODE, KEYWORDCODE," + " KEYWORDNAME, KEYWORDDESCRIPTION) SELECT 1, LANGUAGECODE, (SELECT MAXKEYWORD " + " FROM " + CMAttrs.getSchema(ds) + "ICMSTMAXKEYWORD WHERE keywordclass=1 and languagecode = 'ENU'), '" + name + "',  CASE WHEN " + " LANGUAGECODE='ENU' THEN '' ELSE '*' END || '" + desc + "' FROM " + CMAttrs.getSchema(ds) + "ICMSTNLSLANGUAGES A  " + " WHERE NOT EXISTS (SELECT 1 FROM " + CMAttrs.getSchema(ds) + "ICMSTNLSKEYWORDS B WHERE B.LANGUAGECODE = 'ENU' " + " AND B.KEYWORDCLASS = 1 AND B.KEYWORDNAME = '" + name + "')";
                    Logger.logDebug(CMAttrs.class, methodName, request, "SQL: " + sqlInsertKeyword);
                    stmtInsertKeyword = conn.prepareStatement(sqlInsertKeyword);
                    if (stmtInsertKeyword.executeUpdate() <= 0) break block41;
                    String sqlInsertAttrdefs = "INSERT INTO " + CMAttrs.getSchema(ds) + "ICMSTATTRDEFS (ATTRIBUTEID, ATTRSQLTYPE, ATTRLENGTH, ATTRSCALE, ATTRFLAGS)" + " SELECT KEYWORDCODE, 448, 256, 0, 0 FROM " + CMAttrs.getSchema(ds) + "ICMSTNLSKEYWORDS A WHERE " + " LANGUAGECODE = 'ENU' AND KEYWORDCLASS = 1 AND KEYWORDNAME = '" + name + "' AND" + " NOT EXISTS (SELECT 1 FROM " + CMAttrs.getSchema(ds) + "ICMSTATTRDEFS B WHERE A.KEYWORDCODE = B. ATTRIBUTEID AND" + " A.KEYWORDCLASS = 1 AND A.KEYWORDNAME = '" + name + "')";
                    Logger.logDebug(CMAttrs.class, methodName, request, "SQL: " + sqlInsertAttrdefs);
                    stmtInsertAttrdefs = conn.prepareStatement(sqlInsertAttrdefs);
                    if (stmtInsertAttrdefs.executeUpdate() <= 0) break block41;
                    commitWork = true;
                }
                Object var21_19 = null;
                if (rs == null) break block42;
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (stmtQueryKeyword != null) {
                try {
                    stmtQueryKeyword.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (stmtUpdateMaxKeword != null) {
                try {
                    stmtUpdateMaxKeword.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (stmtInsertKeyword != null) {
                try {
                    stmtInsertKeyword.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (stmtInsertAttrdefs != null) {
                try {
                    stmtInsertAttrdefs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (commitWork) {
                conn.commit();
            } else {
                try {
                    conn.rollback();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            try {
                conn.setAutoCommit(autoCommit);
                break block48;
            }
            catch (SQLException e222) {
                // empty catch block
            }
            {
                break block48;
                catch (SQLException e3) {
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (stmtQueryKeyword != null) {
                    try {
                        stmtQueryKeyword.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (stmtUpdateMaxKeword != null) {
                    try {
                        stmtUpdateMaxKeword.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (stmtInsertKeyword != null) {
                    try {
                        stmtInsertKeyword.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (stmtInsertAttrdefs != null) {
                    try {
                        stmtInsertAttrdefs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (commitWork) {
                    conn.commit();
                } else {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e222) {
                    // empty catch block
                }
                CMAttrs.releaseConnectionFromDs(ds);
                throw throwable;
            }
        }
        CMAttrs.releaseConnectionFromDs(ds);
        nameAttr = CMAttrs.retrieveAttrByName(ds, name);
        if (nameAttr == null) {
            throw new Exception("Could not retrieve or create" + name + "attribute");
        }
        if (commitWork) {
            Logger.logDebug(CMAttrs.class, methodName, request, "Attribute: " + name + " created.");
        }
        return nameAttr;
    }

    private static Connection getConnectionFromDs(DKDatastoreICM ds) throws DKException, Exception {
        ds.startTransaction();
        return (Connection)ds.handle("ICM").handle();
    }

    private static void releaseConnectionFromDs(DKDatastoreICM ds) throws DKException, Exception {
        ds.commit();
    }

    private static DKAttrDefICM retrieveAttrByName(DKDatastoreICM ds, String attrName) throws DKException, Exception {
        DKAttrDefICM attr = null;
        DKDatastoreDefICM dsDef = (DKDatastoreDefICM)ds.datastoreDef();
        attr = (DKAttrDefICM)dsDef.retrieveAttr(attrName);
        return attr;
    }

    public static String getSchema(DKDatastoreICM ds) throws Exception {
        String schema = ds.schemaName().trim();
        if (!schema.equals("")) {
            schema = schema + ".";
        }
        return schema;
    }

    public static String getLSDbPlatformString(DKDatastoreICM ds) throws Exception {
        String platString = null;
        try {
            Connection conn = CMAttrs.getConnectionFromDs(ds);
            platString = ds.getDBType() == 0 ? "DB2 on " : "Oracle on ";
            if (ds.platform() == 0) {
                platString = platString + "Windows";
            }
            if (ds.platform() == 1) {
                platString = platString + "AIX";
            }
            if (ds.platform() == 2) {
                platString = platString + "Solaris";
            }
            if (ds.platform() == 3) {
                platString = platString + "z/OS";
            }
            if (ds.platform() == 4) {
                platString = platString + "Linux";
            }
            if (ds.platform() == 5) {
                platString = platString + "iSeries";
            }
            if (ds.platform() == 6) {
                platString = platString + "HP";
            }
            if (ds.platform() == 7) {
                platString = platString + "Solaris x86";
            }
            if (ds.platform() == 8) {
                platString = platString + "HP IA64";
            }
            if (ds.platform() == 9) {
                platString = platString + "zLinux";
            }
            platString = platString + " - version: " + conn.getMetaData().getDatabaseProductVersion();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            CMAttrs.releaseConnectionFromDs(ds);
            throw throwable;
        }
        CMAttrs.releaseConnectionFromDs(ds);
        return platString;
    }

    private static boolean serverIs842OrAbove(DKDatastoreICM ds) {
        String lsVersion = ds.getLSVersion();
        return lsVersion.compareTo("8.4.02.000") >= 0;
    }

    private static boolean serverIsBelow843(DKDatastoreICM ds) {
        String lsVersion = ds.getLSVersion();
        return lsVersion.compareTo("8.4.03.000") < 0;
    }

    private static boolean serverIs843Ga(DKDatastoreICM ds) {
        String lsVersion = ds.getLSVersion();
        return lsVersion.equals("8.4.03.000");
    }

    private static boolean APIIs843OrHigher(DKDatastoreICM ds) {
        String apiVersion = ds.getAPIVersion();
        return apiVersion.compareTo("8.4.3.000") >= 0;
    }

    private static boolean APIIsBelow843FixPack1(DKDatastoreICM ds) {
        String apiVersion = ds.getAPIVersion();
        return apiVersion.compareTo("8.4.3.100") < 0;
    }
}

