/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.RecentSearchConfig;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserConfig
extends ConfigurationObject {
    private static final String FAVORITES = "favorites";
    private static final String RECENT_SEARCHES = "recentSearches";
    public static final int FAVORITE_CAP = 100;
    public static final int RECENT_SEARCH_CAP = 10;

    @Override
    public String getObjectType() {
        return "user";
    }

    public UserConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type != null) {
            if (type.equals(FAVORITES)) {
                return this.getFavoriteList();
            }
            if (type.equals(RECENT_SEARCHES)) {
                return this.getRecentSearchList();
            }
        }
        return super.getList(type, appName, request);
    }

    public String[] getFavoritesId() {
        return this.stringToArray(this.properties.getProperty(FAVORITES));
    }

    public void setFavoritesId(String[] favorites) {
        this.properties.setProperty(FAVORITES, this.arrayToString(favorites));
    }

    public Collection<FavoriteConfig> getFavoriteList() {
        return this.getFavoritesMap().values();
    }

    public boolean isFavorteMax() {
        return this.getFavoriteList().size() >= 100;
    }

    public Map<String, FavoriteConfig> getFavoritesMap() {
        return this.getMap(FavoriteConfig.class, this.getIdPrefix(), this.getFavoritesId(), true);
    }

    public boolean isRecentSearchMax() {
        return this.getRecentSearchList().size() >= 10;
    }

    public Collection<RecentSearchConfig> getRecentSearchList() {
        LinkedList<RecentSearchConfig> recentSearches;
        block8: {
            recentSearches = null;
            String value = this.properties.getProperty(RECENT_SEARCHES);
            if (value == null) break block8;
            if (value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
                JSONArray jsonArray;
                try {
                    jsonArray = (JSONArray)JSON.parse(value);
                }
                catch (Exception e) {
                    Logger.logError(UserConfig.class, "getRecentSearchList", "Unable to parse recent searches", (Throwable)e);
                    return null;
                }
                Iterator i = jsonArray.iterator();
                recentSearches = new LinkedList<RecentSearchConfig>();
                while (i.hasNext()) {
                    RecentSearchConfig recentSearchConfig = new RecentSearchConfig(this.getConfigurationObject(), this.getIdPrefix(), null);
                    recentSearchConfig.setValues((JSONObject)i.next());
                    recentSearches.add(recentSearchConfig);
                }
            } else {
                try {
                    String[] idArray;
                    for (String id : idArray = this.stringToArray(value)) {
                        RecentSearchConfig config = Config.getConfiguration(RecentSearchConfig.class, this.getIdPrefix(), id, new boolean[0]);
                        config.delete();
                        Config.removeConfigurationFromCache(config);
                    }
                    this.properties.remove(RECENT_SEARCHES);
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return recentSearches;
    }

    public void addRecentSearch(RecentSearchConfig recentSearchConfig) {
        JSONArray jsonArray = new JSONArray();
        Collection<RecentSearchConfig> recentSearches = this.getRecentSearchList();
        if (recentSearches != null) {
            for (RecentSearchConfig currRecentSearchConfig : recentSearches) {
                if (recentSearchConfig.equals(currRecentSearchConfig)) continue;
                jsonArray.add(currRecentSearchConfig.toJSON());
                if (jsonArray.size() != 10) continue;
                jsonArray.remove(0);
            }
        }
        jsonArray.add(recentSearchConfig.toJSON());
        this.setProperty(RECENT_SEARCHES, jsonArray.toString());
    }

    @Override
    protected String propertiesToString(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            stringBuffer.append(key);
            stringBuffer.append("=");
            if (key.equals(RECENT_SEARCHES)) {
                value = this.encodeJSON(value);
            }
            stringBuffer.append(value);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    @Override
    protected void removeValuesFromList(String key, List<String> deleteValues, Properties props) {
        if (RECENT_SEARCHES.equals(key)) {
            Collection<RecentSearchConfig> recentSearches = this.getRecentSearchList();
            if (recentSearches != null) {
                JSONArray jsonArray = new JSONArray();
                HashSet<String> idSet = new HashSet<String>(deleteValues);
                for (RecentSearchConfig recentSearchConfig : recentSearches) {
                    if (idSet.contains(recentSearchConfig.getTemplateId()) || recentSearchConfig.getVsId() != null && idSet.contains(recentSearchConfig.getVsId())) continue;
                    jsonArray.add(recentSearchConfig.toJSON());
                }
                if (jsonArray.size() < recentSearches.size()) {
                    this.setProperty(RECENT_SEARCHES, jsonArray.toString());
                }
            }
        } else {
            super.removeValuesFromList(key, deleteValues, props);
        }
    }

    private String encodeJSON(String json) {
        int length = json.length();
        char[] chars = new char[length * 2];
        int charCount = 0;
        block0: for (int i = 0; i < length; ++i) {
            char c = json.charAt(i);
            chars[charCount++] = c;
            if (c != '\\') continue;
            char nextChar = json.charAt(i + 1);
            if (nextChar == 'u') {
                for (int j = 0; j < 4; ++j) {
                    c = json.charAt(i + 2 + j);
                    if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f' || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F') continue;
                    chars[charCount++] = 117;
                    chars[charCount++] = 48;
                    chars[charCount++] = 48;
                    chars[charCount++] = 53;
                    chars[charCount++] = 99;
                    continue block0;
                }
                continue;
            }
            if (nextChar == '\"') {
                chars[charCount++] = 117;
                chars[charCount++] = 48;
                chars[charCount++] = 48;
                chars[charCount++] = 50;
                chars[charCount++] = 50;
                ++i;
                continue;
            }
            chars[charCount++] = 117;
            chars[charCount++] = 48;
            chars[charCount++] = 48;
            chars[charCount++] = 53;
            chars[charCount++] = 99;
            if (json.charAt(i + 1) != '\\') continue;
            ++i;
        }
        return PropertyConverter.escapeListDelimiter((String)new String(chars, 0, charCount), (char)';');
    }
}

