/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.InterfaceTextLocaleConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsConfig
extends ConfigurationObject {
    private static final String LOGGING_LEVEL = "logging.level";
    private static final String LOGGING_CLASS_INCLUDES = "logging.class.includes";
    private static final String LOGGING_CLASS_EXCLUDES = "logging.class.excludes";
    private static final String LOGGING_DEBUG_USERS = "logging.debug.users";
    private static final String LOGGING_DEBUG_HOSTS = "logging.debug.hosts";
    private static final String DISABLE_AUTOCOMPLETE = "disableAutocomplete";
    private static final String CULTURAL_COLLATION = "culturalCollation";
    private static final String ADMIN_USERS = "adminUsers";
    private static final String ICON_STATUS = "iconStatus";
    private static final String OD_LANGUAGE = "odLanguage";
    private static final String OD_TEMPDIR = "odTempdir";
    private static final String OD_TRACEDIR = "odTracedir";
    private static final String OD_TRACELEVEL = "odTracelevel";
    private static final String OD_MAX_TRACE_FILESIZE = "odMaxTraceFilesize";
    private static final String OD_AFP2PDF_INSTALLDIR = "odAfp2pdfInstalldir";
    private static final String OD_CUSTOM_PROPS = "odCustomProperties";
    public static final String FILE_TYPES = "fileTypes";
    public static final String USER_ACTION_MACROS = "userActionMacros";

    public SettingsConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    public String getObjectType() {
        return "settings";
    }

    public String getLoggingClassIncludes() {
        return this.properties.getProperty(LOGGING_CLASS_INCLUDES, "");
    }

    public void setLoggingClassIncludes(String loggingClassIncludes) {
        this.properties.setProperty(LOGGING_CLASS_INCLUDES, loggingClassIncludes);
    }

    public String getLoggingClassExcludes() {
        return this.properties.getProperty(LOGGING_CLASS_EXCLUDES, "");
    }

    public void setLoggingClassExcludes(String loggingClassExcludes) {
        this.properties.setProperty(LOGGING_CLASS_EXCLUDES, loggingClassExcludes);
    }

    public String getLoggingDebugUsers() {
        return this.properties.getProperty(LOGGING_DEBUG_USERS, "");
    }

    public void setLoggingDebugUsers(String loggingDebugUsers) {
        this.properties.setProperty(LOGGING_DEBUG_USERS, loggingDebugUsers);
    }

    public String getLoggingDebugHosts() {
        return this.properties.getProperty(LOGGING_DEBUG_HOSTS, "");
    }

    public void setLoggingDebugHosts(String loggingDebugHosts) {
        this.properties.setProperty(LOGGING_DEBUG_HOSTS, loggingDebugHosts);
    }

    public int getLoggingLevel() {
        return Integer.parseInt(this.properties.getProperty(LOGGING_LEVEL, "2"));
    }

    public void setLoggingLevel(int loggingLevel) {
        this.properties.setProperty(LOGGING_LEVEL, Integer.toString(loggingLevel));
    }

    public boolean getDisableAutocomplete() {
        return Boolean.parseBoolean(this.properties.getProperty(DISABLE_AUTOCOMPLETE, "false"));
    }

    public void setDisableAutocomplete(boolean disableAutocomplete) {
        this.properties.setProperty(DISABLE_AUTOCOMPLETE, Boolean.toString(disableAutocomplete));
    }

    public boolean getCulturalCollation() {
        return Boolean.parseBoolean(this.properties.getProperty(CULTURAL_COLLATION, "false"));
    }

    public void setCulturalCollation(boolean culturalCollation) {
        this.properties.setProperty(CULTURAL_COLLATION, Boolean.toString(culturalCollation));
    }

    public String[] getIconStatusId() {
        return this.stringToArray(this.properties.getProperty(ICON_STATUS));
    }

    public Collection<IconStatusConfig> getIconStatusList() {
        return this.getMap(IconStatusConfig.class, this.getIdPrefix(), this.getIconStatusId(), true).values();
    }

    public String getODLanguage() {
        return this.properties.getProperty(OD_LANGUAGE, "");
    }

    public void setODLanguage(String language) {
        this.properties.setProperty(OD_LANGUAGE, language);
    }

    public String getODTempdir() {
        return this.properties.getProperty(OD_TEMPDIR, "");
    }

    public void setODTempdir(String tempdir) {
        this.properties.setProperty(OD_TEMPDIR, tempdir);
    }

    public String getODTracedir() {
        return this.properties.getProperty(OD_TRACEDIR, "");
    }

    public void setODTracedir(String tracedir) {
        this.properties.setProperty(OD_TRACEDIR, tracedir);
    }

    public String getODTracelevelString() {
        return this.properties.getProperty(OD_TRACELEVEL, "1");
    }

    public int getODTracelevel() {
        return Integer.parseInt(this.properties.getProperty(OD_TRACELEVEL, "1"));
    }

    public void setODTracelevel(int tracelevel) {
        this.properties.setProperty(OD_TRACELEVEL, Integer.toString(tracelevel));
    }

    public String getODMaxTraceFilesizeString() {
        return this.properties.getProperty(OD_MAX_TRACE_FILESIZE, "0");
    }

    public int getODMaxTraceFilesize() {
        return Integer.parseInt(this.properties.getProperty(OD_MAX_TRACE_FILESIZE, "0"));
    }

    public void setODMaxTraceFilesize(int maxTraceFilesize) {
        this.properties.setProperty(OD_MAX_TRACE_FILESIZE, Integer.toString(maxTraceFilesize));
    }

    public String getODAfp2pdfInstalldir() {
        return this.properties.getProperty(OD_AFP2PDF_INSTALLDIR, "");
    }

    public void setODAfp2pdfInstalldir(String afp2pdfInstalldir) {
        this.properties.setProperty(OD_AFP2PDF_INSTALLDIR, afp2pdfInstalldir);
    }

    public String getCustomProperties() {
        return this.properties.getProperty(OD_CUSTOM_PROPS, "");
    }

    public void setCustomProperties(String customProps) {
        this.properties.setProperty(OD_CUSTOM_PROPS, customProps);
    }

    public String[] getAdminUsers() {
        return this.stringToArray(this.properties.getProperty(ADMIN_USERS));
    }

    public void setAdminUsers(String[] adminUsers) {
        this.properties.setProperty(ADMIN_USERS, this.arrayToString(adminUsers));
    }

    public List<String> getAdminUsersList() {
        return this.stringToList(this.properties.getProperty(ADMIN_USERS));
    }

    public String[] getFileTypes() {
        return this.stringToArray(this.properties.getProperty(FILE_TYPES, "word, excel, powerpoint, outlook, pdf"));
    }

    public String[] getFilterredFileType() {
        String fileTypes = this.properties.getProperty(FILE_TYPES);
        if (fileTypes != null && fileTypes.length() > 4) {
            fileTypes = fileTypes.replaceAll("word,", "").trim();
            fileTypes = fileTypes.replaceAll("excel,", "").trim();
            fileTypes = fileTypes.replaceAll("powerpoint,", "").trim();
            fileTypes = fileTypes.replaceAll("outlook,", "").trim();
            fileTypes = fileTypes.replaceAll("pdf,", "").trim();
        }
        return this.stringToArray(fileTypes);
    }

    public void setFileTypes(String[] fileTypes) {
        this.properties.setProperty(FILE_TYPES, this.arrayToString(fileTypes));
    }

    public static String getLocalizedFileTypeLabel(FileTypeConfig fileTypeConfig, Locale locale) {
        String label = fileTypeConfig.getName();
        String id = fileTypeConfig.getObjectId();
        InterfaceTextConfig config = null;
        try {
            config = Config.getInterfaceTextConfig("navigator", id);
        }
        catch (Exception e) {
            return label;
        }
        if (!config.isEmpty() && config.getLocaleData() != null) {
            InterfaceTextLocaleConfig localeConfig = config.getLocaleData();
            if (localeConfig.properties.get(locale.toString()) != null) {
                label = (String)localeConfig.properties.get(locale.toString());
            } else if (localeConfig.properties.get(locale.toString().substring(0, 2)) != null) {
                label = (String)localeConfig.properties.get(locale.toString().substring(0, 2));
            }
        }
        return label;
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        return type.equals(FILE_TYPES) ? this.getFileTypesList(appName) : (type.equals(USER_ACTION_MACROS) ? this.getUserActionMacrosList(appName) : null);
    }

    public Collection<FileTypeConfig> getFileTypesList(String appName) {
        return this.getFileTypesMap(appName).values();
    }

    public Map<String, FileTypeConfig> getFileTypesMap(String appName) {
        return this.getMacrosMap(appName, FileTypeConfig.class);
    }

    public String[] getUserActionMacros() {
        return this.stringToArray(this.properties.getProperty(USER_ACTION_MACROS, "added.p8, modified.p8, checkedOut.p8, added.cm, modified.cm, checkedOut.cm"));
    }

    public void setUserActionMacros(String[] userActionMacros) {
        this.properties.setProperty(USER_ACTION_MACROS, this.arrayToString(userActionMacros));
    }

    public Collection<UserActionMacroConfig> getUserActionMacrosList(String appName) {
        return this.getUserActionMacrosMap(appName).values();
    }

    public Map<String, UserActionMacroConfig> getUserActionMacrosMap(String appName) {
        return this.getMacrosMap(appName, UserActionMacroConfig.class);
    }

    public <T extends ConfigurationObject> String[] getMacros(Class<T> configClass) {
        String[] macros = null;
        if (configClass == FileTypeConfig.class) {
            macros = this.getFileTypes();
        } else if (configClass == UserActionMacroConfig.class) {
            macros = this.getUserActionMacros();
        }
        return macros;
    }

    public <T extends ConfigurationObject> Map<String, T> getMacrosMap(String appName, Class<T> configClass) {
        if (appName == null || appName.isEmpty()) {
            appName = "navigator";
        }
        Map<String, T> configMap = this.getMap(configClass, appName, this.getMacros(configClass), true);
        for (ConfigurationObject config : configMap.values()) {
            if (!config.isEmpty()) continue;
            configMap = this.getMap(configClass, "navigator.default", this.getMacros(configClass), true);
            break;
        }
        return configMap;
    }
}

