/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.ConfigurationValidation;
import com.ibm.ecm.configuration.ODLoginConfig;
import com.ibm.ecm.configuration.PropertyMappingConfig;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.PasswordEncrypter;
import com.ibm.edms.od.ODConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfig
extends ConfigurationObject
implements ConfigurationValidation {
    private static final String INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS = "includeMIMETypesInSearchResults";
    private static final String PDF_CONVERSION = "pdfConversion";
    private static final String KEEP_IN_AUTO_FOLDER = "keepInAutoFolder";
    private static final String UPDATE_STORAGE_COLLECTION = "updateStorageCollection";
    private static final String MAX_WORKLISTS = "maxWorklists";
    private static final String MAX_ITEM_TYPES = "maxItemTypes";
    private static final String LANGUAGE_CODES = "languageCodes";
    private static final String ROOT_FOLDER_ID = "rootFolderId";
    private static final String FOLDERING_ENABLED = "folderingEnabled";
    private static final String UNIFIED_SEARCHES_ENABLED = "unifiedSearchesEnabled";
    private static final String SEARCH_MAX_RESULTS = "searchMaxResults";
    private static final String TIMEOUT_IN_SECONDS = "timeoutInSeconds";
    private static final String MATCH_ALL = "matchAll";
    private static final String USE_SSO = "useSSO";
    private static final String DIRECT_RETRIEVE_ENABLED = "directRetrieveEnabled";
    private static final String CONNECTION_POINT = "connectionPoint";
    private static final String OBJECT_STORE = "objectStore";
    private static final String OBJECT_STORE_DISPLAY_NAME = "objectStoreName";
    private static final String PROTOCOL = "protocol";
    private static final String CMIS_REPOSITORY_ID = "cmisRepositoryID";
    private static final String USE_GZIP_ENCODING = "useGzipEncoding";
    private static final String ADD_AS_MAJOR_VERSION = "addAsMajorVersion";
    private static final String CHECKIN_AS_MAJOR_VERSION = "checkinAsMajorVersion";
    private static final String ANNOTATION_SECURITY = "annotationSecurity";
    private static final String FOLDER_SEARCH_EXPRESSION = "folderSearchExpression";
    private static final String MAX_HITS = "maxHits";
    private static final String LINE_CONVERSION = "lineConversion";
    private static final String AFP_CONVERSION = "afpConversion";
    private static final String SHOW_DOC_LOCATION = "showDocLocation";
    private static final String TEMP_DIR = "tempDir";
    private static final String TRACE_DIR = "traceDir";
    private static final String TRACE_LEVEL = "traceLevel";
    private static final String PORT_NUMBER = "portNumber";
    private static final String AFP2PD_CONFIG_FILE = "afp2pdfConfigFile";
    private static final String XFORM_XML_FILE = "transformXMLFile";
    private static final String OD_SSL = "odSSL";
    private static final String OD_KEYRING_DBFILE = "odKeyringDBFile";
    private static final String OD_KEYRING_STASHFILE = "odKeyringStashFile";
    private static final String CUSTOM_PROPS = "customProperties";
    private static final String IS_VALID = "isValid";
    private static final String MAX_IN_MEMORY_RETRIEVE_SIZE = "maxInMemoryRetrieveSize";
    private static final String MAX_DOWNLOAD_SIZE = "maxDownloadSize";
    private static final String TIMESTAMP_FORMAT = "timestampFormat";
    private static final String TIME_FORMAT = "timeFormat";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String TEAMSPACES_ENABLED = "teamspacesEnabled";
    private static final String SERVER_NAME = "serverName";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String DOCUMENT_SYSTEM_PROPERTIES = "documentSystemProperties";
    private static final String FOLDER_SYSTEM_PROPERTIES = "folderSystemProperties";
    private static final String FOLDER_DEF_COLS = "folderDefCols";
    private static final String FOLDER_MAGAZINE_DEF_COLS = "folderMagazineDefCols";
    private static final String SEARCH_DEF_COLS = "searchDefCols";
    private static final String SEARCH_MAGAZINE_DEF_COLS = "searchMagazineDefCols";
    private static final String DOC_NAME_PROPERTY = "docNameProp";
    private static final String FOLDER_NAME_PROPERTY = "folderNameProp";
    private static final String SEARCH_FILTERED_DOCUMENT_PROPERTIES = "searchFilteredDocumentProperties";
    private static final String SEARCH_FILTERED_FOLDER_PROPERTIES = "searchFilteredFolderProperties";
    private static final String SEARCH_OP_DATETIME = "datetimeOp";
    private static final String SEARCH_OP_INTEGER = "integerOp";
    private static final String SEARCH_OP_STRING = "stringOp";
    private static final String SEARCH_OP_BOOLEAN = "booleanOp";
    private static final String SEARCH_OP_OBJECT = "objectOp";
    private static final String SEARCH_OP_ID = "idOp";
    private static final String SEARCH_OP_USER = "userOp";
    private static final String SEARCH_OP_FLOAT = "floatOp";
    private static final String OD_SSO_PASSWD = "ssoPassword";
    private static final String STATUS_DOC_NOTES = "statusDocNotes";
    private static final String STATUS_DOC_HOLD = "statusDocHold";
    private static final String STATUS_DOC_CHECKED_OUT = "statusDocCheckedOut";
    private static final String STATUS_DOC_BOOKMARKS = "statusDocBookmarks";
    private static final String STATUS_DOC_DECLARED_RECORD = "statusDocDeclaredRecord";
    private static final String STATUS_DOC_MINOR_VERSIONS = "statusDocMinorVersions";
    private static final String STATUS_WORK_ITEM_CHECKED_OUT = "statusWorkItemCheckedOut";
    private static final String STATUS_WORK_ITEM_LOCKED = "statusWorkItemLocked";
    private static final String STATUS_WORK_ITEM_SUSPENDED = "statusWorkItemSuspended";
    private static final String STATUS_WORK_ITEM_DEADLINE = "statusWorkItemDeadline";
    public static final String PROPERTIES_MAPPING_LIST_TYPE = "propertiesMapping";
    private static final String PROPERTIES_MAPPING = "propertiesMapping";
    private static final String DEFAULT_EMAIL_CLASS_FOR_ADD = "defaultEmailClassForAdd";
    private static final String DEFAULT_FOLDER_CLASS_FOR_ADD = "defaultFolderClassForAdd";
    private int maxCabinets;

    @Override
    public String getObjectType() {
        return "repository";
    }

    public RepositoryConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME);
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    public String getType() {
        return this.properties.getProperty(TYPE, "");
    }

    public void setType(String type) {
        this.properties.setProperty(TYPE, type);
    }

    public String getServerName() {
        return this.properties.getProperty(SERVER_NAME);
    }

    public void setServerName(String serverName) {
        this.properties.setProperty(SERVER_NAME, serverName);
    }

    public boolean isTeamspacesEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(TEAMSPACES_ENABLED, "false"));
    }

    public void setTeamspacesEnabled(boolean teamspacesEnabled) {
        this.properties.setProperty(TEAMSPACES_ENABLED, Boolean.toString(teamspacesEnabled));
    }

    public String getDateFormat() {
        return this.properties.getProperty(DATE_FORMAT);
    }

    public void setDateFormat(String dateFormat) {
        this.properties.setProperty(DATE_FORMAT, dateFormat);
    }

    public String getTimeFormat() {
        return this.properties.getProperty(TIME_FORMAT);
    }

    public void setTimeFormat(String timeFormat) {
        this.properties.setProperty(TIME_FORMAT, timeFormat);
    }

    public String getTimestampFormat() {
        return this.properties.getProperty(TIMESTAMP_FORMAT);
    }

    public void setTimestampFormat(String timestampFormat) {
        this.properties.setProperty(TIMESTAMP_FORMAT, timestampFormat);
    }

    public int getMaxDownloadSize() {
        return Integer.parseInt(this.properties.getProperty(MAX_DOWNLOAD_SIZE, "0"));
    }

    public void setMaxDownloadSize(int maxDownloadSize) {
        this.properties.setProperty(MAX_DOWNLOAD_SIZE, Integer.toString(maxDownloadSize));
    }

    public int getMaxInMemoryRetrieveSize() {
        return Integer.parseInt(this.properties.getProperty(MAX_IN_MEMORY_RETRIEVE_SIZE, "0"));
    }

    public void setMaxInMemoryRetrieveSize(int maxInMemoryRetrieveSize) {
        this.properties.setProperty(MAX_IN_MEMORY_RETRIEVE_SIZE, Integer.toString(maxInMemoryRetrieveSize));
    }

    public boolean isMatchAll() {
        return Boolean.parseBoolean(this.properties.getProperty(MATCH_ALL, "true"));
    }

    public void setMatchAll(boolean matchAll) {
        this.properties.setProperty(MATCH_ALL, Boolean.toString(matchAll));
    }

    public String getPortNumber() {
        return this.properties.getProperty(PORT_NUMBER, "0");
    }

    public void setPortNumber(String port) {
        this.properties.setProperty(PORT_NUMBER, port);
    }

    public String getAfp2PdfConfigFile() {
        return this.properties.getProperty(AFP2PD_CONFIG_FILE, "");
    }

    public void setAfp2PdfConfigFile(String afp2PdfConfigFile) {
        this.properties.setProperty(AFP2PD_CONFIG_FILE, afp2PdfConfigFile);
    }

    public String getTransformXMLFile() {
        return this.properties.getProperty(XFORM_XML_FILE, "");
    }

    public void setTransformXMLFile(String transformXMLFile) {
        this.properties.setProperty(XFORM_XML_FILE, transformXMLFile);
    }

    public String getODSSL() {
        return this.properties.getProperty(OD_SSL, "false");
    }

    public void setODSSL(String odSSL) {
        this.properties.setProperty(OD_SSL, odSSL);
    }

    public String getODKeyringDBFile() {
        return this.properties.getProperty(OD_KEYRING_DBFILE, "");
    }

    public void setODKeyringDBFile(String odKeyringDBFile) {
        this.properties.setProperty(OD_KEYRING_DBFILE, odKeyringDBFile);
    }

    public String getODKeyringStashFile() {
        return this.properties.getProperty(OD_KEYRING_STASHFILE, "");
    }

    public void setODKeyringStashFile(String odKeyringStashFile) {
        this.properties.setProperty(OD_KEYRING_STASHFILE, odKeyringStashFile);
    }

    public String getCustomProperties() {
        return this.properties.getProperty(CUSTOM_PROPS, "");
    }

    public void setCustomProperties(String customProps) {
        this.properties.setProperty(CUSTOM_PROPS, customProps);
    }

    @Override
    public boolean isValid() {
        return Boolean.parseBoolean(this.properties.getProperty(IS_VALID, "true"));
    }

    @Override
    public void setValid(boolean value) {
        this.properties.setProperty(IS_VALID, Boolean.toString(value));
    }

    public int getTraceLevel() {
        return Integer.parseInt(this.properties.getProperty(TRACE_LEVEL, "0"));
    }

    public void setTraceLevel(int traceLevel) {
        this.properties.setProperty(TRACE_LEVEL, Integer.toString(traceLevel));
    }

    public String getTraceDir() {
        return this.properties.getProperty(TRACE_DIR);
    }

    public void setTraceDir(String traceDir) {
        this.properties.setProperty(TRACE_DIR, traceDir);
    }

    public String getTempDir() {
        return this.properties.getProperty(TEMP_DIR);
    }

    public void setTempDir(String tempDir) {
        this.properties.setProperty(TEMP_DIR, tempDir);
    }

    public boolean isShowDocLocation() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_DOC_LOCATION, "false"));
    }

    public void setShowDocLocation(boolean showDocLocation) {
        this.properties.setProperty(SHOW_DOC_LOCATION, Boolean.toString(showDocLocation));
    }

    public String getAfpConversion() {
        return this.properties.getProperty(AFP_CONVERSION);
    }

    public void setAfpConversion(String afpConversion) {
        this.properties.setProperty(AFP_CONVERSION, afpConversion);
    }

    public String getLineConversion() {
        return this.properties.getProperty(LINE_CONVERSION);
    }

    public void setLineConversion(String lineConversion) {
        this.properties.setProperty(LINE_CONVERSION, lineConversion);
    }

    public int getMaxHits() {
        return Integer.parseInt(this.properties.getProperty(MAX_HITS, "1000"));
    }

    public void setMaxHits(int maxHits) {
        this.properties.setProperty(MAX_HITS, Integer.toString(maxHits));
    }

    public String getFolderSearchExpression() {
        return this.properties.getProperty(FOLDER_SEARCH_EXPRESSION, "");
    }

    public void setFolderSearchExpression(String folderSearchExpression) {
        this.properties.setProperty(FOLDER_SEARCH_EXPRESSION, folderSearchExpression);
    }

    public boolean getStatusDocNotes() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_NOTES, "true"));
    }

    public boolean getStatusDocHold() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_HOLD, "true"));
    }

    public boolean getStatusDocCheckedOut() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_CHECKED_OUT, "false"));
    }

    public boolean getStatusDocBookmarks() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_BOOKMARKS, "false"));
    }

    public boolean getStatusDocDeclaredRecord() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_DECLARED_RECORD, "false"));
    }

    public boolean getStatusDocMinorVersions() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_MINOR_VERSIONS, "false"));
    }

    public boolean getStatusWorkItemCheckedOut() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_CHECKED_OUT, "false"));
    }

    public boolean getStatusWorkItemLocked() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_LOCKED, "false"));
    }

    public boolean getStatusWorkItemSuspended() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_SUSPENDED, "false"));
    }

    public boolean getStatusWorkItemDeadline() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_DEADLINE, "false"));
    }

    public int getMaxCabinets() {
        return this.maxCabinets;
    }

    public void setMaxCabinets(int maxCabinets) {
        this.maxCabinets = maxCabinets;
    }

    public ODConfig getODConfig(HttpServletRequest request) throws Exception {
        ODLoginConfig odLoginConfig = Config.getConfiguration(ODLoginConfig.class, this.getIdPrefix(), this.getObjectId(), new boolean[0]);
        return odLoginConfig.getODConfig(request);
    }

    public String getProtocol() {
        return this.properties.getProperty(PROTOCOL);
    }

    public void setProtocol(String protocol) {
        this.properties.setProperty(PROTOCOL, protocol);
    }

    public String getObjectStore() {
        return this.properties.getProperty(OBJECT_STORE);
    }

    public void setObjectStore(String objectStore) {
        this.properties.setProperty(OBJECT_STORE, objectStore);
    }

    public String getObjectStoreDisplayName() {
        return this.properties.getProperty(OBJECT_STORE_DISPLAY_NAME);
    }

    public void setObjectStoreDisplayName(String objectStore) {
        this.properties.setProperty(OBJECT_STORE_DISPLAY_NAME, objectStore);
    }

    public String getConnectionPoint() {
        return this.properties.getProperty(CONNECTION_POINT);
    }

    public void setConnectionPoint(String connectionPoint) {
        this.properties.setProperty(CONNECTION_POINT, connectionPoint);
    }

    public String getCmisRepositoryID() {
        return this.properties.getProperty(CMIS_REPOSITORY_ID);
    }

    public void setCmisRepositoryID(String cmisRepositoryID) {
        this.properties.setProperty(CMIS_REPOSITORY_ID, cmisRepositoryID);
    }

    public String getUseGzipEncoding() {
        return this.properties.getProperty(USE_GZIP_ENCODING);
    }

    public void setUseGzipEncoding(String useGzipEncoding) {
        this.properties.setProperty(USE_GZIP_ENCODING, useGzipEncoding);
    }

    public Boolean getAddAsMajorVersion() {
        return Boolean.parseBoolean(this.properties.getProperty(ADD_AS_MAJOR_VERSION, "true"));
    }

    public void setAddAsMajorVersion(Boolean addAsMajorVersion) {
        this.properties.setProperty(ADD_AS_MAJOR_VERSION, Boolean.toString(addAsMajorVersion));
    }

    public Boolean getCheckinAsMajorVersion() {
        return Boolean.parseBoolean(this.properties.getProperty(CHECKIN_AS_MAJOR_VERSION, "true"));
    }

    public void setCheckinAsMajorVersion(Boolean checkinAsMajorVersion) {
        this.properties.setProperty(CHECKIN_AS_MAJOR_VERSION, Boolean.toString(checkinAsMajorVersion));
    }

    public String getAnnotationSecurity() {
        return this.properties.getProperty(ANNOTATION_SECURITY);
    }

    public void setAnnotationSecurity(String annotationSecurity) {
        this.properties.setProperty(ANNOTATION_SECURITY, annotationSecurity);
    }

    public String getDocNameProperty() {
        return this.properties.getProperty(DOC_NAME_PROPERTY);
    }

    public void setDocNameProperty(String docNameProp) {
        this.properties.setProperty(DOC_NAME_PROPERTY, docNameProp);
    }

    public String getFolderNameProperty() {
        return this.properties.getProperty(FOLDER_NAME_PROPERTY);
    }

    public void setFolderNameProperty(String folderNameProp) {
        this.properties.setProperty(FOLDER_NAME_PROPERTY, folderNameProp);
    }

    public String[] getDocumentSystemProperties() {
        return this.stringToArray(this.properties.getProperty(DOCUMENT_SYSTEM_PROPERTIES));
    }

    public void setDocumentSystemProperties(String[] documentSystemProps) {
        this.properties.setProperty(DOCUMENT_SYSTEM_PROPERTIES, this.arrayToString(documentSystemProps));
    }

    public String[] getFolderSystemProperties() {
        return this.stringToArray(this.properties.getProperty(FOLDER_SYSTEM_PROPERTIES));
    }

    public void setFolderSystemProperties(String[] folderSystemProps) {
        this.properties.setProperty(FOLDER_SYSTEM_PROPERTIES, this.arrayToString(folderSystemProps));
    }

    public String[] getFolderDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(FOLDER_DEF_COLS));
    }

    public void setFolderDefaultColumns(String[] folderDefCols) {
        this.properties.setProperty(FOLDER_DEF_COLS, this.arrayToString(folderDefCols));
    }

    public String[] getFolderMagazineDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(FOLDER_MAGAZINE_DEF_COLS));
    }

    public void setFolderMagazineDefaultColumns(String[] folderDefCols) {
        this.properties.setProperty(FOLDER_MAGAZINE_DEF_COLS, this.arrayToString(folderDefCols));
    }

    public String[] getSearchMagazineDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(SEARCH_MAGAZINE_DEF_COLS));
    }

    public void setSearchMagazineDefaultColumns(String[] defCols) {
        this.properties.setProperty(SEARCH_MAGAZINE_DEF_COLS, this.arrayToString(defCols));
    }

    public String[] getSearchDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(SEARCH_DEF_COLS));
    }

    public void setSearchDefaultColumns(String[] searchDefCols) {
        this.properties.setProperty(SEARCH_DEF_COLS, this.arrayToString(searchDefCols));
    }

    public String[] getSearchFilteredOperators(String type) {
        return this.stringToArray(this.properties.getProperty(type));
    }

    public void setSearchFilteredOperators(String type, String[] operators) {
        this.properties.setProperty(type, this.arrayToString(operators));
    }

    public String[] getSearchFilteredDocumentProperties() {
        return this.stringToArray(this.properties.getProperty(SEARCH_FILTERED_DOCUMENT_PROPERTIES));
    }

    public void setSearchFilteredDocumentProperties(String[] searchFilteredProperties) {
        this.properties.setProperty(SEARCH_FILTERED_DOCUMENT_PROPERTIES, this.arrayToString(searchFilteredProperties));
    }

    public String[] getSearchFilteredFolderProperties() {
        return this.stringToArray(this.properties.getProperty(SEARCH_FILTERED_FOLDER_PROPERTIES));
    }

    public void setSearchFilteredFolderProperties(String[] searchFilteredProperties) {
        this.properties.setProperty(SEARCH_FILTERED_FOLDER_PROPERTIES, this.arrayToString(searchFilteredProperties));
    }

    public boolean isDirectRetrieveEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(DIRECT_RETRIEVE_ENABLED, "false"));
    }

    public void setDirectRetrieveEnabled(boolean directRetrieveEnabled) {
        this.properties.setProperty(DIRECT_RETRIEVE_ENABLED, Boolean.toString(directRetrieveEnabled));
    }

    public boolean getUseSSO() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_SSO, "false"));
    }

    public void setUseSSO(boolean useSSO) {
        this.properties.setProperty(USE_SSO, Boolean.toString(useSSO));
    }

    public boolean isUnifiedSearchesEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(UNIFIED_SEARCHES_ENABLED, "false"));
    }

    public void setUnifiedSearchesEnabled(boolean unifiedSearchesEnabled) {
        this.properties.setProperty(UNIFIED_SEARCHES_ENABLED, Boolean.toString(unifiedSearchesEnabled));
    }

    public int getMaxResults() {
        return Integer.parseInt(this.properties.getProperty(SEARCH_MAX_RESULTS, "5000"));
    }

    public void setMaxResults(int maxResults) {
        this.properties.setProperty(SEARCH_MAX_RESULTS, Integer.toString(maxResults));
    }

    public int getTimeoutInSeconds() {
        return Integer.parseInt(this.properties.getProperty(TIMEOUT_IN_SECONDS, "180"));
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.properties.setProperty(TIMEOUT_IN_SECONDS, Integer.toString(timeoutInSeconds));
    }

    public String getRootFolderId() {
        return this.properties.getProperty(ROOT_FOLDER_ID);
    }

    public void setRootFolderId(String rootFolderId) {
        this.properties.setProperty(ROOT_FOLDER_ID, rootFolderId);
    }

    public String getFolderingEnabled() {
        return this.properties.getProperty(FOLDERING_ENABLED);
    }

    public void setFolderingEnabled(String folderingEnabled) {
        this.properties.setProperty(FOLDERING_ENABLED, folderingEnabled);
    }

    public String getLanguageCodes() {
        return this.properties.getProperty(LANGUAGE_CODES);
    }

    public void setLanguageCodes(String languageCodes) {
        this.properties.setProperty(LANGUAGE_CODES, languageCodes);
    }

    public int getMaxItemTypes() {
        if (this.properties.getProperty(MAX_ITEM_TYPES) == null || this.properties.getProperty(MAX_ITEM_TYPES).length() == 0) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(this.properties.getProperty(MAX_ITEM_TYPES));
    }

    public void setMaxItemTypes(int maxItemTypes) {
        this.properties.setProperty(MAX_ITEM_TYPES, String.valueOf(maxItemTypes));
    }

    public int getMaxWorklists() {
        if (this.properties.getProperty(MAX_WORKLISTS) == null || this.properties.getProperty(MAX_WORKLISTS).length() == 0) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(this.properties.getProperty(MAX_WORKLISTS));
    }

    public void setMaxWorklists(int maxWorklists) {
        this.properties.setProperty(MAX_WORKLISTS, String.valueOf(maxWorklists));
    }

    public boolean getUpdateStorageCollection() {
        return Boolean.parseBoolean(this.properties.getProperty(UPDATE_STORAGE_COLLECTION, "false"));
    }

    public void setUpdateStorageCollection(boolean updateStorageCollection) {
        this.properties.setProperty(UPDATE_STORAGE_COLLECTION, String.valueOf(updateStorageCollection));
    }

    public boolean getKeepInAutoFolder() {
        return Boolean.parseBoolean(this.properties.getProperty(KEEP_IN_AUTO_FOLDER, "false"));
    }

    public void setKeepInAutoFolder(boolean keepInAutoFolder) {
        this.properties.setProperty(KEEP_IN_AUTO_FOLDER, String.valueOf(keepInAutoFolder));
    }

    public String getPdfConversion() {
        return this.properties.getProperty(PDF_CONVERSION);
    }

    public void setPdfConversion(String pdfConversion) {
        this.properties.setProperty(PDF_CONVERSION, pdfConversion);
    }

    public boolean getIncludeMIMETypesInSearchResults() {
        return Boolean.parseBoolean(this.properties.getProperty(INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS, "true"));
    }

    public void setIncludeMIMETypesInSearchResults(boolean includeMIMETypesInSearchResults) {
        this.properties.setProperty(INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS, String.valueOf(includeMIMETypesInSearchResults));
    }

    public String getSSOPassword() {
        String clearTextPassword = null;
        try {
            PasswordEncrypter.init();
            clearTextPassword = PasswordEncrypter.decrypt(this.properties.getProperty(OD_SSO_PASSWD));
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, "getSSOPassword", "unexpected error", (Throwable)e);
        }
        return clearTextPassword;
    }

    public void setSSOPassword(String ssoPasswd) {
        String encryptedPassword = null;
        try {
            PasswordEncrypter.init();
            encryptedPassword = PasswordEncrypter.encrypt(ssoPasswd);
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, "setSSOPassword", "unexpected error", (Throwable)e);
        }
        this.properties.setProperty(OD_SSO_PASSWD, encryptedPassword);
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type.equals("propertiesMapping")) {
            return this.getPropertiesMappingList(appName);
        }
        return null;
    }

    public Collection<PropertyMappingConfig> getPropertiesMappingList(String appName) {
        return this.getPropertiesMappingList(appName, this.getPropertiesMapping());
    }

    public Collection<PropertyMappingConfig> getPropertiesMappingList(String appName, String[] ids) {
        return this.getMap(PropertyMappingConfig.class, appName, ids, true).values();
    }

    public String[] getPropertiesMapping() {
        return this.stringToArray(this.properties.getProperty("propertiesMapping"));
    }

    public void setPropertiesMapping(String[] props) {
        this.properties.setProperty("propertiesMapping", this.arrayToString(props));
    }

    public String getDefaultEmailClassForAdd() {
        return this.properties.getProperty(DEFAULT_EMAIL_CLASS_FOR_ADD);
    }

    public void setDefaultEmailClassForAdd(String value) {
        this.properties.setProperty(DEFAULT_EMAIL_CLASS_FOR_ADD, value);
    }

    public String getDefaultFolderClassForAdd() {
        return this.properties.getProperty(DEFAULT_FOLDER_CLASS_FOR_ADD);
    }

    public void setDefaultFolderClassForAdd(String value) {
        this.properties.setProperty(DEFAULT_FOLDER_CLASS_FOR_ADD, value);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void exportPropertiesMapping(String appName, OutputStreamWriter osw, RepositoryConfig repository) throws IOException, FileNotFoundException {
        Collection<PropertyMappingConfig> propsMapping = this.getPropertiesMappingList(appName);
        ConfigurationObject.writeConfigurationToFile(osw, propsMapping);
    }
}

