/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.extension.PluginAction;
import com.ibm.ecm.extension.PluginMenu;
import com.ibm.ecm.extension.PluginMenuItem;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuConfig
extends ConfigurationObject {
    private static final String TYPE = "type";
    private static final String TYPE_LABEL = "typeLabel";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String PRIVILEGE_NAME = "privilegeName";
    private static final String LIST_TYPES = "listTypes";
    private static final String SERVER_TYPES = "serverTypes";
    private static final String GLOBAL = "global";
    private static final String MULTI_DOC = "multiDoc";
    private static final String WIDGET_TYPE = "widgetType";
    private static final String WIDGET_FUNCTION = "widgetFunction";
    private static final String ID = "id";
    private static final String PLUGIN_ID = "pluginId";
    private static final String ITEMS = "items";
    private static final String ACTION_FUNCTION = "actionFunction";
    private static final String LABEL_TEXT = "labelText";
    private static final String LABEL_ID = "labelId";
    private static final String ACTION_MODEL_CLASS = "actionModelClass";
    private static final String MENU_TYPES = "menuTypes";
    private static final String ADDITIONAL_CONFIGURATION = "additionalConfiguration";
    private String label;
    private String icon;
    private List<MenuConfig> subMenus = new ArrayList<MenuConfig>();

    public MenuConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    public String getObjectType() {
        return "menu";
    }

    public static synchronized Collection<MenuConfig> getMenu(HttpServletRequest request, String idPrefix, String id) throws ConfigurationException, MissingValueException {
        MenuConfig rootMenu = Config.getMenuConfig(idPrefix, id, true);
        rootMenu.loadSubMenus(request);
        if (rootMenu.getSubMenus().size() > 0) {
            return rootMenu.getSubMenus();
        }
        LinkedHashMap temp = new LinkedHashMap();
        return temp.values();
    }

    public static synchronized List<MenuConfig> getClonedMenu(HttpServletRequest request, String idPrefix, String id) throws ConfigurationException, MissingValueException {
        Collection<MenuConfig> srcList = MenuConfig.getMenu(request, idPrefix, id);
        ArrayList<MenuConfig> dstList = new ArrayList<MenuConfig>();
        try {
            for (MenuConfig config : srcList) {
                dstList.add((MenuConfig)config.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            AdminLogger.logError(MenuConfig.class, "getClonedMenu", e);
        }
        return dstList;
    }

    public synchronized void loadSubMenus(HttpServletRequest request) throws ConfigurationException, MissingValueException {
        if (this.getItems() != null && this.getItems().length > 0) {
            Map<String, MenuConfig> subMenus = this.getMap(MenuConfig.class, this.getIdPrefix(), this.getItems(), true);
            for (int i = 0; i < this.getItems().length; ++i) {
                String lbl;
                String messageKey;
                String key = this.getItems()[i];
                MenuConfig subMenu = subMenus.get(key);
                if (subMenu == null) continue;
                this.getSubMenus().add(subMenu);
                if (subMenu.getLabelText() != null) {
                    subMenu.setLabel(subMenu.getLabelText());
                } else if (subMenu.getLabelId() != null) {
                    messageKey = "action." + subMenu.getLabelId() + ".label";
                    lbl = MessageUtil.getMessage(request, messageKey);
                    subMenu.setLabel(lbl);
                } else {
                    messageKey = "action." + subMenu.getObjectId() + ".label";
                    lbl = MessageUtil.getMessage(request, messageKey);
                    subMenu.setLabel(lbl);
                }
                if (subMenu.getItems() == null || subMenu.getItems().length <= 0) continue;
                subMenu.loadSubMenus(request);
            }
        }
    }

    public synchronized void loadPluginMenu(HttpServletRequest request, PluginMenu pluginMenu) throws ConfigurationException, MissingValueException {
        PluginMenuItem[] menuItems = pluginMenu.getMenuItems();
        if (menuItems != null) {
            for (int i = 0; i < menuItems.length; ++i) {
                PluginMenuItem menuItem = menuItems[i];
                if (menuItem.getActionId() != null && !menuItem.getActionId().equals("")) {
                    MenuConfig menu = Config.getMenuConfig(this.getIdPrefix(), menuItem.getActionId(), true);
                    menu.setId(menuItem.getActionId());
                    String messageKey = "action." + menu.getObjectId() + ".label";
                    menu.setLabel(MessageUtil.getMessage(request, messageKey));
                    Config.removeConfigurationFromCache(menu);
                    this.subMenus.add(menu);
                    continue;
                }
                String actionIdsLabel = menuItem.getActionIdsLabel(request.getLocale());
                String[] actionIds = menuItem.getActionIds();
                if (actionIdsLabel == null || actionIdsLabel.equals("") || actionIds == null || actionIds.length <= 0) continue;
                MenuConfig menu = Config.getMenuConfig(this.getIdPrefix(), actionIdsLabel, true);
                menu.setId(actionIdsLabel);
                String cascadeMessageKey = "action." + actionIdsLabel + ".label";
                String cascadeLabel = actionIdsLabel;
                if (MessageUtil.containsKey(request, cascadeMessageKey)) {
                    cascadeLabel = MessageUtil.getMessage(request, cascadeMessageKey);
                }
                menu.setLabel(cascadeLabel);
                List<MenuConfig> subMenuList = menu.getSubMenus();
                for (int j = 0; j < actionIds.length; ++j) {
                    String subactionId = actionIds[j];
                    MenuConfig subMenuAction = Config.getMenuConfig(this.getIdPrefix(), subactionId, true);
                    subMenuAction.setId(subactionId);
                    String messageKey = "action." + subMenuAction.getObjectId() + ".label";
                    subMenuAction.setLabel(MessageUtil.getMessage(request, messageKey));
                    subMenuList.add(subMenuAction);
                }
                this.subMenus.add(menu);
            }
        }
    }

    public List<MenuConfig> getSubMenus() {
        return this.subMenus;
    }

    public void setSubMenus(List<MenuConfig> subMenus) {
        this.subMenus = subMenus;
    }

    public String[] getItems() {
        return this.stringToArray(this.properties.getProperty(ITEMS));
    }

    public void setItems(String[] menus) {
        this.properties.setProperty(ITEMS, this.arrayToString(menus));
    }

    public String getPluginId() {
        return this.properties.getProperty(PLUGIN_ID);
    }

    public void setPluginId(String pluginId) {
        this.properties.setProperty(PLUGIN_ID, pluginId);
    }

    public String getId() {
        return this.properties.getProperty(ID);
    }

    public void setId(String id) {
        this.properties.setProperty(ID, id);
    }

    public String getIcon() {
        if (this.icon == null && this.getId() != null) {
            this.icon = this.getId() + ".png";
        }
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getWidgetFunction() {
        return this.properties.getProperty(WIDGET_FUNCTION);
    }

    public void setWidgetFunction(String widgetFunction) {
        this.properties.setProperty(WIDGET_FUNCTION, widgetFunction);
    }

    public String getWidgetType() {
        return this.properties.getProperty(WIDGET_TYPE);
    }

    public void setWidgetType(String widgetType) {
        this.properties.setProperty(WIDGET_TYPE, widgetType);
    }

    @Override
    public String getName() {
        String name = this.properties.getProperty(NAME);
        if (name == null) {
            name = this.getObjectId();
        }
        return name;
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    public String getDescription() {
        return this.properties.getProperty(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.properties.setProperty(DESCRIPTION, description);
    }

    public String getType() {
        return this.properties.getProperty(TYPE);
    }

    public void setType(String type) {
        this.properties.setProperty(TYPE, type);
    }

    public String getTypeLabel() {
        return this.properties.getProperty(TYPE_LABEL);
    }

    public void setTypeLabel(String typeLabel) {
        this.properties.setProperty(TYPE_LABEL, typeLabel);
    }

    public boolean isMultiDoc() {
        return Boolean.parseBoolean(this.properties.getProperty(MULTI_DOC, "false"));
    }

    public void setMultiDoc(boolean multiDoc) {
        this.properties.setProperty(MULTI_DOC, Boolean.toString(multiDoc));
    }

    public boolean isGlobal() {
        return Boolean.parseBoolean(this.properties.getProperty(GLOBAL, "false"));
    }

    public void setGlobal(boolean global) {
        this.properties.setProperty(GLOBAL, Boolean.toString(global));
    }

    public String getAction() {
        if (this.getId() != null && !this.getId().equals("Separator")) {
            if (this.properties.getProperty(ACTION_FUNCTION) != null) {
                return this.properties.getProperty(ACTION_FUNCTION);
            }
            return "action" + this.getId();
        }
        return "";
    }

    public void setAction(String actionFunction) {
        this.properties.setProperty(ACTION_FUNCTION, actionFunction);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean containsServer(String serverId) {
        String[] serverTypes = this.getServerTypes();
        if (serverTypes.length == 1 && serverTypes[0].equals("")) {
            return true;
        }
        for (int i = 0; i < serverTypes.length; ++i) {
            if (!serverId.equals(serverTypes[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getServerTypes() {
        return this.stringToArray(this.properties.getProperty(SERVER_TYPES));
    }

    public void setServerTypes(String[] serverTypes) {
        this.properties.setProperty(SERVER_TYPES, this.arrayToString(serverTypes));
    }

    public String[] getListTypes() {
        return this.stringToArray(this.properties.getProperty(LIST_TYPES));
    }

    public void setListTypes(String[] listTypes) {
        this.properties.setProperty(LIST_TYPES, this.arrayToString(listTypes));
    }

    public String[] getPrivilegeNames() {
        if (this.properties.getProperty(PRIVILEGE_NAME) != null) {
            return this.properties.getProperty(PRIVILEGE_NAME).split(",");
        }
        return new String[0];
    }

    public void setPrivilegeNames(String[] privilegeNames) {
        this.properties.setProperty(PRIVILEGE_NAME, this.arrayToString(privilegeNames));
    }

    public String getLabelText() {
        return this.properties.getProperty(LABEL_TEXT);
    }

    public void setLabelText(String labelText) {
        this.properties.setProperty(LABEL_TEXT, labelText);
    }

    public String getLabelId() {
        return this.properties.getProperty(LABEL_ID);
    }

    public void setLabelId(String labelId) {
        if (labelId != null) {
            this.properties.setProperty(LABEL_ID, labelId);
        }
    }

    public String getActionModelClass() {
        return this.properties.getProperty(ACTION_MODEL_CLASS);
    }

    public void setActionModelClass(String actionModelClass) {
        this.properties.setProperty(ACTION_MODEL_CLASS, actionModelClass);
    }

    public String[] getMenuTypes() {
        return this.stringToArray(this.properties.getProperty(MENU_TYPES));
    }

    public void setMenuTypes(String[] menuTypes) {
        this.properties.setProperty(MENU_TYPES, this.arrayToString(menuTypes));
    }

    public String getAdditionalConfiguration() {
        return this.properties.getProperty(ADDITIONAL_CONFIGURATION);
    }

    public void setAdditionalConfiguration(String additionalConfiguration) {
        this.properties.setProperty(ADDITIONAL_CONFIGURATION, additionalConfiguration);
    }

    public Object clone() throws CloneNotSupportedException {
        MenuConfig value;
        try {
            value = Config.getMenuConfig(this.getIdPrefix(), this.getObjectId(), new boolean[0]);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException();
        }
        value.cloned = true;
        return value;
    }

    public JSONObject getJson() {
        JSONObject jsonAction = new JSONObject();
        this.getJson(jsonAction);
        return jsonAction;
    }

    public JSONObject getJson(JSONObject jsonAction) {
        String methodName = "getJson";
        jsonAction.put(ID, this.getId());
        jsonAction.put("label", this.getLabel());
        if (this.getLabelId() != null) {
            jsonAction.put(LABEL_ID, this.getLabelId());
        }
        jsonAction.put("icon", this.getIcon());
        jsonAction.put(PLUGIN_ID, this.covertEmptyStringtoNull(this.getPluginId()));
        jsonAction.put("action", this.getAction());
        JSONUtils.put(jsonAction, MULTI_DOC, this.isMultiDoc());
        JSONUtils.put(jsonAction, GLOBAL, this.isGlobal());
        try {
            jsonAction.put(PRIVILEGE_NAME, this.arrayToString(this.getPrivilegeNames()));
        }
        catch (Exception e) {
            // empty catch block
        }
        jsonAction.put(WIDGET_TYPE, this.covertEmptyStringtoNull(this.getWidgetType()));
        jsonAction.put(WIDGET_FUNCTION, this.covertEmptyStringtoNull(this.getWidgetFunction()));
        String listTypes = this.arrayToString(this.getListTypes());
        jsonAction.put(LIST_TYPES, listTypes != null ? listTypes : "");
        jsonAction.put(SERVER_TYPES, this.arrayToString(this.getServerTypes()));
        jsonAction.put(ACTION_MODEL_CLASS, this.getActionModelClass());
        jsonAction.put(MENU_TYPES, this.arrayToString(this.getMenuTypes()));
        if (this.getSubMenus().size() > 0) {
            JSONArray jsonSubActions = new JSONArray();
            jsonAction.put("actions", jsonSubActions);
            for (MenuConfig subMenu : this.subMenus) {
                JSONObject jsonSub2Action = new JSONObject();
                jsonSubActions.add(jsonSub2Action);
                subMenu.getJson(jsonSub2Action);
            }
        }
        return jsonAction;
    }

    public void copy(HttpServletRequest request, PluginAction pluginAction) {
        this.setIcon("plugin.do?plugin=" + pluginAction.getId() + "&action=getResource&resource=" + pluginAction.getIcon());
        this.setLabel(pluginAction.getName(request.getLocale()));
        this.setId(pluginAction.getId());
        this.setAction(pluginAction.getActionFunction());
        this.setMultiDoc(pluginAction.isMultiDoc());
        this.setGlobal(pluginAction.isGlobal());
        this.setPrivilegeNames(pluginAction.getPrivilege().split(","));
        this.setServerTypes(pluginAction.getServerTypes().split(","));
        this.setActionModelClass(pluginAction.getActionModelClass());
        this.setPluginId(pluginAction.getPluginId());
        this.setMenuTypes(pluginAction.getMenuTypes());
        this.setAdditionalConfiguration(pluginAction.getAdditionalConfiguration(request.getLocale()).toString());
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

