/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.Constants;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.ConfigurationValidation;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.InterfaceTextLocaleConfig;
import com.ibm.ecm.configuration.MobileFeatureConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.ServerConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import com.ibm.ecm.extension.PluginMenuType;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.json.java.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopConfig
extends ConfigurationObject
implements ConfigurationValidation {
    private static final String SHOW_FIELD_HOVER_HELP = "showFieldHoverHelp";
    private static final String PASSWORD_RULES_URL = "passwordRulesUrl";
    private static final String LOGIN_INFORMATION_URL = "loginInformationUrl";
    private static final String LOGIN_LOGO_URL = "loginLogoUrl";
    private static final String BANNER_LOGO_URL = "bannerLogoUrl";
    private static final String APPLICATION_NAME = "applicationName";
    private static final String MESSAGE_SEARCH_URL = "messageSearchUrl";
    private static final String HELP_URL = "helpUrl";
    private static final String MENU_PREFIX = "menuPrefix";
    private static final String REPOSITORIES = "repositories";
    private static final String SERVERS = "servers";
    private static final String INTERFACETEXTS = "interfaceTexts";
    private static final String NAME = "name";
    private static final String DEFAULT_REPOSITORY = "defaultRepository";
    private static final String FILE_INTO_FOLDER = "fileIntoFolder";
    private static final String SHOW_SECURITY = "showSecurity";
    private static final String ADDITIONAL_SCRIPT = "additionalScript";
    private static final String ADDITIONAL_CSS = "additionalCss";
    private static final String LAYOUT = "layout";
    private static final String FEATURES = "features";
    private static final String DEFAULT_FEATURE = "defaultFeature";
    private static final String LAYOUT_LOG_FILE = "layoutLogFile";
    private static final String BANNER_BACKGROUND_COLOR = "bannerBackgroundColor";
    private static final String BANNER_APPLICATION_NAME_COLOR = "bannerApplicationNameColor";
    private static final String BANNER_MENU_COLOR = "bannerMenuColor";
    private static final String TEAMSPACES_DEFAULT_REPOSITORY = "teamspacesDefaultRepository";
    private static final String WORK_DEFAULT_REPOSITORY = "workDefaultRepository";
    private static final String OTHER_FEATURES_DEFAULT_REPOSITORY = "otherFeaturesDefaultRepository";
    private static final String SHOW_THUMBNAILS = "showThumbnails";
    private static final String SHOW_VIEWFILMSTRIP = "showViewFilmstrip";
    private static final String SHOW_GLOBAL_TOOLBAR = "showGlobalToolbar";
    private static final String ACTION_HANDLER = "actionHandler";
    private static final String DESCRIPTION = "description";
    private static final String IS_DEFAULT = "isDefault";
    private static final String VIEWER = "viewer";
    private static final String THEME = "theme";
    private static final String APPLICATION_SPACE_LABELS = "appSpaceLabels";
    private static final String MOBILE_NAME_IDS = "mobileNameIds";
    private static final String SUPPORT_WORKFLOW_NOTIFICATION = "workflowNotification";
    private static final String PREVENT_CREATE_NEW_SEARCH = "preventCreateNewSearch";
    private static final String PREVENT_CREATE_NEW_UNIFIED_SEARCH = "preventCreateNewUnifiedSearch";
    private static final String MAX_NUMBER_DOC_TO_ADD = "maxNumberDocToAdd";
    private static final String MAX_NUMBER_DOC_TO_MODIFY = "maxNumberDocToModify";
    private static final String IS_VALID = "isValid";
    private static final String ACCESS_CONTROL_ENABLED = "accessControlEnabled";
    private static final String AUTHENTICATION_TYPE = "authenticationType";
    private static final String DEFAULT_DATA_SOURCE = "defaultDataSource";
    private static final String DATA_SOURCES = "dataSources";
    private static final String TOOLBAR_ATTACHMENT = "AttachmentToolbar";
    private static final String TOOLBAR_CONTENT_LIST = "ContentListToolbar";
    private static final String TOOLBAR_FAVORITES = "FavoritesToolbar";
    private static final String TOOLBAR_GLOBAL = "GlobalToolbar";
    private static final String TOOLBAR_INBASKET = "InbasketToolbar";
    private static final String TOOLBAR_INBASKET_P8 = "InbasketToolbarP8";
    private static final String TOOLBAR_BROWSE = "BrowseToolbar";
    private static final String TOOLBAR_SELECT_OBJECT = "SelectObjectToolbar";
    private static final String TOOLBAR_TEAMSPACE = "TeamspaceToolbar";
    private static final String TOOLBAR_TEAMSPACES_LIST = "TeamspacesListToolbar";
    private static final String TOOLBAR_TEMPLATES_LIST = "TemplatesListToolbar";
    private static final String CONTEXT_MENU_BANNER_USER_SESSION = "BannerUserSessionContextMenu";
    private static final String CONTEXT_MENU_BANNER_TOOLS = "BannerToolsContextMenu";
    private static final String CONTEXT_MENU_ATTACHMENT_ITEM = "AttachmentItemContextMenu";
    private static final String CONTEXT_MENU_ATTACHMENT_FOLDER = "AttachmentFolderContextMenu";
    private static final String CONTEXT_MENU_ADD_DOCUMENT_ATTACHMENT = "AddDocumentAttachmentContextMenu";
    private static final String CONTEXT_MENU_ADD_FOLDER_ATTACHMENT = "AddFolderAttachmentContextMenu";
    private static final String CONTEXT_MENU_FAVORITES = "FavoritesContextMenu";
    private static final String CONTEXT_MENU_FAVORITES_ITEM = "FavoriteItemContextMenu";
    private static final String CONTEXT_MENU_FAVORITES_FOLDER = "FavoriteFolderContextMenu";
    private static final String CONTEXT_MENU_FAVORITES_TEAMSPACE = "FavoriteTeamspaceContextMenu";
    private static final String CONTEXT_MENU_FAVORITES_SEARCH_TEMPLATE = "FavoriteSearchTemplateContextMenu";
    private static final String CONTEXT_MENU_FOLDER = "FolderContextMenu";
    private static final String CONTEXT_MENU_ITEM = "ItemContextMenu";
    private static final String CONTEXT_MENU_SYSTEM_ITEM = "SystemItemContextMenu";
    private static final String CONTEXT_MENU_MIX_ITEMS = "MixItemsContextMenu";
    private static final String CONTEXT_MENU_OBJECTSTORE_FOLDER = "ObjectStoreFolderContextMenu";
    private static final String CONTEXT_MENU_SEARCH = "SearchContextMenu";
    private static final String CONTEXT_MENU_SEARCH_TEMPLATE = "SearchTemplateContextMenu";
    private static final String CONTEXT_MENU_SEARCH_SEARCH_TEMPLATE = "SearchSearchTemplateContextMenu";
    private static final String CONTEXT_MENU_SELECT_OBJECT_ITEM = "SelectObjectItemContextMenu";
    private static final String CONTEXT_MENU_SELECT_OBJECT_FOLDER = "SelectObjectFolderContextMenu";
    private static final String CONTEXT_MENU_TEAMSPACE = "TeamspaceContextMenu";
    private static final String CONTEXT_MENU_TEAMSPACE_FOLDER = "TeamspaceFolderContextMenu";
    private static final String CONTEXT_MENU_TEAMSPACE_SUBFOLDER = "TeamspaceSubFolderContextMenu";
    private static final String CONTEXT_MENU_TEAMSPACE_TEMPLATE = "TeamspaceTemplateContextMenu";
    private static final String CONTEXT_MENU_TRACKER_QUEUE = "TrackerQueueContextMenu";
    private static final String CONTEXT_MENU_USER_QUEUE = "UserQueueContextMenu";
    private static final String CONTEXT_MENU_PROCESS_QUEUE = "ProcessQueueContextMenu";
    private static final String CONTEXT_MENU_WORK_ITEM_FOLDER = "WorkItemFolderContextMenu";
    private static final String CONTEXT_MENU_WORK_ITEM_DOCUMENT = "WorkItemDocumentContextMenu";
    private static final String CONTEXT_MENU_VERSIONS = "VersionsContextMenu";
    private static final String CONTEXT_MENU_VERSIONS_CM = "VersionsCMContextMenu";
    private static final String DISABLE_AUTOCOMPLETE = "disableAutocomplete";
    private static final String CULTURAL_COLLATION = "culturalCollation";
    private static final String USER_ACTION_MACROS = "userActionMacros";
    private static final String CHECKOUT_ON_OPEN_DOC = "checkoutOnOpenDoc";
    private static final String PROMPT_CLOSING_OFFICE = "promptCloseOffice";
    private static final String DELETE_LOCAL_ON_ADD = "deleteLocalOnAdd";
    private static final String DELETE_LOCAL_ON_SAVE = "deleteLocalOnSave";
    private static final String ADD_WITH_ENTRY_TEMPLATE_ONLY = "addWithEntryTemplateOnly";
    private static final String PROMPT_FOR_PROPERTIES_ON_ADD = "promptForPropsOnAdd";
    private static final String DELETE_EMAIL_ON_ADD = "deleteEmailOnAdd";
    private static final String SEND_EMAIL_AS_LINK_ONLY = "sendEmailAsLinkOnly";
    private static final String ENABLE_PROP_MAPPING_FOR_ADD = "enablePropMappingForAdd";
    private static final String MOBILE_APP_ACCESS = "mobileAppAccess";
    private static final String ADD_PHOTO_FROM_MOBILE = "addPhotoFromMobile";
    private static final String ADD_DOC_FOLDERS_TO_REPO = "addDocFoldersToRepo";
    private static final String OPEN_DOC_FROM_OTHER_APP = "openDocFromOtherApp";
    private static final String MOBILE_FEATURES = "mobileFeatures";

    public DesktopConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    public String getObjectType() {
        return "desktop";
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            this.setDefaultValue(MOBILE_APP_ACCESS, "true");
            this.setDefaultValue(ADD_PHOTO_FROM_MOBILE, "true");
            this.setDefaultValue(ADD_DOC_FOLDERS_TO_REPO, "true");
            this.setDefaultValue(OPEN_DOC_FROM_OTHER_APP, "true");
            this.setDefaultValue(IS_VALID, "true");
        }
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME);
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    public String getDescription() {
        return this.properties.getProperty(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.properties.setProperty(DESCRIPTION, description);
    }

    public String getDefault() {
        return this.properties.getProperty(IS_DEFAULT);
    }

    public void setDefault(String isDefault) {
        this.properties.setProperty(IS_DEFAULT, isDefault);
    }

    public boolean getFileIntoFolder() {
        return Boolean.parseBoolean(this.properties.getProperty(FILE_INTO_FOLDER, "false"));
    }

    public void setFileIntoFolder(boolean fileIntoFolder) {
        this.properties.setProperty(FILE_INTO_FOLDER, Boolean.toString(fileIntoFolder));
    }

    public boolean getShowSecurity() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_SECURITY, "false"));
    }

    public void setShowSecurity(boolean showSecurity) {
        this.properties.setProperty(SHOW_SECURITY, Boolean.toString(showSecurity));
    }

    public String[] getServersId() {
        return this.stringToArray(this.properties.getProperty(SERVERS));
    }

    public void setServersId(String[] servers) {
        this.properties.setProperty(SERVERS, this.arrayToString(servers));
    }

    public String[] getAssignedMobileFeaturesId() {
        return this.stringToArray(this.properties.getProperty(MOBILE_FEATURES));
    }

    public String[] getMobileFeaturesId() {
        return this.stringToArray(this.properties.getProperty(MOBILE_FEATURES, "favorites, browse, search, casesearch, datacap"));
    }

    public void setMobileFeaturesId(String[] featureIds) {
        this.properties.setProperty(MOBILE_FEATURES, this.arrayToString(featureIds));
    }

    public String[] getRepositoriesId() {
        return this.stringToArray(this.properties.getProperty(REPOSITORIES));
    }

    public void setRepositoriesId(String[] repositories) {
        this.properties.setProperty(REPOSITORIES, this.arrayToString(repositories));
    }

    public String getMenuPrefix() {
        return this.properties.getProperty(MENU_PREFIX);
    }

    public void setMenuPrefix(String menuPrefix) {
        this.properties.setProperty(MENU_PREFIX, menuPrefix);
    }

    public String getHelpUrl() {
        return this.properties.getProperty(HELP_URL);
    }

    public void setHelpUrl(String helpUrl) {
        this.properties.setProperty(HELP_URL, helpUrl);
    }

    public String getMessageSearchUrl() {
        return this.properties.getProperty(MESSAGE_SEARCH_URL);
    }

    public void setMessageSearchUrl(String messageSearchUrl) {
        this.properties.setProperty(MESSAGE_SEARCH_URL, messageSearchUrl);
    }

    public String getApplicationName() {
        return this.properties.getProperty(APPLICATION_NAME);
    }

    public void setApplicationName(String applicationName) {
        this.properties.setProperty(APPLICATION_NAME, applicationName);
    }

    public String getLoginLogoUrl() {
        return this.properties.getProperty(LOGIN_LOGO_URL);
    }

    public void setLoginLogoUrl(String loginLogoUrl) {
        this.properties.setProperty(LOGIN_LOGO_URL, loginLogoUrl);
    }

    public String getBannerLogoUrl() {
        return this.properties.getProperty(BANNER_LOGO_URL);
    }

    public void setBannerLogoUrl(String bannerLogoUrl) {
        this.properties.setProperty(BANNER_LOGO_URL, bannerLogoUrl);
    }

    public String getLoginInformationUrl() {
        return this.properties.getProperty(LOGIN_INFORMATION_URL);
    }

    public void setLoginInformationUrl(String loginInformationUrl) {
        this.properties.setProperty(LOGIN_INFORMATION_URL, loginInformationUrl);
    }

    public String getPasswordRulesUrl() {
        return this.properties.getProperty(PASSWORD_RULES_URL);
    }

    public void setPasswordRulesUrl(String passwordRulesUrl) {
        this.properties.setProperty(PASSWORD_RULES_URL, passwordRulesUrl);
    }

    public boolean isShowFieldHoverHelp() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_FIELD_HOVER_HELP, "false"));
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.properties.setProperty(SHOW_FIELD_HOVER_HELP, Boolean.toString(showFieldHoverHelp));
    }

    @Override
    public boolean isValid() {
        return Boolean.parseBoolean(this.properties.getProperty(IS_VALID, "true"));
    }

    @Override
    public void setValid(boolean value) {
        this.properties.setProperty(IS_VALID, Boolean.toString(value));
    }

    public boolean isAccessControlEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(ACCESS_CONTROL_ENABLED, "false"));
    }

    public void setAccessControlEnabled(boolean enabled) {
        this.properties.setProperty(ACCESS_CONTROL_ENABLED, Boolean.toString(enabled));
    }

    public Collection<ServerConfig> getServerList() {
        return this.getMap(ServerConfig.class, "navigator", this.getServersId(), new boolean[0]).values();
    }

    public Map<String, ServerConfig> getServerMap() {
        return this.getMap(ServerConfig.class, "navigator", this.getServersId(), new boolean[0]);
    }

    public ServerConfig getServer(String serverId) {
        ServerConfig serverConfig = null;
        try {
            serverConfig = Config.getServerConfig("navigator", serverId);
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, "getServer", "unexpected error", (Throwable)e);
        }
        return serverConfig;
    }

    public Collection<RepositoryConfig> getRepositoryList() {
        return this.getMap(RepositoryConfig.class, "navigator", this.getRepositoriesId(), new boolean[0]).values();
    }

    public Map<String, RepositoryConfig> getRepositoryMap() {
        return this.getMap(RepositoryConfig.class, "navigator", this.getRepositoriesId(), new boolean[0]);
    }

    public RepositoryConfig getRepository(String repositoryId) {
        RepositoryConfig repositoryConfig = null;
        try {
            repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, "getRepository", "unexpected error", (Throwable)e);
        }
        return repositoryConfig;
    }

    public boolean hasRepository(String repositoryId) {
        boolean found = false;
        String[] ids = this.getRepositoriesId();
        if (ids == null || ids.length == 0) {
            return found;
        }
        for (String id : ids) {
            if (id == null || !id.equalsIgnoreCase(repositoryId)) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getDefaultRepositoryId() {
        return this.properties.getProperty(DEFAULT_REPOSITORY);
    }

    public void setDefaultRepositoryId(String repositoryId) {
        this.properties.setProperty(DEFAULT_REPOSITORY, repositoryId);
    }

    public String getAdditionalScript() {
        return this.properties.getProperty(ADDITIONAL_SCRIPT);
    }

    public void setAdditionalScript(String scriptName) {
        this.properties.setProperty(ADDITIONAL_SCRIPT, scriptName);
    }

    public String getAdditionalCss() {
        return this.properties.getProperty(ADDITIONAL_CSS);
    }

    public void setAdditionalCss(String cssName) {
        this.properties.setProperty(ADDITIONAL_CSS, cssName);
    }

    public String getLayout() {
        return this.properties.getProperty(LAYOUT);
    }

    public void setLayout(String layout) {
        this.properties.setProperty(LAYOUT, layout);
    }

    public String[] getFeatures() {
        return this.stringToArray(this.properties.getProperty(FEATURES));
    }

    public void setFeatures(String[] features) {
        this.properties.setProperty(FEATURES, this.arrayToString(features));
    }

    public String getDefaultFeature() {
        return this.properties.getProperty(DEFAULT_FEATURE);
    }

    public void setDefaultFeature(String defaultFeature) {
        this.properties.setProperty(DEFAULT_FEATURE, defaultFeature);
    }

    public String getLayoutLogFile() {
        return this.properties.getProperty(LAYOUT_LOG_FILE);
    }

    public void setLayoutLogFile(String logFile) {
        this.properties.setProperty(LAYOUT_LOG_FILE, logFile);
    }

    public String getBannerBackgroundColor() {
        return this.properties.getProperty(BANNER_BACKGROUND_COLOR);
    }

    public void setBannerBackgroundColor(String layoutBannerColor) {
        this.properties.setProperty(BANNER_BACKGROUND_COLOR, layoutBannerColor);
    }

    public String getBannerApplicationNameColor() {
        return this.properties.getProperty(BANNER_APPLICATION_NAME_COLOR);
    }

    public void setBannerApplicationNameColor(String bannerApplicationNameColor) {
        this.properties.setProperty(BANNER_APPLICATION_NAME_COLOR, bannerApplicationNameColor);
    }

    public String getBannerMenuColor() {
        return this.properties.getProperty(BANNER_MENU_COLOR);
    }

    public void setBannerMenuColor(String layoutBannerMenuColor) {
        this.properties.setProperty(BANNER_MENU_COLOR, layoutBannerMenuColor);
    }

    public String getTeamspacesDefaultRepository() {
        return this.properties.getProperty(TEAMSPACES_DEFAULT_REPOSITORY);
    }

    public void setTeamspacesDefaultRepository(String defaultRepository) {
        this.properties.setProperty(TEAMSPACES_DEFAULT_REPOSITORY, defaultRepository);
    }

    public String getWorkDefaultRepository() {
        return this.properties.getProperty(WORK_DEFAULT_REPOSITORY);
    }

    public void setWorkDefaultRepository(String defaultRepository) {
        this.properties.setProperty(WORK_DEFAULT_REPOSITORY, defaultRepository);
    }

    public String getOtherFeaturesDefaultRepository() {
        return this.properties.getProperty(OTHER_FEATURES_DEFAULT_REPOSITORY);
    }

    public void setotherFeaturesDefaultRepository(String defaultRepository) {
        this.properties.setProperty(OTHER_FEATURES_DEFAULT_REPOSITORY, defaultRepository);
    }

    public boolean getShowThumbnails() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_THUMBNAILS, "true"));
    }

    public void setShowThumbnails(boolean showThumbnails) {
        this.properties.setProperty(SHOW_THUMBNAILS, Boolean.toString(showThumbnails));
    }

    public boolean getShowViewFilmstrip() {
        String thumbnailValue = this.properties.getProperty(SHOW_THUMBNAILS, "true");
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_VIEWFILMSTRIP, thumbnailValue));
    }

    public void setShowViewFilmstrip(boolean showViewFilmstrip) {
        this.properties.setProperty(SHOW_VIEWFILMSTRIP, Boolean.toString(showViewFilmstrip));
    }

    public boolean getShowGlobalToolbar() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_GLOBAL_TOOLBAR, "false"));
    }

    public void setShowGlobalToolbar(boolean showGlobalToolbar) {
        this.properties.setProperty(SHOW_GLOBAL_TOOLBAR, Boolean.toString(showGlobalToolbar));
    }

    public String getActionHandler() {
        return this.properties.getProperty(ACTION_HANDLER);
    }

    public void setActionHandler(String actionHandler) {
        this.properties.setProperty(ACTION_HANDLER, actionHandler);
    }

    public String getViewer() {
        return this.properties.getProperty(VIEWER);
    }

    public void setViewer(String viewer) {
        this.properties.setProperty(VIEWER, viewer);
    }

    public String getTheme() {
        return this.properties.getProperty(THEME, "");
    }

    public void setTheme(String theme) {
        this.properties.setProperty(THEME, theme);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setApplicationSpaceLabels(String[] appSpaceLabels) {
        this.properties.setProperty(APPLICATION_SPACE_LABELS, this.arrayToString(appSpaceLabels));
    }

    public String[] getApplicationSpaceLabels() {
        return this.stringToArray(this.properties.getProperty(APPLICATION_SPACE_LABELS));
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type.equals(REPOSITORIES)) {
            return this.getRepositoriesList(appName);
        }
        if (type.equals(SERVERS)) {
            return this.getServersList(appName);
        }
        if (type.equals(INTERFACETEXTS)) {
            return this.getApplicationSpaceLabelsList(appName);
        }
        if (type.equals(MOBILE_FEATURES)) {
            return this.getMobileFeatureList(appName);
        }
        return null;
    }

    public Collection<MobileFeatureConfig> getMobileFeatureList(String idPrefix) {
        Collection<MobileFeatureConfig> features = this.getMap(MobileFeatureConfig.class, idPrefix, this.getMobileFeaturesId(), true).values();
        for (MobileFeatureConfig config : features) {
            if (!config.isEmpty()) continue;
            features = this.getMap(MobileFeatureConfig.class, "navigator.default.mobilefeature", this.getMobileFeaturesId(), true).values();
            break;
        }
        return features;
    }

    public Collection<InterfaceTextConfig> getFeatureLabelsList(String idPrefix) {
        return this.getMap(InterfaceTextConfig.class, idPrefix, this.getMobileFeaturesId(), true).values();
    }

    public static String getLocalizedFeatureLabel(MobileFeatureConfig mobileConfig, Locale locale) {
        String label = mobileConfig.getName();
        String id = mobileConfig.getObjectId();
        InterfaceTextConfig config = null;
        try {
            config = Config.getInterfaceTextConfig("navigator", id);
        }
        catch (Exception e) {
            return label;
        }
        if (!config.isEmpty() && config.getLocaleData() != null) {
            InterfaceTextLocaleConfig localeConfig = config.getLocaleData();
            if (localeConfig.properties.get(locale.toString()) != null) {
                label = (String)localeConfig.properties.get(locale.toString());
            } else if (localeConfig.properties.get(locale.toString().substring(0, 2)) != null) {
                label = (String)localeConfig.properties.get(locale.toString().substring(0, 2));
            }
        }
        return label;
    }

    public Collection<RepositoryConfig> getRepositoriesList(String idPrefix) {
        return this.getMap(RepositoryConfig.class, idPrefix, this.getRepositoriesId(), true).values();
    }

    public Collection<ServerConfig> getServersList(String idPrefix) {
        return this.getMap(ServerConfig.class, idPrefix, this.getServersId(), true).values();
    }

    public Collection<InterfaceTextConfig> getApplicationSpaceLabelsList(String idPrefix) {
        return this.getMap(InterfaceTextConfig.class, idPrefix, this.getApplicationSpaceLabels(), true).values();
    }

    public Collection<InterfaceTextConfig> getMobileFeatureLabelsList(String idPrefix) {
        return this.getMap(InterfaceTextConfig.class, idPrefix, this.getMobileFeaturesId(), true).values();
    }

    public Collection<InterfaceTextLocaleConfig> getApplicationSpaceLabelsLocaleList(String idPrefix) {
        return this.getMap(InterfaceTextLocaleConfig.class, idPrefix, this.getApplicationSpaceLabels(), true).values();
    }

    public Collection<InterfaceTextLocaleConfig> getMobileFeatureLabelsLocaleList(String idPrefix) {
        return this.getMap(InterfaceTextLocaleConfig.class, idPrefix, this.getMobileFeaturesId(), true).values();
    }

    public static String getLocalizedAppSpaceLabel(Collection<InterfaceTextConfig> list, String repositoryId, String appSpace, Locale locale) {
        String label = appSpace;
        for (InterfaceTextConfig itConfig : list) {
            if (!itConfig.getRepositoryId().equals(repositoryId) || !itConfig.getLabelKey().equals(appSpace)) continue;
            InterfaceTextLocaleConfig localeConfig = itConfig.getLocaleData();
            if (localeConfig.properties.get(locale.toString()) != null) {
                label = (String)localeConfig.properties.get(locale.toString());
                break;
            }
            if (localeConfig.properties.get(locale.toString().substring(0, 2)) == null) continue;
            label = (String)localeConfig.properties.get(locale.toString().substring(0, 2));
            break;
        }
        return label;
    }

    @Override
    public void delete() {
        String appName = this.getIdPrefix();
        this.deleteInterfaceTextAndLocale(this.getApplicationSpaceLabelsList(appName), this.getApplicationSpaceLabelsLocaleList(appName));
        this.deleteInterfaceTextAndLocale(this.getMobileFeatureLabelsList(appName), this.getMobileFeatureLabelsLocaleList(appName));
        Collection<MobileFeatureConfig> mobileFeatures = this.getMobileFeatureList(appName);
        if (!mobileFeatures.isEmpty()) {
            for (MobileFeatureConfig mobileFeature : mobileFeatures) {
                mobileFeature.delete();
            }
        }
        super.delete();
    }

    private void deleteInterfaceTextAndLocale(Collection<InterfaceTextConfig> interfaceTexts, Collection<InterfaceTextLocaleConfig> interfaceTextLocales) {
        if (!interfaceTexts.isEmpty()) {
            for (InterfaceTextConfig interfaceText : interfaceTexts) {
                interfaceText.delete();
            }
        }
        if (!interfaceTextLocales.isEmpty()) {
            for (InterfaceTextLocaleConfig interfaceTextLocale : interfaceTextLocales) {
                interfaceTextLocale.delete();
            }
        }
    }

    public void exportInterfaceText(String appName, OutputStreamWriter osw) throws IOException, FileNotFoundException {
        Collection<InterfaceTextConfig> interfaceTexts = this.getApplicationSpaceLabelsList(appName);
        DesktopConfig.writeConfigurationToFile(osw, interfaceTexts);
        Collection<InterfaceTextLocaleConfig> interfaceTextLocales = this.getApplicationSpaceLabelsLocaleList(appName);
        DesktopConfig.writeConfigurationToFile(osw, interfaceTextLocales);
        interfaceTexts = this.getMobileFeatureLabelsList(appName);
        DesktopConfig.writeConfigurationToFile(osw, interfaceTexts);
        interfaceTextLocales = this.getMobileFeatureLabelsLocaleList(appName);
        DesktopConfig.writeConfigurationToFile(osw, interfaceTextLocales);
    }

    public void exportMobileFeature(String appName, OutputStreamWriter osw) throws IOException, FileNotFoundException {
        Collection<MobileFeatureConfig> mobileFeatures = this.getMobileFeatureList(appName);
        ConfigurationObject.writeConfigurationToFile(osw, mobileFeatures);
    }

    public void exportSecurity(String appName, OutputStreamWriter osw) throws IOException, FileNotFoundException {
    }

    public void setSupportWorkflowNotification(boolean supportNotification) {
        this.properties.setProperty(SUPPORT_WORKFLOW_NOTIFICATION, Boolean.toString(supportNotification));
    }

    public boolean getSupportWorkflowNotification() {
        return Boolean.parseBoolean(this.properties.getProperty(SUPPORT_WORKFLOW_NOTIFICATION, "false"));
    }

    public void setPreventCreateNewSearch(boolean preventCreateNewSearch) {
        this.properties.setProperty(PREVENT_CREATE_NEW_SEARCH, Boolean.toString(preventCreateNewSearch));
    }

    public boolean getPreventCreateNewSearch() {
        return Boolean.parseBoolean(this.properties.getProperty(PREVENT_CREATE_NEW_SEARCH, "false"));
    }

    public void setPreventCreateNewUnifiedSearch(boolean preventCreateNewUnifiedSearch) {
        this.properties.setProperty(PREVENT_CREATE_NEW_UNIFIED_SEARCH, Boolean.toString(preventCreateNewUnifiedSearch));
    }

    public boolean getPreventCreateNewUnifiedSearch() {
        return Boolean.parseBoolean(this.properties.getProperty(PREVENT_CREATE_NEW_UNIFIED_SEARCH, "false"));
    }

    public void setMaxNumberDocToAdd(int maxNumberDocToAdd) {
        this.properties.setProperty(MAX_NUMBER_DOC_TO_ADD, Integer.toString(maxNumberDocToAdd));
    }

    public int getMaxNumberDocToAdd() {
        return Integer.parseInt(this.properties.getProperty(MAX_NUMBER_DOC_TO_ADD, "50"));
    }

    public void setMaxNumberDocToModify(int maxNumberDocToModify) {
        this.properties.setProperty(MAX_NUMBER_DOC_TO_MODIFY, Integer.toString(maxNumberDocToModify));
    }

    public int getMaxNumberDocToModify() {
        return Integer.parseInt(this.properties.getProperty(MAX_NUMBER_DOC_TO_MODIFY, "50"));
    }

    public boolean getDisableAutocomplete() {
        return Boolean.parseBoolean(this.properties.getProperty(DISABLE_AUTOCOMPLETE, "false"));
    }

    public void setDisableAutocomplete(boolean disableAutocomplete) {
        this.properties.setProperty(DISABLE_AUTOCOMPLETE, Boolean.toString(disableAutocomplete));
    }

    public boolean getCulturalCollation() {
        return Boolean.parseBoolean(this.properties.getProperty(CULTURAL_COLLATION, "false"));
    }

    public void setCulturalCollation(boolean culturalCollation) {
        this.properties.setProperty(CULTURAL_COLLATION, Boolean.toString(culturalCollation));
    }

    public boolean getCheckoutOnOpenDoc() {
        return Boolean.parseBoolean(this.properties.getProperty(CHECKOUT_ON_OPEN_DOC, "false"));
    }

    public void setCheckoutOnOpenDoc(boolean value) {
        this.properties.setProperty(CHECKOUT_ON_OPEN_DOC, Boolean.toString(value));
    }

    public boolean getPromptCloseOfficeIfDocCheckout() {
        return Boolean.parseBoolean(this.properties.getProperty(PROMPT_CLOSING_OFFICE, "false"));
    }

    public void setPromptCloseOfficeIfDocCheckout(boolean value) {
        this.properties.setProperty(PROMPT_CLOSING_OFFICE, Boolean.toString(value));
    }

    public boolean getDeleteLocalOnAdd() {
        return Boolean.parseBoolean(this.properties.getProperty(DELETE_LOCAL_ON_ADD, "false"));
    }

    public void seDeleteLocalOnAdd(boolean value) {
        this.properties.setProperty(DELETE_LOCAL_ON_ADD, Boolean.toString(value));
    }

    public boolean getDeleteLocalOnSave() {
        return Boolean.parseBoolean(this.properties.getProperty(DELETE_LOCAL_ON_SAVE, "false"));
    }

    public void setDeleteLocalOnSave(boolean value) {
        this.properties.setProperty(DELETE_LOCAL_ON_SAVE, Boolean.toString(value));
    }

    public boolean getAddWithEntryTemplateOnly() {
        return Boolean.parseBoolean(this.properties.getProperty(ADD_WITH_ENTRY_TEMPLATE_ONLY, "false"));
    }

    public void setAddWithEntryTemplateOnly(boolean value) {
        this.properties.setProperty(ADD_WITH_ENTRY_TEMPLATE_ONLY, Boolean.toString(value));
    }

    public boolean getPromptForPropsOnAdd() {
        return Boolean.parseBoolean(this.properties.getProperty(PROMPT_FOR_PROPERTIES_ON_ADD, "false"));
    }

    public void setPromptForPropsOnAdd(boolean value) {
        this.properties.setProperty(PROMPT_FOR_PROPERTIES_ON_ADD, Boolean.toString(value));
    }

    public boolean getDeleteEmailOnAdd() {
        return Boolean.parseBoolean(this.properties.getProperty(DELETE_EMAIL_ON_ADD, "false"));
    }

    public void setDeleteEmailOnAdd(boolean value) {
        this.properties.setProperty(DELETE_EMAIL_ON_ADD, Boolean.toString(value));
    }

    public boolean getSendEmailAsLinkOnly() {
        return Boolean.parseBoolean(this.properties.getProperty(SEND_EMAIL_AS_LINK_ONLY, "true"));
    }

    public void setSendEmailAsLinkOnly(boolean value) {
        this.properties.setProperty(SEND_EMAIL_AS_LINK_ONLY, Boolean.toString(value));
    }

    public boolean getEnablePropMappingForAdd() {
        return Boolean.parseBoolean(this.properties.getProperty(ENABLE_PROP_MAPPING_FOR_ADD, "false"));
    }

    public void setEnablePropMappingForAdd(boolean value) {
        this.properties.setProperty(ENABLE_PROP_MAPPING_FOR_ADD, Boolean.toString(value));
    }

    public boolean getMobileAppAccess() {
        return Boolean.parseBoolean(this.properties.getProperty(MOBILE_APP_ACCESS, "false"));
    }

    public void setMobileAppAccess(boolean mobileAppAccess) {
        this.properties.setProperty(MOBILE_APP_ACCESS, Boolean.toString(mobileAppAccess));
    }

    public boolean getAddPhotoFromMobile() {
        return Boolean.parseBoolean(this.properties.getProperty(ADD_PHOTO_FROM_MOBILE, "false"));
    }

    public void setAddPhotoFromMobile(boolean addPhotoFromMobile) {
        this.properties.setProperty(ADD_PHOTO_FROM_MOBILE, Boolean.toString(addPhotoFromMobile));
    }

    public boolean getAddDocFoldersToRepo() {
        return Boolean.parseBoolean(this.properties.getProperty(ADD_DOC_FOLDERS_TO_REPO, "false"));
    }

    public void setAddDocFoldersToRepo(boolean addDocFoldersToRepo) {
        this.properties.setProperty(ADD_DOC_FOLDERS_TO_REPO, Boolean.toString(addDocFoldersToRepo));
    }

    public boolean getOpenDocFromOtherApp() {
        return Boolean.parseBoolean(this.properties.getProperty(ADD_PHOTO_FROM_MOBILE, "false"));
    }

    public void setOpenDocFromOtherApp(boolean openDocFromOtherApp) {
        this.properties.setProperty(ADD_PHOTO_FROM_MOBILE, Boolean.toString(openDocFromOtherApp));
    }

    public Constants.AuthenticationType getAuthenticationType() {
        Constants.AuthenticationType authType = Constants.AuthenticationType.CONTAINER;
        if (this.properties.getProperty(AUTHENTICATION_TYPE) != null) {
            try {
                authType = Constants.AuthenticationType.getEnum((int)new Integer(this.properties.getProperty(AUTHENTICATION_TYPE)));
            }
            catch (Exception e) {
                authType = Constants.AuthenticationType.CONTAINER;
            }
        } else {
            authType = this.getObjectId() != null && this.getObjectId().equals("admin") ? Constants.AuthenticationType.CONTAINER : Constants.AuthenticationType.REPOSITORY;
        }
        return authType;
    }

    public void setAuthenticationType(Constants.AuthenticationType authType) {
        if (authType != null) {
            this.properties.setProperty(AUTHENTICATION_TYPE, new Integer(authType.getValue()).toString());
        }
    }

    public String getDefaultDataSource() {
        return this.properties.getProperty(DEFAULT_DATA_SOURCE);
    }

    public void setDefaultDataSource(String defaultDataSource) {
        this.properties.setProperty(DEFAULT_DATA_SOURCE, defaultDataSource);
    }

    public String[] getDataSources() {
        return this.stringToArray(this.properties.getProperty(DATA_SOURCES));
    }

    public void setDataSources(String[] dataSources) {
        this.properties.setProperty(DATA_SOURCES, this.arrayToString(dataSources));
    }

    public void setPluginValues(HttpServletRequest request, JSONObject jsonObject) {
        Map<String, PluginMenuType> pluginMenuTypeMap = PluginUtil.getPluginMenuTypes(request);
        for (String key : pluginMenuTypeMap.keySet()) {
            PluginMenuType pluginMenuType = pluginMenuTypeMap.get(key);
            String pluginMenuTypeId = pluginMenuType.getId();
            String pluginMenuId = (String)jsonObject.get(pluginMenuTypeId);
            if (pluginMenuId == null) continue;
            this.setProperty(pluginMenuTypeId, pluginMenuId);
        }
    }

    public String[] getUserActionMacros() {
        return this.stringToArray(this.properties.getProperty(USER_ACTION_MACROS, "addedBy, modifiedBy, checkedOutBy"));
    }

    public void setUserActionMacros(String[] userActionMacros) {
        this.properties.setProperty(USER_ACTION_MACROS, this.arrayToString(userActionMacros));
    }

    public Collection<UserActionMacroConfig> getUserActionMacrosList(String prefix) {
        return this.getMap(UserActionMacroConfig.class, prefix, this.getUserActionMacros(), true).values();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

