/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Cache;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.AdminLogger;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.PropertyConverter;

public class DatabaseConfiguration
extends org.apache.commons.configuration.DatabaseConfiguration {
    private DataSource datasource;
    private String table;
    private String nameColumn;
    private String keyColumn;
    private String valueColumn;
    private String name;
    private final boolean doCommits;
    private static final int DISCONNECT_ERROR_CODE = -4499;
    private static final String DISCONNET_SQL_STATE = "08001";
    private static final String RETRY_CONNECTION = "DBReconnect";

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name) {
        this(datasource, table, nameColumn, keyColumn, valueColumn, name, false);
    }

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name, boolean commits) {
        super(datasource, table, nameColumn, keyColumn, valueColumn, name, commits);
        this.datasource = datasource;
        this.table = table;
        this.nameColumn = nameColumn;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.name = name;
        this.doCommits = commits;
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn) {
        this(datasource, table, null, keyColumn, valueColumn, null);
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn, boolean commits) {
        this(datasource, table, null, keyColumn, valueColumn, null, commits);
    }

    public Object getProperty(String key) {
        Object o = null;
        try {
            o = this._getProperty(key);
        }
        catch (MissingValueException e) {
            try {
                Config.reconnectToDB();
                o = this._getProperty(key);
            }
            catch (Exception ex) {
                AdminLogger.logError((Object)this, "getProperty", "reconnect failed", (Throwable)ex);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _getProperty(String key) throws MissingValueException {
        ArrayList<String> result = null;
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(this.table).append(" WHERE ");
        query.append(this.keyColumn).append("=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            block14: {
                try {
                    conn = this.getConnection();
                    pstmt = conn.prepareStatement(query.toString());
                    pstmt.setString(1, key);
                    if (this.nameColumn != null) {
                        pstmt.setString(2, this.name);
                    }
                    ResultSet rs = pstmt.executeQuery();
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        int length;
                        String value = null;
                        Clob clob = rs.getClob(this.valueColumn);
                        if (clob != null && (length = (int)clob.length()) > 0) {
                            Reader is = clob.getCharacterStream();
                            StringBuffer sb = new StringBuffer();
                            char[] buffer = new char[length];
                            int count = 0;
                            try {
                                while ((count = is.read(buffer)) != -1) {
                                    sb.append(buffer);
                                }
                                value = new String(sb);
                            }
                            catch (Exception e) {
                                value = null;
                            }
                        }
                        if (this.isDelimiterParsingDisabled()) {
                            results.add(value);
                            continue;
                        }
                        CollectionUtils.addAll(results, (Iterator)PropertyConverter.toIterator(value, (char)this.getListDelimiter()));
                    }
                    if (results.isEmpty()) break block14;
                    result = results.size() > 1 ? results : results.get(0);
                }
                catch (SQLException e) {
                    this.fireError(5, key, null, e);
                    AdminLogger.logError((Object)this, "getProperty", "key = " + key, (Throwable)e);
                    Object retryConnection = Cache.getInstance().get(RETRY_CONNECTION);
                    if (retryConnection == null && e.getErrorCode() == -4499 && e.getSQLState().equalsIgnoreCase(DISCONNET_SQL_STATE)) {
                        AdminLogger.logDebug((Object)this, "getProperty", "Disconnect from the datasource: " + e.getSQLState());
                        Cache.getInstance().add(RETRY_CONNECTION, Boolean.TRUE);
                        throw new MissingValueException("Disconnect", e.getSQLState());
                    }
                    Object var17_19 = null;
                    this.close(conn, pstmt);
                }
            }
            Object var17_18 = null;
            this.close(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            this.close(conn, pstmt);
            throw throwable;
        }
        if (result == null) {
            AdminLogger.logDebug((Object)this, "getProperty", "key = " + key + " return empty result back. Make sure Grant SQL has been run if value is expected");
        }
        return result;
    }

    private void close(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error((Object)"An error occured on closing the statement", (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error((Object)"An error occured on closing the connection", (Throwable)e);
        }
    }
}

