/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Cache;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationObject {
    protected static final char ARRAY_DELIMITER = ',';
    protected static final char KEY_DELIMITER = '.';
    protected static final char LIST_ESC_CHAR = '\\';
    protected static final String LIST_ESCAPE = String.valueOf('\\');
    protected static final int MODIFIER = 26;
    private Configuration configuration;
    protected Properties properties;
    private String objectId;
    private String idPrefix;
    protected boolean cloned = false;

    public ConfigurationObject(Configuration configuration, String idPrefix, String objectId) {
        this.configuration = configuration;
        this.objectId = objectId;
        this.idPrefix = idPrefix;
        this.load();
    }

    public Configuration getConfigurationObject() {
        return this.configuration;
    }

    public abstract String getObjectType();

    public String getName() {
        return "";
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public String getKey() {
        String key = this.idPrefix == null || this.idPrefix.length() == 0 ? this.getObjectType() + '.' + this.objectId : this.getObjectType() + '.' + this.idPrefix + '.' + this.objectId;
        return key;
    }

    public Collection getList(String type, String appName, HttpServletRequest request) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        AbstractConfiguration defaultConfig = Config.getDefaultConfiguration();
        String key = this.getKey();
        if (key.startsWith("icon.navigator.default") || key.startsWith("iconStatus.navigator.") || key.startsWith("filetype.navigator") || key.startsWith("interfaceText.navigator")) {
            if (this.configuration != null && this.configuration.containsKey(key)) {
                Configuration configuration = this.configuration;
                synchronized (configuration) {
                    this.properties = this.configuration.getProperties(key);
                }
            } else {
                this.properties = defaultConfig != null && defaultConfig.containsKey(key) ? Config.getDefaultConfiguration().getProperties(key) : new Properties();
            }
        } else if (defaultConfig != null && defaultConfig.containsKey(key)) {
            this.properties = Config.getDefaultConfiguration().getProperties(key);
        } else if (this.configuration != null) {
            Configuration configuration = this.configuration;
            synchronized (configuration) {
                this.properties = this.configuration.getProperties(key);
            }
        } else {
            this.properties = new Properties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ConfigurationException {
        if (!this.cloned) {
            String propertiesString = this.propertiesToString(this.properties);
            Configuration configuration = this.configuration;
            synchronized (configuration) {
                this.configuration.setProperty(this.getKey(), (Object)propertiesString);
            }
        }
    }

    public void dump(OutputStreamWriter osw) throws IOException {
        String configString = this.getKey() + " = " + this.propertiesToString(this.properties);
        osw.write(configString);
        osw.write("\n");
    }

    public static <V extends ConfigurationObject> void writeConfigurationToFile(OutputStreamWriter osw, Collection<V> configList) throws IOException, FileNotFoundException {
        for (ConfigurationObject configObject : configList) {
            if (configObject.isEmpty()) continue;
            configObject.dump(osw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            this.configuration.clearProperty(this.getKey());
        }
    }

    public boolean isEmpty() {
        return this.properties.entrySet().size() <= 0;
    }

    public List stringToList(String string) {
        return PropertyConverter.split((String)string, (char)',');
    }

    public String[] stringToArray(String string) {
        String[] array = null;
        if (string == null || string.length() == 0) {
            array = new String[]{};
        } else {
            List list = PropertyConverter.split((String)string, (char)',');
            array = new String[list.size()];
            list.toArray(array);
        }
        return array;
    }

    public String arrayToString(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            String escapedValue = PropertyConverter.escapeDelimiters((String)array[i], (char)',');
            stringBuffer.append(escapedValue);
        }
        return stringBuffer.toString();
    }

    protected boolean skipThisPropertyWhenSaving(String key) {
        return false;
    }

    protected String propertiesToString(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (this.skipThisPropertyWhenSaving(key)) continue;
            if (stringBuffer.length() > 1) {
                stringBuffer.append(';');
            }
            String value = properties.getProperty(key);
            stringBuffer.append(key);
            stringBuffer.append("=");
            if (value != null && value.indexOf(LIST_ESCAPE + ';') == -1) {
                value = PropertyConverter.escapeDelimiters((String)value, (char)';');
            }
            stringBuffer.append(value);
        }
        return stringBuffer.toString();
    }

    public String covertEmptyStringtoNull(String value) {
        return value != null && value.length() == 0 ? null : value;
    }

    public <V extends ConfigurationObject> Map<String, V> getMap(Class<V> configClass, String idPrefix, String[] ids, boolean ... flags) {
        boolean skipCaching = false;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        LinkedHashMap<String, V> map = this.getConfiguration(configClass, idPrefix, ids, skipCaching);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends ConfigurationObject> LinkedHashMap<String, V> getConfiguration(Class<V> configClass, String idPrefix, String[] ids, boolean ... flags) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>();
        boolean skipCaching = false;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        try {
            LinkedHashMap<String, V> linkedHashMap = map;
            synchronized (linkedHashMap) {
                for (String id : ids) {
                    if (id == null || id.length() <= 0) continue;
                    V config = Config.getConfiguration(configClass, idPrefix, id, skipCaching);
                    map.put(id, config);
                }
            }
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, "LinkedHasMap", "Error in getting configuraiton", (Throwable)e);
        }
        return map;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Set<Map.Entry<Object, Object>> keys = this.properties.entrySet();
        for (Map.Entry<Object, Object> entry : keys) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof String) {
                String temp = (String)entryValue;
                if (temp.equals("true")) {
                    json.put(entry.getKey(), (Object)true);
                    continue;
                }
                if (temp.equals("false")) {
                    json.put(entry.getKey(), (Object)false);
                    continue;
                }
                if (temp.indexOf(",") > -1) {
                    String[] values = temp.split(",");
                    JSONArray jsonArray = new JSONArray();
                    for (String value : values) {
                        jsonArray.add(value);
                    }
                    json.put(entry.getKey(), jsonArray);
                    continue;
                }
                json.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(entryValue instanceof ConfigurationObject)) continue;
            ConfigurationObject configObj = (ConfigurationObject)entryValue;
            json.put(entry.getKey(), configObj.toJSON());
        }
        if (this.getObjectId() != null) {
            json.put("id", this.getObjectId());
        }
        return json;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getPropertyValue(String key) {
        return this.properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPropertyNames() {
        String key = this.getClass().getName() + ".getConstants.";
        LinkedHashMap<String, String> constants = (LinkedHashMap<String, String>)Cache.getInstance().get(key);
        if (constants == null) {
            constants = new LinkedHashMap<String, String>();
            try {
                LinkedHashMap<String, String> linkedHashMap = constants;
                synchronized (linkedHashMap) {
                    Field[] flds;
                    Class<?> c = this.getClass();
                    for (Field f : flds = c.getDeclaredFields()) {
                        if (f.isEnumConstant() || 26 != f.getModifiers() || f.getType() != String.class) continue;
                        f.setAccessible(true);
                        constants.put((String)f.get(this), (String)f.get(this));
                    }
                }
            }
            catch (Exception e) {
                AdminLogger.logError((Object)this, "getPropertyNames", "Key is: " + key, (Throwable)e);
            }
            Cache.getInstance().add(key, constants);
        }
        return constants;
    }

    public void setValues(JSONObject json) {
        this.setValues(json, false);
    }

    public void setValues(JSONObject json, boolean forceUpdate) {
        this.setValues(json, forceUpdate, true);
    }

    protected void setValues(JSONObject json, boolean forceUpdate, boolean escapeDelimiters) {
        Map<String, String> names = this.getPropertyNames();
        Set keys = json.entrySet();
        for (Map.Entry entry : keys) {
            String sValue;
            String key = (String)entry.getKey();
            if (!forceUpdate && !names.containsKey(key)) continue;
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    sValue = (String)jsonArray.get(i);
                    if (escapeDelimiters) {
                        sValue = PropertyConverter.escapeListDelimiter((String)sValue, (char)';');
                        sValue = PropertyConverter.escapeDelimiters((String)sValue, (char)',');
                    }
                    buffer.append(sValue);
                }
                sValue = buffer.toString();
            } else {
                String string = sValue = value != null ? value.toString() : "";
                if (escapeDelimiters) {
                    sValue = PropertyConverter.escapeListDelimiter((String)sValue, (char)';');
                }
            }
            this.properties.setProperty(key, sValue);
        }
    }

    public void removeValuesFromList(String key, List<String> deleteValues) {
        this.removeValuesFromList(key, deleteValues, this.properties);
    }

    protected void removeValuesFromList(String key, List<String> deleteValues, Properties props) {
        String[] array = this.stringToArray(props.getProperty(key));
        boolean removed = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String val = array[i];
            if (!this.isInList(deleteValues, val)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                String escapedValue = PropertyConverter.escapeDelimiters((String)val, (char)',');
                stringBuffer.append(escapedValue);
                continue;
            }
            removed = true;
        }
        if (removed) {
            props.setProperty(key, stringBuffer.toString());
        }
    }

    private boolean isInList(List<String> keys, String key) {
        for (int i = 0; i < keys.size(); ++i) {
            if (!keys.get(i).equals(key)) continue;
            return true;
        }
        return false;
    }

    public void addValueToList(String key, String value) {
        String[] array = this.stringToArray(this.properties.getProperty(key));
        String[] newArray = new String[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        newArray[array.length] = value;
        this.properties.setProperty(key, this.arrayToString(newArray));
    }

    protected void setDefaultValue(String propertyName, String defaultValue) {
        if (this.properties.getProperty(propertyName) == null) {
            this.properties.setProperty(propertyName, defaultValue);
        }
    }

    public String toString() {
        return this.getObjectId();
    }
}

