/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Cache;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.DatabaseConfiguration;
import com.ibm.ecm.configuration.DesktopAccessConfig;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.IconConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.IdLabelConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.InterfaceTextLocaleConfig;
import com.ibm.ecm.configuration.LocaleConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.MenuTypeConfig;
import com.ibm.ecm.configuration.MobileFeatureConfig;
import com.ibm.ecm.configuration.ODLoginConfig;
import com.ibm.ecm.configuration.PluginConfig;
import com.ibm.ecm.configuration.PluginUserConfig;
import com.ibm.ecm.configuration.PropertyMappingConfig;
import com.ibm.ecm.configuration.RecentSearchConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.ServerConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import com.ibm.ecm.configuration.UserConfig;
import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.configuration.ViewerDefConfig;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.serviceability.Logger;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final char LIST_DELIMITER = ';';
    private static DataSource dataSource;
    private static AbstractConfiguration configuration;
    private static AbstractConfiguration defaultConfiguration;
    private static Cache cache;
    private static String schema;
    private static String jndiResource;
    public static final String APPLICATION_NAME = "navigator";
    private static CONFIGURATION_TYPE configurationType;

    public static synchronized void initialize(String enablePropertiesConfig, String propertiesFileName, String userDefinedSchema, String userDefinedJNDI) throws Exception {
        URL url;
        String methodName = "initialize";
        AdminLogger.logEntry(Config.class, methodName);
        String configTypeEnvVar = System.getenv("newConfig");
        if (configTypeEnvVar != null && configTypeEnvVar.toLowerCase().equalsIgnoreCase("true") || enablePropertiesConfig != null && enablePropertiesConfig.equalsIgnoreCase("true")) {
            configurationType = CONFIGURATION_TYPE.PROPERTIES;
        }
        if (defaultConfiguration == null) {
            url = Config.class.getResource("/com/ibm/ecm/configuration/DefaultConfiguration.properties");
            defaultConfiguration = new PropertiesConfiguration();
            defaultConfiguration.setListDelimiter(';');
            ((PropertiesConfiguration)defaultConfiguration).setURL(url);
            AdminLogger.logInfo(Config.class, methodName, "Loading default configuration from " + url.toString());
            try {
                ((PropertiesConfiguration)defaultConfiguration).load();
            }
            catch (Exception e) {
                AdminLogger.logError(Config.class, methodName, e);
            }
            ((PropertiesConfiguration)defaultConfiguration).setAutoSave(true);
            AdminLogger.logDebug(Config.class, methodName, "Default configuration loaded.");
        }
        if (configuration == null) {
            if (configurationType == CONFIGURATION_TYPE.PROPERTIES) {
                if (propertiesFileName == null) {
                    propertiesFileName = "/Configuration.properties";
                }
                url = Config.class.getResource(propertiesFileName);
                configuration = new PropertiesConfiguration();
                configuration.setListDelimiter(';');
                ((PropertiesConfiguration)configuration).setURL(url);
                AdminLogger.logInfo(Config.class, methodName, "Loading configuration from " + url.toString());
                try {
                    ((PropertiesConfiguration)configuration).load();
                }
                catch (Exception e) {
                    AdminLogger.logError(Config.class, methodName, e);
                }
                ((PropertiesConfiguration)configuration).setAutoSave(true);
                AdminLogger.logDebug(configuration, methodName, "Create a Properties configuration object");
            } else if (configurationType == CONFIGURATION_TYPE.DATABASE) {
                InitialContext initialContext = null;
                try {
                    AdminLogger.logInfo(Config.class, methodName, "User defined JNDI resource: " + userDefinedJNDI);
                    initialContext = new InitialContext();
                    if (userDefinedJNDI != null && userDefinedJNDI.length() > 0) {
                        AdminLogger.logInfo(Config.class, methodName, "Loading configuration from database specified by user defined JNDI resource " + userDefinedJNDI);
                        dataSource = (DataSource)initialContext.lookup(userDefinedJNDI);
                        jndiResource = userDefinedJNDI;
                    } else {
                        AdminLogger.logInfo(Config.class, methodName, "No user defined JNDI defined use default configuration from database " + jndiResource);
                        initialContext = new InitialContext();
                        dataSource = (DataSource)initialContext.lookup(jndiResource);
                    }
                }
                catch (NameNotFoundException e) {
                    try {
                        AdminLogger.logInfo(Config.class, methodName, "Retry using default configuration from database specified by JNDI resource " + jndiResource);
                        initialContext = new InitialContext();
                        dataSource = (DataSource)initialContext.lookup(jndiResource);
                    }
                    catch (NameNotFoundException ex) {
                        jndiResource = "java:comp/env/jdbc/CIWEBDS";
                        AdminLogger.logInfo(Config.class, methodName, "Final retry using default configuration from database specified by JNDI resource " + jndiResource);
                        initialContext = new InitialContext();
                        dataSource = (DataSource)initialContext.lookup(jndiResource);
                    }
                }
                AdminLogger.logInfo(Config.class, methodName, "Configuration is loaded from database specified by JNDI resource " + jndiResource);
                if (userDefinedSchema != null && userDefinedSchema.length() > 0) {
                    if (userDefinedSchema.matches(".*\\s.*")) {
                        AdminLogger.logError(Config.class, methodName, "User defined schema name cannot contain whitespace characters: " + userDefinedSchema);
                        throw new IllegalArgumentException("User defined schema name cannot contain whitespace characters: " + userDefinedSchema);
                    }
                    schema = userDefinedSchema;
                }
                String schemaPrefixPlusTableName = schema + "." + "CONFIGURATION";
                configuration = new DatabaseConfiguration(dataSource, schemaPrefixPlusTableName, "ID", "ATTRIBUTES");
                configuration.setListDelimiter(';');
                AdminLogger.logDebug(configuration, methodName, "Create a Database configuration object");
            }
            cache = Cache.getInstance();
            ApplicationConfig appConfig = Config.getApplicationConfig(APPLICATION_NAME);
            cache.setDefaultObjectExpirationPeriod(appConfig.getObjectExpiration());
            cache.setThreadSleepTime(appConfig.getThreadSleepTime());
        } else {
            AdminLogger.logDebug(Config.class, methodName, "Config.initialize method has been called more than once.");
        }
        AdminLogger.logExit(Config.class, methodName);
    }

    public static CONFIGURATION_TYPE getConfigurationType() {
        return configurationType;
    }

    public static void reconnectToDB() throws Exception {
        try {
            InitialContext initialContext = new InitialContext();
            dataSource = (DataSource)initialContext.lookup(jndiResource);
        }
        catch (NameNotFoundException e) {
            jndiResource = "java:comp/env/jdbc/CIWEBDS";
            InitialContext initialContext = new InitialContext();
            dataSource = (DataSource)initialContext.lookup(jndiResource);
        }
        String schemaPrefixPlusTableName = schema + "." + "CONFIGURATION";
        configuration = new DatabaseConfiguration(dataSource, schemaPrefixPlusTableName, "ID", "ATTRIBUTES");
        configuration.setListDelimiter(';');
    }

    public static ApplicationConfig getApplicationConfig(String applicationId) throws ConfigurationException, MissingValueException {
        applicationId = applicationId == null || applicationId.length() == 0 ? APPLICATION_NAME : applicationId;
        return Config.getConfiguration(ApplicationConfig.class, null, applicationId, new boolean[0]);
    }

    public static DesktopConfig getDesktopConfig(String applicationId, String desktopId) throws ConfigurationException, MissingValueException {
        SettingsConfig setttingsConfig = Config.getSettingsConfig(applicationId);
        desktopId = desktopId != null ? desktopId : null;
        DesktopConfig desktopConfig = Config.getConfiguration(DesktopConfig.class, applicationId, desktopId = desktopId == null || desktopId.length() == 0 ? Config.getDefaultDesktopName(null) : desktopId, new boolean[0]);
        if (desktopConfig != null && !desktopConfig.isEmpty()) {
            desktopConfig.setDisableAutocomplete(setttingsConfig.getDisableAutocomplete());
            desktopConfig.setCulturalCollation(setttingsConfig.getCulturalCollation());
        }
        return desktopConfig;
    }

    public static DesktopAccessConfig getDesktopAccessConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(DesktopAccessConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static SettingsConfig getSettingsConfig(String applicationId) throws ConfigurationException, MissingValueException {
        return Config.getSettingsConfig(applicationId, "default");
    }

    public static SettingsConfig getSettingsConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        return Config.getConfiguration(SettingsConfig.class, applicationId, id, new boolean[0]);
    }

    public static InterfaceTextConfig getInterfaceTextConfig(String applicationId, String interfaceTextId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(InterfaceTextConfig.class, appConfig.getObjectId(), interfaceTextId, new boolean[0]);
    }

    public static InterfaceTextLocaleConfig getInterfaceTextLocaleConfig(String applicationId, String interfaceTextId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(InterfaceTextLocaleConfig.class, appConfig.getObjectId(), interfaceTextId, new boolean[0]);
    }

    public static ViewerConfig getViewerConfig(String applicationId, String viewerId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        viewerId = viewerId == null || viewerId.length() == 0 ? "default" : viewerId;
        return Config.getConfiguration(ViewerConfig.class, appConfig.getObjectId(), viewerId, new boolean[0]);
    }

    public static ViewerDefConfig getViewerDefConfig(String applicationId, String viewerDefId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(ViewerDefConfig.class, appConfig.getObjectId(), viewerDefId, new boolean[0]);
    }

    public static ViewerMappingConfig getViewerMappingConfig(String applicationId, String viewerMappingId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(ViewerMappingConfig.class, appConfig.getObjectId(), viewerMappingId, new boolean[0]);
    }

    public static LocaleConfig getLocaleConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(LocaleConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static IdLabelConfig getIdLabelConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(IdLabelConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static IconConfig getIconConfig(String applicationId, String iconId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        iconId = iconId == null || iconId.length() == 0 ? "default" : iconId;
        return Config.getConfiguration(IconConfig.class, appConfig.getObjectId(), iconId, new boolean[0]);
    }

    public static FileTypeConfig getFileTypeConfig(String applicationId, String fileType) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(FileTypeConfig.class, appConfig.getObjectId(), fileType, new boolean[0]);
    }

    public static PropertyMappingConfig getPropertyMappingConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(PropertyMappingConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static MobileFeatureConfig getMobileFeatureConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(MobileFeatureConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static UserActionMacroConfig getUserActionMacroConfig(String applicationId, String userAction) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(UserActionMacroConfig.class, appConfig.getObjectId(), userAction, new boolean[0]);
    }

    public static IconStatusConfig getIconStatusConfig(String applicationId, String iconId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        iconId = iconId == null || iconId.length() == 0 ? "default" : iconId;
        return Config.getConfiguration(IconStatusConfig.class, appConfig.getObjectId(), iconId, new boolean[0]);
    }

    public static RepositoryConfig getRepositoryConfig(String applicationId, String repositoryId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(RepositoryConfig.class, appConfig.getObjectId(), repositoryId, new boolean[0]);
    }

    public static ServerConfig getServerConfig(String applicationId, String serverId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(ServerConfig.class, appConfig.getObjectId(), serverId, new boolean[0]);
    }

    public static MenuConfig getMenuConfig(String applicationId, String menuId, boolean ... flags) throws ConfigurationException, MissingValueException {
        boolean skipCaching = false;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(MenuConfig.class, appConfig.getObjectId(), menuId, skipCaching);
    }

    public static MenuTypeConfig getMenuTypeConfig(String applicationId, String menuTypeId, boolean ... flags) throws ConfigurationException, MissingValueException {
        boolean skipCaching = false;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(MenuTypeConfig.class, appConfig.getObjectId(), menuTypeId, skipCaching);
    }

    public static PluginConfig getPluginConfig(String applicationId, String pluginId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(PluginConfig.class, appConfig.getObjectId(), pluginId, new boolean[0]);
    }

    public static FavoriteConfig getFavoriteConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(FavoriteConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static UserConfig getUserConfig(String applicationId, String userId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(UserConfig.class, appConfig.getObjectId(), userId.toLowerCase(), new boolean[0]);
    }

    public static PluginUserConfig getPluginUserConfig(String applicationId, String userId, String pluginId, String key) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(PluginUserConfig.class, appConfig.getObjectId(), userId.toLowerCase() + "." + pluginId + "." + key, new boolean[0]);
    }

    public static ODLoginConfig getODLoginConfig(String applicationId, String repositoryId) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return new ODLoginConfig((Configuration)Config.getConfiguration(), appConfig.getObjectId(), repositoryId);
    }

    public static RecentSearchConfig getRecentSearchConfig(String applicationId, String id) throws ConfigurationException, MissingValueException {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationId);
        return Config.getConfiguration(RecentSearchConfig.class, appConfig.getObjectId(), id, new boolean[0]);
    }

    public static ApplicationConfig getApplicationConfig(HttpServletRequest request) {
        String appName = request.getParameter("application");
        ApplicationConfig appConfig = null;
        try {
            appConfig = Config.getApplicationConfig(appName);
        }
        catch (Throwable e) {
            AdminLogger.logError(Config.class, "getApplicationConfig", "Application not found, Name = " + appName, e);
        }
        return appConfig;
    }

    public static DesktopConfig getDesktopConfig(HttpServletRequest request) {
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        DesktopConfig desktopConfig = null;
        try {
            desktopName = desktopName != null ? desktopName : Config.getDefaultDesktopName(request);
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            desktopConfig = Config.getDesktopConfig(appConfig.getObjectId(), desktopName);
        }
        catch (Throwable e) {
            AdminLogger.logError(Config.class, "getDesktopConfig", "desktop not found, desktopName = " + desktopName, e);
        }
        return desktopConfig;
    }

    public static RepositoryConfig getRepositoryConfig(HttpServletRequest request) {
        String appName = request.getParameter("application");
        String repositoryId = request.getParameter("repositoryId");
        RepositoryConfig repository = null;
        try {
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            repository = Config.getConfiguration(RepositoryConfig.class, appConfig.getObjectId(), repositoryId, new boolean[0]);
        }
        catch (Throwable e) {
            AdminLogger.logError(Config.class, "getRepository", "repository not found, repository = " + repositoryId, e);
        }
        return repository;
    }

    public static RepositoryConfig getRepositoryConfigUsingIdOrServerName(HttpServletRequest request, String repositoryId) {
        RepositoryConfig repositoryConfig;
        block4: {
            String appName = request.getParameter("application");
            String desktopName = request.getParameter("desktop");
            if (repositoryId == null) {
                repositoryId = request.getParameter("repositoryId");
            }
            String serverName = request.getParameter("server");
            repositoryConfig = null;
            try {
                ApplicationConfig appConfig = Config.getApplicationConfig(appName);
                DesktopConfig desktopConfig = Config.getDesktopConfig(appConfig.getObjectId(), desktopName);
                repositoryConfig = Config.getConfiguration(RepositoryConfig.class, appConfig.getObjectId(), repositoryId, new boolean[0]);
                if (repositoryConfig != null || serverName == null || serverName.length() <= 0) break block4;
                for (RepositoryConfig repository : desktopConfig.getRepositoryList()) {
                    if (!repository.getServerName().equals(serverName) && !repository.getName().equals(serverName)) continue;
                    repositoryConfig = Config.getConfiguration(RepositoryConfig.class, appConfig.getObjectId(), repository.getObjectId(), new boolean[0]);
                    break;
                }
            }
            catch (Throwable e) {
                AdminLogger.logError(Config.class, "getRepository", "repository not found, repository = " + repositoryId, e);
            }
        }
        return repositoryConfig;
    }

    public static boolean hasRepositoryConfigUsingIdOrServerName(HttpServletRequest request, String repositoryId) {
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        if (repositoryId == null) {
            repositoryId = request.getParameter("repositoryId");
        }
        try {
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            DesktopConfig desktopConfig = Config.getDesktopConfig(appConfig.getObjectId(), desktopName);
            return desktopConfig.hasRepository(repositoryId);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static RepositoryConfig getRepositoryConfigUsingIdOrServerName(HttpServletRequest request) {
        return Config.getRepositoryConfigUsingIdOrServerName(request, null);
    }

    public static ServerConfig getServerConfig(HttpServletRequest request) {
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String repositoryId = request.getParameter("repositoryId");
        RepositoryConfig repository = null;
        try {
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            DesktopConfig desktopConfig = Config.getDesktopConfig(appConfig.getObjectId(), desktopName);
            repository = desktopConfig.getRepository(repositoryId);
            return desktopConfig.getServer(repository.getType());
        }
        catch (Throwable e) {
            AdminLogger.logError(DesktopConfig.class, "getServerConfig", "server not found, type = " + repositoryId, e);
            return null;
        }
    }

    static boolean checkConfiguration() throws ConfigurationException {
        if (configuration == null) {
            ConfigurationException e = new ConfigurationException("Configuration object missing. Call Config's initialize method first before other method");
            throw e;
        }
        return true;
    }

    static boolean checkValue(String value, String message) throws MissingValueException {
        if (value == null || value.length() == 0) {
            MissingValueException e = new MissingValueException(message);
            throw e;
        }
        return true;
    }

    public static synchronized boolean removeConfigurationFromCache(ConfigurationObject config) {
        String key = config.getClass().getName() + "." + (config.getIdPrefix() == null || config.getIdPrefix().length() == 0 ? "" : config.getIdPrefix() + ".") + config.getObjectId();
        return Cache.getInstance().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends ConfigurationObject> T getConfiguration(Class<T> ConfigClass, String idPrefix, String id, boolean ... flags) throws ConfigurationException, MissingValueException {
        Config.checkConfiguration();
        Config.checkValue(id, "Id can not be null or empty string");
        boolean skipCaching = false;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        String key = ConfigClass.getName() + "." + (idPrefix == null || idPrefix.length() == 0 ? "" : idPrefix + ".") + id;
        ConfigurationObject config = null;
        if (!skipCaching) {
            config = (ConfigurationObject)Cache.getInstance().get(key);
        }
        if (config == null) {
            try {
                Constructor<T> constructor;
                Constructor<T> constructor2 = constructor = ConfigClass.getConstructor(Configuration.class, String.class, String.class);
                synchronized (constructor2) {
                    config = (ConfigurationObject)constructor.newInstance(configuration, idPrefix, id);
                }
            }
            catch (Exception e) {
                ConfigurationException ce = new ConfigurationException((Throwable)e);
                AdminLogger.logError(Config.class, "getConfiguration", (HttpSession)null, e.getMessage());
                throw ce;
            }
            Cache.getInstance().add(key, config);
        }
        return (T)config;
    }

    public static final AbstractConfiguration getConfiguration() {
        return configuration;
    }

    public static final AbstractConfiguration getDefaultConfiguration() {
        return defaultConfiguration;
    }

    public static String getJDBCVersion() {
        String jdbcDriverInfo = "";
        if (dataSource != null) {
            try {
                DatabaseMetaData dmd;
                Connection conn = dataSource.getConnection();
                if (conn != null && (dmd = conn.getMetaData()) != null) {
                    jdbcDriverInfo = dmd.getDriverName() + " " + dmd.getDriverVersion();
                }
            }
            catch (SQLException e) {
                AdminLogger.logError(Config.class, "getJDBCVersion", (HttpSession)null, e.getMessage());
            }
        }
        return jdbcDriverInfo;
    }

    public static String getDatabseName() {
        String dataBaseName = "";
        if (dataSource != null) {
            try {
                DatabaseMetaData dmd;
                Connection conn = dataSource.getConnection();
                if (conn != null && (dmd = conn.getMetaData()) != null) {
                    ResultSet rs = dmd.getSchemas();
                    if (rs == null) {
                        rs = dmd.getCatalogs();
                    }
                    if (rs != null && rs.next()) {
                        dataBaseName = rs.getString(1);
                    }
                }
            }
            catch (SQLException e) {
                AdminLogger.logError(Config.class, "getDatabseName", (HttpSession)null, e.getMessage());
            }
        }
        return dataBaseName;
    }

    public static String getDefaultDesktopName(HttpServletRequest request) throws ConfigurationException, MissingValueException {
        String methodName = "getDefaultDesktopName";
        String appName = null;
        String desktopName = null;
        if (request != null) {
            appName = request.getParameter("application");
            desktopName = request.getParameter("desktop");
        }
        appName = appName == null || appName.length() == 0 ? APPLICATION_NAME : appName;
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        if (request != null) {
            Logger.logDebug(Config.class, methodName, (ServletRequest)request, "DesktopName in Request: " + desktopName);
        }
        if (desktopName == null || desktopName.length() == 0) {
            Collection<DesktopConfig> desktopConfigs = appConfig.getDesktopList();
            for (DesktopConfig desktopConfig : desktopConfigs) {
                if (!desktopConfig.getDefault().equals("Yes")) continue;
                desktopName = desktopConfig.getObjectId();
                break;
            }
            if (request != null) {
                Logger.logDebug(Config.class, methodName, (ServletRequest)request, "Default DesktopName from configuration: " + desktopName);
            }
            if (desktopName == null || desktopName.length() == 0) {
                if (request != null) {
                    Logger.logDebug(Config.class, methodName, (ServletRequest)request, "No Default DesktopName found: " + desktopName + " So setting it to admin");
                }
                desktopName = "admin";
            }
        }
        if (request != null) {
            Logger.logDebug(Config.class, methodName, (ServletRequest)request, "Default DesktopName returning: " + desktopName);
        }
        return desktopName;
    }

    static {
        schema = "CIWEB";
        jndiResource = "jdbc/CIWEBDS";
        configurationType = CONFIGURATION_TYPE.DATABASE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONFIGURATION_TYPE {
        PROPERTIES,
        DATABASE;

    }
}

