/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Set;

public class Cache
implements Serializable {
    private static transient Hashtable cacheTable = null;
    private static transient Cache cache = null;
    private static transient Object initLock = new Object();
    private static transient boolean _debug = true;
    private static transient WCCacheThread cacheThread = null;
    private static transient Object threadSleepLock = new Object();
    private static int threadSleepTime = 0;
    private static int objectExpiration = 0;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final int MINUTES_PER_YEAR = 525600;
    private static final long serialVersionUID = -6677411056110525860L;

    private Cache() {
        cacheTable = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getInstance() {
        Object object = initLock;
        synchronized (object) {
            if (cache == null) {
                cache = new Cache();
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable hashtable = cacheTable;
        synchronized (hashtable) {
            cacheTable = new Hashtable();
        }
    }

    public static int getMaxTimeout() {
        return 525600;
    }

    public void stopThread() {
        this.setThreadSleepTime(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadSleepTime(int minutesSleepTime) {
        String methodName = "setThreadSleepTime";
        Object object = threadSleepLock;
        synchronized (object) {
            if (minutesSleepTime > 0) {
                if (minutesSleepTime > Cache.getMaxTimeout()) {
                    minutesSleepTime = Cache.getMaxTimeout();
                }
                threadSleepTime = minutesSleepTime;
                if (cacheThread == null || !cacheThread.isAlive() && threadSleepTime > 0) {
                    cacheThread = new WCCacheThread(threadSleepTime);
                    cacheThread.setPriority(1);
                    cacheThread.start();
                } else if (cacheThread != null) {
                    cacheThread.setThreadSleepTime(threadSleepTime);
                }
            } else {
                threadSleepTime = 0;
                if (cacheThread != null && cacheThread.isAlive()) {
                    cacheThread.setThreadSleepTime(threadSleepTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadSleepTime() {
        int retval = 0;
        Object object = threadSleepLock;
        synchronized (object) {
            retval = threadSleepTime;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultObjectExpirationPeriod(int objectExpirationPeriod) {
        String methodName = "setObjectExpirationPeriod";
        Object object = threadSleepLock;
        synchronized (object) {
            objectExpiration = objectExpirationPeriod > 0 || objectExpirationPeriod < 0 ? (objectExpirationPeriod > Cache.getMaxTimeout() || objectExpirationPeriod < 0 ? Cache.getMaxTimeout() : objectExpirationPeriod) : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultObjectExpirationPeriod() {
        int retval = 0;
        Object object = threadSleepLock;
        synchronized (object) {
            retval = objectExpiration;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        Hashtable hashtable = cacheTable;
        synchronized (hashtable) {
            sb.append("thread sleep duration: " + this.getThreadSleepTime());
            sb.append(lineSeparator);
            sb.append("dump cache: ");
            sb.append(lineSeparator);
            Set keySet = cacheTable.keySet();
            for (String key : keySet) {
                WCCacheObject cacheObject = (WCCacheObject)cacheTable.get(key);
                sb.append(cacheObject.toString());
                sb.append("    ");
                sb.append(lineSeparator);
            }
        }
        return sb.toString();
    }

    public boolean add(String key, Object object) {
        return this.add(key, object, this.getDefaultObjectExpirationPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String key, Object object, int expiresInMinutes) {
        boolean added = false;
        Cache cacheInit = Cache.getInstance();
        if (expiresInMinutes < 0) {
            expiresInMinutes = Cache.getMaxTimeout();
        }
        if (expiresInMinutes > 0) {
            WCCacheObject cacheObject = new WCCacheObject(key, object, expiresInMinutes);
            Hashtable hashtable = cacheTable;
            synchronized (hashtable) {
                if (cacheThread != null) {
                    cacheTable.put(key, cacheObject);
                    added = true;
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key) {
        boolean removed = false;
        Cache cacheInit = Cache.getInstance();
        Hashtable hashtable = cacheTable;
        synchronized (hashtable) {
            Object object;
            WCCacheObject cacheObject = cache.getCacheObject(key);
            if (cacheObject != null && (object = cacheTable.remove(key)) != null) {
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Cache cacheInit = Cache.getInstance();
        Object object = null;
        if (this.getThreadSleepTime() == 0) {
            return null;
        }
        Hashtable hashtable = cacheTable;
        synchronized (hashtable) {
            WCCacheObject cacheObject = cache.getCacheObject(key);
            if (cacheObject != null) {
                if (cacheObject.isExpired()) {
                    this.remove(key);
                } else {
                    object = cacheObject.getObject();
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WCCacheObject getCacheObject(String key) {
        WCCacheObject cacheObject = null;
        Hashtable hashtable = cacheTable;
        synchronized (hashtable) {
            cacheObject = (WCCacheObject)cacheTable.get(key);
        }
        return cacheObject;
    }

    private class WCCacheThread
    extends Thread {
        int threadMinutesSleep = 0;

        private WCCacheThread() {
            this.threadMinutesSleep = 0;
        }

        private WCCacheThread(int minutesSleepTime) {
            this.threadMinutesSleep = minutesSleepTime;
        }

        public void setThreadSleepTime(int minutesSleepTime) {
            this.threadMinutesSleep = minutesSleepTime;
        }

        public int getThreadSleepTime() {
            return this.threadMinutesSleep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object runLock;
            Object object = runLock = new Object();
            synchronized (object) {
                try {
                    while (true) {
                        Hashtable hashtable = cacheTable;
                        synchronized (hashtable) {
                            Set keySet = cacheTable.keySet();
                            for (String key : keySet) {
                                WCCacheObject cacheObject = cache.getCacheObject(key);
                                if (!cacheObject.isExpired()) continue;
                                cache.remove(key);
                            }
                        }
                        int sleepTime = cacheThread.getThreadSleepTime();
                        if (sleepTime <= 0) {
                            Cache.this.clear();
                            cacheThread = null;
                            break;
                        }
                        this.wait((long)sleepTime * 60000L);
                    }
                }
                catch (ConcurrentModificationException cme) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class WCCacheObject
    implements Serializable {
        private long expirationTimestamp = 0L;
        private transient Object cacheObject;
        private transient String cacheObjectKey;
        private static final long serialVersionUID = -6386255410114374495L;

        private WCCacheObject() {
        }

        private WCCacheObject(String key, Object object, int expiresInMinutes) {
            if (expiresInMinutes > Cache.getMaxTimeout()) {
                expiresInMinutes = Cache.getMaxTimeout();
            }
            long expiresInMilli = (long)expiresInMinutes * 60000L;
            this.expirationTimestamp = this.getTime() + expiresInMilli;
            this.cacheObjectKey = key;
            this.cacheObject = object;
        }

        private long getTime() {
            return Calendar.getInstance().getTime().getTime();
        }

        private boolean isExpired() {
            return this.getTime() > this.getExpirationTimestamp();
        }

        private long getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        private Object getObject() {
            return this.cacheObject;
        }

        private String getKey() {
            return this.cacheObjectKey;
        }

        public String toString() {
            return "key " + this.getKey() + ", isExpired " + this.isExpired() + ", expiration " + new Timestamp(this.getExpirationTimestamp()).toString();
        }
    }
}

