/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.PluginConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.ServerConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.extension.PluginMenu;
import com.ibm.ecm.extension.PluginMenuType;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.PluginUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfig
extends ConfigurationObject {
    private static final String LOCALES = "locales";
    private static final String PLUGINS = "plugins";
    private static final String DESKTOPS = "desktops";
    private static final String REPOSITORIES = "repositories";
    private static final String MENUS = "menus";
    private static final String VIEWERS = "viewers";
    private static final String SERVERS = "servers";
    private static final String OBJECT_EXPIRATION = "objectExpiration";
    private static final String THREAD_SLEEP_TIME = "threadSleepTime";
    private static final String DESKTOP = "desktop";
    public static final String ENCRYPTION_KEY = "key";

    public ApplicationConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    public String getObjectType() {
        return "application";
    }

    public int getThreadSleepTime() {
        return Integer.parseInt(this.properties.getProperty(THREAD_SLEEP_TIME, "5"));
    }

    public void setThreadSleepTime(int sleepTime) {
        this.properties.setProperty(THREAD_SLEEP_TIME, Integer.toString(sleepTime));
    }

    public int getObjectExpiration() {
        return Integer.parseInt(this.properties.getProperty(OBJECT_EXPIRATION, "5"));
    }

    public void setObjectExpiration(int expirationTime) {
        this.properties.setProperty(OBJECT_EXPIRATION, Integer.toString(expirationTime));
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type.equals(DESKTOPS)) {
            return this.getDesktopList(request);
        }
        if (type.equals(REPOSITORIES)) {
            return this.getRepositoriesList();
        }
        if (type.equals(MENUS)) {
            return this.getMenusList(request);
        }
        if (type.equals(SERVERS)) {
            return this.getServersList();
        }
        if (type.equals(PLUGINS)) {
            return this.getPluginList();
        }
        if (type.equals(VIEWERS)) {
            return this.getViewersList(request);
        }
        if (type.equals("iconStatus")) {
            return this.getIconStatusList();
        }
        return null;
    }

    public String[] getDesktopsId() {
        return this.stringToArray(this.properties.getProperty(DESKTOPS));
    }

    public void setDesktopsId(String[] ids) {
        this.properties.put(DESKTOPS, this.arrayToString(ids));
    }

    public Collection<DesktopConfig> getDesktopList(HttpServletRequest request) {
        return this.getDesktopList(request, this.getDesktopsId());
    }

    public Collection<DesktopConfig> getDesktopList(HttpServletRequest request, String[] desktopsId) {
        Collection<DesktopConfig> list = this.getMap(DesktopConfig.class, this.getObjectId(), desktopsId, true).values();
        for (DesktopConfig config : list) {
            if (!config.getObjectId().equals("admin")) continue;
            String name = "";
            String description = "";
            try {
                name = MessageUtil.getMessage(request, "desktop." + config.getObjectId() + ".name");
                description = MessageUtil.getMessage(request, "desktop." + config.getObjectId() + ".description");
            }
            catch (Exception e) {
                // empty catch block
            }
            config.setName(name);
            config.setDescription(description);
        }
        return list;
    }

    public Collection<DesktopConfig> getDesktopList() {
        return this.getMap(DesktopConfig.class, this.getObjectId(), this.getDesktopsId(), true).values();
    }

    public String[] getRepositoriesId() {
        return this.stringToArray(this.properties.getProperty(REPOSITORIES));
    }

    public void setRepositoriesId(String[] ids) {
        this.properties.put(REPOSITORIES, this.arrayToString(ids));
    }

    public Collection<RepositoryConfig> getRepositoriesList() {
        return this.getRepositoriesList(this.getRepositoriesId());
    }

    public Collection<RepositoryConfig> getRepositoriesList(String[] ids) {
        return this.getMap(RepositoryConfig.class, this.getObjectId(), ids, true).values();
    }

    public String[] getViewersId() {
        return this.stringToArray(this.properties.getProperty(VIEWERS));
    }

    public void setViewersId(String[] ids) {
        this.properties.setProperty(VIEWERS, this.arrayToString(ids));
    }

    public void setPluginsId(String[] ids) {
        this.properties.setProperty(PLUGINS, this.arrayToString(ids));
    }

    public void setMenusId(String[] ids) {
        this.properties.setProperty(MENUS, this.arrayToString(ids));
    }

    public Collection<ViewerConfig> getViewersList(HttpServletRequest request) {
        Collection<ViewerConfig> list = this.getMap(ViewerConfig.class, this.getObjectId(), this.getViewersId(), true).values();
        for (ViewerConfig config : list) {
            if (!config.getObjectId().equals("default")) continue;
            String name = "";
            String description = "";
            try {
                name = MessageUtil.getMessage(request, "viewerMap.default.name");
                description = MessageUtil.getMessage(request, "viewerMap.default.description");
            }
            catch (Exception e) {
                // empty catch block
            }
            config.setName(name);
            config.setDescription(description);
        }
        return list;
    }

    public String[] getServersId() {
        return this.stringToArray(this.properties.getProperty(SERVERS));
    }

    public Collection<ServerConfig> getServersList() {
        return this.getMap(ServerConfig.class, this.getObjectId(), this.getServersId(), true).values();
    }

    public String[] getMenusId() {
        return this.stringToArray(this.properties.getProperty(MENUS));
    }

    public Collection<MenuConfig> getMenusList(HttpServletRequest request) {
        String methodName = "getMenusList";
        Map<String, MenuConfig> definedMenusMap = this.getMap(MenuConfig.class, this.getObjectId(), this.getMenusId(), true);
        Properties defaultProperties = Config.getDefaultConfiguration().getProperties(this.getObjectType() + "." + this.getObjectId() + ".defaultMenus");
        String[] defaultMenuIds = this.stringToArray(defaultProperties.getProperty("items"));
        Map<String, MenuConfig> menusMap = this.getMap(MenuConfig.class, this.getObjectId(), defaultMenuIds, true);
        Map<String, PluginMenuType> pluginMenuTypeMap = PluginUtil.getPluginMenuTypes(request);
        for (String key : definedMenusMap.keySet()) {
            MenuConfig menuConfig = definedMenusMap.get(key);
            if (menusMap.containsKey(key)) continue;
            menusMap.put(key, menuConfig);
        }
        Collection<MenuConfig> list = menusMap.values();
        for (MenuConfig menuConfig : list) {
            this.processMenuConfig(menuConfig, pluginMenuTypeMap, request);
        }
        ArrayList<MenuConfig> arrayList = new ArrayList<MenuConfig>(list);
        Map<String, PluginMenu> pluginMenuMap = PluginUtil.getPluginMenus(request);
        for (String key : pluginMenuMap.keySet()) {
            PluginMenu pluginMenu = pluginMenuMap.get(key);
            try {
                MenuConfig config = Config.getMenuConfig(this.getObjectId(), pluginMenu.getId(), new boolean[0]);
                config.setName(pluginMenu.getName(request.getLocale()));
                config.setPluginId(pluginMenu.getPluginId());
                config.setDescription(pluginMenu.getDescription(request.getLocale()) != null ? pluginMenu.getDescription(request.getLocale()) : "");
                config.setType(pluginMenu.getMenuType());
                PluginMenuType pluginMenuType = pluginMenuTypeMap.get(pluginMenu.getMenuType());
                if (pluginMenuType != null) {
                    config.setTypeLabel(pluginMenuType.getName(request.getLocale()));
                } else {
                    try {
                        config.setTypeLabel(MessageUtil.getMessage(request, "menuType." + config.getType() + ".label"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                arrayList.add(config);
            }
            catch (Exception e) {
                AdminLogger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        return arrayList;
    }

    private void processMenuConfig(MenuConfig menuConfig, Map<String, PluginMenuType> pluginMenuTypeMap, HttpServletRequest request) {
        if (menuConfig.getType() == null || menuConfig.getType().equals("")) {
            String id = menuConfig.getObjectId();
            if (id != null && id.startsWith("Default")) {
                menuConfig.setType(id.substring("Default".length()));
            } else {
                menuConfig.setType("");
            }
        }
        String typeLabel = "";
        if (pluginMenuTypeMap.containsKey(menuConfig.getType())) {
            PluginMenuType pluginMenuType = pluginMenuTypeMap.get(menuConfig.getType());
            typeLabel = pluginMenuType.getName(request.getLocale());
            menuConfig.setPluginId(pluginMenuType.getPluginId());
        } else {
            try {
                typeLabel = MessageUtil.getMessage(request, "menuType." + menuConfig.getType() + ".label");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        menuConfig.setTypeLabel(typeLabel);
        if (menuConfig.getObjectId().startsWith("Default")) {
            String defaultNameLabel = "";
            String defaultDescriptionLabel = "";
            try {
                defaultNameLabel = MessageUtil.getMessage(request, "menu." + menuConfig.getObjectId() + ".name");
                defaultDescriptionLabel = MessageUtil.getMessage(request, "menu." + menuConfig.getObjectId() + ".description");
            }
            catch (Exception e) {
                // empty catch block
            }
            menuConfig.setName(defaultNameLabel);
            menuConfig.setDescription(defaultDescriptionLabel);
        }
    }

    public String[] getLocales() {
        String temp = this.properties.getProperty(LOCALES);
        if (temp.indexOf(",ro") == -1) {
            temp = temp + ",ro";
        }
        return this.stringToArray(temp);
    }

    public String[] getLocalizeSettings() {
        Properties defaultProperties = Config.getDefaultConfiguration().getProperties(this.getObjectType() + "." + this.getObjectId() + ".defaultLocalizedSettings");
        String[] locales = this.stringToArray(defaultProperties.getProperty(LOCALES));
        return locales;
    }

    public String[] getPluginsId() {
        return this.stringToArray(this.properties.getProperty(PLUGINS));
    }

    public Collection<PluginConfig> getPluginList() {
        return this.getPluginList(this.getPluginsId());
    }

    public Collection<PluginConfig> getPluginList(String[] ids) {
        return this.getMap(PluginConfig.class, this.getObjectId(), ids, true).values();
    }

    public DesktopConfig getDesktop() {
        DesktopConfig desktop = null;
        try {
            desktop = Config.getDesktopConfig(this.getObjectId(), this.getDesktopName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return desktop;
    }

    public String getDesktopName() {
        return this.properties.getProperty(DESKTOP);
    }

    public void setDesktopName(String desktop) {
        this.properties.setProperty(DESKTOP, desktop);
    }

    public String getEncryptionKey() {
        return this.properties.getProperty(ENCRYPTION_KEY);
    }

    public void setEncryptionKey(String key) {
        this.properties.setProperty(ENCRYPTION_KEY, key);
    }

    public SettingsConfig getSettingsConfig() {
        try {
            SettingsConfig config = Config.getSettingsConfig(this.getObjectId());
            return config;
        }
        catch (ConfigurationException e) {
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return null;
    }

    public Collection<IconStatusConfig> getIconStatusList() {
        SettingsConfig config = this.getSettingsConfig();
        if (config != null) {
            return config.getIconStatusList();
        }
        return null;
    }

    public boolean checkAdminAccessForUser(String userid) {
        String methodName = "checkAdminAccessForUser";
        SettingsConfig config = this.getSettingsConfig();
        if (config != null) {
            List<String> adminUsers = config.getAdminUsersList();
            AdminLogger.logDebug(this, methodName, "adminUsers defined in the config=" + adminUsers);
            if (adminUsers != null && !adminUsers.isEmpty()) {
                return this.containsIgnoreCase(adminUsers, userid);
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(List<String> l, String s) {
        String methodName = "containsIgnoreCase";
        String shortNameFromPrinciple = s;
        if (s.contains("@")) {
            StringTokenizer st = new StringTokenizer(s, "@");
            shortNameFromPrinciple = (String)st.nextElement();
        }
        for (String nextItem : l) {
            if (!nextItem.equalsIgnoreCase(s) && !nextItem.equalsIgnoreCase(shortNameFromPrinciple)) continue;
            AdminLogger.logDebug(this, methodName, "adminUser found in the config=" + s);
            return true;
        }
        AdminLogger.logDebug(this, methodName, "adminUser Not found in the config=" + s);
        return false;
    }

    public void exportDesktops(HttpServletRequest request, OutputStreamWriter osw, String[] desktopIds, String[] repositoryIds, boolean includeSecurity) throws IOException, FileNotFoundException {
        Collection<DesktopConfig> desktops = this.getDesktopList(request, desktopIds);
        String appName = request.getParameter("application");
        appName = appName == null ? "navigator" : appName;
        this.exportCustomMenus(request, osw, desktops);
        this.exportCustomViewer(request, osw, desktops);
        for (DesktopConfig desktop : desktops) {
            if (!desktop.getObjectId().equalsIgnoreCase("admin")) {
                if (desktop.getDefault() != null && desktop.getDefault().equalsIgnoreCase("yes")) {
                    desktop.setDefault("No");
                }
                desktop.exportInterfaceText(appName, osw);
                desktop.exportMobileFeature(appName, osw);
                if (includeSecurity) {
                    desktop.exportSecurity(appName, osw);
                }
            }
            String[] filteredIds = this.filterIds(desktop.getRepositoriesId(), repositoryIds);
            desktop.setRepositoriesId(filteredIds);
            desktop.dump(osw);
            Config.removeConfigurationFromCache(desktop);
        }
    }

    public void exportRepositories(HttpServletRequest request, OutputStreamWriter osw, String[] repositoryIds) throws IOException, FileNotFoundException {
        Collection<RepositoryConfig> repositories = this.getRepositoriesList(repositoryIds);
        for (RepositoryConfig repository : repositories) {
            repository.exportPropertiesMapping(this.getObjectId(), osw, repository);
            repository.dump(osw);
        }
    }

    private void exportCustomMenus(HttpServletRequest request, OutputStreamWriter osw, Collection<DesktopConfig> desktops) throws IOException, FileNotFoundException {
        Collection<MenuConfig> menus = this.getMenusList(request);
        AbstractConfiguration config = Config.getDefaultConfiguration();
        String key = null;
        for (MenuConfig menuConfig : menus) {
            key = menuConfig.getKey();
            if (config.containsKey(key) || !this.findInDesktop(key, desktops)) continue;
            menuConfig.dump(osw);
        }
    }

    private void exportCustomViewer(HttpServletRequest request, OutputStreamWriter osw, Collection<DesktopConfig> desktops) throws IOException, FileNotFoundException {
        Collection<ViewerConfig> viewers = this.getViewersList(request);
        AbstractConfiguration config = Config.getDefaultConfiguration();
        String key = null;
        for (ViewerConfig viewerConfig : viewers) {
            key = viewerConfig.getKey();
            if (config.containsKey(key) || !this.findViewerInDesktop(key, desktops)) continue;
            viewerConfig.dump(osw);
            for (ViewerMappingConfig viewerMapping : viewerConfig.getViewerMappingList()) {
                viewerMapping.dump(osw);
            }
        }
    }

    public void exportPlugins(HttpServletRequest request, OutputStreamWriter osw, String[] pluginIds) throws IOException, FileNotFoundException {
        Collection<PluginConfig> plugins = this.getPluginList(pluginIds);
        ConfigurationObject.writeConfigurationToFile(osw, plugins);
    }

    private boolean findViewerInDesktop(String key, Collection<DesktopConfig> desktops) {
        for (DesktopConfig desktop : desktops) {
            String[] keys;
            String id;
            String viewers = desktop.getViewer();
            if (viewers.indexOf(id = StringUtils.join((Object[])Arrays.copyOfRange(keys = key.split("\\."), 2, keys.length), (char)'.')) <= -1) continue;
            return true;
        }
        return false;
    }

    private boolean findInDesktop(String key, Collection<DesktopConfig> desktops) {
        AbstractConfiguration config = Config.getConfiguration();
        for (DesktopConfig desktop : desktops) {
            String[] keys;
            desktop.getViewer();
            Properties properties = config.getProperties(desktop.getKey());
            String desktopInString = this.propertiesToString(properties);
            if (desktopInString.indexOf((keys = key.split("\\."))[2]) <= -1) continue;
            return true;
        }
        return false;
    }

    private String[] filterIds(String[] oldIds, String[] baseIds) {
        String[] result = new String[oldIds.length];
        int i = 0;
        for (String id : oldIds) {
            for (String baseId : baseIds) {
                if (!baseId.equalsIgnoreCase(id)) continue;
                result[i++] = id;
            }
        }
        return result;
    }
}

