/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.viewer;

import com.ibm.ecm.serviceability.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SubResponse
extends HttpServletResponseWrapper {
    private boolean headerWritten;
    private Object headerWait = new Object();
    private Hashtable headerHash = new Hashtable();
    private SubServletOutputStream outputStream = new SubServletOutputStream();
    private int responseCode = 200;
    private String responseMsg;
    private String contentType;
    private String characterEncoding;
    private int contentLength;

    public SubResponse(HttpServletResponse response) throws IOException {
        super(response);
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)((Object)this.outputStream));
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.outputStream.getInputStream();
    }

    public void sendError(int sc, String msg) throws IOException {
        this.responseCode = sc;
        this.responseMsg = msg;
        this.notifyHeaderWritten();
    }

    public void sendError(int sc) throws IOException {
        this.responseCode = sc;
        this.notifyHeaderWritten();
    }

    public void setStatus(int sc, String sm) {
        this.responseCode = sc;
        this.responseMsg = sm;
        this.notifyHeaderWritten();
    }

    public void setStatus(int sc) {
        this.responseCode = sc;
        this.notifyHeaderWritten();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMsg;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        Logger.logDebug((Object)this, "setContentType", (ServletRequest)((HttpServletRequest)null), type);
        this.contentType = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String encoding) {
        super.setCharacterEncoding(encoding);
        Logger.logDebug((Object)this, "setCharacterEncoding", (ServletRequest)((HttpServletRequest)null), encoding);
        this.characterEncoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setHeader(String name, String value) {
        this.headerHash.put(name, value);
        super.setHeader(name, value);
    }

    public String getHeader(String name) {
        return (String)this.headerHash.get(name);
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
        super.setContentLength(contentLength);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForHeader() {
        if (!this.headerWritten) {
            Object object = this.headerWait;
            synchronized (object) {
                if (!this.headerWritten) {
                    try {
                        this.headerWait.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHeaderWritten() {
        if (!this.headerWritten) {
            Object object = this.headerWait;
            synchronized (object) {
                if (!this.headerWritten) {
                    this.headerWritten = true;
                    this.headerWait.notify();
                }
            }
        }
    }

    private class SubServletOutputStream
    extends ServletOutputStream {
        PipedInputStream pipedInputStream;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();

        public SubServletOutputStream() throws IOException {
            this.pipedInputStream = new PipedInputStream(this.pipedOutputStream);
        }

        public void write(int b) throws IOException {
            SubResponse.this.notifyHeaderWritten();
            this.pipedOutputStream.write(b);
        }

        public InputStream getInputStream() {
            return this.pipedInputStream;
        }

        public void close() throws IOException {
            SubResponse.this.notifyHeaderWritten();
            this.pipedOutputStream.close();
        }

        public void flush() throws IOException {
            SubResponse.this.notifyHeaderWritten();
            this.pipedOutputStream.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            SubResponse.this.notifyHeaderWritten();
            this.pipedOutputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            SubResponse.this.notifyHeaderWritten();
            this.pipedOutputStream.write(b);
        }
    }
}

