/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.viewer;

import com.ibm.ecm.beans.viewer.DocLoadInfo;
import com.ibm.ecm.beans.viewer.DocServicesSessionBean;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBStreamingDocServicesCallbacks;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class StreamingDocServicesCallbacks
extends CMBStreamingDocServicesCallbacks
implements Serializable {
    private static final long serialVersionUID = 1L;
    DocServicesSessionBean sessionBean;

    public StreamingDocServicesCallbacks(DocServicesSessionBean sessionBean) {
        this.sessionBean = sessionBean;
    }

    public InputStream getAnnotation(CMBDocument document, int annotationNumber) {
        return null;
    }

    public InputStream getForm(CMBDocument document, String formName) {
        Logger.logInfo((Object)this, "getForm", this.sessionBean._session, "Not supported, returning null");
        return null;
    }

    public int getPartPageCount(CMBDocument document, int partNumber) {
        String methodName = "getPartPageCount";
        Logger.logEntry((Object)this, methodName, this.sessionBean._session);
        Logger.logInfo((Object)this, methodName, this.sessionBean._session, "part number " + partNumber);
        DocLoadInfo docLoadInfo = this.sessionBean.getDocLoadInfo(document);
        int partPageCount = partNumber == docLoadInfo.getPartCount() - 1 ? docLoadInfo.getLastPartPageCount() : docLoadInfo.getPartPageCount();
        Logger.logInfo((Object)this, methodName, this.sessionBean._session, "part page count " + partPageCount);
        Logger.logExit((Object)this, methodName, this.sessionBean._session);
        return partPageCount;
    }

    public InputStream getPart(CMBDocument document, int partNumber, StringBuffer outMimeType) {
        URL docURL;
        String methodName = "getPart";
        Logger.logEntry((Object)this, methodName, this.sessionBean._session);
        DocLoadInfo docLoadInfo = this.sessionBean.getDocLoadInfo(document);
        String serverType = docLoadInfo.getServerType();
        URL contextURL = docLoadInfo.getContextURL();
        String docURLString = docLoadInfo.getDocURLString();
        String cookieProperty = docLoadInfo.getCookieProperty();
        Logger.logInfo((Object)this, methodName, this.sessionBean._session, "Part number " + partNumber);
        try {
            if (serverType != null && serverType.equals("od")) {
                Logger.logInfo((Object)this, methodName, this.sessionBean._session, "Adding transform=native and segment num to Url for OD");
                docURL = new URL(contextURL, docURLString + "&transform=native&segment_num=" + partNumber);
            } else {
                docURL = new URL(contextURL, docURLString + "&transform=native&part_number=" + partNumber);
            }
        }
        catch (MalformedURLException e) {
            Logger.logInfo((Object)this, methodName, this.sessionBean._session, "MalformedURLException -- assuming local resource");
            docURL = this.getClass().getResource("/" + docURLString);
        }
        Logger.logInfo((Object)this, methodName, this.sessionBean._session, "Attempting to retrieve the part content.");
        try {
            DocServicesSessionBean.DocInfo docInfo = new DocServicesSessionBean.DocInfo();
            InputStream instream = this.sessionBean.getContentFromService(docURLString, docURL, cookieProperty, docLoadInfo.getLastRequest(), docLoadInfo.getLastResponse(), docInfo);
            Logger.logInfo((Object)this, methodName, this.sessionBean._session, "contentLength: " + docInfo.contentLength + " contentType: " + docInfo.contentType + " contentEncoding: " + docInfo.contentEncoding);
            outMimeType.append(docInfo.contentType);
            Logger.logExit((Object)this, methodName, this.sessionBean._session);
            return instream;
        }
        catch (Exception e) {
            throw new CMBDocumentEngineException(e.getMessage(), (Object)e);
        }
    }

    public InputStream getResources(CMBDocument document) {
        return null;
    }

    public void trace(String message) {
        try {
            Logger.logDebug((Object)this, "trace", this.sessionBean._session, message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean traceEnabled() {
        return true;
    }

    public String deployNativeLibrary(String arg0) {
        String methodName = "deployNativeLibrary";
        Logger.logEntry((Object)this, methodName, this.sessionBean._session);
        Logger.logExit((Object)this, methodName, this.sessionBean._session);
        return null;
    }

    public boolean getPrintPrivilege(CMBDocument document) {
        return true;
    }
}

